/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.Holiday;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceTypeMismatchException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.jar.JarEntry;

public final class ICUResourceBundleTest
extends TestFmwk {
    private static final ClassLoader testLoader = (class$com$ibm$icu$dev$test$util$ICUResourceBundleTest == null ? (class$com$ibm$icu$dev$test$util$ICUResourceBundleTest = ICUResourceBundleTest.class$("com.ibm.icu.dev.test.util.ICUResourceBundleTest")) : class$com$ibm$icu$dev$test$util$ICUResourceBundleTest).getClassLoader();
    private static final String COLLATION_RESNAME = "collations";
    private static final String COLLATION_KEYWORD = "collation";
    private static final String DEFAULT_NAME = "default";
    private static final String STANDARD_NAME = "standard";
    static /* synthetic */ Class class$com$ibm$icu$dev$test$util$ICUResourceBundleTest;

    public static void main(String[] args) throws Exception {
        ICUResourceBundleTest test = new ICUResourceBundleTest();
        test.run(args);
    }

    public void TestGetResources() {
        try {
            Enumeration<URL> en = testLoader.getResources("com.ibm.icu.dev.data");
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                if (url == null) {
                    this.warnln("could not load resource data");
                    return;
                }
                URLConnection c = url.openConnection();
                if (c instanceof JarURLConnection) {
                    JarURLConnection jc = (JarURLConnection)c;
                    JarEntry je = jc.getJarEntry();
                    this.logln("jar entry: " + je.toString());
                    continue;
                }
                InputStream is = c.getInputStream();
                this.logln("input stream:");
                InputStreamReader r = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(r);
                String line = null;
                int n = 0;
                while ((line = br.readLine()) != null) {
                    this.logln("  " + ++n + ": " + line);
                }
            }
        }
        catch (SecurityException ex) {
            this.warnln("could not load resource data: " + ex);
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            this.warnln("could not load resource data: " + ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errln("Unexpected exception: " + ex);
        }
    }

    public void TestResourceBundleWrapper() {
        UResourceBundle bundle = UResourceBundle.getBundleInstance((String)"com.ibm.icu.impl.data.HolidayBundle", (String)"da_DK");
        Object o = bundle.getObject("holidays");
        if (o instanceof Holiday[]) {
            this.logln("wrapper mechanism works for Weekend data");
        } else {
            this.errln("Did not get the expected output for Weekend data");
        }
        bundle = UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (String)"bogus");
        if (bundle instanceof ICUResourceBundle && bundle.getULocale().equals((Object)"en_US")) {
            this.logln("wrapper mechanism works for bogus locale");
        } else {
            this.errln("wrapper mechanism failed for bogus locale.");
        }
        try {
            bundle = UResourceBundle.getBundleInstance((String)"bogus", (String)"bogus");
            if (bundle != null) {
                this.errln("Did not get the expected exception");
            }
        }
        catch (MissingResourceException ex) {
            this.logln("got the expected exception");
        }
    }

    public void TestJB3879() {
        try {
            ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)ULocale.getDefault().toString(), (ClassLoader)testLoader);
            if (bundle == null) {
                this.errln("could not create the resource bundle");
            }
        }
        catch (MissingResourceException ex) {
            this.warnln("could not load test data: " + ex.getMessage());
        }
    }

    public void TestOpen() {
        String[] strings;
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (String)"en_US_POSIX");
        if (bundle == null) {
            this.errln("could not create the resource bundle");
        }
        ICUResourceBundle obj = bundle.get("NumberPatterns");
        int size = obj.getSize();
        int type = obj.getType();
        if (type == 8) {
            for (int i = 0; i < size; ++i) {
                ICUResourceBundle sub = obj.get(i);
                String temp = sub.getString();
                if (temp.length() != 0) continue;
                this.errln("Failed to get the items from NumberPatterns array in bundle: " + bundle.getULocale().getBaseName());
            }
        }
        if (size != (strings = bundle.getStringArray("NumberPatterns")).length) {
            this.errln("Failed to get the items from NumberPatterns array in bundle: " + bundle.getULocale().getBaseName());
        }
        obj = bundle.get("NumberElements");
        size = obj.getSize();
        type = obj.getType();
        if (type == 8) {
            for (int i = 0; i < size; ++i) {
                ICUResourceBundle sub = obj.get(i);
                String temp = sub.getString();
                if (temp.length() != 0) continue;
                this.errln("Failed to get the items from NumberPatterns array in bundle: " + bundle.getULocale().getBaseName());
            }
        }
        if (bundle == null) {
            this.errln("could not create the resource bundle");
        }
        if ((bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b/coll", (String)"en_US_POSIX")) == null) {
            this.errln("could not load the stream");
        }
        if (!(bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (String)"my_very_very_very_long_bogus_bundle")).getULocale().equals((Object)ULocale.getDefault())) {
            this.errln("UResourceBundle did not load the default bundle when bundle was not found");
        }
    }

    public void TestBasicTypes() {
        String value;
        ICUResourceBundle sub2;
        ICUResourceBundle sub1;
        String key;
        ICUResourceBundle sub;
        ByteBuffer got;
        int got2;
        ICUResourceBundle bundle = null;
        try {
            bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testtypes", (ClassLoader)testLoader);
        }
        catch (MissingResourceException e) {
            this.warnln("could not load test data: " + e.getMessage());
            return;
        }
        String expected = "abc\u0000def";
        ICUResourceBundle sub3 = bundle.get("zerotest");
        if (!expected.equals(sub3.getString())) {
            this.errln("Did not get the expected string for key zerotest in bundle testtypes");
        }
        if (!(expected = "").equals((sub3 = bundle.get("emptyexplicitstring")).getString())) {
            this.errln("Did not get the expected string for key emptyexplicitstring in bundle testtypes");
        }
        if (!(expected = "").equals((sub3 = bundle.get("emptystring")).getString())) {
            this.errln("Did not get the expected string for key emptystring in bundle testtypes");
        }
        if ((expected = 123) != (sub3 = bundle.get("onehundredtwentythree")).getInt()) {
            this.errln("Did not get the expected int value for key onehundredtwentythree in bundle testtypes");
        }
        if ((expected = 0) != (sub3 = bundle.get("emptyint")).getInt()) {
            this.errln("Did not get the expected int value for key emptyint in bundle testtypes");
        }
        if ((expected = 1) != (sub3 = bundle.get("one")).getInt()) {
            this.errln("Did not get the expected int value for key one in bundle testtypes");
        }
        if ((expected = -1) != (got2 = (sub3 = bundle.get("minusone")).getInt())) {
            this.errln("Did not get the expected int value for key minusone in bundle testtypes");
        }
        if ((expected = 0xFFFFFFF) != (got2 = sub3.getUInt())) {
            this.errln("Did not get the expected int value for key minusone in bundle testtypes");
        }
        if ((expected = 1) != (sub3 = bundle.get("plusone")).getInt()) {
            this.errln("Did not get the expected int value for key minusone in bundle testtypes");
        }
        if (!Utility.arrayEquals((int[])(expected = new int[]{1, 2, 3, -3, 4, 5, 6, 7}), (Object)(sub3 = bundle.get("integerarray")).getIntVector())) {
            this.errln("Did not get the expected int vector value for key integerarray in bundle testtypes");
        }
        if (!Utility.arrayEquals((int[])(expected = new int[0]), (Object)(sub3 = bundle.get("emptyintv")).getIntVector())) {
            this.errln("Did not get the expected int vector value for key emptyintv in bundle testtypes");
        }
        if ((got = (sub = bundle.get("binarytest")).getBinary()).remaining() != 15) {
            this.errln("Did not get the expected length for the binary ByteBuffer");
        }
        for (int i = 0; i < got.remaining(); ++i) {
            byte b = got.get();
            if (b == i) continue;
            this.errln("Did not get the expected value for binary buffer at index: " + i);
        }
        sub = bundle.get("emptybin");
        got = sub.getBinary();
        if (got.remaining() != 0) {
            this.errln("Did not get the expected length for the emptybin ByteBuffer");
        }
        if (!(key = (sub = bundle.get("emptyarray")).getKey()).equals("emptyarray")) {
            this.errln("Did not get the expected key for emptytable item");
        }
        if (sub.getSize() != 0) {
            this.errln("Did not get the expected length for emptytable item");
        }
        if (!(key = (sub = bundle.get("menu")).getKey()).equals("menu")) {
            this.errln("Did not get the expected key for menu item");
        }
        if (!(key = (sub1 = sub.get("file")).getKey()).equals("file")) {
            this.errln("Did not get the expected key for file item");
        }
        if (!(key = (sub2 = sub1.get("open")).getKey()).equals("open")) {
            this.errln("Did not get the expected key for file item");
        }
        if (!(value = sub2.getString()).equals("Open")) {
            this.errln("Did not get the expected value for key for oen item");
        }
        if (!(key = (sub = bundle.get("emptytable")).getKey()).equals("emptytable")) {
            this.errln("Did not get the expected key for emptytable item");
        }
        if (sub.getSize() != 0) {
            this.errln("Did not get the expected length for emptytable item");
        }
        sub = bundle.get("menu").get("file");
        int size = sub.getSize();
        for (int i = 0; i < size; ++i) {
            String expected2;
            sub1 = sub.get(i);
            switch (i) {
                case 0: {
                    expected2 = "exit";
                    break;
                }
                case 1: {
                    expected2 = "open";
                    break;
                }
                case 2: {
                    expected2 = "save";
                    break;
                }
                default: {
                    expected2 = "";
                }
            }
            String got3 = sub1.getKey();
            if (!expected2.equals(got3)) {
                this.errln("Did not get the expected key at index" + i + ". Expected: " + expected2 + " Got: " + got3);
                continue;
            }
            this.logln("Got the expected key at index: " + i);
        }
    }

    public void TestTable32() {
        int i;
        int size;
        TestCase[] arr = new TestCase[]{new TestCase("ooooooooooooooooo", 0), new TestCase("oooooooooooooooo1", 1), new TestCase("ooooooooooooooo1o", 2), new TestCase("oo11ooo1ooo11111o", 25150), new TestCase("oo11ooo1ooo111111", 25151), new TestCase("o1111111111111111", 65535), new TestCase("1oooooooooooooooo", 65536), new TestCase("1ooooooo11o11ooo1", 65969), new TestCase("1ooooooo11o11oo1o", 65970), new TestCase("1ooooooo111oo1111", 65999)};
        ICUResourceBundle bundle = null;
        try {
            bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testtable32", (ClassLoader)testLoader);
        }
        catch (MissingResourceException ex) {
            this.warnln("could not load resource data: " + ex.getMessage());
            return;
        }
        if (bundle.getType() != 2) {
            this.errln("Could not get the correct type for bundle testtable32");
        }
        if ((size = bundle.getSize()) != 66000) {
            this.errln("Could not get the correct size for bundle testtable32");
        }
        for (i = 0; i < size; ++i) {
            ICUResourceBundle item = bundle.get(i);
            String key = item.getKey();
            int parsedNumber = ICUResourceBundleTest.parseTable32Key(key);
            int number = -1;
            switch (item.getType()) {
                case 0: {
                    String value = item.getString();
                    number = UTF16.charAt((String)value, (int)0);
                    break;
                }
                case 7: {
                    number = item.getInt();
                    break;
                }
                default: {
                    this.errln("Got unexpected resource type in testtable32");
                }
            }
            if (number == parsedNumber) continue;
            this.errln("Did not get expected value in testtypes32 for key" + key + ". Expected: " + parsedNumber + " Got:" + number);
        }
        for (i = 0; i < arr.length; ++i) {
            String expected = arr[i].key;
            ICUResourceBundle item = bundle.get(expected);
            int number = 0;
            String key = item.getKey();
            int parsedNumber = ICUResourceBundleTest.parseTable32Key(key);
            if (!key.equals(expected)) {
                this.errln("Did not get the expected key. Expected: " + expected + " Got:" + key);
            }
            switch (item.getType()) {
                case 0: {
                    String value = item.getString();
                    number = UTF16.charAt((String)value, (int)0);
                    break;
                }
                case 7: {
                    number = item.getInt();
                    break;
                }
                default: {
                    this.errln("Got unexpected resource type in testtable32");
                }
            }
            if (number == parsedNumber) continue;
            this.errln("Did not get expected value in testtypes32 for key" + key + ". Expected: " + parsedNumber + " Got:" + number);
        }
    }

    private static int parseTable32Key(String key) {
        int number = 0;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            number <<= 1;
            if (c != '1') continue;
            number |= 1;
        }
        return number;
    }

    public void TestAliases() {
        String str;
        String simpleAlias = "Open";
        ICUResourceBundle rb = ICUResourceBundle.createBundle((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
        if (rb == null) {
            this.warnln("could not load testaliases data");
            return;
        }
        ICUResourceBundle sub = rb.get("simplealias");
        String s1 = sub.getString("simplealias");
        if (s1.equals(simpleAlias)) {
            this.logln("Alias mechanism works for simplealias");
        } else {
            this.errln("Did not get the expected output for simplealias");
        }
        try {
            rb = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
            sub = rb.get("nonexisting");
            this.errln("Did not get the expected exception for nonexisting");
        }
        catch (MissingResourceException ex) {
            this.logln("Alias mechanism works for nonexisting alias");
        }
        rb = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
        sub = rb.get("referencingalias");
        s1 = sub.getString();
        if (s1.equals("Hani")) {
            this.logln("Alias mechanism works for referencingalias");
        } else {
            this.errln("Did not get the expected output for referencingalias");
        }
        rb = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
        sub = rb.get("boundaries");
        String word = sub.getString("word");
        if (word.equals("word_ja.brk")) {
            this.logln("Got the expected output for boundaries/word");
        } else {
            this.errln("Did not get the expected type for boundaries/word");
        }
        ICUResourceBundle rb1 = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
        if (rb1 != rb) {
            this.errln("Caching of the resource bundle failed");
        } else {
            this.logln("Caching of resource bundle passed");
        }
        sub = rb1.get("testGetStringByKeyAliasing");
        s1 = sub.get("KeyAlias0PST").getString();
        if (s1.equals("America/Los_Angeles")) {
            this.logln("Alias mechanism works for KeyAlias0PST");
        } else {
            this.errln("Did not get the expected output for KeyAlias0PST");
        }
        s1 = sub.getString("KeyAlias1PacificStandardTime");
        if (s1.equals("Pacific Standard Time")) {
            this.logln("Alias mechanism works for KeyAlias1PacificStandardTime");
        } else {
            this.errln("Did not get the expected output for KeyAlias1PacificStandardTime");
        }
        s1 = sub.getString("KeyAlias2PDT");
        if (s1.equals("PDT")) {
            this.logln("Alias mechanism works for KeyAlias2PDT");
        } else {
            this.errln("Did not get the expected output for KeyAlias2PDT");
        }
        s1 = sub.getString("KeyAlias3LosAngeles");
        if (s1.equals("Los Angeles")) {
            this.logln("Alias mechanism works for KeyAlias3LosAngeles. Got: " + s1);
        } else {
            this.errln("Did not get the expected output for KeyAlias3LosAngeles. Got: " + s1);
        }
        sub = rb.get("testGetStringByIndexAliasing");
        s1 = sub.getString(0);
        if (s1.equals("America/Los_Angeles")) {
            this.logln("Alias mechanism works for testGetStringByIndexAliasing/0. Got: " + s1);
        } else {
            this.errln("Did not get the expected output for testGetStringByIndexAliasing/0. Got: " + s1);
        }
        s1 = sub.getString(1);
        if (s1.equals("Pacific Standard Time")) {
            this.logln("Alias mechanism works for testGetStringByIndexAliasing/1");
        } else {
            this.errln("Did not get the expected output for testGetStringByIndexAliasing/1");
        }
        s1 = sub.getString(2);
        if (s1.equals("PDT")) {
            this.logln("Alias mechanism works for testGetStringByIndexAliasing/2");
        } else {
            this.errln("Did not get the expected output for testGetStringByIndexAliasing/2");
        }
        s1 = sub.getString(3);
        if (s1.equals("Los Angeles")) {
            this.logln("Alias mechanism works for testGetStringByIndexAliasing/3. Got: " + s1);
        } else {
            this.errln("Did not get the expected output for testGetStringByIndexAliasing/3. Got: " + s1);
        }
        sub = rb.get("testAliasToTree");
        ByteBuffer buf = sub.get(STANDARD_NAME).get("%%CollationBin").getBinary();
        if (buf == null) {
            this.errln("Did not get the expected output for %%CollationBin");
        }
        if ((str = (rb = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b/rbnf", (String)"fr_BE")).getString("SpelloutRules")) != null || str.length() > 0) {
            this.logln("Alias mechanism works");
        } else {
            this.errln("Alias mechanism failed for fr_BE SpelloutRules");
        }
        rb = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b/coll", (String)"zh_TW");
        ICUResourceBundle b = (ICUResourceBundle)rb.getObject(COLLATION_RESNAME);
        if (b != null) {
            if (b.get(0).getKey().equals(DEFAULT_NAME)) {
                this.logln("Alias mechanism works");
            } else {
                this.errln("Alias mechanism failed for zh_TW collations");
            }
        } else {
            this.errln("Did not get the expected object for collations");
        }
    }

    public void TestAlias() {
        this.logln("Testing %%ALIAS");
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (String)"iw_IL");
        ICUResourceBundle b = rb.get("NumberPatterns");
        if (b != null) {
            if (b.getSize() > 0) {
                this.logln("%%ALIAS mechanism works");
            } else {
                this.errln("%%ALIAS mechanism failed for iw_IL collations");
            }
        } else {
            this.errln("%%ALIAS mechanism failed for iw_IL");
        }
    }

    public void TestXPathAlias() {
        String expResult;
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"te_IN", (ClassLoader)testLoader);
        ICUResourceBundle b = rb.get("aliasClient");
        String result = b.getString();
        if (!result.equals(expResult = "correct")) {
            this.errln("Did not get the expected result for XPath style alias");
        }
        try {
            ICUResourceBundle c = rb.get("rootAliasClient");
            result = c.getString();
            expResult = "correct";
            if (!result.equals(expResult)) {
                this.errln("Did not get the expected result for XPath style alias for rootAliasClient");
            }
        }
        catch (MissingResourceException ex) {
            this.errln("Could not get rootAliasClient");
        }
    }

    public void TestCircularAliases() {
        try {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
            ICUResourceBundle sub = rb.get("aaa");
            String s1 = sub.getString();
            if (s1 != null) {
                this.errln("Did not get the expected exception");
            }
        }
        catch (IllegalArgumentException ex) {
            this.logln("got expected exception for circular references");
        }
        catch (MissingResourceException ex) {
            this.warnln("could not load resource data: " + ex.getMessage());
        }
    }

    public void TestGetWithFallback() {
        String defaultWidth;
        String defaultContext;
        ICUResourceBundle b2;
        ICUResourceBundle b3;
        ICUResourceBundle b4;
        ICUResourceBundle b5;
        ICUResourceBundle b1;
        String defaultCal;
        ICUResourceBundle bundle = null;
        String key = null;
        try {
            bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b/coll", (String)ULocale.canonicalize((String)"de__PHONEBOOK"));
            if (!bundle.getULocale().equals((Object)"de")) {
                this.errln("did not get the expected bundle");
            }
            if (!(key = bundle.getStringWithFallback("collations/collation/default")).equals("phonebook")) {
                this.errln("Did not get the expected result from getStringWithFallback method.");
            }
        }
        catch (MissingResourceException ex) {
            this.logln("got the expected exception");
        }
        bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b/coll", (String)"fr_FR");
        key = bundle.getStringWithFallback("collations/default");
        if (!key.equals(STANDARD_NAME)) {
            this.errln("Did not get the expected result from getStringWithFallback method.");
        }
        if (!(defaultCal = (b1 = (bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (String)"fr_FR")).getWithFallback("calendar")).getStringWithFallback(DEFAULT_NAME)).equals("gregorian")) {
            this.errln("Did not get the expected default calendar string: Expected: gregorian, Got: " + defaultCal);
        }
        if ((b5 = (b4 = (b3 = (b2 = b1.getWithFallback(defaultCal)).getWithFallback("monthNames")).getWithFallback(defaultContext = b3.getStringWithFallback(DEFAULT_NAME))).getWithFallback(defaultWidth = b4.getStringWithFallback(DEFAULT_NAME))).getSize() != 12) {
            this.errln("Did not get the expected size for the default monthNames");
        }
    }

    public void TestKeywordValues() {
        boolean foundStandard = false;
        this.logln("Testing getting collation values:");
        String[] kwVals = ICUResourceBundle.getKeywordValues((String)"com/ibm/icu/impl/data/icudt36b/coll", (String)COLLATION_RESNAME);
        for (int n = 0; n < kwVals.length; ++n) {
            this.logln(new Integer(n).toString() + ": " + kwVals[n]);
            if (DEFAULT_NAME.equals(kwVals[n])) {
                this.errln("getKeywordValues for collation returned 'default' in the list.");
                continue;
            }
            if (!STANDARD_NAME.equals(kwVals[n])) continue;
            if (!foundStandard) {
                foundStandard = true;
                this.logln("found 'standard'");
                continue;
            }
            this.errln("Error - 'standard' is in the keyword list twice!");
        }
        if (!foundStandard) {
            this.errln("Error - 'standard' was not in the collation tree as a keyword.");
        } else {
            this.logln("'standard' was found as a collation keyword.");
        }
    }

    public void TestLocaleDisplayNames() {
        ULocale[] locales = ULocale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!ICUResourceBundleTest.hasLocalizedCountryFor(ULocale.ENGLISH, locales[i])) {
                this.errln("Could not get localized country for " + locales[i]);
            }
            if (!ICUResourceBundleTest.hasLocalizedLanguageFor(ULocale.ENGLISH, locales[i])) {
                this.errln("Could not get localized language for " + locales[i]);
            }
            if (!ICUResourceBundleTest.hasLocalizedCountryFor(locales[i], locales[i])) {
                this.errln("Could not get localized country for " + locales[i]);
                ICUResourceBundleTest.hasLocalizedCountryFor(locales[i], locales[i]);
            }
            if (!ICUResourceBundleTest.hasLocalizedLanguageFor(locales[i], locales[i])) {
                this.errln("Could not get localized language for " + locales[i]);
            }
            this.logln(locales[i] + "\t" + locales[i].getDisplayName(ULocale.ENGLISH) + "\t" + locales[i].getDisplayName(locales[i]));
        }
    }

    private static boolean hasLocalizedLanguageFor(ULocale locale, ULocale otherLocale) {
        String localizedVersion;
        String lang = otherLocale.getLanguage();
        return !lang.equals(localizedVersion = otherLocale.getDisplayLanguage(locale));
    }

    private static boolean hasLocalizedCountryFor(ULocale locale, ULocale otherLocale) {
        String country = otherLocale.getCountry();
        if (country.equals("")) {
            return true;
        }
        String localizedVersion = otherLocale.getDisplayCountry(locale);
        return !country.equals(localizedVersion);
    }

    public void TestFunctionalEquivalent() {
        String[] testCases = new String[]{"f", "de_US_CALIFORNIA", "de", "t", "zh_TW@collation=stroke", "zh@collation=stroke", "f", "de_CN@collation=pinyin", "de", "t", "zh@collation=pinyin", "zh", "t", "zh_CN@collation=pinyin", "zh", "t", "zh_HK@collation=pinyin", "zh", "t", "zh_HK@collation=stroke", "zh@collation=stroke", "t", "zh_HK", "zh@collation=stroke", "t", "zh_MO", "zh@collation=stroke", "t", "zh_TW_STROKE", "zh@collation=stroke", "t", "zh_TW_STROKE@collation=big5han", "zh@collation=big5han", "f", "de_CN@calendar=japanese", "de", "t", "de@calendar=japanese", "de", "t", "zh_TW@collation=big5han", "zh@collation=big5han", "t", "zh_TW@collation=gb2312han", "zh@collation=gb2312han", "t", "zh_CN@collation=big5han", "zh@collation=big5han", "t", "zh_CN@collation=gb2312han", "zh@collation=gb2312han", "t", "zh@collation=big5han", "zh@collation=big5han", "t", "zh@collation=gb2312han", "zh@collation=gb2312han", "t", "hi_IN@collation=direct", "hi@collation=direct", "t", "hi@collation=standard", "hi", "t", "hi@collation=direct", "hi@collation=direct", "f", "hi_AU@collation=direct;currency=CHF;calendar=buddhist", "hi@collation=direct", "f", "hi_AU@collation=standard;currency=CHF;calendar=buddhist", "hi", "t", "de_DE@collation=pinyin", "de", "f", "de_DE_BONN@collation=pinyin", "de", "t", "nl", "root", "t", "nl_NL", "root", "f", "nl_NL_EEXT", "root", "t", "nl@collation=stroke", "root", "t", "nl_NL@collation=stroke", "root", "f", "nl_NL_EEXT@collation=stroke", "root"};
        String F_STR = "f";
        String T_STR = "t";
        boolean[] isAvail = new boolean[1];
        this.logln("Testing functional equivalents...");
        for (int i = 0; i < testCases.length; i += 3) {
            boolean expectAvail = T_STR.equals(testCases[i + 0]);
            ULocale inLocale = new ULocale(testCases[i + 1]);
            ULocale expectLocale = new ULocale(testCases[i + 2]);
            this.logln(new Integer(i / 3).toString() + ": " + new Boolean(expectAvail).toString() + "\t\t" + inLocale.toString() + "\t\t" + expectLocale.toString());
            ULocale equivLocale = ICUResourceBundle.getFunctionalEquivalent((String)"com/ibm/icu/impl/data/icudt36b/coll", (String)COLLATION_RESNAME, (String)COLLATION_KEYWORD, (ULocale)inLocale, (boolean[])isAvail);
            boolean gotAvail = isAvail[0];
            if (gotAvail == expectAvail && equivLocale.equals((Object)expectLocale)) continue;
            this.errln(new Integer(i / 3).toString() + ":  Error, expected  Equiv=" + new Boolean(expectAvail).toString() + "\t\t" + inLocale.toString() + "\t\t--> " + expectLocale.toString() + ",  but got " + new Boolean(gotAvail).toString() + " " + equivLocale.toString());
        }
        this.logln("Testing error conditions:");
        try {
            ULocale equivLocale = ICUResourceBundle.getFunctionalEquivalent((String)"com/ibm/icu/impl/data/icudt36b/coll", (String)"calendar", (String)"calendar", (ULocale)new ULocale("ar_EG@calendar=islamic"), (boolean[])new boolean[1]);
            this.errln("Err: expected MissingResourceException");
        }
        catch (MissingResourceException t) {
            this.logln("expected MissingResourceException caught (PASS): " + t.toString());
        }
    }

    public void TestNorwegian() {
        try {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (String)"no_NO_NY");
            ICUResourceBundle sub = rb.get("Countries");
            String s1 = sub.getString("NO");
            if (s1.equals("Noreg")) {
                this.logln("got expected output ");
            } else {
                this.errln("did not get the expected result");
            }
        }
        catch (IllegalArgumentException ex) {
            this.errln("Caught an unexpected expected");
        }
    }

    public void TestJB4102() {
        try {
            ICUResourceBundle root = (ICUResourceBundle)ICUResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (String)"root");
            ICUResourceBundle t = null;
            try {
                t = root.getWithFallback("calendar/islamic-civil/AmPmMarkers");
                this.errln("Second resource does not exist. How did it get here?\n");
            }
            catch (MissingResourceException ex) {
                this.logln("Got the expected exception");
            }
            try {
                t = root.getWithFallback("calendar/islamic-civil/eras/abbreviated/0/mikimaus/pera");
                this.errln("Second resource does not exist. How did it get here?\n");
            }
            catch (MissingResourceException ex) {
                this.logln("Got the expected exception");
            }
            if (t != null) {
                this.errln("t is not null!");
            }
        }
        catch (MissingResourceException e) {
            this.warnln("Could not load the locale data: " + e.getMessage());
        }
    }

    public void TestCLDRStyleAliases() {
        String result = null;
        Object expected = null;
        String[] expects = new String[]{"", "a41", "a12", "a03", "ar4"};
        this.logln("Testing CLDR style aliases......\n");
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"te_IN_REVISED", (ClassLoader)testLoader);
        ICUResourceBundle alias = rb.get("a");
        for (int i = 1; i < 5; ++i) {
            String resource = "a" + i;
            ICUResourceBundle a = alias.getWithFallback(resource);
            result = a.getString();
            if (!result.equals(expected)) continue;
            this.errln("CLDR style aliases failed resource with name " + resource + "resource, exp " + expects[i] + " , got " + result);
        }
    }

    private String getLSString(int status) {
        switch (status) {
            case 1: {
                return "FROM_FALLBACK";
            }
            case 3: {
                return "FROM_DEFAULT";
            }
            case 2: {
                return "FROM_ROOT";
            }
            case 4: {
                return "FROM_LOCALE";
            }
        }
        return "UNKNOWN";
    }

    public void TestLoadingStatus() {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (String)"yi_IL");
        int status = bundle.getLoadingStatus();
        if (status != 3) {
            this.errln("Did not get the expected value for loading status. Expected " + this.getLSString(3) + " Got: " + this.getLSString(status));
        }
        if ((status = (bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (String)"eo_DE")).getLoadingStatus()) != 1) {
            this.errln("Did not get the expected value for loading status. Expected " + this.getLSString(1) + " Got: " + this.getLSString(status));
        }
        this.logln("Test to verify loading status of get(String)");
        bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (String)"te_IN");
        ICUResourceBundle countries = bundle.get("Countries");
        status = countries.getLoadingStatus();
        if (status != 1) {
            this.errln("Did not get the expected value for loading status. Expected " + this.getLSString(1) + " Got: " + this.getLSString(status));
        }
        this.logln("Test to verify loading status of get(int)");
        ICUResourceBundle ms = bundle.get("MeasurementSystem");
        status = ms.getLoadingStatus();
        if (status != 2) {
            this.errln("Did not get the expected value for loading status. Expected " + this.getLSString(2) + " Got: " + this.getLSString(status));
        }
        this.logln("Test to verify loading status of getwithFallback");
        bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"sh_YU", (ClassLoader)testLoader);
        ICUResourceBundle temp = bundle.getWithFallback("a/a2");
        status = temp.getLoadingStatus();
        if (status != 4) {
            this.errln("Did not get the expected value for loading status. Expected " + this.getLSString(4) + " Got: " + this.getLSString(status));
        }
        if ((status = (temp = bundle.getWithFallback("a/a1")).getLoadingStatus()) != 1) {
            this.errln("Did not get the expected value for loading status. Expected " + this.getLSString(1) + " Got: " + this.getLSString(status));
        }
        if ((status = (temp = bundle.getWithFallback("a/a4")).getLoadingStatus()) != 2) {
            this.errln("Did not get the expected value for loading status. Expected " + this.getLSString(2) + " Got: " + this.getLSString(status));
        }
    }

    public void TestCoverage() {
        Stub stub;
        UResourceBundle bundle = UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b");
        if (bundle == null) {
            this.errln("UResourceBundle.getBundleInstance(String baseName) failed");
        }
        bundle = null;
        bundle = UResourceBundle.getBundleInstance((ULocale)ULocale.getDefault());
        if (bundle == null) {
            this.errln("UResourceBundle.getBundleInstance(ULocale) failed");
            return;
        }
        if (new UResourceTypeMismatchException("coverage") == null) {
            this.errln("Create UResourceTypeMismatchException error");
        }
        class Stub
        extends UResourceBundle {
            Stub() {
            }

            public ULocale getULocale() {
                return ULocale.ROOT;
            }

            protected String getLocaleID() {
                return null;
            }

            protected String getBaseName() {
                return null;
            }

            protected UResourceBundle getParent() {
                return null;
            }

            protected void setLoadingStatus(int newStatus) {
            }

            public Enumeration getKeys() {
                return null;
            }

            protected Object handleGetObject(String key) {
                return null;
            }
        }
        if (!(stub = new Stub()).getLocale().equals(ULocale.ROOT.toLocale())) {
            this.errln("UResourceBundle.getLoclae(Locale) should delegate to (ULocale)");
        }
    }

    public void TestJavaULocaleBundleLoading() {
        UResourceBundle bundle3;
        UResourceBundle bundle2;
        UResourceBundle bundle1;
        String fromEnLatnUs;
        String fromEnLatn;
        String fromEn;
        String baseName = "com.ibm.icu.dev.data.resources.TestDataElements";
        String locName = "en_Latn_US";
        UResourceBundle bundle = UResourceBundle.getBundleInstance((String)baseName, (String)locName, (ClassLoader)testLoader);
        String fromRoot = bundle.getString("from_root");
        if (!fromRoot.equals("This data comes from root")) {
            this.errln("Did not get the expected string for from_root");
        }
        if (!(fromEn = bundle.getString("from_en")).equals("This data comes from en")) {
            this.errln("Did not get the expected string for from_en");
        }
        if (!(fromEnLatn = bundle.getString("from_en_Latn")).equals("This data comes from en_Latn")) {
            this.errln("Did not get the expected string for from_en_Latn");
        }
        if (!(fromEnLatnUs = bundle.getString("from_en_Latn_US")).equals("This data comes from en_Latn_US")) {
            this.errln("Did not get the expected string for from_en_Latn_US");
        }
        if (!(bundle1 = UResourceBundle.getBundleInstance((String)baseName, (ULocale)new ULocale(locName), (ClassLoader)testLoader)).equals(bundle)) {
            this.errln("Did not get the expected bundle for " + baseName + "." + locName);
        }
        if (bundle1 != bundle) {
            this.errln("Did not load the bundle from cache");
        }
        if (!(bundle2 = UResourceBundle.getBundleInstance((String)baseName, (String)"en_IN", (ClassLoader)testLoader)).getLocale().toString().equals("en")) {
            this.errln("Did not get the expected fallback locale. Expected: en Got: " + bundle2.getLocale().toString());
        }
        if (!(bundle3 = UResourceBundle.getBundleInstance((String)baseName, (String)"te_IN", (ClassLoader)testLoader)).getLocale().toString().equals("te")) {
            this.errln("Did not get the expected fallback locale. Expected: te Got: " + bundle2.getLocale().toString());
        }
        UResourceBundle defaultBundle = UResourceBundle.getBundleInstance((String)baseName, (String)"hi_IN", (ClassLoader)testLoader);
        ULocale defaultLocale = ULocale.getDefault();
        if (!defaultBundle.getULocale().equals((Object)defaultLocale)) {
            this.errln("Did not get the default bundle for non-existent bundle");
        }
        ULocale.setDefault((ULocale)ULocale.CANADA_FRENCH);
        UResourceBundle root = UResourceBundle.getBundleInstance((String)baseName, (String)"hi_IN", (ClassLoader)testLoader);
        if (!root.getULocale().toString().equals("")) {
            this.errln("Did not get the root bundle for non-existent default bundle for non-existent bundle");
        }
        ULocale.setDefault((ULocale)defaultLocale);
        Enumeration keys = bundle.getKeys();
        int i = 0;
        while (keys.hasMoreElements()) {
            this.logln("key: " + keys.nextElement());
            ++i;
        }
        if (i != 4) {
            this.errln("Did not get the expected number of keys: got " + i + ", expected 4");
        }
        UResourceBundle bundle4 = UResourceBundle.getBundleInstance((String)baseName, (String)"fr_Latn_FR", (ClassLoader)testLoader);
        if (bundle == null) {
            this.errln("Could not load bundle fr_Latn_FR");
        }
    }

    public void TestAliasFallback() {
        try {
            ULocale loc = new ULocale("en_US");
            ICUResourceBundle b = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b", (ULocale)loc);
            ICUResourceBundle b1 = b.getWithFallback("calendar/hebrew/monthNames/format/abbreviated");
            if (b1 != null) {
                this.logln("loaded data for abbreviated month names: " + b1.getKey());
            }
        }
        catch (MissingResourceException ex) {
            this.warnln("Failed to load data for abbreviated month names");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class TestCase {
        String key;
        int value;

        TestCase(String key, int value) {
            this.key = key;
            this.value = value;
        }
    }
}

