/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class ICUServiceTestSample {
    public static void main(String[] args) {
        HelloServiceClient client = new HelloServiceClient();
        HelloUpdateThread t = new HelloUpdateThread();
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("done");
        if (client == null) {
            // empty if block
        }
    }

    static final class HelloService {
        private static ICUService registry;
        private String name;

        private HelloService(String name) {
            this.name = name;
        }

        public String hello() {
            return this.name;
        }

        public String toString() {
            return super.toString() + ": " + this.name;
        }

        private static ICUService registry() {
            if (registry == null) {
                HelloService.initRegistry();
            }
            return registry;
        }

        private static void initRegistry() {
            registry = new ICULocaleService(){

                protected boolean acceptsListener(EventListener l) {
                    return true;
                }

                protected void notifyListener(EventListener l) {
                    ((HelloServiceListener)l).helloServiceChanged();
                }
            };
            HelloService.doRegister("Hello", "en");
            HelloService.doRegister("Bonjour", "fr");
            HelloService.doRegister("Ni Hao", "zh_CN");
            HelloService.doRegister("Guten Tag", "de");
        }

        public static void addListener(HelloServiceListener l) {
            HelloService.registry().addListener((EventListener)l);
        }

        public static void removeListener(HelloServiceListener l) {
            HelloService.registry().removeListener((EventListener)l);
        }

        public static HelloService get(String id) {
            return (HelloService)HelloService.registry().get(id);
        }

        public static Set getVisibleIDs() {
            return HelloService.registry().getVisibleIDs();
        }

        public static Map getDisplayNames(ULocale locale) {
            return HelloService.getDisplayNames(HelloService.registry(), locale);
        }

        public static void register(String helloString, ULocale locale) {
            if (helloString == null || locale == null) {
                throw new NullPointerException();
            }
            HelloService.doRegister(helloString, locale.toString());
        }

        private static void doRegister(String hello, String id) {
            HelloService.registry().registerObject((Object)new HelloService(hello), id);
        }

        public static SortedMap getDisplayNames(ICUService service, ULocale locale) {
            Collator col = Collator.getInstance((ULocale)locale);
            return service.getDisplayNames(locale, (Comparator)col, null);
        }

        public static interface HelloServiceListener
        extends EventListener {
            public void helloServiceChanged();
        }
    }

    static class HelloUpdateThread
    extends Thread {
        String[][] updates = new String[][]{{"Hey", "en_US_INFORMAL"}, {"Hallo", "de_DE_INFORMAL"}, {"Yo!", "en_US_CALIFORNIA_INFORMAL"}, {"Chi Fanle Ma?", "zh__INFORMAL"}, {"Munch munch... Burger?", "en"}, {"Sniff", "fr"}, {"TongZhi! MaoZeDong SiXiang Wan Sui!", "zh_CN"}, {"Bier? Ja!", "de"}};

        HelloUpdateThread() {
        }

        public void run() {
            for (int i = 0; i < this.updates.length; ++i) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                HelloService.register(this.updates[i][0], new ULocale(this.updates[i][1]));
            }
        }
    }

    static class HelloServiceClient
    implements HelloService.HelloServiceListener {
        HelloServiceClient() {
            HelloService.addListener(this);
            this.display();
        }

        public void helloServiceChanged() {
            this.display();
        }

        private void display() {
            Map names = HelloService.getDisplayNames(ULocale.US);
            System.out.println("displaying " + names.size() + " names.");
            Iterator iter = names.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String displayName = (String)entry.getKey();
                HelloService service = HelloService.get((String)entry.getValue());
                System.out.println(displayName + " says " + service.hello());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {}
            }
            System.out.println("----");
        }
    }
}

