/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.LocaleData;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.HashSet;

public class LocaleDataTest
extends TestFmwk {
    private ULocale[] availableLocales = null;

    public static void main(String[] args) throws Exception {
        new LocaleDataTest().run(args);
    }

    protected void init() {
        this.availableLocales = ICUResourceBundle.getAvailableULocales((String)"com/ibm/icu/impl/data/icudt36b");
    }

    public void TestPaperSize() {
        for (int i = 0; i < this.availableLocales.length; ++i) {
            ULocale locale = this.availableLocales[i];
            LocaleData.PaperSize paperSize = LocaleData.getPaperSize((ULocale)locale);
            String lang = locale.getLanguage();
            if (lang.equals("in")) continue;
            if (locale.toString().indexOf("_US") >= 0) {
                if (paperSize.getHeight() != 279 || paperSize.getWidth() != 216) {
                    this.errln("PaperSize did not return the expected value for locale " + locale + " Expected height: 279 width: 216." + " Got height: " + paperSize.getHeight() + " width: " + paperSize.getWidth());
                    continue;
                }
                this.logln("PaperSize returned the expected values for locale " + locale);
                continue;
            }
            if (paperSize.getHeight() != 297 || paperSize.getWidth() != 210) {
                this.errln("PaperSize did not return the expected value for locale " + locale + " Expected height: 297 width: 210." + " Got height: " + paperSize.getHeight() + " width: " + paperSize.getWidth());
                continue;
            }
            this.logln("PaperSize returned the expected values for locale " + locale);
        }
    }

    public void TestMeasurementSystem() {
        for (int i = 0; i < this.availableLocales.length; ++i) {
            ULocale locale = this.availableLocales[i];
            LocaleData.MeasurementSystem ms = LocaleData.getMeasurementSystem((ULocale)locale);
            String lang = locale.getLanguage();
            if (lang.equals("in")) continue;
            if (locale.toString().indexOf("_US") >= 0) {
                if (ms == LocaleData.MeasurementSystem.US) {
                    this.logln("Got the expected measurement system for locale: " + locale);
                    continue;
                }
                this.errln("Did not get the expected measurement system for locale: " + locale);
                continue;
            }
            if (ms == LocaleData.MeasurementSystem.SI) {
                this.logln("Got the expected measurement system for locale: " + locale);
                continue;
            }
            this.errln("Did not get the expected measurement system for locale: " + locale);
        }
    }

    public void TestExemplarSet() {
        HashSet<ExemplarGroup> testedExemplars = new HashSet<ExemplarGroup>();
        int equalCount = 0;
        for (int i = 0; i < this.availableLocales.length; ++i) {
            ULocale locale = this.availableLocales[i];
            int[] scriptCodes = UScript.getCode((ULocale)locale);
            if (scriptCodes == null) {
                if (locale.toString().indexOf("in") >= 0) continue;
                this.errln("UScript.getCode returned null for locale: " + locale);
                continue;
            }
            UnicodeSet[] exemplarSets = new UnicodeSet[2];
            for (int k = 0; k < 2; ++k) {
                UnicodeSet exemplarSet;
                int option = k == 0 ? 0 : 2;
                exemplarSets[k] = exemplarSet = LocaleData.getExemplarSet((ULocale)locale, (int)option);
                ExemplarGroup exGrp = new ExemplarGroup(exemplarSet, scriptCodes);
                if (testedExemplars.contains(exGrp)) continue;
                testedExemplars.add(exGrp);
                UnicodeSet[] sets = new UnicodeSet[scriptCodes.length];
                for (int j = 0; j < scriptCodes.length; ++j) {
                    sets[j] = new UnicodeSet("[:" + UScript.getShortName((int)scriptCodes[j]) + ":]");
                }
                boolean existsInScript = false;
                UnicodeSetIterator iter = new UnicodeSetIterator(exemplarSet);
                block3: while (!existsInScript && iter.nextRange()) {
                    int j;
                    if (iter.codepoint != UnicodeSetIterator.IS_STRING) {
                        for (j = 0; j < sets.length; ++j) {
                            if (!sets[j].contains(iter.codepoint, iter.codepointEnd)) continue;
                            existsInScript = true;
                            continue block3;
                        }
                        continue;
                    }
                    for (j = 0; j < sets.length; ++j) {
                        if (!sets[j].contains(iter.string)) continue;
                        existsInScript = true;
                        continue block3;
                    }
                }
                if (existsInScript) continue;
                this.errln("ExemplarSet containment failed for locale : " + locale);
            }
            if (this.isVerbose()) {
                this.logln(locale.toString() + " exemplar " + exemplarSets[0]);
                this.logln(locale.toString() + " exemplar(case-folded) " + exemplarSets[1]);
            }
            this.assertTrue(locale.toString() + " case-folded is a superset", exemplarSets[1].containsAll(exemplarSets[0]));
            if (!exemplarSets[1].equals((Object)exemplarSets[0])) continue;
            ++equalCount;
        }
        this.assertTrue("case-folded is sometimes a strict superset, and sometimes equal", equalCount > 0 && equalCount < this.availableLocales.length);
    }

    public void TestExemplarSet2() {
        int equalCount = 0;
        HashSet<ExemplarGroup> testedExemplars = new HashSet<ExemplarGroup>();
        for (int i = 0; i < this.availableLocales.length; ++i) {
            ULocale locale = this.availableLocales[i];
            LocaleData ld = LocaleData.getInstance((ULocale)locale);
            int[] scriptCodes = UScript.getCode((ULocale)locale);
            if (scriptCodes == null) {
                if (locale.toString().indexOf("in") >= 0) continue;
                this.errln("UScript.getCode returned null for locale: " + locale);
                continue;
            }
            UnicodeSet[] exemplarSets = new UnicodeSet[4];
            for (int k = 0; k < 2; ++k) {
                int option = k == 0 ? 0 : 2;
                for (int h = 0; h < 2; ++h) {
                    UnicodeSet exemplarSet;
                    int type = h == 0 ? 0 : 1;
                    exemplarSets[k * 2 + h] = exemplarSet = ld.getExemplarSet(option, type);
                    ExemplarGroup exGrp = new ExemplarGroup(exemplarSet, scriptCodes);
                    if (testedExemplars.contains(exGrp)) continue;
                    testedExemplars.add(exGrp);
                    UnicodeSet[] sets = new UnicodeSet[scriptCodes.length];
                    for (int j = 0; j < scriptCodes.length; ++j) {
                        sets[j] = new UnicodeSet("[:" + UScript.getShortName((int)scriptCodes[j]) + ":]");
                    }
                    boolean existsInScript = false;
                    UnicodeSetIterator iter = new UnicodeSetIterator(exemplarSet);
                    block4: while (!existsInScript && iter.nextRange()) {
                        int j;
                        if (iter.codepoint != UnicodeSetIterator.IS_STRING) {
                            for (j = 0; j < sets.length; ++j) {
                                if (!sets[j].contains(iter.codepoint, iter.codepointEnd)) continue;
                                existsInScript = true;
                                continue block4;
                            }
                            continue;
                        }
                        for (j = 0; j < sets.length; ++j) {
                            if (!sets[j].contains(iter.string)) continue;
                            existsInScript = true;
                            continue block4;
                        }
                    }
                    if (existsInScript || h != 0) continue;
                    this.errln("ExemplarSet containment failed for locale,option,type : " + locale + ", " + option + ", " + type);
                }
            }
            if (this.isVerbose()) {
                this.logln(locale.toString() + " exemplar(ES_STANDARD)" + exemplarSets[0]);
                this.logln(locale.toString() + " exemplar(ES_AUXILIARY) " + exemplarSets[1]);
                this.logln(locale.toString() + " exemplar(case-folded,ES_STANDARD) " + exemplarSets[2]);
                this.logln(locale.toString() + " exemplar(case-folded,ES_AUXILIARY) " + exemplarSets[3]);
            }
            this.assertTrue(locale.toString() + " case-folded is a superset", exemplarSets[2].containsAll(exemplarSets[0]));
            this.assertTrue(locale.toString() + " case-folded is a superset", exemplarSets[3].containsAll(exemplarSets[1]));
            if (exemplarSets[2].equals((Object)exemplarSets[0])) {
                ++equalCount;
            }
            if (!exemplarSets[3].equals((Object)exemplarSets[1])) continue;
            ++equalCount;
        }
        this.assertTrue("case-folded is sometimes a strict superset, and sometimes equal", equalCount > 0 && equalCount < this.availableLocales.length * 2);
    }

    public void TestCoverage() {
        LocaleData ld = LocaleData.getInstance();
        boolean t = ld.getNoSubstitute();
        ld.setNoSubstitute(t);
        this.assertEquals("LocaleData get/set NoSubstitute", t, ld.getNoSubstitute());
        this.logln(ld.getDelimiter(0));
        this.logln(ld.getDelimiter(1));
        this.logln(ld.getDelimiter(2));
        this.logln(ld.getDelimiter(3));
    }

    static class ExemplarGroup {
        private int[] scs;
        private UnicodeSet set;

        ExemplarGroup(UnicodeSet s, int[] scriptCodes) {
            this.set = s;
            this.scs = scriptCodes;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.scs.length && i < 4; ++i) {
                hash = (hash << 8) + this.scs[i];
            }
            return hash;
        }

        public boolean equals(Object other) {
            ExemplarGroup o = (ExemplarGroup)other;
            boolean r = Arrays.equals(this.scs, o.scs) && this.set.equals((Object)o.set);
            return r;
        }
    }
}

