/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Relation {
    private Map m;
    private CollectionFactory subcollection;

    public Relation(Map mainMap, CollectionFactory subcollection) {
        this.m = mainMap;
        if (subcollection == null) {
            subcollection = new CollectionMaker(null);
        }
        this.subcollection = subcollection;
    }

    public void clear() {
        this.m.clear();
    }

    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.m.containsValue(value);
    }

    public Set entrySet() {
        return this.m.entrySet();
    }

    public boolean equals(Object obj) {
        return ((Object)this.m).equals(obj);
    }

    public int hashCode() {
        return ((Object)this.m).hashCode();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public Object remove(Object key) {
        return this.m.remove(key);
    }

    public int size() {
        return this.m.size();
    }

    public String toString() {
        return this.m.toString();
    }

    public Set keySet() {
        return this.m.keySet();
    }

    public Collection values() {
        return this.m.values();
    }

    public Collection get(Object key, Collection output) {
        output.addAll((Collection)this.m.get(key));
        return output;
    }

    public void add(Object key, Object value) {
        Collection o = (Collection)this.m.get(key);
        if (o == null) {
            o = this.subcollection.make();
            this.m.put(key, o);
        }
        o.add(value);
    }

    public Iterator iterator() {
        return this.m.keySet().iterator();
    }

    public static class CollectionMaker
    implements CollectionFactory {
        public static final int HASH = 0;
        public static final int TREE = 1;
        private Comparator comparator = null;
        private int type = 0;

        public CollectionMaker(int type) {
            this.type = type;
        }

        public CollectionMaker(Comparator comparator) {
            this.comparator = comparator;
        }

        public Collection make() {
            if (this.comparator != null) {
                return new TreeSet(this.comparator);
            }
            if (this.type == 0) {
                return new HashSet();
            }
            return new TreeSet();
        }
    }

    public static interface CollectionFactory {
        public Collection make();
    }
}

