/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.util.BNF;
import com.ibm.icu.dev.test.util.Pick;
import com.ibm.icu.dev.test.util.Quoter;
import com.ibm.icu.dev.test.util.Tokenizer;
import com.ibm.icu.text.UnicodeSet;
import java.util.Random;

public class TestBNF {
    static final String[] testRules = new String[]{"$root = [ab]{3};", "$root = [ab]{3,};", "$root = [ab]{3,5};", "$root = [ab]*;", "$root = [ab]?;", "$root = [ab]+;", "$us = [a-z];$root = [0-9$us];", "$root = a $foo b? 25% end 30% | $foo 50%;\r\n$foo = c{1,5} 20%;", "$root = [a-z]{1,5}~;", "$root = [a-z]{5}~;", "$root = '\\' (u | U0010 | U000 $hex) $hex{4} ;\r\n$hex = [0-9A-Fa-f];"};
    static String unicodeSetBNF = "$root = $leaf | '[' $s $root2 $s ']' ;\r\n$root2 = $leaf | '[' $s $root3 $s ']' | ($root3 $s ($op $root3 $s){0,3}) ;\r\n$root3 = $leaf | '[' $s $root4 $s ']' | ($root4 $s ($op $root4 $s){0,3}) ;\r\n$root4 = $leaf | ($leaf $s ($op $leaf $s){0,3}) ;\r\n$op = (('&' | '-') $s)? 70%;$leaf = '[' $s $list $s ']' | $prop;\r\n$list = ($char $s ('-' $s $char $s)? 30%){1,5} ;\r\n$prop = '\\' (p | P) '{' $s $propName $s '}' | '[:' '^'? $s $propName $s ':]';\r\n$needsQuote = [\\-\\][:whitespace:][:control:]] ;\r\n$char = [[\\u0000-\\U00010FFFF]-$needsQuote] | $quoted ;\r\n$quoted = '\\' ('u' | 'U0010' | 'U000' $hex) $hex{4} ;\r\n$hex = [0-9A-Fa-f];\r\n$s = ' '? 20%;\r\n$propName = (whitespace | ws) | (uppercase | uc) | (lowercase | lc) | $category;\r\n$category = ((general | gc) $s '=' $s)? $catvalue;\r\n$catvalue = (C | Other | Cc | Control | Cf | Format | Cn | Unassigned | L | Letter);\r\n";
    static final String[] rules = new String[]{"$s = ' ';", "$noun = dog | house | government | wall | street | zebra;", "$adjective = red | glorious | simple | nasty | heavy | clean;", "$article = quickly | oddly | silently | boldly;", "$adjectivePhrase = ($adverb $s)? 50% $adjective* 0% 30% 20% 10%;", "$nounPhrase = $articles $s ($adjectivePhrase $s)? 30% $noun;", "$verb = goes | fishes | walks | sleeps;", "$tverb = carries | lifts | overturns | hits | jumps on;", "$copula = is 30% | seems 10%;", "$sentence1 = $nounPhrase $s $verb $s ($s $adverb)? 30%;", "$sentence2 = $nounPhrase $s $tverb $s $nounPhrase ($s $adverb)? 30%;", "$sentence3 = $nounPhrase $s $copula $s $adjectivePhrase;", "$conj = but | and | or;", "$sentence4 = $sentence1 | $sentence2 | $sentence3 20% | $sentence4 $conj $sentence4 20%;", "$sentence = $sentence4 '.';"};

    public static void main(String[] args) {
        TestBNF.testTokenizer();
        for (int i = 0; i < testRules.length; ++i) {
            TestBNF.testBNF(testRules[i], null, 20);
        }
        TestBNF.testBNF(unicodeSetBNF, null, 20);
    }

    static void testBNF(String rules, UnicodeSet chars, int count) {
        BNF bnf = new BNF(new Random(0L), new Quoter.RuleQuoter()).addSet("$chars", chars).addRules(rules).complete();
        System.out.println("====================================");
        System.out.println("BNF");
        System.out.println(rules);
        System.out.println(bnf.getInternal());
        for (int i = 0; i < count; ++i) {
            System.out.println(i + ": " + bnf.next());
        }
    }

    static void testMatch(Pick p, String source) {
        Pick.Position pp = new Pick.Position();
        boolean value = p.match(source, pp);
        System.out.println("Match: " + value + ", " + pp);
    }

    public static void printRandoms() {
        BNF bnf = new BNF(new Random(0L), new Quoter.RuleQuoter()).addRules("[a-z]{2,5}").complete();
        System.out.println("Start");
        for (int i = 0; i < 100; ++i) {
            String temp = bnf.next();
            System.out.println(i + ")\t" + temp);
        }
    }

    public static void testTokenizer() {
        Tokenizer t = new Tokenizer();
        String[] samples = new String[]{"a'b'c d #abc\r e", "'a '123 321", "\\\\", "a'b", "a'", "abc def%?ghi", "%", "a", "\\ a", "a''''b"};
        for (int i = 0; i < samples.length; ++i) {
            t.setSource(samples[i]);
            System.out.println();
            System.out.println("Input: " + t.getSource());
            int type = 0;
            while (type != -1) {
                type = t.next();
                System.out.println(t.toString(type, false));
            }
        }
    }

    static class Counts {
        int[] counts;

        Counts(int max) {
            this.counts = new int[max + 1];
        }

        void inc(int index) {
            int n = index;
            this.counts[n] = this.counts[n] + 1;
        }

        void show() {
            System.out.println("Printing Counts");
            for (int i = 0; i < this.counts.length; ++i) {
                if (this.counts[i] == 0) continue;
                System.out.println(i + ": " + this.counts[i]);
            }
            System.out.println();
        }
    }
}

