/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.util.DataInputCompressor;
import com.ibm.icu.dev.test.util.DataOutputCompressor;
import com.ibm.icu.dev.test.util.UnicodeProperty;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.Freezable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public final class UnicodeMap
implements Cloneable,
Freezable,
Externalizable {
    static final boolean ASSERTIONS = false;
    static final long GROWTH_PERCENT = 200L;
    static final long GROWTH_GAP = 10L;
    private int length;
    private int[] transitions;
    private Object[] values;
    private LinkedHashSet availableValues = new LinkedHashSet();
    private transient boolean staleAvailableValues;
    private transient boolean errorOnReset;
    private transient boolean locked;
    private int lastIndex;
    static final boolean DEBUG_WRITE = false;

    public UnicodeMap() {
        this.clear();
    }

    public UnicodeMap clear() {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.length = 2;
        this.transitions = new int[]{0, 0x110000, 0, 0, 0, 0, 0, 0, 0, 0};
        this.values = new Object[10];
        this.availableValues.clear();
        this.staleAvailableValues = false;
        this.errorOnReset = false;
        this.lastIndex = 0;
        return this;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            UnicodeMap that = (UnicodeMap)other;
            if (this.length != that.length) {
                return false;
            }
            for (int i = 0; i < this.length - 1; ++i) {
                if (this.transitions[i] != that.transitions[i]) {
                    return false;
                }
                if (UnicodeMap.areEqual(this.values[i], that.values[i])) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int getHashCode(Object o) {
        return o.hashCode();
    }

    public static boolean areEqual(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public int hashCode() {
        int result = this.length;
        for (int i = 0; i < this.length - 1; ++i) {
            result = 37 * result + this.transitions[i];
            result = 37 * result + this.getHashCode(this.values[i]);
        }
        return result;
    }

    public Object cloneAsThawed() {
        UnicodeMap that = new UnicodeMap();
        that.length = this.length;
        that.transitions = (int[])this.transitions.clone();
        that.values = (Object[])this.values.clone();
        that.availableValues = new LinkedHashSet(this.availableValues);
        that.locked = false;
        return that;
    }

    void _checkInvariants() {
        int i;
        if (this.length < 2 || this.length > this.transitions.length || this.transitions.length != this.values.length) {
            throw new IllegalArgumentException("Invariant failed: Lengths bad");
        }
        for (i = 1; i < this.length - 1; ++i) {
            if (!UnicodeMap.areEqual(this.values[i - 1], this.values[i])) continue;
            throw new IllegalArgumentException("Invariant failed: values shared at \t" + Utility.hex((long)(i - 1)) + ": <" + this.values[i - 1] + ">" + "\t" + Utility.hex((long)i) + ": <" + this.values[i] + ">");
        }
        if (this.transitions[0] != 0 || this.transitions[this.length - 1] != 0x110000) {
            throw new IllegalArgumentException("Invariant failed: bounds set wrong");
        }
        for (i = 1; i < this.length - 1; ++i) {
            if (this.transitions[i - 1] < this.transitions[i]) continue;
            throw new IllegalArgumentException("Invariant failed: not monotonic\t" + Utility.hex((long)(i - 1)) + ": " + this.transitions[i - 1] + "\t" + Utility.hex((long)i) + ": " + this.transitions[i]);
        }
    }

    private int _findIndex(int c) {
        int lo = 0;
        int hi = this.length - 1;
        int i = lo + hi >>> 1;
        while (i != lo) {
            if (c < this.transitions[i]) {
                hi = i;
            } else {
                lo = i;
            }
            i = lo + hi >>> 1;
        }
        return lo;
    }

    private void _checkFind(int codepoint, int value) {
        int other = this.__findIndex(codepoint);
        if (other != value) {
            throw new IllegalArgumentException("Invariant failed: binary search\t" + Utility.hex((long)codepoint) + ": " + value + "\tshould be: " + other);
        }
    }

    private int __findIndex(int codepoint) {
        for (int i = this.length - 1; i > 0; --i) {
            if (this.transitions[i] > codepoint) continue;
            return i;
        }
        return 0;
    }

    private void _removeAt(int index, int count) {
        for (int i = index + count; i < this.length; ++i) {
            this.transitions[i - count] = this.transitions[i];
            this.values[i - count] = this.values[i];
        }
        this.length -= count;
    }

    private void _insertGapAt(int index, int count) {
        int newLength = this.length + count;
        int[] oldtransitions = this.transitions;
        Object[] oldvalues = this.values;
        if (newLength > this.transitions.length) {
            int allocation = (int)(10L + (long)newLength * 200L / 100L);
            this.transitions = new int[allocation];
            this.values = new Object[allocation];
            for (int i = 0; i < index; ++i) {
                this.transitions[i] = oldtransitions[i];
                this.values[i] = oldvalues[i];
            }
        }
        for (int i = this.length - 1; i >= index; --i) {
            this.transitions[i + count] = oldtransitions[i];
            this.values[i + count] = oldvalues[i];
        }
        this.length = newLength;
    }

    private UnicodeMap _put(int codepoint, Object value) {
        int baseIndex = this.transitions[this.lastIndex] <= codepoint && codepoint < this.transitions[this.lastIndex + 1] ? this.lastIndex : this._findIndex(codepoint);
        int limitIndex = baseIndex + 1;
        if (UnicodeMap.areEqual(this.values[baseIndex], value)) {
            return this;
        }
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        if (this.errorOnReset && this.values[baseIndex] != null) {
            throw new IllegalArgumentException("Attempt to reset value for " + Utility.hex((long)codepoint) + " when that is disallowed. Old: " + this.values[baseIndex] + "; New: " + value);
        }
        this.staleAvailableValues = true;
        this.availableValues.add(value);
        int baseCP = this.transitions[baseIndex];
        int limitCP = this.transitions[limitIndex];
        if (baseCP == codepoint) {
            boolean connectsWithPrevious;
            boolean bl = connectsWithPrevious = baseIndex != 0 && UnicodeMap.areEqual(value, this.values[baseIndex - 1]);
            if (limitCP == codepoint + 1) {
                boolean connectsWithFollowing;
                boolean bl2 = connectsWithFollowing = baseIndex < this.length - 1 && UnicodeMap.areEqual(value, this.values[limitIndex]);
                if (connectsWithPrevious) {
                    if (connectsWithFollowing) {
                        this._removeAt(baseIndex, 2);
                    } else {
                        this._removeAt(baseIndex, 1);
                    }
                    --baseIndex;
                } else if (connectsWithFollowing) {
                    this._removeAt(baseIndex, 1);
                    this.transitions[baseIndex] = codepoint;
                } else {
                    this.values[baseIndex] = value;
                }
            } else if (connectsWithPrevious) {
                int n = baseIndex;
                this.transitions[n] = this.transitions[n] + 1;
            } else {
                this.transitions[baseIndex] = codepoint + 1;
                this._insertGapAt(baseIndex, 1);
                this.values[baseIndex] = value;
                this.transitions[baseIndex] = codepoint;
            }
        } else if (limitCP == codepoint + 1) {
            boolean connectsWithFollowing;
            boolean bl = connectsWithFollowing = baseIndex < this.length - 1 && UnicodeMap.areEqual(value, this.values[limitIndex]);
            if (connectsWithFollowing) {
                int n = limitIndex;
                this.transitions[n] = this.transitions[n] - 1;
                return this;
            }
            this._insertGapAt(limitIndex, 1);
            this.transitions[limitIndex] = codepoint;
            this.values[limitIndex] = value;
        } else {
            this._insertGapAt(++baseIndex, 2);
            this.transitions[baseIndex] = codepoint;
            this.values[baseIndex] = value;
            this.transitions[baseIndex + 1] = codepoint + 1;
            this.values[baseIndex + 1] = this.values[baseIndex - 1];
        }
        this.lastIndex = baseIndex;
        return this;
    }

    private UnicodeMap _putAll(int startCodePoint, int endCodePoint, Object value) {
        for (int i = startCodePoint; i <= endCodePoint; ++i) {
            this._put(i, value);
        }
        return this;
    }

    public UnicodeMap put(int codepoint, Object value) {
        if (codepoint < 0 || codepoint > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of range: " + codepoint);
        }
        this._put(codepoint, value);
        return this;
    }

    public UnicodeMap putAll(UnicodeSet codepoints, Object value) {
        UnicodeSetIterator it = new UnicodeSetIterator(codepoints);
        while (it.nextRange()) {
            this._putAll(it.codepoint, it.codepointEnd, value);
        }
        return this;
    }

    public UnicodeMap putAll(int startCodePoint, int endCodePoint, Object value) {
        if (startCodePoint < 0 || endCodePoint > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of range: " + Utility.hex((long)startCodePoint) + ".." + Utility.hex((long)endCodePoint));
        }
        for (int i = startCodePoint; i <= endCodePoint; ++i) {
            this._put(i, value);
        }
        return this;
    }

    public UnicodeMap putAll(UnicodeProperty prop) {
        for (int i = 0; i <= 0x10FFFF; ++i) {
            this._put(i, prop.getValue(i));
        }
        return this;
    }

    public UnicodeMap putAll(UnicodeMap prop) {
        for (int i = 0; i <= 0x10FFFF; ++i) {
            this._put(i, prop.getValue(i));
        }
        return this;
    }

    public UnicodeMap setMissing(Object value) {
        if (!this.getAvailableValues().contains(value)) {
            this.staleAvailableValues = true;
            this.availableValues.add(value);
            for (int i = 0; i < this.length; ++i) {
                if (this.values[i] != null) continue;
                this.values[i] = value;
            }
            return this;
        }
        return this.putAll(this.getSet(null), value);
    }

    public UnicodeSet getSet(Object value, UnicodeSet result) {
        if (result == null) {
            result = new UnicodeSet();
        }
        for (int i = 0; i < this.length - 1; ++i) {
            if (!UnicodeMap.areEqual(value, this.values[i])) continue;
            result.add(this.transitions[i], this.transitions[i + 1] - 1);
        }
        return result;
    }

    public UnicodeSet getSet(Object value) {
        return this.getSet(value, null);
    }

    public UnicodeSet keySet() {
        return this.getSet(null, null).complement();
    }

    public Collection getAvailableValues(Collection result) {
        if (this.staleAvailableValues) {
            HashSet<Object> temp = new HashSet<Object>();
            for (int i = 0; i < this.length - 1; ++i) {
                if (this.values[i] == null) continue;
                temp.add(this.values[i]);
            }
            this.availableValues.retainAll(temp);
            this.staleAvailableValues = false;
        }
        if (result == null) {
            result = new ArrayList(this.availableValues.size());
        }
        result.addAll(this.availableValues);
        return result;
    }

    public Collection getAvailableValues() {
        return this.getAvailableValues(null);
    }

    public Object getValue(int codepoint) {
        if (codepoint < 0 || codepoint > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of range: " + codepoint);
        }
        return this.values[this._findIndex(codepoint)];
    }

    public String fold(String source) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < source.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)source, (int)i);
            Object mResult = this.getValue(cp);
            if (mResult != null) {
                result.append(mResult);
                continue;
            }
            UTF16.append((StringBuffer)result, (int)cp);
        }
        return result.toString();
    }

    public UnicodeMap composeWith(UnicodeMap other, Composer composer) {
        for (int i = 0; i <= 0x10FFFF; ++i) {
            Object v2;
            Object v3;
            Object v1 = this.getValue(i);
            if (v1 == (v3 = composer.compose(i, v1, v2 = other.getValue(i))) || v1 != null && v1.equals(v3)) continue;
            this.put(i, v3);
        }
        return this;
    }

    public UnicodeMap composeWith(UnicodeSet set, Object value, Composer composer) {
        UnicodeSetIterator it = new UnicodeSetIterator(set);
        while (it.next()) {
            Object v3;
            int i = it.codepoint;
            Object v1 = this.getValue(i);
            if (v1 == (v3 = composer.compose(i, v1, value)) || v1 != null && v1.equals(v3)) continue;
            this.put(i, v3);
        }
        return this;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Comparator collected) {
        StringBuffer result = new StringBuffer();
        if (collected == null) {
            for (int i = 0; i < this.length - 1; ++i) {
                Object value = this.values[i];
                if (value == null) continue;
                int start = this.transitions[i];
                int end = this.transitions[i + 1] - 1;
                result.append(Utility.hex((long)start));
                if (start != end) {
                    result.append("..").append(Utility.hex((long)end));
                }
                result.append("\t=> ").append(this.values[i] == null ? "null" : this.values[i].toString()).append("\r\n");
            }
        } else {
            Set set = (Set)this.getAvailableValues(new TreeSet(collected));
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Object value = it.next();
                UnicodeSet s = this.getSet(value);
                result.append(value).append("\t=> ").append(s.toPattern(true)).append("\r\n");
            }
        }
        return result.toString();
    }

    public boolean getErrorOnReset() {
        return this.errorOnReset;
    }

    public void setErrorOnReset(boolean errorOnReset) {
        this.errorOnReset = errorOnReset;
    }

    public boolean isFrozen() {
        return this.locked;
    }

    public Object freeze() {
        this.locked = true;
        return this;
    }

    public void writeExternal(ObjectOutput out1) throws IOException {
        DataOutputCompressor sc = new DataOutputCompressor(out1);
        Collection availableValues = this.getAvailableValues();
        boolean allStrings = this.allAreString(availableValues);
        sc.writeBoolean(allStrings);
        LinkedHashMap object_index = new LinkedHashMap();
        if (this.allAreString(availableValues)) {
            sc.writeStringSet(new TreeSet(availableValues), object_index);
        } else {
            sc.writeCollection(availableValues, object_index);
        }
        sc.writeUInt(this.length);
        int lastTransition = -1;
        int lastValueNumber = 0;
        for (int i = 0; i < this.length; ++i) {
            boolean canCombine;
            int valueNumber = (Integer)object_index.get(this.values[i]);
            int deltaTransition = this.transitions[i] - lastTransition;
            lastTransition = this.transitions[i];
            int deltaValueNumber = valueNumber - lastValueNumber;
            lastValueNumber = valueNumber;
            deltaValueNumber <<= 1;
            boolean bl = canCombine = deltaTransition == 1;
            if (canCombine) {
                deltaValueNumber |= 1;
            }
            sc.writeInt(deltaValueNumber);
            if (canCombine) continue;
            sc.writeUInt(deltaTransition);
        }
        sc.flush();
    }

    private boolean allAreString(Collection availableValues2) {
        Iterator it = availableValues2.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof String) continue;
            return false;
        }
        return true;
    }

    public void readExternal(ObjectInput in1) throws IOException, ClassNotFoundException {
        DataInputCompressor sc = new DataInputCompressor(in1);
        boolean allStrings = sc.readBoolean();
        this.availableValues = new LinkedHashSet();
        Object[] valuesList = allStrings ? sc.readStringSet(this.availableValues) : sc.readCollection(this.availableValues);
        this.length = sc.readUInt();
        this.transitions = new int[this.length];
        this.values = new Object[this.length];
        int currentTransition = -1;
        int currentValue = 0;
        for (int i = 0; i < this.length; ++i) {
            int temp = sc.readInt();
            boolean combined = (temp & 1) != 0;
            this.values[i] = valuesList[currentValue += (temp >>= 1)];
            int deltaTransition = !combined ? sc.readUInt() : 1;
            this.transitions[i] = currentTransition += deltaTransition;
        }
    }

    static int findCommon(String last, String s) {
        int minLen = Math.min(last.length(), s.length());
        for (int i = 0; i < minLen; ++i) {
            if (last.charAt(i) == s.charAt(i)) continue;
            return i;
        }
        return minLen;
    }

    public static class MapIterator {
        public int codepoint;
        public int codepointEnd;
        public Object value;
        private UnicodeMap map;
        private int index;
        private int startRange;
        private int endRange;
        private Object lastValue;

        public MapIterator(UnicodeMap map) {
            this.reset(map);
        }

        public boolean nextRange() {
            if (this.index < 0 || this.index >= this.map.length - 1) {
                return false;
            }
            this.value = this.map.values[this.index];
            this.codepoint = this.startRange = this.map.transitions[this.index++];
            this.codepointEnd = this.endRange = this.map.transitions[this.index] - 1;
            return true;
        }

        public boolean next() {
            if (this.startRange > this.endRange) {
                if (!this.nextRange()) {
                    return false;
                }
                this.lastValue = this.map.values[this.index - 1];
            }
            this.value = this.lastValue;
            this.codepointEnd = this.startRange++;
            this.codepoint = this.codepointEnd;
            return true;
        }

        public MapIterator reset() {
            this.index = 0;
            this.startRange = 0;
            this.endRange = -1;
            return this;
        }

        public MapIterator reset(UnicodeMap map) {
            this.map = map;
            return this.reset();
        }
    }

    public static interface Composer {
        public Object compose(int var1, Object var2, Object var3);
    }
}

