/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class XEquivalenceMap {
    HashMap source_target = new HashMap();
    HashMap target_sourceSet = new HashMap();
    HashMap source_Set = new HashMap();

    public XEquivalenceMap clear() {
        this.source_target.clear();
        this.target_sourceSet.clear();
        this.source_Set.clear();
        return this;
    }

    public XEquivalenceMap add(Object source, Object target) {
        Object otherTarget = this.source_target.get(source);
        if (otherTarget != null) {
            if (otherTarget.equals(target)) {
                return this;
            }
            throw new IllegalArgumentException("Same source mapping to different targets: " + source + " => " + otherTarget + " & " + target);
        }
        this.source_target.put(source, target);
        HashSet<Object> s = (HashSet<Object>)this.target_sourceSet.get(target);
        if (s == null) {
            s = new HashSet<Object>();
            this.target_sourceSet.put(target, s);
        }
        s.add(source);
        this.source_Set.put(source, s);
        return this;
    }

    public Set getEquivalences(Object source) {
        Set s = (Set)this.source_Set.get(source);
        if (s == null) {
            return null;
        }
        return Collections.unmodifiableSet(s);
    }

    public boolean areEquivalent(Object source1, Object source2) {
        Set s = (Set)this.source_Set.get(source1);
        if (s == null) {
            return false;
        }
        return s.contains(source2);
    }

    public Object getTarget(Object source) {
        return this.source_target.get(source);
    }

    public Set getSources(Object target) {
        Set s = (Set)this.target_sourceSet.get(target);
        return Collections.unmodifiableSet(s);
    }

    public Iterator iterator() {
        MyIterator result = new MyIterator();
        result.target_sourceSet_iterator = this.target_sourceSet.keySet().iterator();
        return result;
    }

    public int size() {
        return this.target_sourceSet.size();
    }

    private class MyIterator
    implements Iterator {
        private Iterator target_sourceSet_iterator;

        private MyIterator() {
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.target_sourceSet_iterator.hasNext();
        }

        public Object next() {
            return XEquivalenceMap.this.getSources(this.target_sourceSet_iterator.next());
        }
    }
}

