/*
 ******************************************************************************
 * Copyright (C) 2004-2009, International Business Machines Corporation and   *
 * others. All Rights Reserved.                                               *
 ******************************************************************************
 */
/**
 * @author Ram Viswanadha
 */
package org.unicode.cldr.icu;

public class LDMLConstants {
    public static final String LDML            = "ldml";
    public static final String IDENTITY        = "identity";
    public static final String LDN             = "localeDisplayNames";
    public static final String FALLBACK        = "fallback";
    public static final String LAYOUT          = "layout";
    public static final String ORIENTATION     = "orientation";
    public static final String INTEXT          = "inText";
    public static final String INLIST          = "inList";
    public static final String CHARACTERS      = "characters";
    public static final String CASING          = "casing";
    public static final String LINES           = "lines";
    public static final String DELIMITERS      = "delimiters";
    public static final String MEASUREMENT     = "measurement";
    public static final String DATES           = "dates";
    public static final String NUMBERS         = "numbers";
    public static final String COLLATIONS      = "collations";
    public static final String POSIX           = "posix";
    public static final String SPECIAL         = "special";
    public static final String SOURCE          = "source";
    public static final String PATH            = "path";
    public static final String REGISTRY        = "registry";
    public static final String ALT             = "alt";
    public static final String DRAFT           = "draft";
    public static final String REFERENCES      = "references";
    public static final String PROPOSED        = "proposed";
    public static final String ALIAS           = "alias";
    public static final String VERSION         = "version";
    public static final String LOCALEDISPLAYPATTERN = "localeDisplayPattern";
    public static final String LANGUAGE        = "language";
    public static final String SCRIPT          = "script";
    public static final String CANONICAL       = "canonical";
    public static final String TERRITORY       = "territory";
    public static final String VARIANT         = "variant";
    public static final String TYPE            = "type";
    public static final String AUXILIARY       = "auxiliary";
    public static final String CURRENCY_SYMBOL = "currencySymbol";
    public static final String NUMBER          = "number";
    public static final String GENERATION      = "generation";
    public static final String LANGUAGES       = "languages";
    public static final String SCRIPTS         = "scripts";
    public static final String TERRITORIES     = "territories";
    public static final String VARIANTS        = "variants";
    public static final String TYPES           = "types";
    public static final String KEYS            = "keys";
    public static final String KEY             = "key";
    public static final String EXEMPLAR_CHARACTERS ="exemplarCharacters";
    public static final String MAPPING         ="mapping";
    public static final String QS              = "quotationStart";
    public static final String QE              = "quotationEnd";
    public static final String AQS             = "alternateQuotationStart";
    public static final String AQE             = "alternateQuotationEnd";
    public static final String MS              = "measurementSystem";
    public static final String MSNS            = "measurementSystemNames";
    public static final String MSN             = "measurementSystemName";
    public static final String CODE_PATTERNS   = "codePatterns";
    public static final String CODE_PATTERN    = "codePattern";
    public static final String HEIGHT          = "height";
    public static final String WIDTH           = "width";
    public static final String PAPER_SIZE      = "paperSize";
    public static final String LPC             = "localizedPatternChars";
    public static final String DEFAULT         = "default";
    public static final String DRP             = "dateRangePattern";
    public static final String CALENDARS       = "calendars";
    public static final String MONTHS          = "months";
    public static final String DAYS            = "days";
    public static final String TZN             = "timeZoneNames";
    public static final String CALENDAR        = "calendar";
    public static final String HOUR_FORMAT           = "hourFormat";
    public static final String HOURS_FORMAT          = "hoursFormat";
    public static final String GMT_FORMAT            = "gmtFormat";
    public static final String GMT_ZERO_FORMAT       = "gmtZeroFormat";
    public static final String REGION_FORMAT         = "regionFormat";
    public static final String FALLBACK_FORMAT       = "fallbackFormat";
    public static final String ABBREVIATION_FALLBACK = "abbreviationFallback";
    public static final String PREFERENCE_ORDERING   = "preferenceOrdering";
    public static final String SINGLE_COUNTRIES      = "singleCountries";
    public static final String ZONE            = "zone";
    public static final String METAZONE        = "metazone";
    public static final String EXEMPLAR_CITY   = "exemplarCity";
    public static final String LONG            = "long";
    public static final String SHORT           = "short";
    public static final String DAYLIGHT        = "daylight";
    public static final String STANDARD        = "standard";
    public static final String GENERIC         = "generic";
    public static final String USES_METAZONE   = "usesMetazone";
    public static final String COMMONLY_USED   = "commonlyUsed";
    public static final String USED            = "used";
    public static final String MZONE           = "mzone";
    public static final String WEEK            = "week";
    public static final String AM              = "am";
    public static final String PM              = "pm";
    public static final String ERAS            = "eras";
    public static final String DATE_FORMATS      = "dateFormats";
    public static final String DFL               = "dateFormatLength";
    public static final String DATE_FORMAT       = "dateFormat";
    public static final String SEPARATOR       = "separator";

    public static final String TIME_FORMATS      = "timeFormats";
    public static final String TFL               = "timeFormatLength";
    public static final String TIME_FORMAT       = "timeFormat";
    
    public static final String DATE_TIME_FORMATS = "dateTimeFormats";
    public static final String DTFL              = "dateTimeFormatLength";
    public static final String DATE_TIME_FORMAT  = "dateTimeFormat";
    
    public static final String MONTH_CONTEXT   = "monthContext";
    public static final String DAY_CONTEXT     = "dayContext";
    public static final String MONTH_WIDTH     = "monthWidth";
    public static final String DAY_WIDTH       = "dayWidth";

    public static final String MONTH           = "month";
    public static final String DAY             = "day";
    public static final String COUNT           = "count";
    public static final String MINDAYS         = "minDays";
    public static final String FIRSTDAY        = "firstDay" ;
    public static final String WENDSTART       = "weekendStart";
    public static final String WENDEND         = "weekendEnd";
    public static final String WEEKEND         = "weekend";
    public static final String TIME            = "time";
    public static final String ERA             = "era";
    public static final String ERAABBR         = "eraAbbr";
    public static final String ERANAMES        = "eraNames";
    public static final String ERANARROW       = "eraNarrow";
    public static final String ABBREVIATED     = "abbreviated";
    public static final String WIDE            = "wide";
    public static final String CURRENCY        = "currency";
    public static final String CHOICE          = "choice";
    public static final String DECIMAL_FORMATS = "decimalFormats";
    public static final String SCIENTIFIC_FORMATS  = "scientificFormats";
    public static final String CURRENCY_FORMATS    = "currencyFormats";
    public static final String PERCENT_FORMATS     = "percentFormats";
    public static final String SYMBOLS         = "symbols";
    public static final String CURRENCIES      = "currencies";
    public static final String SYMBOL          = "symbol";
    public static final String DISPLAY_NAME    = "displayName";
    public static final String PATTERN         = "pattern";
    public static final String DECIMAL         = "decimal";
    public static final String GROUP           = "group";
    public static final String MESSAGES        = "messages";
    public static final String YESSTR          = "yesstr";
    public static final String YESEXPR         = "yesexpr";
    public static final String NOSTR           = "nostr";
    public static final String NOEXPR          = "noexpr";
    public static final String COLLATION       = "collation";
    public static final String SEQUENCE        = "Sequence";
    public static final String RULES           = "rules";
    public static final String SETTINGS        = "settings";
    public static final String SUPPRESS_CONTRACTIONS = "suppress_contractions";
    public static final String OPTIMIZE        = "optimize";
    public static final String BASE            = "base";
    public static final String STRENGTH        = "strength";
    public static final String ALTERNATE       = "alternate";
    public static final String BACKWARDS       = "backwards";
    public static final String NORMALIZATION   = "normalization";
    public static final String CASE_LEVEL      = "caseLevel";
    public static final String CASE_FIRST      = "caseFirst";
    public static final String HIRAGANA_Q      = "hiraganaQuaternary";
    public static final String HIRAGANA_Q_DEP  = "hiraganaQuarternary";
    public static final String NUMERIC         = "numeric";
    public static final String RESET           = "reset";
    public static final String PC              = "pc";
    public static final String SC              = "sc";
    public static final String TC              = "tc";
    public static final String QC              = "qc";
    public static final String IC              = "ic";
    public static final String P               = "p";
    public static final String S               = "s";
    public static final String T               = "t";
    public static final String Q               = "q";
    public static final String I               = "i";
    public static final String X               = "x";
    public static final String LAST_VARIABLE   = "last_variable";
    public static final String CP              = "cp";
    public static final String HEX             = "hex";
    public static final String PRIMARY         = "primary";
    public static final String SECONDARY       = "secondary";
    public static final String TERTIARY        = "tertiary";
    public static final String QUARTERNARY     = "quarternary";
    public static final String IDENTICAL       = "identical";
    public static final String BEFORE          = "before";
    public static final String CONTEXT         = "context";
    public static final String EXTEND          = "extend";
    public static final String FIELDS          = "fields";
    public static final String FIELD           = "field";
    public static final String RELATIVE        = "relative";
    // supplemental data
    public static final String SUPPLEMENTAL_DATA = "supplementalData";
    public static final String CURRENCY_DATA     = "currencyData";
    public static final String FRACTIONS         = "fractions";
    public static final String INFO              = "info";
    public static final String ISO_4217          = "iso4217";
    public static final String TENDER            = "tender";
    public static final String DIGITS            = "digits";
    public static final String ROUNDING          = "rounding";
    public static final String REGION            = "region";
    public static final String ISO_3166          = "iso3166";
    public static final String VALID_SUBLOCALE   = "validSubLocales";
    public static final String TERRITORY_CONTAINMENT = "territoryContainment";
    public static final String CONTAINS          = "contains";
    public static final String CODE_MAPPINGS     = "codeMappings";
    public static final String LANGUAGE_DATA     = "languageData";
    public static final String TERRITORY_DATA    = "territoryData";
    public static final String TERRITORY_INFO    = "territoryInfo";
    public static final String MPT               = "mostPopulousTerritory";
    public static final String MPTZ              = "mostPopulousTimezone";
    public static final String METAZONE_INFO     = "metazoneInfo";
    public static final String METAZONE_MAPPINGS = "metazoneMappings";
    public static final String TIMEZONE          = "timezone";
    public static final String TO                = "to";
    public static final String FROM              = "from";
    public static final String LOCALE            = "locale";
    public static final String LOCALES           = "locales";
    public static final String META_DATA         = "metadata";
    public static final String LANGUAGE_ALIAS    = "languageAlias";
    public static final String TERRITORY_ALIAS   = "territoryAlias";
    public static final String REPLACEMENT       = "replacement";
    public static final String SEGMENTATIONS     = "segmentations";
    public static final String TIMEZONE_DATA     = "timezoneData";
    public static final String CALENDAR_DATA     = "calendarData";
    public static final String CALENDAR_PREFERENCE_DATA = "calendarPreferenceData";
    public static final String CALENDAR_PREFERENCE = "calendarPreference";
    public static final String ORDERING          = "ordering";
    public static final String WEEK_DATA         = "weekData";
    public static final String MEASUREMENT_DATA  = "measurementData";
    public static final String ZONE_ITEM         = "zoneItem";
    public static final String ALIASES           = "aliases";
    public static final String MAP_TIMEZONES     = "mapTimezones";
    public static final String MAP_ZONE          = "mapZone";
    public static final String OTHER             = "other";
    public static final String ZONE_FORMATTING   = "zoneFormatting";
    public static final String MULTIZONE         = "multizone";
    public static final String LIKELY_SUBTAGS    = "likelySubtags";
    public static final String LIKELY_SUBTAG     = "likelySubtag";
    public static final String LIKELYSUBTAGS_MAPPINGS = "likelySubtagsMappings";
    public static final String PLURALS           = "plurals";
    public static final String PLURAL_RULE       = "pluralRule";
    public static final String PLURAL_RULES      = "pluralRules";
    public static final String ONE      		 = "one";
    public static final String FEW      		 = "few";
    public static final String MANY				 = "many";
    public static final String TELEPHONE_CODE_DATA = "telephoneCodeData";
    public static final String POSTAL_CODE_DATA = "postalCodeData";
    public static final String CLDR_VERSION      = "cldrVersion";
    public static final String BCP47_KEYWORD_MAPPINGS = "bcp47KeywordMappings";
    public static final String MAP_KEYS          = "mapKeys";
    public static final String KEY_MAP           = "keyMap";
    public static final String MAP_TYPES         = "mapTypes";
    public static final String TYPE_MAP          = "typeMap";
    public static final String BCP47             = "bcp47";

    //PN added
    public static final String MEDIUM          = "medium";
    public static final String DECFL           = "decimalFormatLength";
    public static final String DECIMAL_FORMAT  = "decimalFormat";
    public static final String SCIFL           = "scientificFormatLength";
    public static final String SCIENTIFIC_FORMAT  = "scientificFormat";
    public static final String PERFL           = "percentFormatLength";
    public static final String PERCENT_FORMAT  = "percentFormat";
    public static final String CURFL           = "currencyFormatLength";
    public static final String CURRENCY_FORMAT = "currencyFormat";
    public static final String CURRENCY_SPACING = "currencySpacing";
    public static final String CURRENCY_SPC_BEFORE = "beforeCurrency";
    public static final String CURRENCY_SPC_AFTER = "afterCurrency";
    public static final String CURRENCY_SPC_MATCH = "currencyMatch";
    public static final String CURRENCY_SPC_SUR_MATCH = "surroundingMatch";
    public static final String CURRENCY_SPC_INSERT = "insertBetween";
    public static final String LIST            = "list";
    public static final String PERCENT_SIGN    = "percentSign";
    public static final String NATIVE_ZERO_SIGN= "nativeZeroDigit";
    public static final String PATTERN_DIGIT   = "patternDigit";
    public static final String PLUS_SIGN       = "plusSign";
    public static final String MINUS_SIGN      = "minusSign";
    public static final String EXPONENTIAL     = "exponential";
    public static final String PER_MILLE       = "perMille";
    public static final String INFINITY        = "infinity";
    public static final String NAN             = "nan";
    public static final String XMLNS           = "xmlns";
    public static final String ID              = "id";
    //PN added - type values
    public static final String NARROW          = "narrow";
    public static final String FORMAT          = "format";
    public static final String STAND_ALONE     = "stand-alone";
    public static final String SUN             = "sun";
    public static final String MON             = "mon";
    public static final String TUE             = "tue";
    public static final String WED             = "wed";
    public static final String THU             = "thu";
    public static final String FRI             = "fri";
    public static final String SAT             = "sat";
    public static final String DATE            = "date";
    public static final String MONTH_1          = "1";
    public static final String MONTH_2          = "2";
    public static final String MONTH_3          = "3";
    public static final String MONTH_4          = "4";
    public static final String MONTH_5          = "5";
    public static final String MONTH_6          = "6";
    public static final String MONTH_7          = "7";
    public static final String MONTH_8          = "8";
    public static final String MONTH_9          = "9";
    public static final String MONTH_10         = "10";
    public static final String MONTH_11         = "11";
    public static final String MONTH_12         = "12";
    public static final String MONTH_13         = "13";
    public static final String ERA_0            = "0";
    public static final String ERA_1            = "1";
    public static final String ERA_232          = "232";
    public static final String ERA_233          = "233";
    public static final String ERA_234          = "234";
    public static final String ERA_235          = "235";
    public static final String METRIC           = "metric";
    public static final String US               = "US";
    public static final String UK               = "UK";
    public static final String GREGORIAN       = "gregorian";
    public static final String BUDDHIST        = "buddhist";
    public static final String ISLAMIC         = "islamic";
    public static final String ISLAMIC_CIVIL   = "islamic-civil";
    public static final String HEBREW          = "hebrew";
    public static final String JAPANESE        = "japanese";
    public static final String CHINESE         = "chinese";
    public static final String ROC             = "ROC";   //Republic of China
    public static final String KOREAN          = "korean";
    public static final String INTERNATIONAL   = "international";

    //quarters 
    public static final String QUARTERS         = "quarters";
    public static final String QUARTER_CONTEXT  = "quarterContext";
    public static final String QUARTER_WIDTH    = "quarterWidth";
    public static final String QUARTER          = "quarter";
    public static final String Q_1              = "1";
    public static final String Q_2              = "2";
    public static final String Q_3              = "3";
    public static final String Q_4              = "4";
    
    //flexible date time
    public static final String AVAIL_FMTS       = "availableFormats";
    public static final String DATE_FMT_ITEM    = "dateFormatItem";
    public static final String APPEND_ITEMS     = "appendItems";
    public static final String APPEND_ITEM      = "appendItem";
    public static final String REQUEST          = "request";
    public static final String INTVL_FMTS       = "intervalFormats";
    public static final String INTVL_FMT_FALL   = "intervalFormatFallback";
    public static final String INTVL_FMT_ITEM   = "intervalFormatItem";
    public static final String GREATEST_DIFF    = "greatestDifference";
    
    public static final String LOCALE_PATTERN   = "localePattern";
    public static final String LOCALE_SEPARATOR = "localeSeparator";
    
    public static final String CURRENCY_DECIMAL = "currencyDecimal";
    public static final String CURRENCY_GROUP   = "currencyGroup";
    public static final String CURRENCY_UNIT_PATTERNS = "CurrencyUnitPatterns";
    public static final String CURRENCY_PLURALS = "CurrencyPlurals";

    public static final String UNITS            = "units";
    public static final String UNITS_SHORT      = "unitsShort";
    public static final String UNIT             = "unit";
    public static final String UNIT_PATTERN     = "unitPattern";
    public static final String LANGUAGES_SHORT  = "languagesShort";

    // Rule Based Number Formatting (RBNF)
    public static final String RBNF             = "rbnf";
    public static final String RULESET          = "ruleset";
    public static final String RULESETGROUPING  = "rulesetGrouping";
    public static final String SPELLOUTRULES    = "SpelloutRules";
    public static final String ACCESS           = "access";
    public static final String RBNFRULE         = "rbnfrule";
    public static final String VALUE            = "value";
    public static final String RBNFRULES        = "RBNFRules";
    public static final String RADIX            = "radix";
    public static final String DECEXP           = "decexp";
    public static final String LENIENT_PARSE    = "lenient-parse";
    public static final String NUMBERING_SYSTEMS = "numberingSystems";
    public static final String NUMBERING_SYSTEM  = "numberingSystem";
    public static final String DESC             = "desc";
    public static final String ALGORITHMIC      = "algorithmic";
    public static final String DEFAULT_NUMBERING_SYSTEM = "defaultNumberingSystem";

    //PN added - Open and Close tags
    public static final String VERSION_C       = "</" + VERSION + ">";
    public static final String GENERATION_C    = "</" + GENERATION + ">";
    public static final String LDML_O          = "<" + LDML + ">";
    public static final String LDML_C          = "</" + LDML + ">";
    public static final String IDENTITY_O      = "<" + IDENTITY + ">";
    public static final String IDENTITY_C      = "</" + IDENTITY + ">";
    public static final String LDN_O           = "<" + LDN + ">";
    public static final String LDN_C           = "</" + LDN + ">";
    public static final String LANGUAGES_O     = "<" + LANGUAGES + ">";
    public static final String LANGUAGES_C     = "</" + LANGUAGES + ">";
    public static final String LANGUAGE_O      = "<" + LANGUAGE + ">";
    public static final String LANGUAGE_C      = "</" + LANGUAGE + ">";
    public static final String TERRITORIES_O   = "<" + TERRITORIES + ">";
    public static final String TERRITORIES_C   = "</" + TERRITORIES + ">";
    public static final String TERRITORY_O     = "<" + TERRITORY + ">";
    public static final String TERRITORY_C     = "</" + TERRITORY + ">";
    public static final String SCRIPTS_O       = "<" + SCRIPTS + ">";
    public static final String SCRIPTS_C       = "</" + SCRIPTS + ">";
    public static final String SCRIPT_O        = "<" + SCRIPT + ">";
    public static final String SCRIPT_C        = "</" + SCRIPT + ">";
    public static final String VARIANTS_O      = "<" + VARIANTS + ">";
    public static final String VARIANTS_C      = "</" + VARIANTS + ">";
    public static final String DATES_O         = "<" + DATES + ">";
    public static final String DATES_C         = "</" + DATES + ">";
    public static final String CALENDARS_O     = "<" + CALENDARS + ">";
    public static final String CALENDARS_C     = "</" + CALENDARS + ">";
    public static final String CALENDAR_O      = "<" + CALENDAR + ">";
    public static final String CALENDAR_C      = "</" + CALENDAR + ">";
    public static final String MONTHS_O        = "<" + MONTHS + ">";
    public static final String MONTHS_C        = "</" + MONTHS + ">";
    public static final String MONTH_CONTEXT_O = "<" + MONTH_CONTEXT + ">";
    public static final String MONTH_CONTEXT_C = "</" + MONTH_CONTEXT + ">";
    public static final String MONTH_WIDTH_O   = "<" + MONTH_WIDTH + ">";
    public static final String MONTH_WIDTH_C   = "</" + MONTH_WIDTH + ">";
    public static final String MONTH_O         = "<" + MONTH + ">";
    public static final String MONTH_C         = "</" + MONTH + ">";
    public static final String DAYS_O          = "<" + DAYS + ">";
    public static final String DAYS_C          = "</" + DAYS + ">";
    public static final String DAY_CONTEXT_O   = "<" + DAY_CONTEXT + ">";
    public static final String DAY_CONTEXT_C   = "</" + DAY_CONTEXT + ">";
    public static final String DAY_WIDTH_O     = "<" + DAY_WIDTH + ">";
    public static final String DAY_WIDTH_C     = "</" + DAY_WIDTH + ">";
    public static final String DAY_O           = "<" + DAY + ">";
    public static final String DAY_C           = "</" + DAY + ">";
    public static final String AM_O            = "<" + AM + ">";
    public static final String AM_C            = "</" + AM + ">";
    public static final String PM_O            = "<" + PM + ">";
    public static final String PM_C            = "</" + PM + ">";
    public static final String DATE_FORMATS_O  = "<" + DATE_FORMATS + ">";
    public static final String DATE_FORMATS_C  = "</" + DATE_FORMATS + ">";
    public static final String DFL_O           = "<" + DFL + ">";
    public static final String DFL_C           = "</" + DFL + ">";
    public static final String DATE_FORMAT_O   = "<" + DATE_FORMAT + ">";
    public static final String DATE_FORMAT_C   = "</" + DATE_FORMAT + ">";
    public static final String PATTERN_O       = "<" + PATTERN + ">";
    public static final String PATTERN_C       = "</" + PATTERN + ">";
    public static final String TIME_FORMATS_O  = "<" + TIME_FORMATS + ">";
    public static final String TIME_FORMATS_C  = "</" + TIME_FORMATS + ">";
    public static final String TFL_O           = "<" + TFL + ">";
    public static final String TFL_C           = "</" + TFL + ">";
    public static final String TIME_FORMAT_O   = "<" + TIME_FORMAT + ">";
    public static final String TIME_FORMAT_C   = "</" + TIME_FORMAT + ">";
    public static final String DATE_TIME_FORMATS_O = "<" + DATE_TIME_FORMATS + ">";
    public static final String DATE_TIME_FORMATS_C = "</" + DATE_TIME_FORMATS + ">";
    public static final String DTFL_O          = "<" + DTFL + ">";
    public static final String DTFL_C          = "</" + DTFL + ">";
    public static final String DATE_TIME_FORMAT_O  = "<" + DATE_TIME_FORMAT + ">";
    public static final String DATE_TIME_FORMAT_C  = "</" + DATE_TIME_FORMAT + ">";
    public static final String POSIX_O         = "<" + POSIX + ">";
    public static final String POSIX_C         = "</" + POSIX + ">";
    public static final String MESSAGES_O      = "<" + MESSAGES + ">";
    public static final String MESSAGES_C      = "</" + MESSAGES + ">";
    public static final String YESSTR_O        = "<" + YESSTR + ">";
    public static final String YESSTR_C        = "</" + YESSTR + ">";
    public static final String NOSTR_O         = "<" + NOSTR + ">";
    public static final String NOSTR_C         = "</" + NOSTR + ">";
    public static final String YESEXPR_O       = "<" + YESEXPR + ">";
    public static final String YESEXPR_C       = "</" + YESEXPR + ">";
    public static final String NOEXPR_O        = "<" + NOEXPR + ">";
    public static final String NOEXPR_C        = "</" + NOEXPR + ">";
    public static final String NUMBERS_O       = "<" + NUMBERS + ">";
    public static final String NUMBERS_C       = "</" + NUMBERS + ">";
    public static final String SYMBOLS_O       = "<" + SYMBOLS + ">";
    public static final String SYMBOLS_C       = "</" + SYMBOLS + ">";
    public static final String DECIMAL_O       = "<" + DECIMAL + ">";
    public static final String DECIMAL_C       = "</" + DECIMAL + ">";
    public static final String GROUP_O         = "<" + GROUP + ">";
    public static final String GROUP_C         = "</" + GROUP + ">";
    public static final String DECIMAL_FORMATS_O   = "<" + DECIMAL_FORMATS + ">";
    public static final String DECIMAL_FORMATS_C   = "</" + DECIMAL_FORMATS + ">";
    public static final String DECFL_O             = "<" + DECFL + ">";
    public static final String DECFL_C             = "</" + DECFL + ">";
    public static final String DECIMAL_FORMAT_O    = "<" + DECIMAL_FORMAT + ">";
    public static final String DECIMAL_FORMAT_C    = "</" + DECIMAL_FORMAT + ">";
    public static final String CURRENCY_FORMATS_O  = "<" + CURRENCY_FORMATS + ">";
    public static final String CURRENCY_FORMATS_C  = "</" + CURRENCY_FORMATS + ">";
    public static final String CURFL_O             = "<" + CURFL + ">";
    public static final String CURFL_C             = "</" + CURFL + ">";
    public static final String CURRENCY_FORMAT_O  = "<" + CURRENCY_FORMAT + ">";
    public static final String CURRENCY_FORMAT_C  = "</" + CURRENCY_FORMAT + ">";
    public static final String CURRENCIES_O       = "<" + CURRENCIES + ">";
    public static final String CURRENCIES_C       = "</" + CURRENCIES + ">";
    public static final String CURRENCY_O         = "<" + CURRENCY + ">";
    public static final String CURRENCY_C         = "</" + CURRENCY + ">";
    public static final String DISPLAY_NAME_O     = "<" + DISPLAY_NAME + ">";
    public static final String DISPLAY_NAME_C     = "</" + DISPLAY_NAME + ">";
    public static final String SYMBOL_O           = "<" + SYMBOL + ">";
    public static final String SYMBOL_C           = "</" + SYMBOL + ">";
    public static final String ERAS_O             = "<" + ERAS + ">";
    public static final String ERAS_C             = "</" + ERAS + ">";
    public static final String ERANAMES_O         = "<" + ERANAMES + ">";
    public static final String ERANAMES_C         = "</" + ERANAMES + ">";
    public static final String ERAABBR_O          = "<" + ERAABBR + ">";
    public static final String ERAABBR_C          = "</" + ERAABBR + ">";
    public static final String ERA_O              = "<" + ERA + ">";
    public static final String ERA_C              = "</" + ERA + ">";
    public static final String WEEK_O             = "<" + WEEK + ">";
    public static final String WEEK_C             = "</" + WEEK + ">";
    public static final String DELIMITERS_O       = "<" + DELIMITERS + ">";
    public static final String DELIMITERS_C       = "</" + DELIMITERS + ">";
    public static final String QS_O               = "<" + QS + ">";
    public static final String QS_C               = "</" + QS + ">";
    public static final String QE_O               = "<" + QE + ">";
    public static final String QE_C               = "</" + QE + ">";
    public static final String AQS_O              = "<" + AQS + ">";
    public static final String AQS_C              = "</" + AQS + ">";
    public static final String AQE_O              = "<" + AQE + ">";
    public static final String AQE_C              = "</" + AQE + ">";
    public static final String MEASUREMENT_O      =  "<" + MEASUREMENT + ">";
    public static final String MEASUREMENT_C      =  "</" + MEASUREMENT + ">";
    public static final String MS_O               =  "<" + MS + ">";
    public static final String MS_C               =  "</" + MS + ">";
    public static final String PAPER_SIZE_O       =  "<" + PAPER_SIZE + ">";
    public static final String PAPER_SIZE_C       =  "</" + PAPER_SIZE + ">";
    public static final String HEIGHT_O           =  "<" + HEIGHT + ">";
    public static final String HEIGHT_C           =  "</" + HEIGHT + ">";
    public static final String WIDTH_O            =  "<" + WIDTH + ">";
    public static final String WIDTH_C            =  "</" + WIDTH + ">";
    public static final String LIST_O             =  "<" + LIST + ">";
    public static final String LIST_C             =  "</" + LIST + ">";

    public static final String SPECIAL_O          =  "<" + SPECIAL + ">";
    public static final String SPECIAL_C          =  "</" + SPECIAL + ">";

    public static final String LPC_O                  =  "<" + LPC + ">";
    public static final String LPC_C                  =  "</" + LPC + ">";

    public static final String PERCENT_SIGN_O         =  "<" + PERCENT_SIGN + ">";
    public static final String PERCENT_SIGN_C         =  "</" + PERCENT_SIGN + ">";
    public static final String NATIVE_ZERO_SIGN_O     =  "<" + NATIVE_ZERO_SIGN + ">";
    public static final String NATIVE_ZERO_SIGN_C     =  "</" + NATIVE_ZERO_SIGN + ">";
    public static final String PATTERN_DIGIT_O        =  "<" + PATTERN_DIGIT + ">";
    public static final String PATTERN_DIGIT_C        =  "</" + PATTERN_DIGIT + ">";
    public static final String MINUS_SIGN_O           =  "<" + MINUS_SIGN + ">";
    public static final String MINUS_SIGN_C           =  "</" + MINUS_SIGN + ">";
    public static final String EXPONENTIAL_O          =  "<" + EXPONENTIAL + ">";
    public static final String EXPONENTIAL_C          =  "</" + EXPONENTIAL + ">";
    public static final String PER_MILLE_O            =  "<" + PER_MILLE + ">";
    public static final String PER_MILLE_C            =  "</" + PER_MILLE + ">";
    public static final String INFINITY_O             =  "<" + INFINITY + ">";
    public static final String INFINITY_C             =  "</" + INFINITY + ">";
    public static final String NAN_O                  =  "<" + NAN + ">";
    public static final String NAN_C                  =  "</" + NAN + ">";

    public static final String TZN_O                  =  "<" + TZN + ">";
    public static final String TZN_C                  =  "</" + TZN + ">";
    public static final String ZONE_O                 =  "<" + ZONE + ">";
    public static final String ZONE_C                 =  "</" + ZONE + ">";
    public static final String LONG_O                 =  "<" + LONG + ">";
    public static final String LONG_C                 =  "</" + LONG + ">";
    public static final String SHORT_O                =  "<" + SHORT + ">";
    public static final String SHORT_C                =  "</" + SHORT + ">";
    public static final String STANDARD_O             =  "<" + STANDARD + ">";
    public static final String STANDARD_C             =  "</" + STANDARD + ">";
    public static final String DAYLIGHT_O             =  "<" + DAYLIGHT + ">";
    public static final String DAYLIGHT_C             =  "</" + DAYLIGHT + ">";

    public static final String PERCENT_FORMATS_O      =  "<" + PERCENT_FORMATS + ">";
    public static final String PERCENT_FORMATS_C      =  "</" + PERCENT_FORMATS + ">";
    public static final String PERFL_O                =  "<" + PERFL + ">";
    public static final String PERFL_C                =  "</" + PERFL + ">";
    public static final String PERCENT_FORMAT_O       =  "<" + PERCENT_FORMAT + ">";
    public static final String PERCENT_FORMAT_C       =  "</" + PERCENT_FORMAT + ">";

    public static final String QUARTERS_O             =  "<" + QUARTERS + ">";
    public static final String QUARTERS_C             =  "</" + QUARTERS + ">";
    public static final String QUARTER_CONTEXT_O      =  "<" + QUARTER_CONTEXT + ">";
    public static final String QUARTER_CONTEXT_C      =  "</" + QUARTER_CONTEXT + ">";
    public static final String QUARTER_WIDTH_O        =  "<" + QUARTER_WIDTH + ">";
    public static final String QUARTER_WIDTH_C        =  "</" + QUARTER_WIDTH + ">";
    public static final String QUARTER_O              =  "<" + QUARTER + ">";
    public static final String QUARTER_C              =  "</" + QUARTER + ">";
            
    public static final String AVAIL_FMTS_O           = "<" + AVAIL_FMTS + ">";
    public static final String AVAIL_FMTS_C           = "</" + AVAIL_FMTS + ">";
    public static final String DATE_FMT_ITEM_O        = "<" + DATE_FMT_ITEM + ">";
    public static final String DATE_FMT_ITEM_C        = "</" + DATE_FMT_ITEM + ">";
    public static final String APPEND_ITEMS_O         = "<" + APPEND_ITEMS + ">";
    public static final String APPEND_ITEMS_C         = "</" + APPEND_ITEMS + ">";

    public static final String CURRENCY_SPC_BEFORE_O = "<" + CURRENCY_SPC_BEFORE  + ">";
    public static final String CURRENCY_SPC_BEFORE_C = "</" + CURRENCY_SPC_BEFORE  + ">";
    public static final String CURRENCY_SPC_AFTER_O = "<" + CURRENCY_SPC_AFTER  + ">";
    public static final String CURRENCY_SPC_AFTER_C = "</" + CURRENCY_SPC_AFTER + ">";
    public static final String CURRENCY_SPC_MATCH_O = "<" + CURRENCY_SPC_MATCH + ">";
    public static final String CURRENCY_SPC_MATCH_C = "</" + CURRENCY_SPC_MATCH + ">";
    public static final String CURRENCY_SPC_SUR_MATCH_O = "<" + CURRENCY_SPC_SUR_MATCH + ">";
    public static final String CURRENCY_SPC_SUR_MATCH_C = "</" + CURRENCY_SPC_SUR_MATCH + ">";
    public static final String CURRENCY_SPC_INSERT_O = "<" + CURRENCY_SPC_INSERT + ">";
    public static final String CURRENCY_SPC_INSERT_C = "</" + CURRENCY_SPC_INSERT + ">";
}
