/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test;

import com.ibm.icu.dev.test.TestLog;
import java.io.IOException;
import java.io.Writer;

public final class TestLogWriter
extends Writer {
    private TestLog log;
    private int level;
    private boolean closed;

    public TestLogWriter(TestLog log, int level) {
        this.log = log;
        this.level = level;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(new String(cbuf, off, len));
    }

    public void write(String str) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if ("\r\n".indexOf(str) != -1) {
            this.log.msg("", this.level, this.level == 2, true);
        } else {
            this.log.msg(str, this.level, this.level == 2, false);
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.closed = true;
    }
}

