/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class UnicodePropertySource
implements Cloneable {
    protected String propertyAlias;
    protected int m_nameChoice = 1;
    protected StringFilter filter = new StringFilter();
    protected UnicodeSetIterator matchIterator = new UnicodeSetIterator(new UnicodeSet(0, 0x10FFFF));

    public abstract String getPropertyValue(int var1);

    public abstract Set getAvailablePropertyAliases(Set var1);

    public abstract Set getAvailablePropertyValueAliases(Set var1);

    public abstract String getPropertyAlias(int var1);

    public abstract String getPropertyValueAlias(String var1, int var2);

    public Object clone() {
        try {
            UnicodePropertySource result = (UnicodePropertySource)super.clone();
            result.filter = (StringFilter)this.filter.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Should never happen.");
        }
    }

    public UnicodePropertySource setPropertyAlias(String propertyAlias) {
        this.propertyAlias = propertyAlias;
        return this;
    }

    public String getPropertyAlias() {
        return this.propertyAlias;
    }

    public static final boolean equals(int codepoint, String other) {
        if (other.length() == 1) {
            return codepoint == other.charAt(0);
        }
        return other.equals(UTF16.valueOf((int)codepoint));
    }

    public UnicodeSet getPropertySet(boolean charEqualsValue, UnicodeSet result) {
        if (result == null) {
            result = new UnicodeSet();
        }
        this.matchIterator.reset();
        while (this.matchIterator.next()) {
            String value = this.filter.remap(this.getPropertyValue(this.matchIterator.codepoint));
            if (UnicodePropertySource.equals(this.matchIterator.codepoint, value) != charEqualsValue) continue;
            result.add(this.matchIterator.codepoint);
        }
        return result;
    }

    public UnicodeSet getPropertySet(String propertyValue, UnicodeSet result) {
        if (result == null) {
            result = new UnicodeSet();
        }
        this.matchIterator.reset();
        while (this.matchIterator.next()) {
            String value = this.filter.remap(this.getPropertyValue(this.matchIterator.codepoint));
            if (!propertyValue.equals(value)) continue;
            result.add(this.matchIterator.codepoint);
        }
        return result;
    }

    public UnicodeSet getPropertySet(Matcher matcher, UnicodeSet result) {
        if (result == null) {
            result = new UnicodeSet();
        }
        this.matchIterator.reset();
        while (this.matchIterator.next()) {
            String value = this.filter.remap(this.getPropertyValue(this.matchIterator.codepoint));
            if (value == null || !matcher.matches(value)) continue;
            result.add(this.matchIterator.codepoint);
        }
        return result;
    }

    public int getNameChoice() {
        return this.m_nameChoice;
    }

    public UnicodePropertySource setNameChoice(int choice) {
        this.m_nameChoice = choice;
        return this;
    }

    public StringFilter getFilter() {
        return this.filter;
    }

    public UnicodePropertySource setFilter(StringFilter filter) {
        this.filter = filter;
        return this;
    }

    public static void addAll(UnicodeSetIterator source, UnicodeSet result) {
        while (source.nextRange()) {
            if (source.codepoint == UnicodeSetIterator.IS_STRING) {
                result.add((CharSequence)source.string);
                continue;
            }
            result.add(source.codepoint, source.codepointEnd);
        }
    }

    public UnicodeSet getMatchSet(UnicodeSet result) {
        if (result == null) {
            result = new UnicodeSet();
        }
        UnicodePropertySource.addAll(this.matchIterator, result);
        return result;
    }

    public void setMatchSet(UnicodeSet set) {
        this.matchIterator = new UnicodeSetIterator(set);
    }

    public static class ICU
    extends UnicodePropertySource {
        protected int propEnum = Integer.MIN_VALUE;
        static final List Extras = Arrays.asList("NFC", "NFD", "NFKC", "NKFD");
        static final int NFC = 32768;
        static final int NFD = 32769;
        static final int NFKC = 32770;
        static final int NFKD = 32771;
        static final int EXTRA_START = 32768;
        static final int EXTRA_LIMIT = 32772;
        static final int[][] ranges = new int[][]{{0, 57}, {4096, 4117}, {12288, 12289}, {16384, 16397}};

        public ICU() {
            this.matchIterator = new UnicodeSetIterator(new UnicodeSet("[^[:Cn:]-[:Default_Ignorable_Code_Point:]]"));
        }

        public UnicodePropertySource setPropertyAlias(String propertyAlias) {
            super.setPropertyAlias(propertyAlias);
            int extraPosition = Extras.indexOf(propertyAlias);
            this.propEnum = extraPosition >= 0 ? 32768 + extraPosition : UCharacter.getPropertyEnum((CharSequence)propertyAlias);
            return this;
        }

        public String getPropertyValue(int codePoint) {
            if (this.propEnum < 4117) {
                int enumValue = UCharacter.getIntPropertyValue((int)codePoint, (int)this.propEnum);
                return UCharacter.getPropertyValueName((int)this.propEnum, (int)enumValue, (int)this.m_nameChoice);
            }
            if (this.propEnum < 12289) {
                return Double.toString(UCharacter.getUnicodeNumericValue((int)codePoint));
            }
            switch (this.propEnum) {
                case 16384: {
                    return UCharacter.getAge((int)codePoint).toString();
                }
                case 16385: {
                    return UTF16.valueOf((int)UCharacter.getMirror((int)codePoint));
                }
                case 16386: {
                    return UCharacter.foldCase((String)UTF16.valueOf((int)codePoint), (boolean)true);
                }
                case 16387: {
                    return UCharacter.getISOComment((int)codePoint);
                }
                case 16388: {
                    return UCharacter.toLowerCase((Locale)Locale.ENGLISH, (String)UTF16.valueOf((int)codePoint));
                }
                case 16389: {
                    return UCharacter.getName((int)codePoint);
                }
                case 16390: {
                    return UTF16.valueOf((int)UCharacter.foldCase((int)codePoint, (boolean)true));
                }
                case 16391: {
                    return UTF16.valueOf((int)UCharacter.toLowerCase((int)codePoint));
                }
                case 16392: {
                    return UTF16.valueOf((int)UCharacter.toTitleCase((int)codePoint));
                }
                case 16393: {
                    return UTF16.valueOf((int)UCharacter.toUpperCase((int)codePoint));
                }
                case 16394: {
                    return UCharacter.toTitleCase((Locale)Locale.ENGLISH, (String)UTF16.valueOf((int)codePoint), null);
                }
                case 16395: {
                    return UCharacter.getName1_0((int)codePoint);
                }
                case 16396: {
                    return UCharacter.toUpperCase((Locale)Locale.ENGLISH, (String)UTF16.valueOf((int)codePoint));
                }
                case 32768: {
                    return Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFC);
                }
                case 32769: {
                    return Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFD);
                }
                case 32770: {
                    return Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFKC);
                }
                case 32771: {
                    return Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFKD);
                }
            }
            return null;
        }

        public Set getAvailablePropertyAliases(Set result) {
            for (int i = 0; i < ranges.length; ++i) {
                for (int j = ranges[i][0]; j < ranges[i][1]; ++j) {
                    result.add(UCharacter.getPropertyName((int)j, (int)this.m_nameChoice));
                }
            }
            result.addAll(Extras);
            return result;
        }

        public Set getAvailablePropertyValueAliases(Set result) {
            if (this.propEnum < 4117) {
                int start = UCharacter.getIntPropertyMinValue((int)this.propEnum);
                int end = UCharacter.getIntPropertyMaxValue((int)this.propEnum);
                for (int i = start; i <= end; ++i) {
                    result.add(this.getFixedValueAlias(null, i, this.m_nameChoice));
                }
            } else {
                result.add(this.getFixedValueAlias(null, -1, this.m_nameChoice));
            }
            return result;
        }

        private String getFixedValueAlias(String valueAlias, int valueEnum, int nameChoice) {
            String result;
            if (this.propEnum >= 16384) {
                return "<string>";
            }
            if (this.propEnum >= 12288) {
                return "<double>";
            }
            if (valueAlias != null && !valueAlias.equals("<integer>")) {
                valueEnum = UCharacter.getPropertyValueEnum((int)this.propEnum, (CharSequence)valueAlias);
            }
            if ((result = ICU.fixedGetPropertyValueName(this.propEnum, valueEnum, nameChoice)) != null) {
                return result;
            }
            result = ICU.fixedGetPropertyValueName(this.propEnum, valueEnum, nameChoice == 1 ? 0 : 1);
            if (result != null) {
                return result;
            }
            return "<integer>";
        }

        private static String fixedGetPropertyValueName(int propEnum, int valueEnum, int nameChoice) {
            try {
                return UCharacter.getPropertyValueName((int)propEnum, (int)valueEnum, (int)nameChoice);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getPropertyAlias(int nameChoice) {
            if (this.propEnum < 32768) {
                return UCharacter.getPropertyName((int)this.propEnum, (int)nameChoice);
            }
            return (String)Extras.get(this.propEnum - 32768);
        }

        public String getPropertyValueAlias(String valueAlias, int nameChoice) {
            return this.getFixedValueAlias(valueAlias, -1, nameChoice);
        }
    }

    public static class MapFilter
    extends StringFilter {
        Map valueMap;

        public String remap(String original) {
            Object changed = this.valueMap.get(original);
            return changed == null ? original : (String)changed;
        }

        public Map getMap() {
            return this.valueMap;
        }

        public MapFilter setMap(Map map) {
            this.valueMap = map;
            return this;
        }
    }

    public static class StringFilter
    implements Cloneable {
        public String remap(String original) {
            return original;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Should never happen.");
            }
        }
    }

    public static interface Matcher {
        public boolean matches(String var1);
    }
}

