package org.unicode.cldr.draft.picker;

// $Date: 2012-09-13 21:31:43 -0700 (Thu, 13 Sep 2012) $
//@formatter:off
public class CharData {
    static String[][] CHARACTERS_TO_NAME = {
        { " ", "SPACE" },
        { "-", "HYPHEN-MINUS" },
        { " ", "NO-BREAK SPACE" },
        { "­", "SOFT HYPHEN" },
        { "͏", "COMBINING GRAPHEME JOINER" },
        { "֊", "ARMENIAN HYPHEN" },
        { "־", "HEBREW PUNCTUATION MAQAF" },
        { "؀", "ARABIC NUMBER SIGN" },
        { "؁", "ARABIC SIGN SANAH" },
        { "؂", "ARABIC FOOTNOTE MARKER" },
        { "؃", "ARABIC SIGN SAFHA" },
        { "؄", "ARABIC SIGN SAMVAT" },
        { "۝", "ARABIC END OF AYAH" },
        { "܏", "SYRIAC ABBREVIATION MARK" },
        { "ᅟ", "HANGUL CHOSEONG FILLER" },
        { "ᅠ", "HANGUL JUNGSEONG FILLER" },
        { "᐀", "CANADIAN SYLLABICS HYPHEN" },
        { " ", "OGHAM SPACE MARK" },
        { "឴", "KHMER VOWEL INHERENT AQ" },
        { "឵", "KHMER VOWEL INHERENT AA" },
        { "᠆", "MONGOLIAN TODO SOFT HYPHEN" },
        { "᠋", "MONGOLIAN FREE VARIATION SELECTOR ONE" },
        { "᠌", "MONGOLIAN FREE VARIATION SELECTOR TWO" },
        { "᠍", "MONGOLIAN FREE VARIATION SELECTOR THREE" },
        { "᠎", "MONGOLIAN VOWEL SEPARATOR" },
        { " ", "EN QUAD" },
        { " ", "EM QUAD" },
        { " ", "EN SPACE" },
        { " ", "EM SPACE" },
        { " ", "THREE-PER-EM SPACE" },
        { " ", "FOUR-PER-EM SPACE" },
        { " ", "SIX-PER-EM SPACE" },
        { " ", "FIGURE SPACE" },
        { " ", "PUNCTUATION SPACE" },
        { " ", "THIN SPACE" },
        { " ", "HAIR SPACE" },
        { "​", "ZERO WIDTH SPACE" },
        { "‌", "ZERO WIDTH NON-JOINER" },
        { "‍", "ZERO WIDTH JOINER" },
        { "‎", "LEFT-TO-RIGHT MARK" },
        { "‏", "RIGHT-TO-LEFT MARK" },
        { "‐", "HYPHEN" },
        { "‑", "NON-BREAKING HYPHEN" },
        { "‒", "FIGURE DASH" },
        { "–", "EN DASH" },
        { "—", "EM DASH" },
        { "―", "HORIZONTAL BAR" },
        { " ", "LINE SEPARATOR" },
        { " ", "PARAGRAPH SEPARATOR" },
        { "‪", "LEFT-TO-RIGHT EMBEDDING" },
        { "‫", "RIGHT-TO-LEFT EMBEDDING" },
        { "‬", "POP DIRECTIONAL FORMATTING" },
        { "‭", "LEFT-TO-RIGHT OVERRIDE" },
        { "‮", "RIGHT-TO-LEFT OVERRIDE" },
        { " ", "NARROW NO-BREAK SPACE" },
        { " ", "MEDIUM MATHEMATICAL SPACE" },
        { "⁠", "WORD JOINER" },
        { "⁡", "FUNCTION APPLICATION" },
        { "⁢", "INVISIBLE TIMES" },
        { "⁣", "INVISIBLE SEPARATOR" },
        { "⁤", "INVISIBLE PLUS" },
        { "⸗", "DOUBLE OBLIQUE HYPHEN" },
        { "⸚", "HYPHEN WITH DIAERESIS" },
        { "⸺", "TWO-EM DASH" },
        { "⸻", "THREE-EM DASH" },
        { "　", "IDEOGRAPHIC SPACE" },
        { "〜", "WAVE DASH" },
        { "〰", "WAVY DASH" },
        { "゠", "KATAKANA-HIRAGANA DOUBLE HYPHEN" },
        { "ㅤ", "HANGUL FILLER" },
        { "︀", "VARIATION SELECTOR-1" },
        { "︁", "VARIATION SELECTOR-2" },
        { "︂", "VARIATION SELECTOR-3" },
        { "︃", "VARIATION SELECTOR-4" },
        { "︄", "VARIATION SELECTOR-5" },
        { "︅", "VARIATION SELECTOR-6" },
        { "︆", "VARIATION SELECTOR-7" },
        { "︇", "VARIATION SELECTOR-8" },
        { "︈", "VARIATION SELECTOR-9" },
        { "︉", "VARIATION SELECTOR-10" },
        { "︊", "VARIATION SELECTOR-11" },
        { "︋", "VARIATION SELECTOR-12" },
        { "︌", "VARIATION SELECTOR-13" },
        { "︍", "VARIATION SELECTOR-14" },
        { "︎", "VARIATION SELECTOR-15" },
        { "️", "VARIATION SELECTOR-16" },
        { "︱", "PRESENTATION FORM FOR VERTICAL EM DASH" },
        { "︲", "PRESENTATION FORM FOR VERTICAL EN DASH" },
        { "﹘", "SMALL EM DASH" },
        { "﹣", "SMALL HYPHEN-MINUS" },
        { "﻿", "ZERO WIDTH NO-BREAK SPACE" },
        { "－", "FULLWIDTH HYPHEN-MINUS" },
        { "ﾠ", "HALFWIDTH HANGUL FILLER" },
        { "￹", "INTERLINEAR ANNOTATION ANCHOR" },
        { "￺", "INTERLINEAR ANNOTATION SEPARATOR" },
        { "￻", "INTERLINEAR ANNOTATION TERMINATOR" },
        { "𑂽", "KAITHI NUMBER SIGN" },
        { "𝅳", "MUSICAL SYMBOL BEGIN BEAM" },
        { "𝅴", "MUSICAL SYMBOL END BEAM" },
        { "𝅵", "MUSICAL SYMBOL BEGIN TIE" },
        { "𝅶", "MUSICAL SYMBOL END TIE" },
        { "𝅷", "MUSICAL SYMBOL BEGIN SLUR" },
        { "𝅸", "MUSICAL SYMBOL END SLUR" },
        { "𝅹", "MUSICAL SYMBOL BEGIN PHRASE" },
        { "𝅺", "MUSICAL SYMBOL END PHRASE" },
        { "󠄀", "VARIATION SELECTOR-17" },
        { "󠄁", "VARIATION SELECTOR-18" },
        { "󠄂", "VARIATION SELECTOR-19" },
        { "󠄃", "VARIATION SELECTOR-20" },
        { "󠄄", "VARIATION SELECTOR-21" },
        { "󠄅", "VARIATION SELECTOR-22" },
        { "󠄆", "VARIATION SELECTOR-23" },
        { "󠄇", "VARIATION SELECTOR-24" },
        { "󠄈", "VARIATION SELECTOR-25" },
        { "󠄉", "VARIATION SELECTOR-26" },
        { "󠄊", "VARIATION SELECTOR-27" },
        { "󠄋", "VARIATION SELECTOR-28" },
        { "󠄌", "VARIATION SELECTOR-29" },
        { "󠄍", "VARIATION SELECTOR-30" },
        { "󠄎", "VARIATION SELECTOR-31" },
        { "󠄏", "VARIATION SELECTOR-32" },
        { "󠄐", "VARIATION SELECTOR-33" },
        { "󠄑", "VARIATION SELECTOR-34" },
        { "󠄒", "VARIATION SELECTOR-35" },
        { "󠄓", "VARIATION SELECTOR-36" },
        { "󠄔", "VARIATION SELECTOR-37" },
        { "󠄕", "VARIATION SELECTOR-38" },
        { "󠄖", "VARIATION SELECTOR-39" },
        { "󠄗", "VARIATION SELECTOR-40" },
        { "󠄘", "VARIATION SELECTOR-41" },
        { "󠄙", "VARIATION SELECTOR-42" },
        { "󠄚", "VARIATION SELECTOR-43" },
        { "󠄛", "VARIATION SELECTOR-44" },
        { "󠄜", "VARIATION SELECTOR-45" },
        { "󠄝", "VARIATION SELECTOR-46" },
        { "󠄞", "VARIATION SELECTOR-47" },
        { "󠄟", "VARIATION SELECTOR-48" },
        { "󠄠", "VARIATION SELECTOR-49" },
        { "󠄡", "VARIATION SELECTOR-50" },
        { "󠄢", "VARIATION SELECTOR-51" },
        { "󠄣", "VARIATION SELECTOR-52" },
        { "󠄤", "VARIATION SELECTOR-53" },
        { "󠄥", "VARIATION SELECTOR-54" },
        { "󠄦", "VARIATION SELECTOR-55" },
        { "󠄧", "VARIATION SELECTOR-56" },
        { "󠄨", "VARIATION SELECTOR-57" },
        { "󠄩", "VARIATION SELECTOR-58" },
        { "󠄪", "VARIATION SELECTOR-59" },
        { "󠄫", "VARIATION SELECTOR-60" },
        { "󠄬", "VARIATION SELECTOR-61" },
        { "󠄭", "VARIATION SELECTOR-62" },
        { "󠄮", "VARIATION SELECTOR-63" },
        { "󠄯", "VARIATION SELECTOR-64" },
        { "󠄰", "VARIATION SELECTOR-65" },
        { "󠄱", "VARIATION SELECTOR-66" },
        { "󠄲", "VARIATION SELECTOR-67" },
        { "󠄳", "VARIATION SELECTOR-68" },
        { "󠄴", "VARIATION SELECTOR-69" },
        { "󠄵", "VARIATION SELECTOR-70" },
        { "󠄶", "VARIATION SELECTOR-71" },
        { "󠄷", "VARIATION SELECTOR-72" },
        { "󠄸", "VARIATION SELECTOR-73" },
        { "󠄹", "VARIATION SELECTOR-74" },
        { "󠄺", "VARIATION SELECTOR-75" },
        { "󠄻", "VARIATION SELECTOR-76" },
        { "󠄼", "VARIATION SELECTOR-77" },
        { "󠄽", "VARIATION SELECTOR-78" },
        { "󠄾", "VARIATION SELECTOR-79" },
        { "󠄿", "VARIATION SELECTOR-80" },
        { "󠅀", "VARIATION SELECTOR-81" },
        { "󠅁", "VARIATION SELECTOR-82" },
        { "󠅂", "VARIATION SELECTOR-83" },
        { "󠅃", "VARIATION SELECTOR-84" },
        { "󠅄", "VARIATION SELECTOR-85" },
        { "󠅅", "VARIATION SELECTOR-86" },
        { "󠅆", "VARIATION SELECTOR-87" },
        { "󠅇", "VARIATION SELECTOR-88" },
        { "󠅈", "VARIATION SELECTOR-89" },
        { "󠅉", "VARIATION SELECTOR-90" },
        { "󠅊", "VARIATION SELECTOR-91" },
        { "󠅋", "VARIATION SELECTOR-92" },
        { "󠅌", "VARIATION SELECTOR-93" },
        { "󠅍", "VARIATION SELECTOR-94" },
        { "󠅎", "VARIATION SELECTOR-95" },
        { "󠅏", "VARIATION SELECTOR-96" },
        { "󠅐", "VARIATION SELECTOR-97" },
        { "󠅑", "VARIATION SELECTOR-98" },
        { "󠅒", "VARIATION SELECTOR-99" },
        { "󠅓", "VARIATION SELECTOR-100" },
        { "󠅔", "VARIATION SELECTOR-101" },
        { "󠅕", "VARIATION SELECTOR-102" },
        { "󠅖", "VARIATION SELECTOR-103" },
        { "󠅗", "VARIATION SELECTOR-104" },
        { "󠅘", "VARIATION SELECTOR-105" },
        { "󠅙", "VARIATION SELECTOR-106" },
        { "󠅚", "VARIATION SELECTOR-107" },
        { "󠅛", "VARIATION SELECTOR-108" },
        { "󠅜", "VARIATION SELECTOR-109" },
        { "󠅝", "VARIATION SELECTOR-110" },
        { "󠅞", "VARIATION SELECTOR-111" },
        { "󠅟", "VARIATION SELECTOR-112" },
        { "󠅠", "VARIATION SELECTOR-113" },
        { "󠅡", "VARIATION SELECTOR-114" },
        { "󠅢", "VARIATION SELECTOR-115" },
        { "󠅣", "VARIATION SELECTOR-116" },
        { "󠅤", "VARIATION SELECTOR-117" },
        { "󠅥", "VARIATION SELECTOR-118" },
        { "󠅦", "VARIATION SELECTOR-119" },
        { "󠅧", "VARIATION SELECTOR-120" },
        { "󠅨", "VARIATION SELECTOR-121" },
        { "󠅩", "VARIATION SELECTOR-122" },
        { "󠅪", "VARIATION SELECTOR-123" },
        { "󠅫", "VARIATION SELECTOR-124" },
        { "󠅬", "VARIATION SELECTOR-125" },
        { "󠅭", "VARIATION SELECTOR-126" },
        { "󠅮", "VARIATION SELECTOR-127" },
        { "󠅯", "VARIATION SELECTOR-128" },
        { "󠅰", "VARIATION SELECTOR-129" },
        { "󠅱", "VARIATION SELECTOR-130" },
        { "󠅲", "VARIATION SELECTOR-131" },
        { "󠅳", "VARIATION SELECTOR-132" },
        { "󠅴", "VARIATION SELECTOR-133" },
        { "󠅵", "VARIATION SELECTOR-134" },
        { "󠅶", "VARIATION SELECTOR-135" },
        { "󠅷", "VARIATION SELECTOR-136" },
        { "󠅸", "VARIATION SELECTOR-137" },
        { "󠅹", "VARIATION SELECTOR-138" },
        { "󠅺", "VARIATION SELECTOR-139" },
        { "󠅻", "VARIATION SELECTOR-140" },
        { "󠅼", "VARIATION SELECTOR-141" },
        { "󠅽", "VARIATION SELECTOR-142" },
        { "󠅾", "VARIATION SELECTOR-143" },
        { "󠅿", "VARIATION SELECTOR-144" },
        { "󠆀", "VARIATION SELECTOR-145" },
        { "󠆁", "VARIATION SELECTOR-146" },
        { "󠆂", "VARIATION SELECTOR-147" },
        { "󠆃", "VARIATION SELECTOR-148" },
        { "󠆄", "VARIATION SELECTOR-149" },
        { "󠆅", "VARIATION SELECTOR-150" },
        { "󠆆", "VARIATION SELECTOR-151" },
        { "󠆇", "VARIATION SELECTOR-152" },
        { "󠆈", "VARIATION SELECTOR-153" },
        { "󠆉", "VARIATION SELECTOR-154" },
        { "󠆊", "VARIATION SELECTOR-155" },
        { "󠆋", "VARIATION SELECTOR-156" },
        { "󠆌", "VARIATION SELECTOR-157" },
        { "󠆍", "VARIATION SELECTOR-158" },
        { "󠆎", "VARIATION SELECTOR-159" },
        { "󠆏", "VARIATION SELECTOR-160" },
        { "󠆐", "VARIATION SELECTOR-161" },
        { "󠆑", "VARIATION SELECTOR-162" },
        { "󠆒", "VARIATION SELECTOR-163" },
        { "󠆓", "VARIATION SELECTOR-164" },
        { "󠆔", "VARIATION SELECTOR-165" },
        { "󠆕", "VARIATION SELECTOR-166" },
        { "󠆖", "VARIATION SELECTOR-167" },
        { "󠆗", "VARIATION SELECTOR-168" },
        { "󠆘", "VARIATION SELECTOR-169" },
        { "󠆙", "VARIATION SELECTOR-170" },
        { "󠆚", "VARIATION SELECTOR-171" },
        { "󠆛", "VARIATION SELECTOR-172" },
        { "󠆜", "VARIATION SELECTOR-173" },
        { "󠆝", "VARIATION SELECTOR-174" },
        { "󠆞", "VARIATION SELECTOR-175" },
        { "󠆟", "VARIATION SELECTOR-176" },
        { "󠆠", "VARIATION SELECTOR-177" },
        { "󠆡", "VARIATION SELECTOR-178" },
        { "󠆢", "VARIATION SELECTOR-179" },
        { "󠆣", "VARIATION SELECTOR-180" },
        { "󠆤", "VARIATION SELECTOR-181" },
        { "󠆥", "VARIATION SELECTOR-182" },
        { "󠆦", "VARIATION SELECTOR-183" },
        { "󠆧", "VARIATION SELECTOR-184" },
        { "󠆨", "VARIATION SELECTOR-185" },
        { "󠆩", "VARIATION SELECTOR-186" },
        { "󠆪", "VARIATION SELECTOR-187" },
        { "󠆫", "VARIATION SELECTOR-188" },
        { "󠆬", "VARIATION SELECTOR-189" },
        { "󠆭", "VARIATION SELECTOR-190" },
        { "󠆮", "VARIATION SELECTOR-191" },
        { "󠆯", "VARIATION SELECTOR-192" },
        { "󠆰", "VARIATION SELECTOR-193" },
        { "󠆱", "VARIATION SELECTOR-194" },
        { "󠆲", "VARIATION SELECTOR-195" },
        { "󠆳", "VARIATION SELECTOR-196" },
        { "󠆴", "VARIATION SELECTOR-197" },
        { "󠆵", "VARIATION SELECTOR-198" },
        { "󠆶", "VARIATION SELECTOR-199" },
        { "󠆷", "VARIATION SELECTOR-200" },
        { "󠆸", "VARIATION SELECTOR-201" },
        { "󠆹", "VARIATION SELECTOR-202" },
        { "󠆺", "VARIATION SELECTOR-203" },
        { "󠆻", "VARIATION SELECTOR-204" },
        { "󠆼", "VARIATION SELECTOR-205" },
        { "󠆽", "VARIATION SELECTOR-206" },
        { "󠆾", "VARIATION SELECTOR-207" },
        { "󠆿", "VARIATION SELECTOR-208" },
        { "󠇀", "VARIATION SELECTOR-209" },
        { "󠇁", "VARIATION SELECTOR-210" },
        { "󠇂", "VARIATION SELECTOR-211" },
        { "󠇃", "VARIATION SELECTOR-212" },
        { "󠇄", "VARIATION SELECTOR-213" },
        { "󠇅", "VARIATION SELECTOR-214" },
        { "󠇆", "VARIATION SELECTOR-215" },
        { "󠇇", "VARIATION SELECTOR-216" },
        { "󠇈", "VARIATION SELECTOR-217" },
        { "󠇉", "VARIATION SELECTOR-218" },
        { "󠇊", "VARIATION SELECTOR-219" },
        { "󠇋", "VARIATION SELECTOR-220" },
        { "󠇌", "VARIATION SELECTOR-221" },
        { "󠇍", "VARIATION SELECTOR-222" },
        { "󠇎", "VARIATION SELECTOR-223" },
        { "󠇏", "VARIATION SELECTOR-224" },
        { "󠇐", "VARIATION SELECTOR-225" },
        { "󠇑", "VARIATION SELECTOR-226" },
        { "󠇒", "VARIATION SELECTOR-227" },
        { "󠇓", "VARIATION SELECTOR-228" },
        { "󠇔", "VARIATION SELECTOR-229" },
        { "󠇕", "VARIATION SELECTOR-230" },
        { "󠇖", "VARIATION SELECTOR-231" },
        { "󠇗", "VARIATION SELECTOR-232" },
        { "󠇘", "VARIATION SELECTOR-233" },
        { "󠇙", "VARIATION SELECTOR-234" },
        { "󠇚", "VARIATION SELECTOR-235" },
        { "󠇛", "VARIATION SELECTOR-236" },
        { "󠇜", "VARIATION SELECTOR-237" },
        { "󠇝", "VARIATION SELECTOR-238" },
        { "󠇞", "VARIATION SELECTOR-239" },
        { "󠇟", "VARIATION SELECTOR-240" },
        { "󠇠", "VARIATION SELECTOR-241" },
        { "󠇡", "VARIATION SELECTOR-242" },
        { "󠇢", "VARIATION SELECTOR-243" },
        { "󠇣", "VARIATION SELECTOR-244" },
        { "󠇤", "VARIATION SELECTOR-245" },
        { "󠇥", "VARIATION SELECTOR-246" },
        { "󠇦", "VARIATION SELECTOR-247" },
        { "󠇧", "VARIATION SELECTOR-248" },
        { "󠇨", "VARIATION SELECTOR-249" },
        { "󠇩", "VARIATION SELECTOR-250" },
        { "󠇪", "VARIATION SELECTOR-251" },
        { "󠇫", "VARIATION SELECTOR-252" },
        { "󠇬", "VARIATION SELECTOR-253" },
        { "󠇭", "VARIATION SELECTOR-254" },
        { "󠇮", "VARIATION SELECTOR-255" },
        { "󠇯", "VARIATION SELECTOR-256" },

    };
    static String[][][] CATEGORIES = {
        {
            { "Symbol" },
            /* 116,6 */{ "Alchemical Symbols@Other ", "A2j1dA" },
            /* 387,87 */{ "Arrows", "%=68k11I3706:%M%G7AnTMm6e6HDk%`O728F1f4V1PNF2WF1G}58?]514M]Ol1%2l2Q%W06gQ01U:1Un2Mb>$0M" },
            /* 256,6 */{ "Braille", ";oA0FN" },
            /* 3,6 */{ "Common Indic Number Forms@Other ", "wgi068" },
            /* 39,6 */{ "Control Pictures", "(j90d3" },
            /* 49,50 */{ "Currency", "H3XBMQQ10HB(2106uPM]N:qol202S20V2I:Z0^xM0:91E]J6O6" },
            /* 621,221 */{ "Emoji", ";O906vIMOG%I9UGOun294v1O%1916$6n16]1]1u68WGWGGUGG88:48WE891X4EH2f@695^O1091vs8g0U1nE6916P1G,P9692:1G!]16HH]26G68#18M8-3W#191N3888]1M8|f2EG68Gt18#188738cGt58sGt4G8U868Mmm?8EeF1GM$Mv1|fE@18E8U8E8@2W?X4GE88GG8E8886u868kWOGc8" },
            /* 76,8 */{ "Emoticons@Other ", ";(i1-5W?" },
            /* 94,15 */{ "Enclosed Alphanumeric Supplement@Other ", "(jh1N2m-28,:6N2" },
            /* 249,42 */{ "Game Pieces", "Q6A06f5#1H2,]4MeEY[W1@3W}891N1GF1GN18N1P%k" },
            /* 14,7 */{ "Gender and Genealogical", "2JA0sOc" },
            /* 317,38 */{ "Geometric Shapes", "oG90nMcPTFNfFEQE10t2H3kg3u0%E6OW6^<$0s" },
            /* 63,30 */{ "Keyboard and UI", "Qz80XqUGv771.Uv46%7Y^Y1F2mc]1M" },
            /* 2,4 */{ "Latin 1 Supplement@Other Punctuation", "9FP1" },
            /* 1182,227 */{ "Math", "wug1M8V2868G8,8M88mW888E868G8888868GM8k8M8M88,8d1eE8U8d1++g1f1E:2v2894WX3:2v+]lEQ?60f2E11OH1P1M]1U11U]571WO6WUv3f111MuUmH6Ue6WGGu:26G8:2NO$M:16H8%2V28H211cvg.]4s9AnU#5PNdkX4-1Gc24P1P2:2P2:2P2:2P2:2P2QB606bf$0:;c8%Ef1Ev28v28]BmM" },
            /* 1052,127 */{ "Math Alphanumeric", "w010EGX26G6gy70bm806e2Y806Gce?]Au,8OUmOO68E86uMeU^`Q1t78V686GG6GM8|88k8-58MGs8k8d28M8U8Ok8-UGF28F28#28F28#28F28#28F28#28F28sGd4" },
            /* 257,172 */{ "Miscellaneous", "w=B0rzB0GW8Y040Mg%50EHB686WU8l1$Uv4?8En1E8|:29168U8718k8kG8M868688686e686888,148MO8|8E]7(V10c2tN1cYf806813692W]3%68X2f2|O6G86%1P5m6%5$6%468e[E8c11126v1MH2|%F9DuM8E86m8ULN%0" },
            /* 551,26 */{ "Musical", ";DA0k2mO1NM[d3GVG93N6A;80s" },
            /* 65,22 */{ "Stars/Asterisks", ";OA0v5-3g510E^jW1WV1:l" },
            /* 29,13 */{ "Subscript", "Qq80N1871QC30" },
            /* 33,38 */{ "Superscript", "XFX1x6e1oUg2701+6G|nE8I030QjW0PC6^A}06" },
            /* 189,28 */{ "Technical", "gM90sW#1G6$l7H1!%2N2O?ml1]6?" },
            /* 4,5 */{ "Tibetan@Other ", "YG40M" },
            /* 70,6 */{ "Transport And Map Symbols@Other ", "g?i1N6" },
            /* 10,9 */{ "Vedic Extensions@Other Letter", "(u70M8MO6" },
            /* 67,23 */{ "Weather and Astrological", "Q4A0F1mv3}1v8,uUe^zX171" },
            /* 165,20 */{ "Yijing / Tai Xuan Jing", "w8A0sf7c2WA0#5A>E1-7" },
            /* 67,14 */{ "Historic", "I{)0%4!P7|%4}3" },
            /* 124,27 */{ "Compatibility", "(PD0M;DU1#28-2:5HA6H1-3e!u6" },
        },
        {
            { "Punctuation" },
            /* 20,22 */{ "ASCII Based", "]2E8EG886[6O6f2H6eP16u" },
            /* 16,27 */{ "Dash/Connector", "14f4gX80c%36%1gu30:26Q3t0XG" },
            /* 41,32 */{ "Other", "(s70:<.MO$EGGG8OEms88Iu3068G6n1!" },
            /* 138,91 */{ "Paired", "n36f48v2894X1;P80sP26[6]46P16nvMPF6f3c1^F1H76:2,va@1%5M]26;7106G,fh,Gs2Ms06nPcXF6f48v288686" },
            /* 50,23 */{ "Historic", "gm808kQT30MnN72v1?(%t0E" },
            /* 105,63 */{ "Compatibility", "Ig80e91E91686W8$EH1X36P162pw0,12-1G|8F18W86nDE8c8M[6O6X2E8f2886" },
        },
        {
            { "Number" },
            /* 410,139 */{ "Decimal", "P4,]A6egh10,HC,1I,fb,%A,%A,%A,%A,%A,%A,%A,%A,XK,%A,X6,PP,X6,Q]10,f3,PR,vB,9F,m,nG,]K,m,A710Ocm,^SZ0,vz,f3,1I,%A,]a,w{L0,oo40,vB,f5,9D,2Q10," },
            /* 196,32 */{ "Enclosed/Dotted", "gs90#7%4@1Pvt2g+20,%2s8N1]2,n3N1" },
            /* 40,20 */{ "Fractions/Related", "9G6eGEoX80Ocm,1IV1%3" },
            /* 247,95 */{ "Other", "ot20cHYc]AE9Ck]Lcvd,^910#1oF10,vh2}1073GMQ:30P2!P1EHVMI2V0,9TcQbP0sHn6%JsH2s](#2fg#1wnp0l1;-70?" },
            /* 258,59 */{ "Historic", "o560EgM10,Yk10EGMo230w6u0}39175n1:aMv2$HCUXI,^E10cnQso,60@8" },
            /* 60,24 */{ "Compatibility", "w.80-2o?30EHVM2Us0,w{#0?" },
        },
        {
            { "Format & Whitespace" },
            /* 34,34 */{ "Format", "vF;Z10Uw>60UX2Uf4Ugn#0;`o0sbwt0vME" },
            /* 262,22 */{ "Variation Selector", "]=oY506%7E^$zA#LDF1AV1" },
            /* 19,29 */{ "Whitespace", "^a)05Y)0nBIH602920,n26eP4wB40" },
            /* 7,23 */{ "Historic", "w-10f4^#206IV10(970ols0" },
            /* 16,19 */{ "Compatibility", "fEAQ80?P3P4wB40^@s0" },
        },
        {
            { "Modifier" },
            /* 7,7 */{ "Enclosing", "(y80M8E" },
            /* 186,53 */{ "Nonspacing", "%+#5GG,8t1(#60E8718kWm:I,H46v%71WO|oWQ1En1sGk%2MT_t0k" },
            /* 121,42 */{ "Spacing", "f!!.M%3M91gz30(C30f1695E8?8l18d2X4N32D40XH" },
            /* 47,22 */{ "Historic", "%?71HP62x60M[F2926^Py0" },
            /* 4,5 */{ "Compatibility", "n<686" },
        },
        {
            { "Latin" },
            /* 405,143 */{ "Common", ":5N2mN2P6}18#28V1Gl1GcG|W68cGs8|GMGMG6G}1GWG6OU8GEOG6H168E11M.s$$6f16%2Mv3P168688uW.128$IN706126H26W6:16m6$6P16Gc916[878QAa06zph0696U8EOP3o2706" },
            /* 89,16 */{ "Enclosed", "Q!90t4Y#X1M8-2:5" },
            /* 105,257 */{ "Flipped/Mirrored", "]r=i1jKjnjQq40L!401GCpwGi0Trh04pM83:liJK1qQMnmaJQE10jm10(;50Lj50wX50{W50A1i0TJd0bB506(T40v]a8zE50I0105010IUi0{Zh0:7=w*Uc:V%Dih:h`h9X%B41n1WSL1Qau9q`jh_Bnm4lPm*mHn6amfmSmH6;+80j630Lj50wX50{W50QW80P1T#806f=^Y40(d30gtZ0bUi06AL10D9102g70+M70(#80+q80P3*jA#80{z80" },
            /* 650,209 */{ "Other", "]N6v16m6P16Gv26W6W6G6H286O6G6m86OE86GUGGEGOEv2s8sG!OEOt2mV38?A570@3%5718}2H9|G@1G72GMG#1GcGsGF1G6m|GcXyf2o]20}1u62cW0F1v6N1e68M91?H7zSi081s868EG?8E8EGcu8E8UGEw^60t5H193N3v!H1f171X9O11G6e6O88m11X186IWZ072f9E]96" },
            /* 183,87 */{ "Phonetics (IPA)", "%8N2%96$uH4H3u:9M%CF28718M868UO?86G68E8868GHOeP1SPE8GW11OO6918Of26868886OV3WU%2Wg|70EO6" },
            /* 24,20 */{ "Phonetics (X-IPA)", "1uH1WGeE11G6GO8G868s" },
            /* 148,53 */{ "Historic", "HZ6uP268691s15P361Jd1oQ7068H8cHw!Y?20kAZW0sH26P1l6:BU" },
            /* 358,91 */{ "Compatibility", "HF8WWO8:A6116v5H6!P3E%KcgT706vtM8E8?86GUGE8O8M8E86W8.U12-2X.}6;l30HBMvE,et8:2Qtq0kg710N2mN2" },
        },
        {
            { "Other European Scripts" },
            /* 86,16 */{ "Armenian", "(W10V3[V344k%36W" },
            /* 293,15 */{ "Cyrillic", "2510#B$NEKuHfWE" },
            /* 44,20 */{ "Georgian", "Yc40eG@2mMGEz230Y230" },
            /* 275,74 */{ "Greek", "]]8E88#18@3P3$wC70@1GcGV3GcGs8888l1888888O#48U8eE8E88OEOUeE8k8eE8E88{l706W" },
            /* 137,14 */{ "Historic - Coptic", "Q210F12$A0dAek" },
            /* 55,13 */{ "Historic - Cypriot", "^-+0cG8@386OG" },
            /* 123,18 */{ "Historic - Cyrillic", "^G106g^A0-2o,V0@7u" },
            /* 85,18 */{ "Historic - Georgian", ";Y40V3]3cW2a70V38e" },
            /* 94,9 */{ "Historic - Glagolitic", "^tB0F48F4" },
            /* 27,6 */{ "Historic - Gothic", "^l*0V2" },
            /* 180,32 */{ "Historic - Greek", "]@MG6OEX7EO71f18GU8E;{(0#6YBt0N6" },
            /* 211,23 */{ "Historic - Linear B", "(z)0|8N28t1868N1GF1937B" },
            /* 29,6 */{ "Historic - Ogham", "o_50l2" },
            /* 35,8 */{ "Historic - Old Italic", "oh*0#28M" },
            /* 81,6 */{ "Historic - Runic", "g|50N7" },
            /* 48,6 */{ "Historic - Shavian", "A;*0N4" },
            /* 6,9 */{ "Compatibility - Armenian", "oe10g^$0U" },
            /* 44,46 */{ "Compatibility - Greek", "XG%$e68%6Ef26OoN70888888n58Uu88EOu8EOu8E.886:Q" },
        },
        {
            { "American Scripts" },
            /* 710,20 */{ "Canadian Aboriginal", "gP50NuGd1]oN6TR10Xu6" },
            /* 85,6 */{ "Cherokee", "wG50t7" },
            /* 80,6 */{ "Historic - Deseret", ";(*0F7" },
        },
        {
            { "African Scripts" },
            /* 495,87 */{ "Ethiopic", ";(40l68MGk88MGt38MG@28MGk88MGN18758MG}5X3V1w<60}1.k8k8k8k8k8k8k8kI8X0cGcGc.k8kDDe0-2%1," },
            /* 56,13 */{ "Nko", "I520t2i3,13V1" },
            /* 59,10 */{ "Tifinagh", "o_B0}4u6P1" },
            /* 300,17 */{ "Vai", "^th0NOWV1[6*2Mf1," },
            /* 3,5 */{ "Historic - Nko", "^720E" },
            /* 40,8 */{ "Historic - Osmanya", "g?*0t2G," },
        },
        {
            { "Middle Eastern Scripts" },
            /* 346,84 */{ "Arabic", "gs10V2m,f368W-18F68H26[EGP774XQ8?;}$05!%0U8N1mG6]2[73G19f2,O69iV22B+0#2YVx06{S$0V1]p" },
            /* 53,19 */{ "Hebrew", "Il10V2eE`5#1P46o:$0" },
            /* 63,19 */{ "Thaana", "g|10V311KcP1O:5,%S?" },
            /* 39,22 */{ "Historic - Arabic", "gr10c]2UH46%2f6k8V19D6" },
            /* 49,6 */{ "Historic - Carian", ";Y*0V4" },
            /* 982,13 */{ "Historic - Cuneiform", "gE=0-@HD@8H1M" },
            /* 45,16 */{ "Historic - Hebrew", "gf10#2:1M;>$0!f3" },
            /* 29,6 */{ "Historic - Lycian", "^V*0l2" },
            /* 27,7 */{ "Historic - Lydian", "AA,0N2e" },
            /* 50,9 */{ "Historic - Old Persian", "Aw*0F3WF1" },
            /* 29,7 */{ "Historic - Phoenician", "I7,0d2O" },
            /* 93,22 */{ "Historic - Syriac", "wq10P1O]2[?X21DF18V5GE" },
            /* 31,7 */{ "Historic - Ugaritic", "It*0t28" },
            /* 876,89 */{ "Compatibility - Arabic", "I!10MA($0-813@Wv1#5G-4v371fAE88FCgI#0M8V2868G8,8M88mW888E868G8888868GM8k8M8M88,8d1eE8U8d1" },
            /* 35,17 */{ "Compatibility - Hebrew", "2a(08.F18U886868!" },
        },
        {
            { "South Asian Scripts" },
            /* 93,48 */{ "Bengali", "gj20sG6G@18k8OMOf1n16P16%+6y^6f2E958kG6GE.[6G,G," },
            /* 149,50 */{ "Devanagari", "(X20-4Ov1X16f1c8k9[6gMf0cODRg0M]4E8l18k[V1YEg0l1mE" },
            /* 86,41 */{ "Gujarati", "(*20!8E8@18k868UOv1X16]l6*uE958s8E8E:16G|" },
            /* 77,43 */{ "Gurmukhi", "Av20cW6G@18k8GG693]1E:v6y^69EE958UW6GEO:1|O" },
            /* 85,39 */{ "Kannada", "QR30s8E8}18,8UO936X16CA6958k8E8Mu6116G," },
            /* 74,16 */{ "Lepcha", "oZ70F3%3E=3#1ON1" },
            /* 66,13 */{ "Limbu", "(r60l2O|W|WO|" },
            /* 100,39 */{ "Malayalam", "Ab306v1s8E8t3Gf1n16H2cSB6P5k8E8M.[6GV1O" },
            /* 48,12 */{ "Ol Chiki", "(h70t2i3,%2s" },
            /* 92,47 */{ "Oriya", "Y[20sG6G@18k868UO13EX1:Y6y^6XbE958kG6GE$6[6G?8c" },
            /* 81,15 */{ "Saurashtra", "oni0d4q46n4d1.|" },
            /* 80,27 */{ "Sinhala", "oo30l1O728!8GkC66X6Wc88sv1E" },
            /* 74,40 */{ "Tamil", ";3308cOE8MO6886O6OEO|12HQ6aXX5UOE8M.P1-1" },
            /* 95,42 */{ "Telugu", "wF30s8E8}18,8UOX26m61D6=LEP5k8E8Mu6116G,$s" },
            /* 207,70 */{ "Tibetan", "2{30%5E8M8M8M8M8M8|8Ef2UqC?8l4f468ek8cec8M8M8M8M8M8|8E8N18kW6Ii806e,Gs" },
            /* 1,4 */{ "Historic - Kannada", "YZ30" },
            /* 65,20 */{ "Historic - Kharoshthi", "gU,0M86es8E8V2WEW!$!" },
            /* 83,26 */{ "Historic - Phags Pa", "wU6068AU606e,Gs2*V0}4w|M0M" },
            /* 44,6 */{ "Historic - Syloti Nagri", "(bi0@3" },
            /* 3,6 */{ "Compatibility - Bengali", "Yr2068" },
            /* 8,5 */{ "Compatibility - Devanagari", "Yf20s" },
            /* 6,9 */{ "Compatibility - Gurmukhi", "Qz20G93EG" },
            /* 2,5 */{ "Compatibility - Oriya", "Q0306" },
            /* 22,30 */{ "Compatibility - Tibetan", "A|30]4.WWW91.868$n1.WWW91YX#0M" },
        },
        {
            { "Southeast Asian Scripts" },
            /* 121,20 */{ "Balinese", "(C70F4n1k*6UP4d111}3" },
            /* 83,23 */{ "Cham", "Q`i0t392E8s43F191$6G,GM" },
            /* 48,12 */{ "Kayah Li", "^zi0d2S3,n2," },
            /* 141,26 */{ "Khmer", ";I6073GE8?v3q3l28,W,m,Hi-2" },
            /* 67,41 */{ "Lao", "g:3068G68GmM8k8E88G68M86.GU92MC4Gc86.8cG," },
            /* 188,64 */{ "Myanmar", "QK40-3:1f1cWMOO6uEW7191(xe0V18cOD-e0#18V1mMWE8EGkOMH1|8d1wxe0mE8" },
            /* 83,19 */{ "New Tai Lue", "Y%60@3]1k42d1u6m?O6" },
            /* 35,8 */{ "Tai Le", "2z60t2GU" },
            /* 86,19 */{ "Thai", ";z30N48691c*1Gk11@1" },
            /* 30,8 */{ "Historic - Buginese", "2>60d2G6" },
            /* 22,8 */{ "Historic - Buhid", "2C606.#1" },
            /* 23,6 */{ "Historic - Hanunoo", "AA60}1" },
            /* 3,8 */{ "Historic - Khmer", "gM60v311" },
            /* 37,8 */{ "Historic - Rejang", "Y%i0F311" },
            /* 72,9 */{ "Historic - Sundanese", "^N70#5PNs" },
            /* 22,11 */{ "Historic - Tagalog", "I760718k]26" },
            /* 20,13 */{ "Historic - Tagbanwa", "2C606%3718E86" },
        },
        {
            { "Hangul" },
            /* 112,38 */{ "Other", "ozC0:42Pi0}1WV4Lbi0MO,8F1H1EmeEPqQ?r06" },
            /* 1176,8 */{ "ᄀ HANGUL CHOSEONG KIYEOK", ";gj0}}-I" },
            /* 588,6 */{ "ᄂ HANGUL CHOSEONG NIEUN", "(zk0Vr" },
            /* 1180,13 */{ "ᄃ HANGUL CHOSEONG TIKEUT", "(+i0MAj20}}-I" },
            /* 599,11 */{ "ᄅ HANGUL CHOSEONG RIEUL", "A,i0?2#30Vr" },
            /* 591,11 */{ "ᄆ HANGUL CHOSEONG MIEUM", "A-i0EIS40Vr" },
            /* 1179,13 */{ "ᄇ HANGUL CHOSEONG PIEUP", "Y-i0EY]40}}-I" },
            /* 1177,12 */{ "ᄉ HANGUL CHOSEONG SIOS", "w-i0IC60}}-I" },
            /* 590,11 */{ "ᄋ HANGUL CHOSEONG IEUNG", "(-i06^U70Vr" },
            /* 1177,12 */{ "ᄌ HANGUL CHOSEONG CIEUC", "^-i0Q`70}}-I" },
            /* 588,6 */{ "ᄎ HANGUL CHOSEONG CHIEUCH", "I}r0Vr" },
            /* 588,6 */{ "ᄏ HANGUL CHOSEONG KHIEUKH", "wqs0Vr" },
            /* 589,10 */{ "ᄐ HANGUL CHOSEONG THIEUTH", "2.i02YA0Vr" },
            /* 589,10 */{ "ᄑ HANGUL CHOSEONG PHIEUPH", "A.i0Y}A0Vr" },
            /* 589,10 */{ "ᄒ HANGUL CHOSEONG HIEUH", "I.i0(qB0Vr" },
            /* 1,4 */{ "ᅙ HANGUL CHOSEONG YEORINHIEUH", "Q.i0" },
            /* 350,12 */{ "Historic", "oh40FN^L80d8" },
            /* 118,27 */{ "Compatibility", "oJD0#2]5#2IGs0MX5#2OcGcGcGE" },
        },
        {
            { "Other East Asian Scripts" },
            /* 111,40 */{ "Bopomofo", "ozC0:4HIt3XAV2bXC06I]B0MO,8F1.MGmeEwgs06" },
            /* 142,49 */{ "Hiragana", "ozC0:4W#7AZD1zmD1MOF2X1c8eE986G68H86XD6^Bs061R946" },
            /* 162,52 */{ "Katakana", "ozC0:49978PMV1I2D1rmD1MOF2X1c8eE986eH8MHD6^Bs061R946" },
            /* 156,23 */{ "Mongolian", "YX60738t4$t38aFN18,%3H9" },
            /* 1240,30 */{ "Yi", "oRg0-18}}-FL.U06e,Gs^rT0IG10@4" },
            /* 4,5 */{ "Compatibility - Bopomofo", "Ql)0M" },
            /* 24,21 */{ "Compatibility - Hiragana", "^%C0996G1MF1gas0U2E$0" },
            /* 213,29 */{ "Compatibility - Katakana", "^%C0996]8PDF1vRF48@7g`r0N18}3" },
            /* 4,5 */{ "Compatibility - Yi", "Ql)0M" },
        },
        {
            { "Han 1-Stroke Radicals" },
            /* 43,28 */{ "一", "ItK071]BYL10TX10kOJE8F192426" },
            /* 13,7 */{ "丨", ";wK0M8!" },
            /* 9,11 */{ "丶", "AyK0Ef1a1M8" },
            /* 26,16 */{ "丿", "^yK0,8E2y30{x30|" },
            /* 43,17 */{ "乙", "Q#K0U^iL0>iL0EG}2" },
            /* 7,5 */{ "亅", "Q)K0k" },
            /* 23,33 */{ "Compatibility", "(bC0c]R]q8O8f2Eoeq0]116$f7fG;(k1E" },
            /* 346,83 */{ "Less Common", "A(D0t3(rX1V288k8!8k8868|8l188U8718M8N48E88GE8#48MG@3oA20]G2P60;QB0]9^(20^7L0t2gN40U" },
        },
        {
            { "Han 2-Stroke Radicals" },
            /* 19,8 */{ "二", "^)K0M8N1" },
            /* 26,6 */{ "亠", "(+K0N2" },
            /* 646,42 */{ "人", "A.K0VA15`4@48l6AGL05GL0VT86GZG68d39141|8t1" },
            /* 38,6 */{ "儿", "(gL0V3" },
            /* 7,14 */{ "入", "IkL0MY870T8706" },
            /* 24,18 */{ "八", "(kL0,gzK0bzK0U838c" },
            /* 21,10 */{ "冂", ";mL0#1Yw50" },
            /* 21,6 */{ "冖", "woL0-1" },
            /* 53,6 */{ "冫", "oqL0#4" },
            /* 21,6 */{ "几", "YvL0-1" },
            /* 11,5 */{ "凵", "QxL0?" },
            /* 155,16 */{ "刀", "QyL0d98sWC1$M8F3" },
            /* 93,9 */{ "力", "Y;L0V58@2" },
            /* 28,6 */{ "勹", "^^L0d2" },
            /* 5,5 */{ "匕", "g{L0U" },
            /* 31,15 */{ "匚", "^{L0l12KK0{JK0|" },
            /* 9,5 */{ "匸", "w0M0!" },
            /* 27,20 */{ "十", "g1M0E8c838,(HK0zHK0U" },
            /* 13,6 */{ "卜", "^3M071" },
            /* 25,6 */{ "卩", "A5M0F2" },
            /* 53,20 */{ "厂", "Y7M0t2;ZD0+ZD0MeZU8|" },
            /* 18,6 */{ "厶", "ACM0l1" },
            /* 28,10 */{ "又", "(DM0V2IS10" },
            /* 151,6 */{ "讠", "Y]a0tD" },
            /* 142,94 */{ "Compatibility", "QcC0}1%P8]qG688P1W6G6mO8;fq0f1E9386H18e11Ee[n16[91e11.G$H1n18611$X2cX5kg(k1F28d292%B6f6%A15P1O" },
            /* 3306,212 */{ "Less Common", ";+D0tN8l49H2i40kQRl0(Q+0uH3v1H788]9@18}2872Gk8E8|8s88E8G-18778@28lF8-6G,8@48#486GF28d28t18t48N3874868-78F58V18}28F48l48lG868d18N18#18!8FN8@98FP8s8}F8N28,8VG8F18tF8}2(s30%U;@101bI-50QE60^{40;X60IhB0}Oo_20d3%}t1HCU" },
        },
        {
            { "Han 3-Stroke Radicals" },
            /* 1,4 */{ "丬", "IxK0" },
            /* 754,73 */{ "口", "IGM0@X8U8?8F1=2n1P1t18V4HCyGf4t8Gk%38y46ul28?888s12`1@18#2f3a3V38,$xkGBGs" },
            /* 73,21 */{ "囗", "^`M0c^MJ0>MJ0F4OJE8N1" },
            /* 461,65 */{ "土", "g3N0EAHJ05HJ0VDH2C2728V28-3=3]3d38U8U_eel88F32(I0{%I0?;%I0+%I0!8!" },
            /* 24,11 */{ "士", "QjN0!iXnXF1" },
            /* 7,5 */{ "夂", "YlN0k" },
            /* 12,11 */{ "夊", "AmN0EJOU838" },
            /* 18,6 */{ "夕", "AnN0l1" },
            /* 76,14 */{ "大", "(oN0738|4191d2" },
            /* 476,64 */{ "女", "wvN0N28t6y6%6#18}18Mi2n2738s$i1$s8V78#2:2y5:2#28d7n1i1d18M8MRWl1" },
            /* 48,11 */{ "子", "2DO0@283871" },
            /* 121,31 */{ "宀", "YHO0t1;260+260#18MRW#3:1*1#1871" },
            /* 23,10 */{ "寸", "QSO0?OJE8s" },
            /* 20,14 */{ "小", "YUO0k2?H0{>H0|" },
            /* 22,6 */{ "尢", "AWO0@1" },
            /* 53,7 */{ "尸", "AYO08t4" },
            /* 3,5 */{ "屮", "2dO0E" },
            /* 363,46 */{ "山", "QdO0D#30I#30V28}44595@B8t1y1%1V88kpu?86BGU838E" },
            /* 9,7 */{ "巛", "I.O0c8E" },
            /* 12,5 */{ "工", "A:O0|" },
            /* 13,6 */{ "己", "I;O071" },
            /* 115,16 */{ "巾", "Y<O0t68kp$!838@1" },
            /* 8,5 */{ "干", "^{O0s" },
            /* 6,9 */{ "幺", "2$K0oM40U" },
            /* 118,30 */{ "广", "A}O0@1OJE8-3mZU86x$@2I8H0D8H0c" },
            /* 10,5 */{ "廴", "(9P0," },
            /* 13,6 */{ "廾", "wAP071" },
            /* 8,5 */{ "弋", ";BP0s" },
            /* 61,6 */{ "弓", "oCP0d5" },
            /* 17,6 */{ "彐", "AIP0d1" },
            /* 17,7 */{ "彡", "wJP0!8s" },
            /* 82,33 */{ "彳", "QLP0!Y0H06b0H0l1mhc8U8,<[7186BGF1" },
            /* 151,12 */{ "纟", "(gX071[<,8dB" },
            /* 52,6 */{ "门", "wud0t4" },
            /* 1,4 */{ "飞", "obe0" },
            /* 51,11 */{ "饣", "wne0V386BG," },
            /* 60,6 */{ "马", "(:e0V5" },
            /* 195,94 */{ "Compatibility", "YeC0#2P=11Wm11686W(dq0G86:1mP26m6%1me%1E11X1OmEf1692Ge6H1%1Gm8GX3kX4[F1A,k1}18l58E8EGMP8:5]6]9" },
            /* 8555,310 */{ "Less Common", "YAE0@G8V(I!20|I!10E:5fX18EA8k08QQ+0%1u8Gn3v11B1693P2uO91$8OH2H713vMXG%1%K:6]SG13%2H@vX93tU8F587w8}V8-68tA8dO8db8V38758V28t58F18k8#C8t!8V78V98tU8lT8de8}}V98lB8}B8#387987H8#38NJ8@78U8N18U8kgE10(L10v_X4ngA6109Nn2v2Ac101O1}HSQ*1094^.50N2:BP6Ay10Q<40]5;s20AE20V1H9^j20l1%g-3YY20YU10}zAv10@2;310F1]E72X3}1%Q@2%6UP5uE" },
        },
        {
            { "Han 4-Stroke Radicals" },
            /* 581,32 */{ "心", "oSP0NW]5=5-58M8V2a2f2d48F2K2P2l4" },
            /* 46,17 */{ "戈", "Y]P072mhc8!838838" },
            /* 21,6 */{ "戶", "o{P0-1" },
            /* 741,99 */{ "手", "g}P0E2LG0{KG08kpus871C1H1?8}34494NO8?_11k8#5]6=6-38F24C9Ck8E874G*7P3H468l411_?8t28|4191#2838l186BGk" },
            /* 5,5 */{ "支", "((Q0U" },
            /* 85,31 */{ "攴", "I)Q0F2rI40wI40t2GB68@12dA0{cA0E" },
            /* 17,14 */{ "文", "(;Q0(OF0zOF0N1" },
            /* 13,6 */{ "斗", "I=Q071" },
            /* 21,6 */{ "斤", "Y>Q0-1" },
            /* 39,12 */{ "方", "Q@Q0F1OJE8-1" },
            /* 5,5 */{ "无", ";^Q0U" },
            /* 271,50 */{ "日", "Q_Q0NA(+60j_B0(D50t1XDSDN2H1C1718V523F0{2F0,GB68-1" },
            /* 23,20 */{ "曰", "oJR0!8rS50gS5086868k" },
            /* 33,15 */{ "月", "(LR0V2;070+070U" },
            /* 1018,92 */{ "木", "wOR0@59242}187LAuE05uE0#H2R10{Q10F886uOK1Gk8E8l6uH6=6k8768Ev4P1`5l48F18NAW8hM88!8F1m=1P1c8t1" },
            /* 66,10 */{ "欠", "2TS0E838d5" },
            /* 24,14 */{ "止", "2ZS0I:D0D:D0@1" },
            /* 58,6 */{ "歹", "AbS0F5" },
            /* 24,6 */{ "殳", "YgS072" },
            /* 9,5 */{ "毋", "oiS0!" },
            /* 7,5 */{ "比", "YjS0k" },
            /* 52,6 */{ "毛", "2kS0t4" },
            /* 5,5 */{ "氏", "(oS0U" },
            /* 32,6 */{ "气", "IpS0-2" },
            /* 1079,147 */{ "水", "AsS06WRM8VE8N28!K3P3F18s8t5i6$%5}58V1a1f1}78#1G98KA:168}7872v5v1w^C052D0l5G718E8|v3a6H1f1-28k8t38V1`5f4f1d48728Mn4`4Wd48EG*7n768d28@2`213758-1=1]1k" },
            /* 451,70 */{ "火", "I$T0!%1y1t18tC8MRWl39444}38,838#291(350>450|8N1g^B0nI12DFC0t78Em<Oc8#1" },
            /* 13,14 */{ "爪", ";GU0,jW70oW706" },
            /* 5,5 */{ "父", "^HU0U" },
            /* 4,5 */{ "爻", "YIU0M" },
            /* 9,9 */{ "爿", "IxK0gl90s" },
            /* 18,6 */{ "片", "gJU0l1" },
            /* 2,5 */{ "牙", "ALU06" },
            /* 81,11 */{ "牛", "QLU0N3838#3" },
            /* 216,32 */{ "犬", "wSU0tA$6)sGF1un1K2k868chuk86<[74" },
            /* 16,7 */{ "见", ";ba0U8?" },
            /* 71,6 */{ "贝", "2Sb0V6" },
            /* 53,6 */{ "车", "I]b0#4" },
            /* 1,4 */{ "辶", "g0c0" },
            /* 7,5 */{ "韦", "2Fe0k" },
            /* 13,9 */{ "风", "Aae0k838M" },
            /* 302,124 */{ "Compatibility", "^SC0HE}2::MGEG.Ogeq0G$mEm6OGOEWE%1eE916Ou6m868W$6m6GU11OE8W91WEWGMmOG6eM$8e6W6mG611Of371136P2}18EH4M(!k1:8e#4G6G-28}2871]7$6" },
            /* 11609,249 */{ "Less Common", "^aE0]uFq8#@^U20U%LEY`k06AW+0f7HLfkX2vCH4vM(a10gv10IO10Yg30Hz}}VE8to8-w8@J8-28tK8td8N48FC8E8l68cGNM8V#8#98lK8-A8-A8|8728E8l287N8}}#E8@N8V%8tC88V88-88lC8N18@48t38l`;Y20(>101dYk201)XQ6nUv^Xao940kAi10cv3QF40UHdXG|fe8o^40}}l3YD10c]Ak]7@19YcX4U1d@3%5E%286" },
        },
        {
            { "Han 5-Stroke Radicals" },
            /* 5,5 */{ "玄", "QmU0U" },
            /* 339,47 */{ "玉", "(mU0838N912`1M8d18,i2n2,8t2y2%2F78Wh8M8F186BG@4" },
            /* 10,5 */{ "瓜", "o@U0," },
            /* 50,6 */{ "瓦", "g[U0d4" },
            /* 7,5 */{ "甘", "2{U0k" },
            /* 9,5 */{ "生", "w{U0!" },
            /* 8,5 */{ "用", "g|U0s" },
            /* 89,22 */{ "田", "I}U0?838738k8mhcG!).V1" },
            /* 7,5 */{ "疋", "g7V0k" },
            /* 228,33 */{ "疒", "A8V0t2[<,8d8muK1c8k872[<,8}1838l1" },
            /* 7,5 */{ "癶", ";SV0k" },
            /* 50,11 */{ "白", "gTV0|=Q]QN3" },
            /* 18,14 */{ "皮", "^XV0s^;A0>;A0!" },
            /* 47,12 */{ "皿", "gZV0N2GB68l1" },
            /* 238,39 */{ "目", "(dV0t5v1q1l1G38V1IzA0DzA0N18|4191V98EJO" },
            /* 7,5 */{ "矛", "QzV0k" },
            /* 17,6 */{ "矢", "^zV0d1" },
            /* 328,44 */{ "石", "g#V0N15]20A]20FB8t2%1i4%2t18!upk872Gu<68k8t7" },
            /* 130,48 */{ "示", "I5W0-1IV40^-50DFA0}18!).!11^L40{M40?8-3Q6A0L6A0s" },
            /* 7,9 */{ "禸", "wGW0c((20" },
            /* 182,27 */{ "禾", "IHW0-5upk8}312`1-1Gs).t2GB6" },
            /* 87,6 */{ "穴", "(XW0-7" },
            /* 45,22 */{ "立", "wfW0#1G?Qj70Lj70686BGs" },
            /* 242,6 */{ "钅", "YOd0@L" },
            /* 1,4 */{ "长", "Ald0" },
            /* 86,12 */{ "鸟", ";-f0758MRW72" },
            /* 3,5 */{ "龙", "IIg0E" },
            /* 144,73 */{ "Compatibility", "QkC0}1n.O86n1;eq0$f2u6[P1[68$$P1P16926u[[E91$6.u:2UH4|f6O|11X1[Ew`k1V18V3" },
            /* 6041,188 */{ "Less Common", "AoG0@:;12071n^kXD6I4R1:4WnB9d[15:49lHkX.1pP5Hw]nf]^H20()109d;u101@]2%KY!10:9f.;(307k8dL8}38@88-98?8V?WdA8}S87Q8748l!8-T8#d8d28lI8FK8#12@30nQI,10w^402B20F22,50-1AQ30}b(F10V49f}3]3XA72:4V1:1" },
        },
        {
            { "Han 6-Stroke Radicals" },
            /* 378,51 */{ "竹", ";jW0?8F5K5P5@5%5y5t58s8,<[d213OS3@28E8F5e6hUGl1838s" },
            /* 135,45 */{ "米", "I[W0Mr990w990V2r?10w?10|eZU8l1[<,8}2eZU8s838U" },
            /* 423,48 */{ "糸", "Q4X0@88d2i2n2F3%4y4t48686BGNA8686Ze728.a3X28!8}3" },
            /* 27,10 */{ "缶", "guX0U838#1" },
            /* 57,12 */{ "网", "^wX0t2OJE8}1" },
            /* 52,18 */{ "羊", "A$X0?8MLI20;H20W73" },
            /* 68,11 */{ "羽", "(*X0F5eZU8M" },
            /* 11,5 */{ "老", "^;X0?" },
            /* 6,5 */{ "而", "^<X0c" },
            /* 33,6 */{ "耒", "g=X0@2" },
            /* 76,18 */{ "耳", "g@X0}211_?8718UZe?" },
            /* 10,5 */{ "聿", "Y|X0," },
            /* 346,33 */{ "肉", "Q}X0}8n2i2d28N7bN90gN90l68V486BG," },
            /* 7,5 */{ "臣", "(UY0k" },
            /* 9,5 */{ "自", "YVY0!" },
            /* 9,5 */{ "至", "IWY0!" },
            /* 16,10 */{ "臼", "2XY0,86BGE" },
            /* 15,6 */{ "舌", "gYY0N1" },
            /* 4,5 */{ "舛", ";ZY0M" },
            /* 79,6 */{ "舟", "IaY077" },
            /* 4,5 */{ "艮", "YhY0M" },
            /* 6,5 */{ "色", "(hY0c" },
            /* 984,143 */{ "艸", "QiY0EY$70T$70768V11AiBf1@58EJOk8U8N28#18d2a7e]6d58V1(a70bk70v9t9H4(L70Lb70HBE8#38t88@3838lH8E8o=605>60O8N3P7K7N28kpud286H1a1G7188|8cI(60+(60m-1" },
            /* 30,17 */{ "虍", "gjZ0EDPA0IPA06872" },
            /* 469,85 */{ "虫", "ImZ0l28}283873a6f6c8t2y2%273%1X2C4t18N28d48k%8a9ut39444t3H4C4M8!8#1H2C2?8|8@1X1S1N18?" },
            /* 12,5 */{ "血", ";2a0|" },
            /* 23,6 */{ "行", "^3a0}1" },
            /* 286,63 */{ "衣", "26a06DVE0IVE0t6838#48t2y2%274838d1P1K1F18w^50r^50l2>YD0^YD06$xs" },
            /* 13,6 */{ "襾", "(Va071" },
            /* 51,6 */{ "页", "2Se0l4" },
            /* 2,5 */{ "齐", "oBg06" },
            /* 206,93 */{ "Compatibility", "YmC0l2IPr0MemO68691Em6e6.6GO6n1Oem6P268me$6n19112Eue86WWW:168:4?v6G?%2^,k1Wn56XC-28U86G68M8@4" },
            /* 9331,185 */{ "Less Common", "o5E0oq10;%10VE8VH91l;P^(ok08wb+0Q0101Io3102E20XZoi10n>2;10XUPN18e]1;n30v6m6(L40vHvCX1:8;g10A{30HM}}N@X2#B8F68@D8VI8@(8NQG#L8#68t18tO8#v8Na8##8VC8#^8tt(j10wB30YE30E(870NF13#hfxd1%kce#1:3" },
        },
        {
            { "Han 7-Stroke Radicals" },
            /* 2,8 */{ "卤", "w4M0(<J0" },
            /* 53,15 */{ "見", "^Wa069141!868d3" },
            /* 47,20 */{ "角", "Yda0,86BG@1QC50LC50?" },
            /* 418,45 */{ "言", "oha0lC]1wp50rr50-18F5P1K1F18@88N12Y50bZ50X1}5" },
            /* 15,6 */{ "谷", "A7b0N1" },
            /* 15,6 */{ "豆", "g8b0N1" },
            /* 35,8 */{ "豕", ";9b0@283" },
            /* 37,6 */{ "豸", "2Db0N3" },
            /* 127,9 */{ "貝", "YGb0}88V2" },
            /* 12,5 */{ "赤", "gYb0|" },
            /* 68,15 */{ "走", "oZb0cw-40r-40d5" },
            /* 248,44 */{ "足", "wfb0!8}212C593@18#48M[S1W,8}3mn1C2c8d18d386B" },
            /* 31,6 */{ "身", "I$b0#2" },
            /* 158,31 */{ "車", "2)b0738V1Aa40rb40f1772V40{U40F2" },
            /* 21,6 */{ "辛", "2|b0-1" },
            /* 5,5 */{ "辰", "^}b0U" },
            /* 221,38 */{ "辵", "Y0c0!TGD0YGD0}29141|8}B8OZ8E8U.)!OB68k" },
            /* 184,15 */{ "邑", "YKc0-5838-9838c" },
            /* 125,6 */{ "酉", "Abc0NB" },
            /* 6,5 */{ "釆", "gmc0c" },
            /* 5,5 */{ "里", "2nc0U" },
            /* 1,4 */{ "龟", "(Ig0" },
            /* 101,78 */{ "Compatibility", "oaC0XE#1X*en1Ydq086X1ev1[.mn1Gn18116P1[8m]111%1n1v1[G92G6un4kX7|v1o5l1n5F18E8!" },
            /* 5366,126 */{ "Less Common", "QAE0gj40lFu-8etLO#D2.k06(T,0PL9,AY30v9]_A^60Yl10;N50Az10oi10(I80F`8M8V58Nh8lCu}}}hml3Glb8N@;820o{80|m-3n3V3u-712#9nwv3PF6eO!n3" },
        },
        {
            { "Han 8-Stroke Radicals" },
            /* 696,93 */{ "金", "gnc0@3zLA0(LA0-AX2Yf30+h30k8l18N94B9BV48t28QO30LR30%28t88@12E305G3012l4mh8M8F4y4%4@3v1q1l18l2" },
            /* 8,5 */{ "長", "Ykd0s" },
            /* 104,13 */{ "門", "Ild0@48?_11N3" },
            /* 154,15 */{ "阜", "Yzd0l58N1S1X1-6" },
            /* 3,5 */{ "隶", "Y<d0E" },
            /* 47,6 */{ "隹", "w<d0F4" },
            /* 105,6 */{ "雨", "^@d0d9" },
            /* 13,6 */{ "靑", "g1e071" },
            /* 4,5 */{ "非", "w2e0M" },
            /* 105,15 */{ "鱼", "(Xf0@5871C1H1F2" },
            /* 14,6 */{ "齿", ";Fg0F1" },
            /* 51,54 */{ "Compatibility", ";qC0!:(Ihq094m.uu14:1]1EWH191$H1m92v1v195X8MYzk1vf7186" },
            /* 2760,97 */{ "Less Common", "QTJ0l8H1F4OV68-5:ss2?j0E2W+0AQ50Q>U0#88@yP2dcf1798N#8FJQn30@1^;106;y30l8f4@1P1N61OV39B!XH6n111Mu8" },
        },
        {
            { "Han 9-Stroke Radicals" },
            /* 7,5 */{ "面", "23e0k" },
            /* 98,6 */{ "革", "w3e0-8" },
            /* 27,11 */{ "韋", "oCe0V18MRWc" },
            /* 6,5 */{ "韭", "wFe0c" },
            /* 16,15 */{ "音", "IGe0zy706wy7071" },
            /* 116,26 */{ "頁", "gHe0t1eZU8,Gkx6ud18|4191#3" },
            /* 38,6 */{ "風", "wWe0V3" },
            /* 3,5 */{ "飛", "Qbe0E" },
            /* 132,23 */{ "食", "wbe0V28UZeN2OJE872838-3" },
            /* 3,5 */{ "首", "Qse0E" },
            /* 19,6 */{ "香", "ose0t1" },
            /* 38,28 */{ "Compatibility", "wrC0?f)2vq0f298Ef56n8MIGl1N1" },
            /* 1989,89 */{ "Less Common", "ooH0g520-Q8!IHS1:_P32-30ARC0YA40](^b70gd807Y8lBelaW728NG91}Zv1t288-4Iz70d1mt1n1|el1H2N1fk" },
        },
        {
            { "Han 10-Stroke Radicals" },
            /* 194,34 */{ "馬", "Que0V68V1a1f176ob10jb10-2(Y10zY10M" },
            /* 48,6 */{ "骨", "I@e0N4" },
            /* 7,5 */{ "高", "o_e0k" },
            /* 70,18 */{ "髟", "I`e0l211_?8d1WRM8k" },
            /* 10,5 */{ "鬥", "o2f0," },
            /* 3,5 */{ "鬯", "g3f0E" },
            /* 10,5 */{ "鬲", "(3f0," },
            /* 30,6 */{ "鬼", "w4f0t2" },
            /* 16,18 */{ "Compatibility", "wsC0s;Lr0:9nTgHl1U" },
            /* 1449,35 */{ "Less Common", "^_J077O#9wM(1gQ10#Y]3};gl60@192l2He" },
        },
        {
            { "Han 11..17-Stroke Radicals" },
            /* 292,59 */{ "魚", "Y7f0-2IB10DB10#2[<,8d1eZU8F2%3y3}2eZU88t2WRM8l31b`a#28EJOV1" },
            /* 313,39 */{ "鳥", "Qhf0N38MRWt78]s=s#3838758MRWV18728EJO}2" },
            /* 9,5 */{ "鹵", "w@f0!" },
            /* 38,6 */{ "鹿", "o[f0V3" },
            /* 18,7 */{ "麥", "2`f08d1" },
            /* 4,7 */{ "麦", "A`f0n1E" },
            /* 8,5 */{ "麻", "2|f0s" },
            /* 10,5 */{ "黃", "(|f0," },
            /* 1,4 */{ "黄", ";|f0" },
            /* 4,5 */{ "黍", "w}f0M" },
            /* 40,17 */{ "黑", "20g06>mI0^mI0c8#2" },
            /* 4,5 */{ "黹", "w3g0M" },
            /* 13,6 */{ "黽", "24g08|" },
            /* 4,7 */{ "黾", "A4g091E" },
            /* 5,5 */{ "鼎", "o5g0U" },
            /* 13,6 */{ "鼓", "26g071" },
            /* 27,6 */{ "鼠", "I7g0V2" },
            /* 15,6 */{ "鼻", "w9g0N1" },
            /* 6,5 */{ "齊", "2Bg0c" },
            /* 45,6 */{ "齒", "(Bg0}3" },
            /* 11,7 */{ "龍", "AHg0E8s" },
            /* 3,5 */{ "龜", "gIg0E" },
            /* 6,5 */{ "龠", ";Ig0c" },
            /* 55,39 */{ "Compatibility", "YtC0#1QIr0692H26ef66P5946H5nE.6Q,k1fYt1" },
            /* 2928,104 */{ "Less Common", "IDK0t9$@9uNDGkoOR1fk^x102.20nDQf301=^N50;g202j30M^>90od80g320to12t!]1-H8F[GN6284075f3@394E8l2.GvJ6WEG688" },
        },
        {
            { "Han - Other" },
            /* 149,15 */{ "CJK Strokes", "AQC0N28M8d7H%F3" },
            /* 12,5 */{ "Ideographic Description", "oxC0|" },
            /* 53,18 */{ "Other", "AzC0d18V2GmOUwgs06" },
            /* 113,24 */{ "Compatibility", "gMD0F3PB|%CF2[U%8#2Q+r0M" },
        },
        {
            { "TODO" },
            /* 3043,682 */{ "Missing", "o070T,40Ey5d1*16%1(|f06>)a02ib0wLR0Qp10z>S0Y9R0nBnBnBbT%0A:b0Y9R0nBnBnBAW10T=S0Q9R0nBnBnBAW10j=S09uSR8DEc0sYta0vj65}f0N1Q#g0y%Gg410I5R0rtS0Xj{8b0Mo;b06%Q%MolQ06:A6nB6:B6+iR0cOMa(o(P09)c;d106vBPC>G,0({g06{Cc0ke6XUMwjb06Y7R0UDU10Ae106HOb]10>wz0>(10o<b0fO]16T8h072G6P3F2A0h0vIV2yM?nMsCNUe:Ks[aMQ<Q073eZU8F1HO=5-5IM10,%238*2l2OG,z)10F4S46P4t1j[Q0t588H26j;b0V3871I-$0d4DU%0kf46i4-1%26*2?H1C1cm92`1EWEi1cP1[<!O6OJEZC1I<b0d3%1y16v1q1c8uhMOJ6h[g|P0l6+>Q0N626p0tpjEq0M83`3N288J88,;br0U838,GB68V183872838U11F4f1d1b6P0F2{#10l2]B-4**@1:)@1[t1ww90}}N9TMB0=2]2=2]2=2]2=2]2=2]2=2]2=26:2*2:2*2:2*26%2y26v2q26n2i2n2i2n2i2n26q26n2i2n2i2n2i2n2i26f2a26X2S2X2S2]26`26orr0f6G686G6W918u]5W6$un2We8Eu]U6nQ6" },
        },
    };
}
