/************************************************************************
 * Copyright (c) 2005, Sun Microsystems and others.  All Rights Reserved.
 *************************************************************************/

package org.unicode.cldr.ooo;

/**
 * 
 * class defines constants for the ldmlopenOffice.dtd elements and attributes
 */
public class OpenOfficeLDMLConstants
{
    public static final String FORMAT_INDEX = "formatIndex";
    public static final String FORMAT_INDEX_SMALL = "formatindex";
    public static final String MSGTYPE = "msgtype";
    public static final String USAGE = "usage";
    public static final String VERSION = "version";
    public static final String UNOID = "unoid";
    public static final String SPECIAL_VERSION = "specialVersion";
    public static final String REQUIRED_LDML_VERSION = "requiredLDMLVersion";

    public static final String TRANSLITERATIONS = "transliterations";
    public static final String TRANSLITERATION = "transliteration";
    public static final String FORBIDDEN_CHARACTERS = "forbiddenCharacters";
    public static final String RESERVED_WORDS = "reservedWords";
    public static final String FORBIDDEN_LINE_BEGIN_CHARACTERS = "forbiddenLineBeginCharacters";
    public static final String FORBIDDEN_LINE_END_CHARACTERS = "forbiddenLineEndCharacters";
    public static final String TRUE_WORD = "trueWord";
    public static final String FALSE_WORD = "falseWord";
    public static final String QUARTER_1_WORD = "quarter1Word";
    public static final String QUARTER_2_WORD = "quarter2Word";
    public static final String QUARTER_3_WORD = "quarter3Word";
    public static final String QUARTER_4_WORD = "quarter4Word";
    public static final String ABOVE_WORD = "aboveWord";
    public static final String BELOW_WORD = "belowWord";
    public static final String QUARTER_1_ABBREVIATION = "quarter1Abbreviation";
    public static final String QUARTER_2_ABBREVIATION = "quarter2Abbreviation";
    public static final String QUARTER_3_ABBREVIATION = "quarter3Abbreviation";
    public static final String QUARTER_4_ABBREVIATION = "quarter4Abbreviation";

    public static final String COLLATIONS = "collations";
    public static final String COLLATOR = "collator";
    public static final String COLLATION_OPTIONS = "collationOptions";
    public static final String TRANSLITERATION_MODULES = "transliterationModules";
    public static final String CURRENCY = "currency";
    public static final String SEPARATORS = "separators";
    public static final String DATE_SEPARATOR = "dateSeparator";
    public static final String THOUSAND_SEPARATOR = "thousandSeparator";
    public static final String DECIMAL_SEPARATOR = "decimalSeparator";
    public static final String TIME_SEPARATOR = "timeSeparator";
    public static final String TIME_100SEC_SEPARATOR = "time100SecSeparator";
    public static final String LONG_DATE_DAY_OF_WEEK_SEPARATOR = "longDateDayOfWeekSeparator";
    public static final String LONG_DATE_DAY_SEPARATOR = "longDateDaySeparator";
    public static final String LONG_DATE_MONTH_SEPARATOR = "longDateMonthSeparator";
    public static final String LONG_DATE_YEAR_SEPARATOR = "longDateYearSeparator";

    public static final String NUMBERING_LEVELS = "numberingLevels";
    public static final String NUMBERING_LEVEL = "numberingLevel";
    public static final String PREFIX = "prefix";
    public static final String NUM_TYPE = "numType";
    public static final String SUFFIX = "suffix";
    public static final String NAT_NUM = "natNum";

    public static final String OUTLUNE_NUMBERING_LEVELS = "outLineNumberingLevels";
    public static final String OUTLINE_STYLE = "outlineStyle";
    public static final String OUTLUNE_NUMBERING_LEVEL = "outLineNumberingLevel";
    public static final String BULLET_CHAR = "bulletChar";
    public static final String BULLET_FONT_NAME = "bulletFontName";
    public static final String PARENT_NUMBERING = "parentNumbering";
    public static final String LEFT_MARGIN = "leftMargin";
    public static final String SYMBOL_TEXT_DISTANCE = "symbolTextDistance";
    public static final String FIRST_LINE_OFFSET = "firstLineOffset";

    public static final String SEARCH = "search";
    public static final String SEARCH_OPTIONS = "searchOptions";

    public static final String REF = "ref";

    // #### below this line are new constants (post 7.10.04) ####
    public static final String INDEX = "index";
    public static final String INDEX_KEY = "indexKey";
    public static final String UNICODE_SCRIPT = "unicodeScript";
    public static final String FOLLOW_PAGE_WORD = "followPageWord";
    public static final String PHONETIC = "phonetic";
    public static final String MODULE = "module";

    public static final String DEFAULT_NAME = "defaultName";

    public static final String USED_IN_COMP_FORMAT_CODES = "usedInCompatibleFormatCodes";

    public static final String PLATFORM_ID = "platformId";

    public static final String FORMAT = "format";
    public static final String REPLACE_FROM = "ReplaceFrom";
    public static final String REPLACE_FROM_SMALL = "replaceFrom";
    public static final String REPLACE_TO = "ReplaceTo";
    public static final String REPLACE_TO_SMALL = "replaceTo";

    public static final String CURRENCY_ID = "currencyId";

    // new constants
    public static final String LOCALE = "locale";
    public static final String VERSION_DTD = "versionDTD";
    public static final String ALLOW_UPDATE_FROM_CLDR = "allowUpdateFromCLDR";

    public static final String LONG = "long";
    public static final String MEDIUM = "medium";
    public static final String SHORT = "short";

    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public static final String TYPE = "type";
    public static final String DEFAULT = "default";

    public static final String LEGACY_ONLY = "legacyOnly";
}
