package org.unicode.cldr.util;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * A Map that keeps a fixed number of key-value pairs and kicks pairs out in least-recently-used order.
 * 
 * @author jchye
 * 
 * @param <K>
 *            the key type
 * @param <V>
 *            the value type
 */
public class LruMap<K, V> extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -9176469448381227725L;
    private int cacheSize;

    public LruMap(int cacheSize) {
        super(cacheSize, 1, true);
        this.cacheSize = cacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return size() > this.cacheSize;
    }
}
