/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.util.BytesTrie;
import com.ibm.icu.util.BytesTrieBuilder;
import com.ibm.icu.util.StringTrieBuilder;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;

public class BytesTrieTest
extends TestFmwk {
    private BytesTrieBuilder builder_ = new BytesTrieBuilder();

    public static void main(String[] args) throws Exception {
        new BytesTrieTest().run(args);
    }

    public void Test00Builder() {
        this.builder_.clear();
        try {
            this.builder_.build(StringTrieBuilder.Option.FAST);
            this.errln("BytesTrieBuilder().build() did not throw IndexOutOfBoundsException");
            return;
        }
        catch (IndexOutOfBoundsException e) {
            try {
                byte[] equal = new byte[]{61};
                this.builder_.add(equal, 1, 0).add(equal, 1, 1);
                this.errln("BytesTrieBuilder.add() did not detect duplicates");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
    }

    public void Test10Empty() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("", 0)};
        this.checkData(data);
    }

    public void Test11_a() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", 1)};
        this.checkData(data);
    }

    public void Test12_a_ab() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", 1), new StringAndValue("ab", 100)};
        this.checkData(data);
    }

    public void Test20ShortestBranch() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", 1000), new StringAndValue("b", 2000)};
        this.checkData(data);
    }

    public void Test21Branches() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", 16), new StringAndValue("cc", 64), new StringAndValue("e", 256), new StringAndValue("ggg", 1024), new StringAndValue("i", 4096), new StringAndValue("kkkk", 16384), new StringAndValue("n", 65536), new StringAndValue("ppppp", 262144), new StringAndValue("r", 0x100000), new StringAndValue("sss", 0x200000), new StringAndValue("t", 0x400000), new StringAndValue("uu", 0x800000), new StringAndValue("vv", Integer.MAX_VALUE), new StringAndValue("zz", Integer.MIN_VALUE)};
        for (int length = 2; length <= data.length; ++length) {
            this.logln("TestBranches length=" + length);
            this.checkData(data, length);
        }
    }

    public void Test22LongSequence() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", -1), new StringAndValue("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", -2), new StringAndValue("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", -3)};
        this.checkData(data);
    }

    public void Test23LongBranch() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", -2), new StringAndValue("b", -1), new StringAndValue("c", 0), new StringAndValue("d2", 1), new StringAndValue("f", 63), new StringAndValue("g", 64), new StringAndValue("h", 65), new StringAndValue("j23", 6400), new StringAndValue("j24", 6655), new StringAndValue("j25", 6656), new StringAndValue("k2", 6784), new StringAndValue("k3", 6911), new StringAndValue("l234567890", 6912), new StringAndValue("l234567890123", 6913), new StringAndValue("nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn", 0x10FFFF), new StringAndValue("oooooooooooooooooooooooooooooooooooooooooooooooooooooo", 0x110000), new StringAndValue("pppppppppppppppppppppppppppppppppppppppppppppppppppppp", 0x120000), new StringAndValue("r", 0x333333), new StringAndValue("s2345", 0x4444444), new StringAndValue("t234567890", 0x77777777), new StringAndValue("z", -2147483647)};
        this.checkData(data);
    }

    public void Test24ValuesForState() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", -1), new StringAndValue("ab", -2), new StringAndValue("abc", -3), new StringAndValue("abcd", -4), new StringAndValue("abcde", -5), new StringAndValue("abcdef", -6)};
        this.checkData(data);
    }

    public void Test30Compact() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("+", 0), new StringAndValue("+august", 8), new StringAndValue("+december", 12), new StringAndValue("+july", 7), new StringAndValue("+june", 6), new StringAndValue("+november", 11), new StringAndValue("+october", 10), new StringAndValue("+september", 9), new StringAndValue("-", 0), new StringAndValue("-august", 8), new StringAndValue("-december", 12), new StringAndValue("-july", 7), new StringAndValue("-june", 6), new StringAndValue("-november", 11), new StringAndValue("-october", 10), new StringAndValue("-september", 9), new StringAndValue("xjuly", 7), new StringAndValue("xjune", 6)};
        this.checkData(data);
    }

    public BytesTrie buildMonthsTrie(StringTrieBuilder.Option buildOption) {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("august", 8), new StringAndValue("jan", 1), new StringAndValue("jan.", 1), new StringAndValue("jana", 1), new StringAndValue("janbb", 1), new StringAndValue("janc", 1), new StringAndValue("janddd", 1), new StringAndValue("janee", 1), new StringAndValue("janef", 1), new StringAndValue("janf", 1), new StringAndValue("jangg", 1), new StringAndValue("janh", 1), new StringAndValue("janiiii", 1), new StringAndValue("janj", 1), new StringAndValue("jankk", 1), new StringAndValue("jankl", 1), new StringAndValue("jankmm", 1), new StringAndValue("janl", 1), new StringAndValue("janm", 1), new StringAndValue("jannnnnnnnnnnnnnnnnnnnnnnnnnnnn", 1), new StringAndValue("jano", 1), new StringAndValue("janpp", 1), new StringAndValue("janqqq", 1), new StringAndValue("janr", 1), new StringAndValue("januar", 1), new StringAndValue("january", 1), new StringAndValue("july", 7), new StringAndValue("jun", 6), new StringAndValue("jun.", 6), new StringAndValue("june", 6)};
        return this.buildTrie(data, data.length, buildOption);
    }

    public void Test40GetUniqueValue() {
        BytesTrie trie = this.buildMonthsTrie(StringTrieBuilder.Option.FAST);
        long uniqueValue = trie.getUniqueValue();
        if (uniqueValue != 0L) {
            this.errln("unique value at root");
        }
        trie.next(106);
        trie.next(97);
        trie.next(110);
        uniqueValue = trie.getUniqueValue();
        if (uniqueValue != 3L) {
            this.errln("not unique value 1 after \"jan\": instead " + uniqueValue);
        }
        trie.first(106);
        trie.next(117);
        uniqueValue = trie.getUniqueValue();
        if (uniqueValue != 0L) {
            this.errln("unique value after \"ju\"");
        }
        if (trie.next(110) != BytesTrie.Result.INTERMEDIATE_VALUE || 6 != trie.getValue()) {
            this.errln("not normal value 6 after \"jun\"");
        }
        if ((uniqueValue = trie.getUniqueValue()) != 13L) {
            this.errln("not unique value 6 after \"jun\"");
        }
        trie.first(97);
        trie.next(117);
        uniqueValue = trie.getUniqueValue();
        if (uniqueValue != 17L) {
            this.errln("not unique value 8 after \"au\"");
        }
    }

    public void Test41GetNextBytes() {
        StringBuilder buffer;
        BytesTrie trie = this.buildMonthsTrie(StringTrieBuilder.Option.SMALL);
        int count = trie.getNextBytes((Appendable)(buffer = new StringBuilder()));
        if (count != 2 || !"aj".contentEquals(buffer)) {
            this.errln("months getNextBytes()!=[aj] at root");
        }
        trie.next(106);
        trie.next(97);
        trie.next(110);
        buffer.setLength(0);
        count = trie.getNextBytes((Appendable)buffer);
        if (count != 20 || !".abcdefghijklmnopqru".contentEquals(buffer)) {
            this.errln("months getNextBytes()!=[.abcdefghijklmnopqru] after \"jan\"");
        }
        trie.getValue();
        buffer.setLength(0);
        count = trie.getNextBytes((Appendable)buffer);
        if (count != 20 || !".abcdefghijklmnopqru".contentEquals(buffer)) {
            this.errln("months getNextBytes()!=[.abcdefghijklmnopqru] after \"jan\"+getValue()");
        }
        trie.next(117);
        buffer.setLength(0);
        count = trie.getNextBytes((Appendable)buffer);
        if (count != 1 || !"a".contentEquals(buffer)) {
            this.errln("months getNextBytes()!=[a] after \"janu\"");
        }
        trie.next(97);
        buffer.setLength(0);
        count = trie.getNextBytes((Appendable)buffer);
        if (count != 1 || !"r".contentEquals(buffer)) {
            this.errln("months getNextBytes()!=[r] after \"janua\"");
        }
        trie.next(114);
        trie.next(121);
        buffer.setLength(0);
        count = trie.getNextBytes((Appendable)buffer);
        if (count != 0 || buffer.length() != 0) {
            this.errln("months getNextBytes()!=[] after \"january\"");
        }
    }

    public void Test50IteratorFromBranch() {
        BytesTrie trie = this.buildMonthsTrie(StringTrieBuilder.Option.FAST);
        trie.next(106);
        trie.next(97);
        trie.next(110);
        BytesTrie.Iterator iter = trie.iterator();
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("", 1), new StringAndValue(".", 1), new StringAndValue("a", 1), new StringAndValue("bb", 1), new StringAndValue("c", 1), new StringAndValue("ddd", 1), new StringAndValue("ee", 1), new StringAndValue("ef", 1), new StringAndValue("f", 1), new StringAndValue("gg", 1), new StringAndValue("h", 1), new StringAndValue("iiii", 1), new StringAndValue("j", 1), new StringAndValue("kk", 1), new StringAndValue("kl", 1), new StringAndValue("kmm", 1), new StringAndValue("l", 1), new StringAndValue("m", 1), new StringAndValue("nnnnnnnnnnnnnnnnnnnnnnnnnnnn", 1), new StringAndValue("o", 1), new StringAndValue("pp", 1), new StringAndValue("qqq", 1), new StringAndValue("r", 1), new StringAndValue("uar", 1), new StringAndValue("uary", 1)};
        this.checkIterator(iter, data);
        this.logln("after iter.reset()");
        this.checkIterator(iter.reset(), data);
    }

    public void Test51IteratorFromLinearMatch() {
        BytesTrie trie = this.buildMonthsTrie(StringTrieBuilder.Option.SMALL);
        trie.next(106);
        trie.next(97);
        trie.next(110);
        trie.next(117);
        trie.next(97);
        BytesTrie.Iterator iter = trie.iterator();
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("r", 1), new StringAndValue("ry", 1)};
        this.checkIterator(iter, data);
        this.logln("after iter.reset()");
        this.checkIterator(iter.reset(), data);
    }

    public void Test52TruncatingIteratorFromRoot() {
        BytesTrie trie = this.buildMonthsTrie(StringTrieBuilder.Option.FAST);
        BytesTrie.Iterator iter = trie.iterator(4);
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("augu", -1), new StringAndValue("jan", 1), new StringAndValue("jan.", 1), new StringAndValue("jana", 1), new StringAndValue("janb", -1), new StringAndValue("janc", 1), new StringAndValue("jand", -1), new StringAndValue("jane", -1), new StringAndValue("janf", 1), new StringAndValue("jang", -1), new StringAndValue("janh", 1), new StringAndValue("jani", -1), new StringAndValue("janj", 1), new StringAndValue("jank", -1), new StringAndValue("janl", 1), new StringAndValue("janm", 1), new StringAndValue("jann", -1), new StringAndValue("jano", 1), new StringAndValue("janp", -1), new StringAndValue("janq", -1), new StringAndValue("janr", 1), new StringAndValue("janu", -1), new StringAndValue("july", 7), new StringAndValue("jun", 6), new StringAndValue("jun.", 6), new StringAndValue("june", 6)};
        this.checkIterator(iter, data);
        this.logln("after iter.reset()");
        this.checkIterator(iter.reset(), data);
    }

    public void Test53TruncatingIteratorFromLinearMatchShort() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("abcdef", 10), new StringAndValue("abcdepq", 200), new StringAndValue("abcdeyz", 3000)};
        BytesTrie trie = this.buildTrie(data, data.length, StringTrieBuilder.Option.FAST);
        trie.next(97);
        trie.next(98);
        BytesTrie.Iterator iter = trie.iterator(2);
        StringAndValue[] expected = new StringAndValue[]{new StringAndValue("cd", -1)};
        this.checkIterator(iter, expected);
        this.logln("after iter.reset()");
        this.checkIterator(iter.reset(), expected);
    }

    public void Test54TruncatingIteratorFromLinearMatchLong() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("abcdef", 10), new StringAndValue("abcdepq", 200), new StringAndValue("abcdeyz", 3000)};
        BytesTrie trie = this.buildTrie(data, data.length, StringTrieBuilder.Option.FAST);
        trie.next(97);
        trie.next(98);
        trie.next(99);
        BytesTrie.Iterator iter = trie.iterator(3);
        StringAndValue[] expected = new StringAndValue[]{new StringAndValue("def", 10), new StringAndValue("dep", -1), new StringAndValue("dey", -1)};
        this.checkIterator(iter, expected);
        this.logln("after iter.reset()");
        this.checkIterator(iter.reset(), expected);
    }

    public void Test59IteratorFromBytes() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("mm", 3), new StringAndValue("mmm", 33), new StringAndValue("mmnop", 333)};
        this.builder_.clear();
        for (StringAndValue item : data) {
            this.builder_.add(item.bytes, item.bytes.length, item.value);
        }
        ByteBuffer trieBytes = this.builder_.buildByteBuffer(StringTrieBuilder.Option.FAST);
        this.checkIterator(BytesTrie.iterator((byte[])trieBytes.array(), (int)(trieBytes.arrayOffset() + trieBytes.position()), (int)0), data);
    }

    private void checkData(StringAndValue[] data) {
        this.checkData(data, data.length);
    }

    private void checkData(StringAndValue[] data, int dataLength) {
        this.logln("checkData(dataLength=" + dataLength + ", fast)");
        this.checkData(data, dataLength, StringTrieBuilder.Option.FAST);
        this.logln("checkData(dataLength=" + dataLength + ", small)");
        this.checkData(data, dataLength, StringTrieBuilder.Option.SMALL);
    }

    private void checkData(StringAndValue[] data, int dataLength, StringTrieBuilder.Option buildOption) {
        BytesTrie trie = this.buildTrie(data, dataLength, buildOption);
        this.checkFirst(trie, data, dataLength);
        this.checkNext(trie, data, dataLength);
        this.checkNextWithState(trie, data, dataLength);
        this.checkNextString(trie, data, dataLength);
        this.checkIterator(trie, data, dataLength);
    }

    private BytesTrie buildTrie(StringAndValue[] data, int dataLength, StringTrieBuilder.Option buildOption) {
        int step;
        int index;
        if ((dataLength & 1) != 0) {
            index = dataLength / 2;
            step = 2;
        } else if (dataLength % 3 != 0) {
            index = dataLength / 5;
            step = 3;
        } else {
            index = dataLength - 1;
            step = -1;
        }
        this.builder_.clear();
        for (int i = 0; i < dataLength; ++i) {
            this.builder_.add(data[index].bytes, data[index].bytes.length, data[index].value);
            index = (index + step) % dataLength;
        }
        BytesTrie trie = this.builder_.build(buildOption);
        try {
            this.builder_.add(new byte[]{122, 122, 122}, 0, 999);
            this.errln("builder.build().add(zzz) did not throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ByteBuffer trieBytes = this.builder_.buildByteBuffer(buildOption);
        this.logln("serialized trie size: " + trieBytes.remaining() + " bytes\n");
        if ((dataLength & 1) != 0) {
            return trie;
        }
        return new BytesTrie(trieBytes.array(), trieBytes.arrayOffset() + trieBytes.position());
    }

    private void checkFirst(BytesTrie trie, StringAndValue[] data, int dataLength) {
        for (int i = 0; i < dataLength; ++i) {
            if (data[i].s.length() == 0) continue;
            byte c = data[i].bytes[0];
            BytesTrie.Result firstResult = trie.first((int)c);
            int firstValue = firstResult.hasValue() ? trie.getValue() : -1;
            int nextC = data[i].s.length() > 1 ? data[i].bytes[1] : 0;
            BytesTrie.Result nextResult = trie.next(nextC);
            if (firstResult == trie.reset().next((int)c) && firstResult == trie.current() && firstValue == (firstResult.hasValue() ? trie.getValue() : -1) && nextResult == trie.next(nextC)) continue;
            this.errln(String.format("trie.first(%c)!=trie.reset().next(same) for %s", c, data[i].s));
        }
        trie.reset();
    }

    private void checkNext(BytesTrie trie, StringAndValue[] data, int dataLength) {
        BytesTrie.State state = new BytesTrie.State();
        for (int i = 0; i < dataLength; ++i) {
            int stringLength = data[i].s.length();
            BytesTrie.Result result = trie.next(data[i].bytes, 0, stringLength);
            if (!result.hasValue() || result != trie.current()) {
                this.errln("trie does not seem to contain " + data[i].s);
            } else if (trie.getValue() != data[i].value) {
                this.errln(String.format("trie value for %s is %d=0x%x instead of expected %d=0x%x", data[i].s, trie.getValue(), trie.getValue(), data[i].value, data[i].value));
            } else if (result != trie.current() || trie.getValue() != data[i].value) {
                this.errln("trie value for " + data[i].s + " changes when repeating current()/getValue()");
            }
            trie.reset();
            result = trie.current();
            for (int j = 0; j < stringLength; ++j) {
                if (!result.hasNext()) {
                    this.errln(String.format("trie.current()!=hasNext before end of %s (at index %d)", data[i].s, j));
                    break;
                }
                if (result == BytesTrie.Result.INTERMEDIATE_VALUE) {
                    trie.getValue();
                    if (trie.current() != BytesTrie.Result.INTERMEDIATE_VALUE) {
                        this.errln(String.format("trie.getValue().current()!=BytesTrie.Result.INTERMEDIATE_VALUE before end of %s (at index %d)", data[i].s, j));
                        break;
                    }
                }
                if (!(result = trie.next((int)data[i].bytes[j])).matches()) {
                    this.errln(String.format("trie.next()=BytesTrie.Result.NO_MATCH before end of %s (at index %d)", data[i].s, j));
                    break;
                }
                if (result == trie.current()) continue;
                this.errln(String.format("trie.next()!=following current() before end of %s (at index %d)", data[i].s, j));
                break;
            }
            if (!result.hasValue()) {
                this.errln("trie.next()!=hasValue at the end of " + data[i].s);
                continue;
            }
            trie.getValue();
            if (result != trie.current()) {
                this.errln("trie.current() != current()+getValue()+current() after end of " + data[i].s);
            }
            trie.saveState(state);
            boolean nextContinues = false;
            for (int c = 32; c < 127; ++c) {
                if (!trie.resetToState(state).next(c).matches()) continue;
                nextContinues = true;
                break;
            }
            if (result == BytesTrie.Result.INTERMEDIATE_VALUE != nextContinues) {
                this.errln("(trie.current()==BytesTrie.Result.INTERMEDIATE_VALUE) contradicts (trie.next(some UChar)!=BytesTrie.Result.NO_MATCH) after end of " + data[i].s);
            }
            trie.reset();
        }
    }

    private void checkNextWithState(BytesTrie trie, StringAndValue[] data, int dataLength) {
        BytesTrie.State noState = new BytesTrie.State();
        BytesTrie.State state = new BytesTrie.State();
        for (int i = 0; i < dataLength; ++i) {
            BytesTrie.Result result;
            if ((i & 1) == 0) {
                try {
                    trie.resetToState(noState);
                    this.errln("trie.resetToState(noState) should throw an IllegalArgumentException");
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            byte[] expectedString = data[i].bytes;
            int stringLength = data[i].s.length();
            int partialLength = stringLength / 3;
            for (int j = 0; j < partialLength; ++j) {
                if (trie.next((int)expectedString[j]).matches()) continue;
                this.errln("trie.next()=BytesTrie.Result.NO_MATCH for a prefix of " + data[i].s);
                return;
            }
            trie.saveState(state);
            BytesTrie.Result resultAtState = trie.current();
            int valueAtState = -99;
            if (resultAtState.hasValue()) {
                valueAtState = trie.getValue();
            }
            if ((result = trie.next(0)) != BytesTrie.Result.NO_MATCH || result != trie.current()) {
                this.errln("trie.next(0) matched after part of " + data[i].s);
            }
            if (resultAtState != trie.resetToState(state).current() || resultAtState.hasValue() && valueAtState != trie.getValue()) {
                this.errln("trie.next(part of " + data[i].s + ") changes current()/getValue() after " + "saveState/next(0)/resetToState");
            } else {
                result = trie.next(expectedString, partialLength, stringLength);
                if (!result.hasValue() || result != trie.current()) {
                    this.errln("trie.next(rest of " + data[i].s + ") does not seem to contain " + data[i].s + " after " + "saveState/next(0)/resetToState");
                } else {
                    result = trie.resetToState(state).next(expectedString, partialLength, stringLength);
                    if (!result.hasValue() || result != trie.current()) {
                        this.errln("trie does not seem to contain " + data[i].s + " after saveState/next(rest)/resetToState");
                    } else if (trie.getValue() != data[i].value) {
                        this.errln(String.format("trie value for %s is %d=0x%x instead of expected %d=0x%x", data[i].s, trie.getValue(), trie.getValue(), data[i].value, data[i].value));
                    }
                }
            }
            trie.reset();
        }
    }

    private void checkNextString(BytesTrie trie, StringAndValue[] data, int dataLength) {
        for (int i = 0; i < dataLength; ++i) {
            byte[] expectedString = data[i].bytes;
            int stringLength = data[i].s.length();
            if (!trie.next(expectedString, 0, stringLength / 2).matches()) {
                this.errln("trie.next(up to middle of string)=BytesTrie.Result.NO_MATCH for " + data[i].s);
                continue;
            }
            trie.next(expectedString, stringLength / 2, stringLength);
            if (trie.next(0).matches()) {
                this.errln("trie.next(string+NUL)!=BytesTrie.Result.NO_MATCH for " + data[i].s);
            }
            trie.reset();
        }
    }

    private void checkIterator(BytesTrie trie, StringAndValue[] data, int dataLength) {
        this.checkIterator(trie.iterator(), data, dataLength);
    }

    private void checkIterator(BytesTrie.Iterator iter, StringAndValue[] data) {
        this.checkIterator(iter, data, data.length);
    }

    private void checkIterator(BytesTrie.Iterator iter, StringAndValue[] data, int dataLength) {
        for (int i = 0; i < dataLength; ++i) {
            if (!iter.hasNext()) {
                this.errln("trie iterator hasNext()=false for item " + i + ": " + data[i].s);
                break;
            }
            BytesTrie.Entry entry = iter.next();
            StringBuilder bytesString = new StringBuilder();
            for (int j = 0; j < entry.bytesLength(); ++j) {
                bytesString.append((char)(entry.byteAt(j) & 0xFF));
            }
            if (!data[i].s.contentEquals(bytesString)) {
                this.errln(String.format("trie iterator next().getString()=%s but expected %s for item %d", bytesString, data[i].s, i));
            }
            if (entry.value == data[i].value) continue;
            this.errln(String.format("trie iterator next().getValue()=%d=0x%x but expected %d=0x%x for item %d: %s", entry.value, entry.value, data[i].value, data[i].value, i, data[i].s));
        }
        if (iter.hasNext()) {
            this.errln("trie iterator hasNext()=true after all items");
        }
        try {
            iter.next();
            this.errln("trie iterator next() did not throw NoSuchElementException after all items");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    private static final class StringAndValue {
        public String s;
        public byte[] bytes;
        public int value;

        public StringAndValue(String str, int val) {
            this.s = str;
            this.bytes = new byte[this.s.length()];
            for (int i = 0; i < this.bytes.length; ++i) {
                this.bytes[i] = (byte)this.s.charAt(i);
            }
            this.value = val;
        }
    }
}

