/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CaseIterator {
    private static Transliterator toName = Transliterator.getInstance((String)"[:^ascii:] Any-Name");
    private static Transliterator toHex = Transliterator.getInstance((String)"[:^ascii:] Any-Hex");
    private static Transliterator toHex2 = Transliterator.getInstance((String)"[[^!-\u007f]-[,]] Any-Hex");
    private static Map fromCaseFold = new HashMap();
    private static Map toCaseFold = new HashMap();
    private static int maxLength = 0;
    private static final boolean GENERATE = false;
    private static final boolean DUMP = false;
    private static String[][] exceptionList = new String[][]{{"a\u02be", "A\u02be", "a\u02be"}, {"ff", "FF", "Ff", "fF", "ff"}, {"ffi", "FFI", "FFi", "FfI", "Ffi", "F\ufb01", "fFI", "fFi", "ffI", "ffi", "f\ufb01", "\ufb00I", "\ufb00i"}, {"ffl", "FFL", "FFl", "FfL", "Ffl", "F\ufb02", "fFL", "fFl", "ffL", "ffl", "f\ufb02", "\ufb00L", "\ufb00l"}, {"fi", "FI", "Fi", "fI", "fi"}, {"fl", "FL", "Fl", "fL", "fl"}, {"h\u0331", "H\u0331", "h\u0331"}, {"i\u0307", "I\u0307", "i\u0307"}, {"j\u030c", "J\u030c", "j\u030c"}, {"ss", "SS", "Ss", "S\u017f", "sS", "ss", "s\u017f", "\u017fS", "\u017fs", "\u017f\u017f"}, {"st", "ST", "St", "sT", "st", "\u017fT", "\u017ft"}, {"t\u0308", "T\u0308", "t\u0308"}, {"w\u030a", "W\u030a", "w\u030a"}, {"y\u030a", "Y\u030a", "y\u030a"}, {"\u02bcn", "\u02bcN", "\u02bcn"}, {"\u03ac\u03b9", "\u0386\u0345", "\u0386\u0399", "\u0386\u03b9", "\u0386\u1fbe", "\u03ac\u0345", "\u03ac\u0399", "\u03ac\u03b9", "\u03ac\u1fbe"}, {"\u03ae\u03b9", "\u0389\u0345", "\u0389\u0399", "\u0389\u03b9", "\u0389\u1fbe", "\u03ae\u0345", "\u03ae\u0399", "\u03ae\u03b9", "\u03ae\u1fbe"}, {"\u03b1\u0342", "\u0391\u0342", "\u03b1\u0342"}, {"\u03b1\u0342\u03b9", "\u0391\u0342\u0345", "\u0391\u0342\u0399", "\u0391\u0342\u03b9", "\u0391\u0342\u1fbe", "\u03b1\u0342\u0345", "\u03b1\u0342\u0399", "\u03b1\u0342\u03b9", "\u03b1\u0342\u1fbe", "\u1fb6\u0345", "\u1fb6\u0399", "\u1fb6\u03b9", "\u1fb6\u1fbe"}, {"\u03b1\u03b9", "\u0391\u0345", "\u0391\u0399", "\u0391\u03b9", "\u0391\u1fbe", "\u03b1\u0345", "\u03b1\u0399", "\u03b1\u03b9", "\u03b1\u1fbe"}, {"\u03b7\u0342", "\u0397\u0342", "\u03b7\u0342"}, {"\u03b7\u0342\u03b9", "\u0397\u0342\u0345", "\u0397\u0342\u0399", "\u0397\u0342\u03b9", "\u0397\u0342\u1fbe", "\u03b7\u0342\u0345", "\u03b7\u0342\u0399", "\u03b7\u0342\u03b9", "\u03b7\u0342\u1fbe", "\u1fc6\u0345", "\u1fc6\u0399", "\u1fc6\u03b9", "\u1fc6\u1fbe"}, {"\u03b7\u03b9", "\u0397\u0345", "\u0397\u0399", "\u0397\u03b9", "\u0397\u1fbe", "\u03b7\u0345", "\u03b7\u0399", "\u03b7\u03b9", "\u03b7\u1fbe"}, {"\u03b9\u0308\u0300", "\u0345\u0308\u0300", "\u0399\u0308\u0300", "\u03b9\u0308\u0300", "\u1fbe\u0308\u0300"}, {"\u03b9\u0308\u0301", "\u0345\u0308\u0301", "\u0399\u0308\u0301", "\u03b9\u0308\u0301", "\u1fbe\u0308\u0301"}, {"\u03b9\u0308\u0342", "\u0345\u0308\u0342", "\u0399\u0308\u0342", "\u03b9\u0308\u0342", "\u1fbe\u0308\u0342"}, {"\u03b9\u0342", "\u0345\u0342", "\u0399\u0342", "\u03b9\u0342", "\u1fbe\u0342"}, {"\u03c1\u0313", "\u03a1\u0313", "\u03c1\u0313", "\u03f1\u0313"}, {"\u03c5\u0308\u0300", "\u03a5\u0308\u0300", "\u03c5\u0308\u0300"}, {"\u03c5\u0308\u0301", "\u03a5\u0308\u0301", "\u03c5\u0308\u0301"}, {"\u03c5\u0308\u0342", "\u03a5\u0308\u0342", "\u03c5\u0308\u0342"}, {"\u03c5\u0313", "\u03a5\u0313", "\u03c5\u0313"}, {"\u03c5\u0313\u0300", "\u03a5\u0313\u0300", "\u03c5\u0313\u0300", "\u1f50\u0300"}, {"\u03c5\u0313\u0301", "\u03a5\u0313\u0301", "\u03c5\u0313\u0301", "\u1f50\u0301"}, {"\u03c5\u0313\u0342", "\u03a5\u0313\u0342", "\u03c5\u0313\u0342", "\u1f50\u0342"}, {"\u03c5\u0342", "\u03a5\u0342", "\u03c5\u0342"}, {"\u03c9\u0342", "\u03a9\u0342", "\u03c9\u0342", "\u2126\u0342"}, {"\u03c9\u0342\u03b9", "\u03a9\u0342\u0345", "\u03a9\u0342\u0399", "\u03a9\u0342\u03b9", "\u03a9\u0342\u1fbe", "\u03c9\u0342\u0345", "\u03c9\u0342\u0399", "\u03c9\u0342\u03b9", "\u03c9\u0342\u1fbe", "\u1ff6\u0345", "\u1ff6\u0399", "\u1ff6\u03b9", "\u1ff6\u1fbe", "\u2126\u0342\u0345", "\u2126\u0342\u0399", "\u2126\u0342\u03b9", "\u2126\u0342\u1fbe"}, {"\u03c9\u03b9", "\u03a9\u0345", "\u03a9\u0399", "\u03a9\u03b9", "\u03a9\u1fbe", "\u03c9\u0345", "\u03c9\u0399", "\u03c9\u03b9", "\u03c9\u1fbe", "\u2126\u0345", "\u2126\u0399", "\u2126\u03b9", "\u2126\u1fbe"}, {"\u03ce\u03b9", "\u038f\u0345", "\u038f\u0399", "\u038f\u03b9", "\u038f\u1fbe", "\u03ce\u0345", "\u03ce\u0399", "\u03ce\u03b9", "\u03ce\u1fbe"}, {"\u0565\u0582", "\u0535\u0552", "\u0535\u0582", "\u0565\u0552", "\u0565\u0582"}, {"\u0574\u0565", "\u0544\u0535", "\u0544\u0565", "\u0574\u0535", "\u0574\u0565"}, {"\u0574\u056b", "\u0544\u053b", "\u0544\u056b", "\u0574\u053b", "\u0574\u056b"}, {"\u0574\u056d", "\u0544\u053d", "\u0544\u056d", "\u0574\u053d", "\u0574\u056d"}, {"\u0574\u0576", "\u0544\u0546", "\u0544\u0576", "\u0574\u0546", "\u0574\u0576"}, {"\u057e\u0576", "\u054e\u0546", "\u054e\u0576", "\u057e\u0546", "\u057e\u0576"}, {"\u1f00\u03b9", "\u1f00\u0345", "\u1f00\u0399", "\u1f00\u03b9", "\u1f00\u1fbe", "\u1f08\u0345", "\u1f08\u0399", "\u1f08\u03b9", "\u1f08\u1fbe"}, {"\u1f01\u03b9", "\u1f01\u0345", "\u1f01\u0399", "\u1f01\u03b9", "\u1f01\u1fbe", "\u1f09\u0345", "\u1f09\u0399", "\u1f09\u03b9", "\u1f09\u1fbe"}, {"\u1f02\u03b9", "\u1f02\u0345", "\u1f02\u0399", "\u1f02\u03b9", "\u1f02\u1fbe", "\u1f0a\u0345", "\u1f0a\u0399", "\u1f0a\u03b9", "\u1f0a\u1fbe"}, {"\u1f03\u03b9", "\u1f03\u0345", "\u1f03\u0399", "\u1f03\u03b9", "\u1f03\u1fbe", "\u1f0b\u0345", "\u1f0b\u0399", "\u1f0b\u03b9", "\u1f0b\u1fbe"}, {"\u1f04\u03b9", "\u1f04\u0345", "\u1f04\u0399", "\u1f04\u03b9", "\u1f04\u1fbe", "\u1f0c\u0345", "\u1f0c\u0399", "\u1f0c\u03b9", "\u1f0c\u1fbe"}, {"\u1f05\u03b9", "\u1f05\u0345", "\u1f05\u0399", "\u1f05\u03b9", "\u1f05\u1fbe", "\u1f0d\u0345", "\u1f0d\u0399", "\u1f0d\u03b9", "\u1f0d\u1fbe"}, {"\u1f06\u03b9", "\u1f06\u0345", "\u1f06\u0399", "\u1f06\u03b9", "\u1f06\u1fbe", "\u1f0e\u0345", "\u1f0e\u0399", "\u1f0e\u03b9", "\u1f0e\u1fbe"}, {"\u1f07\u03b9", "\u1f07\u0345", "\u1f07\u0399", "\u1f07\u03b9", "\u1f07\u1fbe", "\u1f0f\u0345", "\u1f0f\u0399", "\u1f0f\u03b9", "\u1f0f\u1fbe"}, {"\u1f20\u03b9", "\u1f20\u0345", "\u1f20\u0399", "\u1f20\u03b9", "\u1f20\u1fbe", "\u1f28\u0345", "\u1f28\u0399", "\u1f28\u03b9", "\u1f28\u1fbe"}, {"\u1f21\u03b9", "\u1f21\u0345", "\u1f21\u0399", "\u1f21\u03b9", "\u1f21\u1fbe", "\u1f29\u0345", "\u1f29\u0399", "\u1f29\u03b9", "\u1f29\u1fbe"}, {"\u1f22\u03b9", "\u1f22\u0345", "\u1f22\u0399", "\u1f22\u03b9", "\u1f22\u1fbe", "\u1f2a\u0345", "\u1f2a\u0399", "\u1f2a\u03b9", "\u1f2a\u1fbe"}, {"\u1f23\u03b9", "\u1f23\u0345", "\u1f23\u0399", "\u1f23\u03b9", "\u1f23\u1fbe", "\u1f2b\u0345", "\u1f2b\u0399", "\u1f2b\u03b9", "\u1f2b\u1fbe"}, {"\u1f24\u03b9", "\u1f24\u0345", "\u1f24\u0399", "\u1f24\u03b9", "\u1f24\u1fbe", "\u1f2c\u0345", "\u1f2c\u0399", "\u1f2c\u03b9", "\u1f2c\u1fbe"}, {"\u1f25\u03b9", "\u1f25\u0345", "\u1f25\u0399", "\u1f25\u03b9", "\u1f25\u1fbe", "\u1f2d\u0345", "\u1f2d\u0399", "\u1f2d\u03b9", "\u1f2d\u1fbe"}, {"\u1f26\u03b9", "\u1f26\u0345", "\u1f26\u0399", "\u1f26\u03b9", "\u1f26\u1fbe", "\u1f2e\u0345", "\u1f2e\u0399", "\u1f2e\u03b9", "\u1f2e\u1fbe"}, {"\u1f27\u03b9", "\u1f27\u0345", "\u1f27\u0399", "\u1f27\u03b9", "\u1f27\u1fbe", "\u1f2f\u0345", "\u1f2f\u0399", "\u1f2f\u03b9", "\u1f2f\u1fbe"}, {"\u1f60\u03b9", "\u1f60\u0345", "\u1f60\u0399", "\u1f60\u03b9", "\u1f60\u1fbe", "\u1f68\u0345", "\u1f68\u0399", "\u1f68\u03b9", "\u1f68\u1fbe"}, {"\u1f61\u03b9", "\u1f61\u0345", "\u1f61\u0399", "\u1f61\u03b9", "\u1f61\u1fbe", "\u1f69\u0345", "\u1f69\u0399", "\u1f69\u03b9", "\u1f69\u1fbe"}, {"\u1f62\u03b9", "\u1f62\u0345", "\u1f62\u0399", "\u1f62\u03b9", "\u1f62\u1fbe", "\u1f6a\u0345", "\u1f6a\u0399", "\u1f6a\u03b9", "\u1f6a\u1fbe"}, {"\u1f63\u03b9", "\u1f63\u0345", "\u1f63\u0399", "\u1f63\u03b9", "\u1f63\u1fbe", "\u1f6b\u0345", "\u1f6b\u0399", "\u1f6b\u03b9", "\u1f6b\u1fbe"}, {"\u1f64\u03b9", "\u1f64\u0345", "\u1f64\u0399", "\u1f64\u03b9", "\u1f64\u1fbe", "\u1f6c\u0345", "\u1f6c\u0399", "\u1f6c\u03b9", "\u1f6c\u1fbe"}, {"\u1f65\u03b9", "\u1f65\u0345", "\u1f65\u0399", "\u1f65\u03b9", "\u1f65\u1fbe", "\u1f6d\u0345", "\u1f6d\u0399", "\u1f6d\u03b9", "\u1f6d\u1fbe"}, {"\u1f66\u03b9", "\u1f66\u0345", "\u1f66\u0399", "\u1f66\u03b9", "\u1f66\u1fbe", "\u1f6e\u0345", "\u1f6e\u0399", "\u1f6e\u03b9", "\u1f6e\u1fbe"}, {"\u1f67\u03b9", "\u1f67\u0345", "\u1f67\u0399", "\u1f67\u03b9", "\u1f67\u1fbe", "\u1f6f\u0345", "\u1f6f\u0399", "\u1f6f\u03b9", "\u1f6f\u1fbe"}, {"\u1f70\u03b9", "\u1f70\u0345", "\u1f70\u0399", "\u1f70\u03b9", "\u1f70\u1fbe", "\u1fba\u0345", "\u1fba\u0399", "\u1fba\u03b9", "\u1fba\u1fbe"}, {"\u1f74\u03b9", "\u1f74\u0345", "\u1f74\u0399", "\u1f74\u03b9", "\u1f74\u1fbe", "\u1fca\u0345", "\u1fca\u0399", "\u1fca\u03b9", "\u1fca\u1fbe"}, {"\u1f7c\u03b9", "\u1f7c\u0345", "\u1f7c\u0399", "\u1f7c\u03b9", "\u1f7c\u1fbe", "\u1ffa\u0345", "\u1ffa\u0399", "\u1ffa\u03b9", "\u1ffa\u1fbe"}};
    private int count = 0;
    private String[][] variants;
    private boolean done = false;
    private int[] counts;
    private StringBuffer nextBuffer = new StringBuffer();

    public void reset(String source) {
        this.counts = new int[source.length()];
        this.variants = new String[source.length()][];
        String piece = null;
        this.count = 0;
        for (int i = 0; i < source.length(); i += piece.length()) {
            String caseFold = null;
            int max = i + maxLength;
            if (max > source.length()) {
                max = source.length();
            }
            for (int j = max; j > i && (caseFold = (String)toCaseFold.get(piece = source.substring(i, j))) == null; --j) {
            }
            if (caseFold == null) {
                piece = UTF16.valueOf((String)source, (int)i);
                this.variants[this.count++] = new String[]{piece};
                continue;
            }
            this.variants[this.count++] = (String[])fromCaseFold.get(caseFold);
        }
        this.reset();
    }

    public void reset() {
        this.done = false;
        for (int i = 0; i < this.count; ++i) {
            this.counts[i] = 0;
        }
    }

    public String next() {
        int i;
        if (this.done) {
            return null;
        }
        this.nextBuffer.setLength(0);
        for (i = 0; i < this.count; ++i) {
            this.nextBuffer.append(this.variants[i][this.counts[i]]);
        }
        for (i = this.count - 1; i >= 0; --i) {
            int n = i;
            this.counts[n] = this.counts[n] + 1;
            if (this.counts[i] < this.variants[i].length) break;
            this.counts[i] = 0;
        }
        if (i < 0) {
            this.done = true;
        }
        return this.nextBuffer.toString();
    }

    public static void main(String[] args) {
        String[] testCases = new String[]{"fiss", "h\u03a3"};
        CaseIterator ci = new CaseIterator();
        for (int i = 0; i < testCases.length; ++i) {
            String item = testCases[i];
            System.out.println();
            System.out.println("Testing: " + toName.transliterate(item));
            System.out.println();
            ci.reset(item);
            int count = 0;
            String temp = ci.next();
            while (temp != null) {
                System.out.println(toName.transliterate(temp));
                ++count;
                temp = ci.next();
            }
            System.out.println("Total: " + count);
        }
        UnicodeSet caseless = new UnicodeSet();
        for (int i = 0; i <= 0x10FFFF; ++i) {
            String cp = UTF16.valueOf((int)i);
            ci.reset(cp);
            int count = 0;
            String fold = null;
            String temp = ci.next();
            while (temp != null) {
                fold = temp;
                if (++count > 1) break;
                temp = ci.next();
            }
            if (count != 1 || !fold.equals(cp)) continue;
            caseless.add(i);
        }
        System.out.println("caseless = " + caseless.toPattern(true));
        UnicodeSet not_lc = new UnicodeSet("[:^lc:]");
        UnicodeSet a = new UnicodeSet();
        a.set(not_lc);
        a.removeAll(caseless);
        System.out.println("[:^lc:] - caseless = " + a.toPattern(true));
        a.set(caseless);
        a.removeAll(not_lc);
        System.out.println("caseless - [:^lc:] = " + a.toPattern(true));
    }

    static {
        for (int i = 0; i < exceptionList.length; ++i) {
            String[] exception = exceptionList[i];
            HashSet<String> s = new HashSet<String>();
            for (int j = 0; j < exception.length; ++j) {
                s.add(exception[j]);
            }
            fromCaseFold.put(exception[0], s);
        }
        boolean defaultmapping = true;
        for (int i = 0; i <= 0x10FFFF; ++i) {
            HashSet<String> s;
            String cp;
            String mapped;
            int cat = UCharacter.getType((int)i);
            if (cat == 0 || cat == 18 || (mapped = UCharacter.foldCase((String)(cp = UTF16.valueOf((int)i)), (boolean)defaultmapping)).equals(cp)) continue;
            if (maxLength < mapped.length()) {
                maxLength = mapped.length();
            }
            if ((s = (HashSet<String>)fromCaseFold.get(mapped)) == null) {
                s = new HashSet<String>();
                s.add(mapped);
                fromCaseFold.put(mapped, s);
            }
            s.add(cp);
            toCaseFold.put(cp, mapped);
            toCaseFold.put(mapped, mapped);
        }
        HashMap fromCaseFold2 = new HashMap();
        for (Object key : fromCaseFold.keySet()) {
            Set s = (Set)fromCaseFold.get(key);
            String[] temp = new String[s.size()];
            s.toArray(temp);
            fromCaseFold2.put(key, temp);
        }
        fromCaseFold = fromCaseFold2;
    }
}

