/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.BytesTrie;
import com.ibm.icu.util.CharsTrie;
import com.ibm.icu.util.CharsTrieBuilder;
import com.ibm.icu.util.StringTrieBuilder;
import java.util.NoSuchElementException;

public class CharsTrieTest
extends TestFmwk {
    private CharsTrieBuilder builder_ = new CharsTrieBuilder();

    public static void main(String[] args) throws Exception {
        new CharsTrieTest().run(args);
    }

    public void Test00Builder() {
        this.builder_.clear();
        try {
            this.builder_.build(StringTrieBuilder.Option.FAST);
            this.errln("CharsTrieBuilder().build() did not throw IndexOutOfBoundsException");
            return;
        }
        catch (IndexOutOfBoundsException e) {
            try {
                this.builder_.add((CharSequence)"=", 0).add((CharSequence)"=", 1);
                this.errln("CharsTrieBuilder.add() did not detect duplicates");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
    }

    public void Test10Empty() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("", 0)};
        this.checkData(data);
    }

    public void Test11_a() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", 1)};
        this.checkData(data);
    }

    public void Test12_a_ab() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", 1), new StringAndValue("ab", 100)};
        this.checkData(data);
    }

    public void Test20ShortestBranch() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", 1000), new StringAndValue("b", 2000)};
        this.checkData(data);
    }

    public void Test21Branches() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", 16), new StringAndValue("cc", 64), new StringAndValue("e", 256), new StringAndValue("ggg", 1024), new StringAndValue("i", 4096), new StringAndValue("kkkk", 16384), new StringAndValue("n", 65536), new StringAndValue("ppppp", 262144), new StringAndValue("r", 0x100000), new StringAndValue("sss", 0x200000), new StringAndValue("t", 0x400000), new StringAndValue("uu", 0x800000), new StringAndValue("vv", Integer.MAX_VALUE), new StringAndValue("zz", Integer.MIN_VALUE)};
        for (int length = 2; length <= data.length; ++length) {
            this.logln("TestBranches length=" + length);
            this.checkData(data, length);
        }
    }

    public void Test22LongSequence() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", -1), new StringAndValue("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", -2), new StringAndValue("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", -3)};
        this.checkData(data);
    }

    public void Test23LongBranch() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", -2), new StringAndValue("b", -1), new StringAndValue("c", 0), new StringAndValue("d2", 1), new StringAndValue("f", 63), new StringAndValue("g", 64), new StringAndValue("h", 65), new StringAndValue("j23", 6400), new StringAndValue("j24", 6655), new StringAndValue("j25", 6656), new StringAndValue("k2", 6784), new StringAndValue("k3", 6911), new StringAndValue("l234567890", 6912), new StringAndValue("l234567890123", 6913), new StringAndValue("nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn", 0x10FFFF), new StringAndValue("oooooooooooooooooooooooooooooooooooooooooooooooooooooo", 0x110000), new StringAndValue("pppppppppppppppppppppppppppppppppppppppppppppppppppppp", 0x120000), new StringAndValue("r", 0x333333), new StringAndValue("s2345", 0x4444444), new StringAndValue("t234567890", 0x77777777), new StringAndValue("z", -2147483647)};
        this.checkData(data);
    }

    public void Test24ValuesForState() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", -1), new StringAndValue("ab", -2), new StringAndValue("abc", -3), new StringAndValue("abcd", -4), new StringAndValue("abcde", -5), new StringAndValue("abcdef", -6)};
        this.checkData(data);
    }

    public void Test30Compact() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("+", 0), new StringAndValue("+august", 8), new StringAndValue("+december", 12), new StringAndValue("+july", 7), new StringAndValue("+june", 6), new StringAndValue("+november", 11), new StringAndValue("+october", 10), new StringAndValue("+september", 9), new StringAndValue("-", 0), new StringAndValue("-august", 8), new StringAndValue("-december", 12), new StringAndValue("-july", 7), new StringAndValue("-june", 6), new StringAndValue("-november", 11), new StringAndValue("-october", 10), new StringAndValue("-september", 9), new StringAndValue("xjuly", 7), new StringAndValue("xjune", 6)};
        this.checkData(data);
    }

    public void Test31FirstForCodePoint() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("a", 1), new StringAndValue("a\ud800", 2), new StringAndValue("a\ud800\udc00", 3), new StringAndValue("\ud840", 4), new StringAndValue("\ud840\udc00\udbff", 5), new StringAndValue("\ud840\udc00\udbff\udfff", 6), new StringAndValue("\ud840\udc00\udbff\udfffz", 7), new StringAndValue("\ud900\udc00xy", 8), new StringAndValue("\ud900\udc00xyz", 9)};
        this.checkData(data);
    }

    public void Test32NextForCodePoint() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("\u4dff\ud800\udc00\u9999\ud840\udc00\udfff\udbff\udfff", 2000000000), new StringAndValue("\u4dff\ud800\udc00\u9999\ud840\udc02", 44444), new StringAndValue("\u4dff\ud800\udfff", 99999)};
        CharsTrie trie = this.buildTrie(data, data.length, StringTrieBuilder.Option.FAST);
        BytesTrie.Result result = trie.nextForCodePoint(19967);
        if (result != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(65536)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(39321)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(131072)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(57343)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(0x10FFFF)) != BytesTrie.Result.FINAL_VALUE || result != trie.current() || trie.getValue() != 2000000000) {
            this.errln("CharsTrie.nextForCodePoint() fails for " + data[0].s);
        }
        if ((result = trie.firstForCodePoint(19967)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(65536)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(39321)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(131074)) != BytesTrie.Result.FINAL_VALUE || result != trie.current() || trie.getValue() != 44444) {
            this.errln("CharsTrie.nextForCodePoint() fails for " + data[1].s);
        }
        if ((result = trie.reset().nextForCodePoint(19967)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(65536)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(39321)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(131618)) != BytesTrie.Result.NO_MATCH || result != trie.current()) {
            this.errln("CharsTrie.nextForCodePoint() fails for \u4dff\\U00010000\u9999\\U00020222");
        }
        if ((result = trie.reset().nextForCodePoint(19967)) != BytesTrie.Result.NO_VALUE || result != trie.current() || (result = trie.nextForCodePoint(66559)) != BytesTrie.Result.FINAL_VALUE || result != trie.current() || trie.getValue() != 99999) {
            this.errln("CharsTrie.nextForCodePoint() fails for " + data[2].s);
        }
    }

    private CharsTrie buildLargeTrie(int numUniqueFirst) {
        Generator gen = new Generator();
        this.builder_.clear();
        while (gen.countUniqueFirstChars() < numUniqueFirst) {
            this.builder_.add(gen.getString(), gen.getValue());
            gen.next();
        }
        this.logln("buildLargeTrie(" + numUniqueFirst + ") added " + gen.getIndex() + " strings");
        CharSequence trieChars = this.builder_.buildCharSequence(StringTrieBuilder.Option.FAST);
        this.logln("serialized trie size: " + trieChars.length() + " chars\n");
        return new CharsTrie(trieChars, 0);
    }

    public void Test37LargeTrie() {
        CharsTrie trie = this.buildLargeTrie(1111);
        Generator gen = new Generator();
        while (gen.countUniqueFirstChars() < 1111) {
            int index;
            CharSequence x = gen.getString();
            int value = gen.getValue();
            if (x.length() == 0) {
                index = 0;
            } else {
                if (trie.first((int)x.charAt(0)) == BytesTrie.Result.NO_MATCH) {
                    this.errln(String.format("first(first char U+%04X)=BytesTrie.Result.NO_MATCH for string %d\n", Character.valueOf(x.charAt(0)), gen.getIndex()));
                    break;
                }
                index = 1;
            }
            BytesTrie.Result result = trie.next(x, index, x.length());
            if (!result.hasValue() || result != trie.current() || value != trie.getValue()) {
                this.errln(String.format("next(" + CharsTrieTest.prettify(x) + ")!=hasValue or " + "next()!=current() or getValue() wrong " + "for string " + gen.getIndex(), new Object[0]));
                break;
            }
            gen.next();
        }
    }

    private CharsTrie buildMonthsTrie(StringTrieBuilder.Option buildOption) {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("august", 8), new StringAndValue("jan", 1), new StringAndValue("jan.", 1), new StringAndValue("jana", 1), new StringAndValue("janbb", 1), new StringAndValue("janc", 1), new StringAndValue("janddd", 1), new StringAndValue("janee", 1), new StringAndValue("janef", 1), new StringAndValue("janf", 1), new StringAndValue("jangg", 1), new StringAndValue("janh", 1), new StringAndValue("janiiii", 1), new StringAndValue("janj", 1), new StringAndValue("jankk", 1), new StringAndValue("jankl", 1), new StringAndValue("jankmm", 1), new StringAndValue("janl", 1), new StringAndValue("janm", 1), new StringAndValue("jannnnnnnnnnnnnnnnnnnnnnnnnnnnn", 1), new StringAndValue("jano", 1), new StringAndValue("janpp", 1), new StringAndValue("janqqq", 1), new StringAndValue("janr", 1), new StringAndValue("januar", 1), new StringAndValue("january", 1), new StringAndValue("july", 7), new StringAndValue("jun", 6), new StringAndValue("jun.", 6), new StringAndValue("june", 6)};
        return this.buildTrie(data, data.length, buildOption);
    }

    public void Test40GetUniqueValue() {
        CharsTrie trie = this.buildMonthsTrie(StringTrieBuilder.Option.FAST);
        long uniqueValue = trie.getUniqueValue();
        if (uniqueValue != 0L) {
            this.errln("unique value at root");
        }
        trie.next(106);
        trie.next(97);
        trie.next(110);
        uniqueValue = trie.getUniqueValue();
        if (uniqueValue != 3L) {
            this.errln("not unique value 1 after \"jan\": instead " + uniqueValue);
        }
        trie.first(106);
        trie.next(117);
        uniqueValue = trie.getUniqueValue();
        if (uniqueValue != 0L) {
            this.errln("unique value after \"ju\"");
        }
        if (trie.next(110) != BytesTrie.Result.INTERMEDIATE_VALUE || 6 != trie.getValue()) {
            this.errln("not normal value 6 after \"jun\"");
        }
        if ((uniqueValue = trie.getUniqueValue()) != 13L) {
            this.errln("not unique value 6 after \"jun\"");
        }
        trie.first(97);
        trie.next(117);
        uniqueValue = trie.getUniqueValue();
        if (uniqueValue != 17L) {
            this.errln("not unique value 8 after \"au\"");
        }
    }

    public void Test41GetNextChars() {
        StringBuilder buffer;
        CharsTrie trie = this.buildMonthsTrie(StringTrieBuilder.Option.SMALL);
        int count = trie.getNextChars((Appendable)(buffer = new StringBuilder()));
        if (count != 2 || !"aj".contentEquals(buffer)) {
            this.errln("months getNextChars()!=[aj] at root");
        }
        trie.next(106);
        trie.next(97);
        trie.next(110);
        buffer.setLength(0);
        count = trie.getNextChars((Appendable)buffer);
        if (count != 20 || !".abcdefghijklmnopqru".contentEquals(buffer)) {
            this.errln("months getNextChars()!=[.abcdefghijklmnopqru] after \"jan\"");
        }
        trie.getValue();
        buffer.setLength(0);
        count = trie.getNextChars((Appendable)buffer);
        if (count != 20 || !".abcdefghijklmnopqru".contentEquals(buffer)) {
            this.errln("months getNextChars()!=[.abcdefghijklmnopqru] after \"jan\"+getValue()");
        }
        trie.next(117);
        buffer.setLength(0);
        count = trie.getNextChars((Appendable)buffer);
        if (count != 1 || !"a".contentEquals(buffer)) {
            this.errln("months getNextChars()!=[a] after \"janu\"");
        }
        trie.next(97);
        buffer.setLength(0);
        count = trie.getNextChars((Appendable)buffer);
        if (count != 1 || !"r".contentEquals(buffer)) {
            this.errln("months getNextChars()!=[r] after \"janua\"");
        }
        trie.next(114);
        trie.next(121);
        buffer.setLength(0);
        count = trie.getNextChars((Appendable)buffer);
        if (count != 0 || buffer.length() != 0) {
            this.errln("months getNextChars()!=[] after \"january\"");
        }
    }

    public void Test50IteratorFromBranch() {
        CharsTrie trie = this.buildMonthsTrie(StringTrieBuilder.Option.FAST);
        trie.next(106);
        trie.next(97);
        trie.next(110);
        CharsTrie.Iterator iter = trie.iterator();
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("", 1), new StringAndValue(".", 1), new StringAndValue("a", 1), new StringAndValue("bb", 1), new StringAndValue("c", 1), new StringAndValue("ddd", 1), new StringAndValue("ee", 1), new StringAndValue("ef", 1), new StringAndValue("f", 1), new StringAndValue("gg", 1), new StringAndValue("h", 1), new StringAndValue("iiii", 1), new StringAndValue("j", 1), new StringAndValue("kk", 1), new StringAndValue("kl", 1), new StringAndValue("kmm", 1), new StringAndValue("l", 1), new StringAndValue("m", 1), new StringAndValue("nnnnnnnnnnnnnnnnnnnnnnnnnnnn", 1), new StringAndValue("o", 1), new StringAndValue("pp", 1), new StringAndValue("qqq", 1), new StringAndValue("r", 1), new StringAndValue("uar", 1), new StringAndValue("uary", 1)};
        this.checkIterator(iter, data);
        this.logln("after iter.reset()");
        this.checkIterator(iter.reset(), data);
    }

    public void Test51IteratorFromLinearMatch() {
        CharsTrie trie = this.buildMonthsTrie(StringTrieBuilder.Option.SMALL);
        trie.next(106);
        trie.next(97);
        trie.next(110);
        trie.next(117);
        trie.next(97);
        CharsTrie.Iterator iter = trie.iterator();
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("r", 1), new StringAndValue("ry", 1)};
        this.checkIterator(iter, data);
        this.logln("after iter.reset()");
        this.checkIterator(iter.reset(), data);
    }

    public void Test52TruncatingIteratorFromRoot() {
        CharsTrie trie = this.buildMonthsTrie(StringTrieBuilder.Option.FAST);
        CharsTrie.Iterator iter = trie.iterator(4);
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("augu", -1), new StringAndValue("jan", 1), new StringAndValue("jan.", 1), new StringAndValue("jana", 1), new StringAndValue("janb", -1), new StringAndValue("janc", 1), new StringAndValue("jand", -1), new StringAndValue("jane", -1), new StringAndValue("janf", 1), new StringAndValue("jang", -1), new StringAndValue("janh", 1), new StringAndValue("jani", -1), new StringAndValue("janj", 1), new StringAndValue("jank", -1), new StringAndValue("janl", 1), new StringAndValue("janm", 1), new StringAndValue("jann", -1), new StringAndValue("jano", 1), new StringAndValue("janp", -1), new StringAndValue("janq", -1), new StringAndValue("janr", 1), new StringAndValue("janu", -1), new StringAndValue("july", 7), new StringAndValue("jun", 6), new StringAndValue("jun.", 6), new StringAndValue("june", 6)};
        this.checkIterator(iter, data);
        this.logln("after iter.reset()");
        this.checkIterator(iter.reset(), data);
    }

    public void Test53TruncatingIteratorFromLinearMatchShort() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("abcdef", 10), new StringAndValue("abcdepq", 200), new StringAndValue("abcdeyz", 3000)};
        CharsTrie trie = this.buildTrie(data, data.length, StringTrieBuilder.Option.FAST);
        trie.next(97);
        trie.next(98);
        CharsTrie.Iterator iter = trie.iterator(2);
        StringAndValue[] expected = new StringAndValue[]{new StringAndValue("cd", -1)};
        this.checkIterator(iter, expected);
        this.logln("after iter.reset()");
        this.checkIterator(iter.reset(), expected);
    }

    public void Test54TruncatingIteratorFromLinearMatchLong() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("abcdef", 10), new StringAndValue("abcdepq", 200), new StringAndValue("abcdeyz", 3000)};
        CharsTrie trie = this.buildTrie(data, data.length, StringTrieBuilder.Option.FAST);
        trie.next(97);
        trie.next(98);
        trie.next(99);
        CharsTrie.Iterator iter = trie.iterator(3);
        StringAndValue[] expected = new StringAndValue[]{new StringAndValue("def", 10), new StringAndValue("dep", -1), new StringAndValue("dey", -1)};
        this.checkIterator(iter, expected);
        this.logln("after iter.reset()");
        this.checkIterator(iter.reset(), expected);
    }

    public void Test59IteratorFromChars() {
        StringAndValue[] data = new StringAndValue[]{new StringAndValue("mm", 3), new StringAndValue("mmm", 33), new StringAndValue("mmnop", 333)};
        this.builder_.clear();
        for (StringAndValue item : data) {
            this.builder_.add((CharSequence)item.s, item.value);
        }
        CharSequence trieChars = this.builder_.buildCharSequence(StringTrieBuilder.Option.FAST);
        this.checkIterator(CharsTrie.iterator((CharSequence)trieChars, (int)0, (int)0), data);
    }

    private void checkData(StringAndValue[] data) {
        this.checkData(data, data.length);
    }

    private void checkData(StringAndValue[] data, int dataLength) {
        this.logln("checkData(dataLength=" + dataLength + ", fast)");
        this.checkData(data, dataLength, StringTrieBuilder.Option.FAST);
        this.logln("checkData(dataLength=" + dataLength + ", small)");
        this.checkData(data, dataLength, StringTrieBuilder.Option.SMALL);
    }

    private void checkData(StringAndValue[] data, int dataLength, StringTrieBuilder.Option buildOption) {
        CharsTrie trie = this.buildTrie(data, dataLength, buildOption);
        this.checkFirst(trie, data, dataLength);
        this.checkNext(trie, data, dataLength);
        this.checkNextWithState(trie, data, dataLength);
        this.checkNextString(trie, data, dataLength);
        this.checkIterator(trie, data, dataLength);
    }

    private CharsTrie buildTrie(StringAndValue[] data, int dataLength, StringTrieBuilder.Option buildOption) {
        int step;
        int index;
        if ((dataLength & 1) != 0) {
            index = dataLength / 2;
            step = 2;
        } else if (dataLength % 3 != 0) {
            index = dataLength / 5;
            step = 3;
        } else {
            index = dataLength - 1;
            step = -1;
        }
        this.builder_.clear();
        for (int i = 0; i < dataLength; ++i) {
            this.builder_.add((CharSequence)data[index].s, data[index].value);
            index = (index + step) % dataLength;
        }
        CharsTrie trie = this.builder_.build(buildOption);
        try {
            this.builder_.add((CharSequence)"zzz", 999);
            this.errln("builder.build().add(zzz) did not throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        CharSequence trieChars = this.builder_.buildCharSequence(buildOption);
        this.logln("serialized trie size: " + trieChars.length() + " chars");
        if ((dataLength & 1) != 0) {
            return trie;
        }
        return new CharsTrie(trieChars, 0);
    }

    private void checkFirst(CharsTrie trie, StringAndValue[] data, int dataLength) {
        for (int i = 0; i < dataLength; ++i) {
            if (data[i].s.length() == 0) continue;
            String expectedString = data[i].s;
            int c = expectedString.charAt(0);
            int nextCp = expectedString.length() > 1 ? expectedString.charAt(1) : 0;
            BytesTrie.Result firstResult = trie.first(c);
            int firstValue = firstResult.hasValue() ? trie.getValue() : -1;
            BytesTrie.Result nextResult = trie.next(nextCp);
            if (firstResult != trie.reset().next(c) || firstResult != trie.current() || firstValue != (firstResult.hasValue() ? trie.getValue() : -1) || nextResult != trie.next(nextCp)) {
                this.errln(String.format("trie.first(U+%04X)!=trie.reset().next(same) for %s", c, data[i].s));
            }
            c = expectedString.codePointAt(0);
            int cLength = Character.charCount(c);
            nextCp = expectedString.length() > cLength ? expectedString.codePointAt(cLength) : 0;
            firstResult = trie.firstForCodePoint(c);
            firstValue = firstResult.hasValue() ? trie.getValue() : -1;
            nextResult = trie.nextForCodePoint(nextCp);
            if (firstResult == trie.reset().nextForCodePoint(c) && firstResult == trie.current() && firstValue == (firstResult.hasValue() ? trie.getValue() : -1) && nextResult == trie.nextForCodePoint(nextCp)) continue;
            this.errln(String.format("trie.firstForCodePoint(U+%04X)!=trie.reset().nextForCodePoint(same) for %s", c, data[i].s));
        }
        trie.reset();
    }

    private void checkNext(CharsTrie trie, StringAndValue[] data, int dataLength) {
        CharsTrie.State state = new CharsTrie.State();
        for (int i = 0; i < dataLength; ++i) {
            String expectedString = data[i].s;
            int stringLength = expectedString.length();
            BytesTrie.Result result = trie.next((CharSequence)expectedString, 0, stringLength);
            if (!result.hasValue() || result != trie.current()) {
                this.errln("trie does not seem to contain " + data[i].s);
            } else if (trie.getValue() != data[i].value) {
                this.errln(String.format("trie value for %s is %d=0x%x instead of expected %d=0x%x", data[i].s, trie.getValue(), trie.getValue(), data[i].value, data[i].value));
            } else if (result != trie.current() || trie.getValue() != data[i].value) {
                this.errln("trie value for " + data[i].s + " changes when repeating current()/getValue()");
            }
            trie.reset();
            result = trie.current();
            for (int j = 0; j < stringLength; ++j) {
                if (!result.hasNext()) {
                    this.errln(String.format("trie.current()!=hasNext before end of %s (at index %d)", data[i].s, j));
                    break;
                }
                if (result == BytesTrie.Result.INTERMEDIATE_VALUE) {
                    trie.getValue();
                    if (trie.current() != BytesTrie.Result.INTERMEDIATE_VALUE) {
                        this.errln(String.format("trie.getValue().current()!=BytesTrie.Result.INTERMEDIATE_VALUE before end of %s (at index %d)", data[i].s, j));
                        break;
                    }
                }
                if (!(result = trie.next((int)expectedString.charAt(j))).matches()) {
                    this.errln(String.format("trie.next()=BytesTrie.Result.NO_MATCH before end of %s (at index %d)", data[i].s, j));
                    break;
                }
                if (result == trie.current()) continue;
                this.errln(String.format("trie.next()!=following current() before end of %s (at index %d)", data[i].s, j));
                break;
            }
            if (!result.hasValue()) {
                this.errln("trie.next()!=hasValue at the end of " + data[i].s);
                continue;
            }
            trie.getValue();
            if (result != trie.current()) {
                this.errln("trie.current() != current()+getValue()+current() after end of " + data[i].s);
            }
            trie.saveState(state);
            boolean nextContinues = false;
            for (int c = 32; c < 57344; ++c) {
                if (c == 128) {
                    c = 55296;
                }
                if (!trie.resetToState(state).next(c).matches()) continue;
                nextContinues = true;
                break;
            }
            if (result == BytesTrie.Result.INTERMEDIATE_VALUE != nextContinues) {
                this.errln("(trie.current()==BytesTrie.Result.INTERMEDIATE_VALUE) contradicts (trie.next(some char)!=BytesTrie.Result.NO_MATCH) after end of " + data[i].s);
            }
            trie.reset();
        }
    }

    private void checkNextWithState(CharsTrie trie, StringAndValue[] data, int dataLength) {
        CharsTrie.State noState = new CharsTrie.State();
        CharsTrie.State state = new CharsTrie.State();
        for (int i = 0; i < dataLength; ++i) {
            BytesTrie.Result result;
            if ((i & 1) == 0) {
                try {
                    trie.resetToState(noState);
                    this.errln("trie.resetToState(noState) should throw an IllegalArgumentException");
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            String expectedString = data[i].s;
            int stringLength = expectedString.length();
            int partialLength = stringLength / 3;
            for (int j = 0; j < partialLength; ++j) {
                if (trie.next((int)expectedString.charAt(j)).matches()) continue;
                this.errln("trie.next()=BytesTrie.Result.NO_MATCH for a prefix of " + data[i].s);
                return;
            }
            trie.saveState(state);
            BytesTrie.Result resultAtState = trie.current();
            int valueAtState = -99;
            if (resultAtState.hasValue()) {
                valueAtState = trie.getValue();
            }
            if ((result = trie.next(0)) != BytesTrie.Result.NO_MATCH || result != trie.current()) {
                this.errln("trie.next(0) matched after part of " + data[i].s);
            }
            if (resultAtState != trie.resetToState(state).current() || resultAtState.hasValue() && valueAtState != trie.getValue()) {
                this.errln("trie.next(part of " + data[i].s + ") changes current()/getValue() after " + "saveState/next(0)/resetToState");
            } else {
                result = trie.next((CharSequence)expectedString, partialLength, stringLength);
                if (!result.hasValue() || result != trie.current()) {
                    this.errln("trie.next(rest of " + data[i].s + ") does not seem to contain " + data[i].s + " after " + "saveState/next(0)/resetToState");
                } else {
                    result = trie.resetToState(state).next((CharSequence)expectedString, partialLength, stringLength);
                    if (!result.hasValue() || result != trie.current()) {
                        this.errln("trie does not seem to contain " + data[i].s + " after saveState/next(rest)/resetToState");
                    } else if (trie.getValue() != data[i].value) {
                        this.errln(String.format("trie value for %s is %d=0x%x instead of expected %d=0x%x", data[i].s, trie.getValue(), trie.getValue(), data[i].value, data[i].value));
                    }
                }
            }
            trie.reset();
        }
    }

    private void checkNextString(CharsTrie trie, StringAndValue[] data, int dataLength) {
        for (int i = 0; i < dataLength; ++i) {
            String expectedString = data[i].s;
            int stringLength = expectedString.length();
            if (!trie.next((CharSequence)expectedString, 0, stringLength / 2).matches()) {
                this.errln("trie.next(up to middle of string)=BytesTrie.Result.NO_MATCH for " + data[i].s);
                continue;
            }
            trie.next((CharSequence)expectedString, stringLength / 2, stringLength);
            if (trie.next(0).matches()) {
                this.errln("trie.next(string+NUL)!=BytesTrie.Result.NO_MATCH for " + data[i].s);
            }
            trie.reset();
        }
    }

    private void checkIterator(CharsTrie trie, StringAndValue[] data, int dataLength) {
        this.checkIterator(trie.iterator(), data, dataLength);
    }

    private void checkIterator(CharsTrie.Iterator iter, StringAndValue[] data) {
        this.checkIterator(iter, data, data.length);
    }

    private void checkIterator(CharsTrie.Iterator iter, StringAndValue[] data, int dataLength) {
        for (int i = 0; i < dataLength; ++i) {
            if (!iter.hasNext()) {
                this.errln("trie iterator hasNext()=false for item " + i + ": " + data[i].s);
                break;
            }
            CharsTrie.Entry entry = iter.next();
            String expectedString = data[i].s;
            if (!expectedString.contentEquals(entry.chars)) {
                this.errln(String.format("trie iterator next().getString()=%s but expected %s for item %d", entry.chars, data[i].s, i));
            }
            if (entry.value == data[i].value) continue;
            this.errln(String.format("trie iterator next().getValue()=%d=0x%x but expected %d=0x%x for item %d: %s", entry.value, entry.value, data[i].value, data[i].value, i, data[i].s));
        }
        if (iter.hasNext()) {
            this.errln("trie iterator hasNext()=true after all items");
        }
        try {
            iter.next();
            this.errln("trie iterator next() did not throw NoSuchElementException after all items");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    private static final class Generator {
        private StringBuilder s = new StringBuilder();
        private UnicodeSet set = new UnicodeSet();
        private int value = 4711;
        private int num = 0;

        public void next() {
            this.s.setLength(0);
            char c = (char)(this.value >> 16);
            this.s.append(c);
            this.s.append((char)(this.value >> 4));
            if ((this.value & 1) != 0) {
                this.s.append((char)this.value);
            }
            this.set.add((int)c);
            this.value += (this.value >> 5 & 0x7FF) * 3 + 1;
            ++this.num;
        }

        public CharSequence getString() {
            return this.s;
        }

        public int getValue() {
            return this.value;
        }

        public int countUniqueFirstChars() {
            return this.set.size();
        }

        public int getIndex() {
            return this.num;
        }
    }

    private static final class StringAndValue {
        public String s;
        public int value;

        public StringAndValue(String str, int val) {
            this.s = str;
            this.value = val;
        }
    }
}

