/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtilities {
    public static final int ALL_EMPTY = 0;
    public static final int NOT_A_SUPERSET_B = 1;
    public static final int NOT_A_DISJOINT_B = 2;
    public static final int NOT_A_SUBSET_B = 4;
    public static final int NOT_A_EQUALS_B = 5;
    public static final int A_PROPER_SUBSET_OF_B = 3;
    public static final int A_PROPER_SUPERSET_B = 6;
    public static final int A_PROPER_OVERLAPS_B = 7;

    public static <T> String join(T[] array, String separator) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                result.append(separator);
            }
            result.append(array[i]);
        }
        return result.toString();
    }

    public static <T, U extends Collection<T>> String join(U collection, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator<T> it = collection.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(it.next());
        }
        return result.toString();
    }

    public static <T> Map<T, T> asMap(T[][] source, Map<T, T> target, boolean reverse) {
        int from = 0;
        int to = 1;
        if (reverse) {
            from = 1;
            to = 0;
        }
        for (int i = 0; i < source.length; ++i) {
            target.put(source[i][from], source[i][to]);
        }
        return target;
    }

    public static <T, U extends Collection<T>> U addAll(Iterator<T> source, U target) {
        while (source.hasNext()) {
            target.add(source.next());
        }
        return target;
    }

    public static int size(Iterator source) {
        int result = 0;
        while (source.hasNext()) {
            source.next();
            ++result;
        }
        return result;
    }

    public static <T> Map<T, T> asMap(T[][] source) {
        return CollectionUtilities.asMap(source, new HashMap(), false);
    }

    public static <K, V> Map<K, V> removeAll(Map<K, V> m, Collection<K> itemsToRemove) {
        for (K item : itemsToRemove) {
            m.remove(item);
        }
        return m;
    }

    public <T, U extends Collection<T>> T getFirst(U c) {
        Iterator<T> it = c.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    public static <T, U extends Collection<T>> T getBest(U c, Comparator<T> comp, int direction) {
        Iterator<T> it = c.iterator();
        if (!it.hasNext()) {
            return null;
        }
        T bestSoFar = it.next();
        if (direction < 0) {
            while (it.hasNext()) {
                T item = it.next();
                int compValue = comp.compare(item, bestSoFar);
                if (compValue >= 0) continue;
                bestSoFar = item;
            }
        } else {
            while (it.hasNext()) {
                T item = it.next();
                int compValue = comp.compare(item, bestSoFar);
                if (compValue <= 0) continue;
                bestSoFar = item;
            }
        }
        return bestSoFar;
    }

    public static <T, U extends Collection<T>> U removeAll(U c, ObjectMatcher<T> f) {
        Iterator<T> it = c.iterator();
        while (it.hasNext()) {
            T item = it.next();
            if (!f.matches(item)) continue;
            it.remove();
        }
        return c;
    }

    public static <T, U extends Collection<T>> U retainAll(U c, ObjectMatcher<T> f) {
        Iterator<T> it = c.iterator();
        while (it.hasNext()) {
            T item = it.next();
            if (f.matches(item)) continue;
            it.remove();
        }
        return c;
    }

    public static boolean containsSome(Collection a, Collection b) {
        if (a.size() == 0 || b.size() == 0) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (a instanceof SortedSet && b instanceof SortedSet) {
            SortedSet aa = (SortedSet)a;
            SortedSet bb = (SortedSet)b;
            Comparator bbc = bb.comparator();
            Comparator aac = aa.comparator();
            if (bbc == null && aac == null) {
                Iterator ai = aa.iterator();
                Iterator bi = bb.iterator();
                Comparable ao = (Comparable)ai.next();
                Comparable bo = (Comparable)bi.next();
                while (true) {
                    int rel;
                    if ((rel = ao.compareTo(bo)) < 0) {
                        if (!ai.hasNext()) {
                            return false;
                        }
                        ao = (Comparable)ai.next();
                        continue;
                    }
                    if (rel <= 0) break;
                    if (!bi.hasNext()) {
                        return false;
                    }
                    bo = (Comparable)bi.next();
                }
                return true;
            }
            if (((Object)bbc).equals(a)) {
                Iterator ai = aa.iterator();
                Iterator bi = bb.iterator();
                Object ao = ai.next();
                Object bo = bi.next();
                while (true) {
                    int rel;
                    if ((rel = aac.compare(ao, bo)) < 0) {
                        if (!ai.hasNext()) {
                            return false;
                        }
                        ao = ai.next();
                        continue;
                    }
                    if (rel <= 0) break;
                    if (!bi.hasNext()) {
                        return false;
                    }
                    bo = bi.next();
                }
                return true;
            }
        }
        Iterator it = a.iterator();
        while (it.hasNext()) {
            if (!b.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection a, Collection b) {
        if (a == b) {
            return true;
        }
        if (b.size() == 0) {
            return true;
        }
        if (a.size() < b.size()) {
            return false;
        }
        if (a instanceof SortedSet && b instanceof SortedSet) {
            SortedSet aa = (SortedSet)a;
            SortedSet bb = (SortedSet)b;
            Comparator bbc = bb.comparator();
            Comparator aac = aa.comparator();
            if (bbc == null && aac == null) {
                Iterator ai = aa.iterator();
                Iterator bi = bb.iterator();
                Comparable ao = (Comparable)ai.next();
                Comparable bo = (Comparable)bi.next();
                while (true) {
                    int rel;
                    if ((rel = ao.compareTo(bo)) == 0) {
                        if (!bi.hasNext()) {
                            return true;
                        }
                        if (!ai.hasNext()) {
                            return false;
                        }
                        bo = (Comparable)bi.next();
                        ao = (Comparable)ai.next();
                        continue;
                    }
                    if (rel >= 0) break;
                    if (!ai.hasNext()) {
                        return false;
                    }
                    ao = (Comparable)ai.next();
                }
                return false;
            }
            if (((Object)bbc).equals(aac)) {
                Iterator ai = aa.iterator();
                Iterator bi = bb.iterator();
                Object ao = ai.next();
                Object bo = bi.next();
                while (true) {
                    int rel;
                    if ((rel = aac.compare(ao, bo)) == 0) {
                        if (!bi.hasNext()) {
                            return true;
                        }
                        if (!ai.hasNext()) {
                            return false;
                        }
                        bo = bi.next();
                        ao = ai.next();
                        continue;
                    }
                    if (rel >= 0) break;
                    if (!ai.hasNext()) {
                        return false;
                    }
                    ao = ai.next();
                }
                return false;
            }
        }
        return a.containsAll(b);
    }

    public static boolean containsNone(Collection a, Collection b) {
        return !CollectionUtilities.containsSome(a, b);
    }

    public static int getContainmentRelation(Collection a, Collection b) {
        int result;
        if (a.size() == 0) {
            return b.size() == 0 ? 0 : 1;
        }
        if (b.size() == 0) {
            return 4;
        }
        Iterator it = a.iterator();
        for (result = 0; result != 6 && it.hasNext(); result |= b.contains(it.next()) ? 2 : 4) {
        }
        it = b.iterator();
        while ((result & 3) != 3 && it.hasNext()) {
            result |= a.contains(it.next()) ? 2 : 1;
        }
        return result;
    }

    public static String remove(String source, UnicodeSet removals) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < source.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)source, (int)i);
            if (removals.contains(cp)) continue;
            UTF16.append((StringBuffer)result, (int)cp);
        }
        return result.toString();
    }

    public static int matchesAt(CharSequence text, int offset, CharSequence other) {
        int len = other.length();
        int i = 0;
        int j = offset;
        while (i < len) {
            char tc;
            char pc = other.charAt(i);
            if (pc != (tc = text.charAt(j))) {
                return -1;
            }
            ++i;
            ++j;
        }
        return i;
    }

    public int span(CharSequence string, int offset, UnicodeSet testSet) {
        int newOffset;
        while ((newOffset = testSet.matchesAt(string, offset)) >= 0) {
        }
        return offset;
    }

    public int spanNot(CharSequence string, int offset, UnicodeSet testSet) {
        int newOffset;
        while ((newOffset = testSet.matchesAt(string, offset)) < 0) {
            ++offset;
        }
        return offset;
    }

    public static UnicodeSet flatten(UnicodeSet exemplar1) {
        UnicodeSet result = new UnicodeSet();
        boolean gotString = false;
        UnicodeSetIterator it = new UnicodeSetIterator(exemplar1);
        while (it.nextRange()) {
            if (it.codepoint == UnicodeSetIterator.IS_STRING) {
                result.addAll((CharSequence)it.string);
                gotString = true;
                continue;
            }
            result.add(it.codepoint, it.codepointEnd);
        }
        if (gotString) {
            exemplar1.set(result);
        }
        return exemplar1;
    }

    public static class RegexIterator
    extends FilteredIterator {
        private Matcher matcher;

        public RegexIterator set(Iterator baseIterator, Matcher matcher) {
            super.set(baseIterator);
            this.matcher = matcher;
            return this;
        }

        public boolean isIncluded(Object item) {
            return this.matcher.reset((String)item).matches();
        }
    }

    public static class PrefixIterator
    extends FilteredIterator {
        private String prefix;

        public PrefixIterator set(Iterator baseIterator, String prefix) {
            super.set(baseIterator);
            this.prefix = prefix;
            return this;
        }

        public boolean isIncluded(Object item) {
            return ((String)item).startsWith(this.prefix);
        }
    }

    public static abstract class FilteredIterator
    implements Iterator {
        private Iterator baseIterator;
        private static final Object EMPTY = new Object();
        private static final Object DONE = new Object();
        private Object nextObject = EMPTY;

        public FilteredIterator set(Iterator baseIterator) {
            this.baseIterator = baseIterator;
            return this;
        }

        public void remove() {
            throw new UnsupportedOperationException("Doesn't support removal");
        }

        public Object next() {
            Object result = this.nextObject;
            this.nextObject = EMPTY;
            return result;
        }

        public boolean hasNext() {
            if (this.nextObject == DONE) {
                return false;
            }
            if (this.nextObject != EMPTY) {
                return true;
            }
            while (this.baseIterator.hasNext()) {
                this.nextObject = this.baseIterator.next();
                if (!this.isIncluded(this.nextObject)) continue;
                return true;
            }
            this.nextObject = DONE;
            return false;
        }

        public abstract boolean isIncluded(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InverseMatcher<T>
    implements ObjectMatcher<T> {
        ObjectMatcher<T> other;

        public ObjectMatcher set(ObjectMatcher toInverse) {
            this.other = toInverse;
            return this;
        }

        @Override
        public boolean matches(T value) {
            return !this.other.matches(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ObjectMatcher<T> {
        public boolean matches(T var1);
    }
}

