/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.CurrencyData;
import com.ibm.icu.text.CurrencyDisplayNames;
import com.ibm.icu.text.CurrencyMetaInfo;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class CurrencyTest
extends TestFmwk {
    public static void main(String[] args) throws Exception {
        new CurrencyTest().run(args);
    }

    public void TestAPI() {
        Currency usd = Currency.getInstance((String)"USD");
        usd.hashCode();
        Currency jpy = Currency.getInstance((String)"JPY");
        if (usd.equals((Object)jpy)) {
            this.errln("FAIL: USD == JPY");
        }
        if (usd.equals((Object)"abc")) {
            this.errln("FAIL: USD == (String)");
        }
        if (usd.equals(null)) {
            this.errln("FAIL: USD == (null)");
        }
        if (!usd.equals((Object)usd)) {
            this.errln("FAIL: USD != USD");
        }
        try {
            Currency nullCurrency = Currency.getInstance((String)null);
            this.errln("FAIL: Expected getInstance(null) to throw a NullPointerException, but returned " + nullCurrency);
        }
        catch (NullPointerException npe) {
            this.logln("PASS: getInstance(null) threw a NullPointerException");
        }
        try {
            Currency bogusCurrency = Currency.getInstance((String)"BOGUS");
            this.errln("FAIL: Expected getInstance(\"BOGUS\") to throw an IllegalArgumentException, but returned " + bogusCurrency);
        }
        catch (IllegalArgumentException iae) {
            this.logln("PASS: getInstance(\"BOGUS\") threw an IllegalArgumentException");
        }
        Locale[] avail = Currency.getAvailableLocales();
        if (avail == null) {
            this.errln("FAIL: getAvailableLocales returned null");
        }
        try {
            usd.getName(ULocale.US, 5, new boolean[1]);
            this.errln("expected getName with invalid type parameter to throw exception");
        }
        catch (Exception e) {
            this.logln("PASS: getName failed as expected");
        }
    }

    public void TestRegistration() {
        Currency nus2;
        Currency nus1;
        Currency jpy = Currency.getInstance((String)"JPY");
        Currency usd = Currency.getInstance((Locale)Locale.US);
        try {
            Currency.unregister(null);
            this.errln("expected unregister of null to throw exception");
        }
        catch (Exception e) {
            this.logln("PASS: unregister of null failed as expected");
        }
        if (Currency.unregister((Object)"")) {
            this.errln("unregister before register erroneously succeeded");
        }
        ULocale fu_FU = new ULocale("fu_FU");
        Object key1 = Currency.registerInstance((Currency)jpy, (ULocale)ULocale.US);
        Object key2 = Currency.registerInstance((Currency)jpy, (ULocale)fu_FU);
        Currency nus = Currency.getInstance((Locale)Locale.US);
        if (!nus.equals((Object)jpy)) {
            this.errln("expected " + jpy + " but got: " + nus);
        }
        if (!(nus1 = Currency.getInstance((Locale)Locale.JAPAN)).equals((Object)jpy)) {
            this.errln("expected " + jpy + " but got: " + nus1);
        }
        ULocale[] locales = Currency.getAvailableULocales();
        boolean found = false;
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].equals((Object)fu_FU)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.errln("did not find locale" + fu_FU + " in currency locales");
        }
        if (!Currency.unregister((Object)key1)) {
            this.errln("unable to unregister currency using key1");
        }
        if (!Currency.unregister((Object)key2)) {
            this.errln("unable to unregister currency using key2");
        }
        if (!(nus2 = Currency.getInstance((Locale)Locale.US)).equals((Object)usd)) {
            this.errln("expected " + usd + " but got: " + nus2);
        }
        locales = Currency.getAvailableULocales();
        found = false;
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].equals((Object)fu_FU)) continue;
            found = true;
            break;
        }
        if (found) {
            this.errln("found locale" + fu_FU + " in currency locales after unregister");
        }
        Locale[] locs = Currency.getAvailableLocales();
        found = false;
        for (int i = 0; i < locs.length; ++i) {
            if (!locs[i].equals(fu_FU)) continue;
            found = true;
            break;
        }
        if (found) {
            this.errln("found locale" + fu_FU + " in currency locales after unregister");
        }
    }

    public void TestNames() {
        ULocale en = ULocale.ENGLISH;
        boolean[] isChoiceFormat = new boolean[1];
        Currency usd = Currency.getInstance((String)"USD");
        if (!this.noData()) {
            this.assertEquals("USD.getName(SYMBOL_NAME)", "$", usd.getName(en, 0, isChoiceFormat));
            this.assertEquals("USD.getName(LONG_NAME)", "US Dollar", usd.getName(en, 1, isChoiceFormat));
        }
    }

    public void TestCoverage() {
        Currency usd = Currency.getInstance((String)"USD");
        if (!this.noData()) {
            this.assertEquals("USD.getSymbol()", "$", usd.getSymbol());
        }
    }

    public void TestCurrencyDisplayNames() {
        if (!CurrencyDisplayNames.hasData()) {
            this.errln("hasData() should return true.");
        }
        CurrencyDisplayNames cdn = CurrencyDisplayNames.getInstance((ULocale)ULocale.GERMANY);
        this.assertEquals("de_USD_name", "US-Dollar", cdn.getName("USD"));
        this.assertEquals("de_USD_symbol", "$", cdn.getSymbol("USD"));
        this.assertEquals("de_USD_plural_other", "US-Dollar", cdn.getPluralName("USD", "other"));
        this.assertEquals("de_USD_plural_foo", "US-Dollar", cdn.getPluralName("USD", "foo"));
        cdn = CurrencyDisplayNames.getInstance((ULocale)ULocale.forLanguageTag((String)"en-US"));
        this.assertEquals("en-US_USD_name", "US Dollar", cdn.getName("USD"));
        this.assertEquals("en-US_USD_symbol", "$", cdn.getSymbol("USD"));
        this.assertEquals("en-US_USD_plural_one", "US dollar", cdn.getPluralName("USD", "one"));
        this.assertEquals("en-US_USD_plural_other", "US dollars", cdn.getPluralName("USD", "other"));
        this.assertEquals("en-US_FOO_name", "FOO", cdn.getName("FOO"));
        this.assertEquals("en-US_FOO_symbol", "FOO", cdn.getSymbol("FOO"));
        this.assertEquals("en-US_FOO_plural_other", "FOO", cdn.getPluralName("FOO", "other"));
        this.assertEquals("en-US bundle", "en", cdn.getULocale().toString());
        cdn = CurrencyDisplayNames.getInstance((ULocale)ULocale.forLanguageTag((String)"zz-Gggg-YY"));
        this.assertEquals("bundle from current locale", "en", cdn.getULocale().toString());
        cdn = CurrencyDisplayNames.getInstance((ULocale)ULocale.GERMANY, (boolean)true);
        this.assertNotNull("have currency data for Germany", cdn);
        this.assertEquals("de_USD_name", "US-Dollar", cdn.getName("USD"));
        this.assertEquals("de_USD_symbol", "$", cdn.getSymbol("USD"));
        this.assertEquals("de_USD_plural_other", "US-Dollar", cdn.getPluralName("USD", "other"));
        this.assertNull("de_USD_plural_foo", cdn.getPluralName("USD", "foo"));
        this.assertNull("de_FOO_name", cdn.getName("FOO"));
        this.assertNull("de_FOO_symbol", cdn.getSymbol("FOO"));
        this.assertNull("de_FOO_plural_other", cdn.getPluralName("FOO", "other"));
        this.assertNull("de_FOO_plural_foo", cdn.getPluralName("FOO", "foo"));
        cdn = CurrencyDisplayNames.getInstance((ULocale)ULocale.forLanguageTag((String)"zz-Gggg-YY"), (boolean)true);
        String ln = "";
        if (cdn != null) {
            ln = " (" + cdn.getULocale().toString() + ")";
        }
        this.assertNull("no fallback from unknown locale" + ln, cdn);
    }

    public void TestCurrencyData() {
        CurrencyData.DefaultInfo info_fallback = (CurrencyData.DefaultInfo)CurrencyData.DefaultInfo.getWithFallback((boolean)true);
        if (info_fallback == null) {
            this.errln("getWithFallback() returned null.");
            return;
        }
        CurrencyData.DefaultInfo info_nofallback = (CurrencyData.DefaultInfo)CurrencyData.DefaultInfo.getWithFallback((boolean)false);
        if (info_nofallback == null) {
            this.errln("getWithFallback() returned null.");
            return;
        }
        if (!info_fallback.getName("isoCode").equals("isoCode") || info_nofallback.getName("isoCode") != null) {
            this.errln("Error calling getName().");
            return;
        }
        if (!info_fallback.getPluralName("isoCode", "type").equals("isoCode") || info_nofallback.getPluralName("isoCode", "type") != null) {
            this.errln("Error calling getPluralName().");
            return;
        }
        if (!info_fallback.getSymbol("isoCode").equals("isoCode") || info_nofallback.getSymbol("isoCode") != null) {
            this.errln("Error calling getSymbol().");
            return;
        }
        if (!info_fallback.symbolMap().isEmpty()) {
            this.errln("symbolMap() should return empty map.");
            return;
        }
        if (!info_fallback.nameMap().isEmpty()) {
            this.errln("nameMap() should return empty map.");
            return;
        }
        if (!info_fallback.getUnitPatterns().isEmpty() || info_nofallback.getUnitPatterns() != null) {
            this.errln("Error calling getUnitPatterns().");
            return;
        }
        if (!info_fallback.getSpacingInfo().equals(CurrencyData.CurrencySpacingInfo.DEFAULT) || info_nofallback.getSpacingInfo() != null) {
            this.errln("Error calling getSpacingInfo().");
            return;
        }
        if (info_fallback.getULocale() != ULocale.ROOT) {
            this.errln("Error calling getLocale().");
            return;
        }
        if (info_fallback.getFormatInfo("isoCode") != null) {
            this.errln("Error calling getFormatInfo().");
            return;
        }
    }

    public void testCurrencyMetaInfoRanges() {
        CurrencyMetaInfo metainfo = CurrencyMetaInfo.getInstance((boolean)true);
        this.assertNotNull("have metainfo", metainfo);
        CurrencyMetaInfo.CurrencyFilter filter = CurrencyMetaInfo.CurrencyFilter.onRegion((String)"DE");
        List currenciesInGermany = metainfo.currencyInfo(filter);
        this.logln("currencies: " + currenciesInGermany.size());
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
        fmt.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
        Date demLastDate = new Date(Long.MAX_VALUE);
        Date eurFirstDate = new Date(Long.MIN_VALUE);
        for (CurrencyMetaInfo.CurrencyInfo info : currenciesInGermany) {
            this.logln(info.toString());
            this.logln("from: " + fmt.format((Object)info.from) + Long.toHexString(info.from));
            this.logln("  to: " + fmt.format((Object)info.to) + Long.toHexString(info.to));
            if (info.code.equals("DEM")) {
                demLastDate = new Date(info.to);
                continue;
            }
            if (!info.code.equals("EUR")) continue;
            eurFirstDate = new Date(info.from);
        }
        this.assertEquals("DEM available at last date", 2L, metainfo.currencyInfo(filter.withDate(demLastDate)).size());
        Date demLastDatePlus1ms = new Date(demLastDate.getTime() + 1L);
        this.assertEquals("DEM not available after very start of last date", 1L, metainfo.currencyInfo(filter.withDate(demLastDatePlus1ms)).size());
        this.assertEquals("EUR available on start of first date", 2L, metainfo.currencyInfo(filter.withDate(eurFirstDate)).size());
        Date eurFirstDateMinus1ms = new Date(eurFirstDate.getTime() - 1L);
        this.assertEquals("EUR not avilable before very start of first date", 1L, metainfo.currencyInfo(filter.withDate(eurFirstDateMinus1ms)).size());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
        cal.setTime(demLastDate);
        this.assertEquals("hour is 23", 23L, cal.get(11));
        this.assertEquals("minute is 59", 59L, cal.get(12));
        this.assertEquals("second is 59", 59L, cal.get(13));
        this.assertEquals("millisecond is 999", 999L, cal.get(14));
        cal.setTime(eurFirstDate);
        this.assertEquals("hour is 0", 0L, cal.get(11));
        this.assertEquals("minute is 0", 0L, cal.get(12));
        this.assertEquals("second is 0", 0L, cal.get(13));
        this.assertEquals("millisecond is 0", 0L, cal.get(14));
    }

    public void TestCurrencyMetaInfo() {
        CurrencyMetaInfo metainfo = CurrencyMetaInfo.getInstance();
        if (metainfo == null) {
            this.errln("Unable to get CurrencyMetaInfo instance.");
            return;
        }
        if (!CurrencyMetaInfo.hasData()) {
            this.errln("hasData() should note return false.");
            return;
        }
        CurrencyMetaInfo.CurrencyFilter filter = CurrencyMetaInfo.CurrencyFilter.onCurrency((String)"currency");
        CurrencyMetaInfo.CurrencyFilter filter2 = CurrencyMetaInfo.CurrencyFilter.onCurrency((String)"test");
        if (filter == null) {
            this.errln("Unable to create CurrencyFilter.");
            return;
        }
        if (filter.equals(new Object())) {
            this.errln("filter should not equal to Object");
            return;
        }
        if (filter.equals(filter2)) {
            this.errln("filter should not equal filter2");
            return;
        }
        if (filter.hashCode() == 0) {
            this.errln("Error getting filter hashcode");
            return;
        }
        if (filter.toString() == null) {
            this.errln("Error calling toString()");
            return;
        }
        CurrencyMetaInfo.CurrencyInfo info = new CurrencyMetaInfo.CurrencyInfo("region", "code", 0L, 1L, 1);
        if (info == null) {
            this.errln("Error creating CurrencyInfo.");
            return;
        }
        if (info.toString() == null) {
            this.errln("Error calling toString()");
            return;
        }
        CurrencyMetaInfo.CurrencyDigits digits = metainfo.currencyDigits("isoCode");
        if (digits == null) {
            this.errln("Unable to get CurrencyDigits.");
            return;
        }
        if (digits.toString() == null) {
            this.errln("Error calling toString()");
            return;
        }
    }

    public void TestCurrencyKeyword() {
        ULocale locale = new ULocale("th_TH@collation=traditional;currency=QQQ");
        Currency currency = Currency.getInstance((ULocale)locale);
        String result = currency.getCurrencyCode();
        if (!"QQQ".equals(result)) {
            this.errln("got unexpected currency: " + result);
        }
    }

    public void TestAvailableCurrencyCodes() {
        String[][] tests = new String[][]{{"eo_AM", "1950-01-05"}, {"eo_AM", "1969-12-31", "SUR"}, {"eo_AM", "1991-12-26", "RUR"}, {"eo_AM", "2000-12-23", "AMD"}, {"eo_AD", "2000-12-23", "EUR", "ESP", "FRF", "ADP"}, {"eo_AD", "1969-12-31", "ESP", "FRF", "ADP"}, {"eo_AD", "1950-01-05", "ESP", "ADP"}, {"eo_AD", "1900-01-17", "ESP"}, {"eo_UA", "1994-12-25"}, {"eo_QQ", "1969-12-31"}, {"eo_AO", "2000-12-23", "AOA"}, {"eo_AO", "1995-12-25", "AOR", "AON"}, {"eo_AO", "1990-12-26", "AON", "AOK"}, {"eo_AO", "1979-12-29", "AOK"}, {"eo_AO", "1969-12-31"}, {"eo_DE@currency=DEM", "2000-12-23", "EUR", "DEM"}, {"eo-DE-u-cu-dem", "2000-12-23", "EUR", "DEM"}, {"en_US", null, "USD"}, {"en_US_PREEURO", null, "USD"}, {"en_US_Q", null, "USD"}};
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        for (String[] test : tests) {
            Date date;
            ULocale locale = new ULocale(test[0]);
            String timeString = test[1];
            if (timeString == null) {
                date = new Date();
                timeString = "today";
            } else {
                try {
                    date = fmt.parse(timeString);
                }
                catch (Exception e) {
                    this.fail("could not parse date: " + timeString);
                    continue;
                }
            }
            String[] expected = null;
            if (test.length > 2) {
                expected = new String[test.length - 2];
                System.arraycopy(test, 2, expected, 0, expected.length);
            }
            String[] actual = Currency.getAvailableCurrencyCodes((ULocale)locale, (Date)date);
            HashSet<String> expectedSet = new HashSet<String>();
            if (expected != null) {
                expectedSet.addAll(Arrays.asList(expected));
            }
            HashSet<String> actualSet = new HashSet<String>();
            if (actual != null) {
                actualSet.addAll(Arrays.asList(actual));
            }
            this.assertEquals(locale + " on " + timeString, expectedSet, actualSet);
        }
    }

    public void TestDeprecatedCurrencyFormat() {
        Locale locale = new Locale("sr", "QQ");
        DecimalFormatSymbols icuSymbols = new DecimalFormatSymbols(locale);
        String symbol = icuSymbols.getCurrencySymbol();
        Currency currency = icuSymbols.getCurrency();
        String expectCur = null;
        String expectSym = "\u00a4";
        if (!symbol.toString().equals(expectSym) || currency != null) {
            this.errln("for " + locale + " expected " + expectSym + "/" + expectCur + " but got " + symbol + "/" + currency);
        } else {
            this.logln("for " + locale + " expected " + expectSym + "/" + expectCur + " and got " + symbol + "/" + currency);
        }
    }

    public void TestGetKeywordValues() {
        int i;
        String[][] PREFERRED = new String[][]{{"root"}, {"und"}, {"und_ZZ"}, {"en_US", "USD"}, {"en_029"}, {"en_TH", "THB"}, {"de", "EUR"}, {"de_DE", "EUR"}, {"de_ZZ"}, {"ar", "EGP"}, {"ar_PS", "JOD", "ILS"}, {"en@currency=CAD", "USD"}, {"fr@currency=ZZZ", "EUR"}, {"de_DE@currency=DEM", "EUR"}};
        String[] ALL = Currency.getKeywordValuesForLocale((String)"currency", (ULocale)ULocale.getDefault(), (boolean)false);
        HashSet<String> ALLSET = new HashSet<String>();
        for (i = 0; i < ALL.length; ++i) {
            ALLSET.add(ALL[i]);
        }
        for (i = 0; i < PREFERRED.length; ++i) {
            ULocale loc = new ULocale(PREFERRED[i][0]);
            String[] expected = new String[PREFERRED[i].length - 1];
            System.arraycopy(PREFERRED[i], 1, expected, 0, expected.length);
            String[] pref = Currency.getKeywordValuesForLocale((String)"currency", (ULocale)loc, (boolean)true);
            this.assertEquals(loc.toString(), (T[])expected, (T[])pref);
            String[] all = Currency.getKeywordValuesForLocale((String)"currency", (ULocale)loc, (boolean)false);
            HashSet<String> returnedSet = new HashSet<String>();
            returnedSet.addAll(Arrays.asList(all));
            this.assertEquals(loc.toString(), ALLSET, returnedSet);
        }
    }

    public void TestIsAvailable() {
        Date d1995 = new Date(788918400000L);
        Date d2000 = new Date(946684800000L);
        Date d2005 = new Date(1104537600000L);
        this.assertTrue("USD all time", Currency.isAvailable((String)"USD", null, null));
        this.assertTrue("USD before 1995", Currency.isAvailable((String)"USD", null, (Date)d1995));
        this.assertTrue("USD 1995-2005", Currency.isAvailable((String)"USD", (Date)d1995, (Date)d2005));
        this.assertTrue("USD after 2005", Currency.isAvailable((String)"USD", (Date)d2005, null));
        this.assertTrue("USD on 2005-01-01", Currency.isAvailable((String)"USD", (Date)d2005, (Date)d2005));
        this.assertTrue("usd all time", Currency.isAvailable((String)"usd", null, null));
        this.assertTrue("DEM all time", Currency.isAvailable((String)"DEM", null, null));
        this.assertTrue("DEM before 1995", Currency.isAvailable((String)"DEM", null, (Date)d1995));
        this.assertTrue("DEM 1995-2000", Currency.isAvailable((String)"DEM", (Date)d1995, (Date)d2000));
        this.assertTrue("DEM 1995-2005", Currency.isAvailable((String)"DEM", (Date)d1995, (Date)d2005));
        this.assertFalse("DEM after 2005", Currency.isAvailable((String)"DEM", (Date)d2005, null));
        this.assertTrue("DEM on 2000-01-01", Currency.isAvailable((String)"DEM", (Date)d2000, (Date)d2000));
        this.assertFalse("DEM on 2005-01-01", Currency.isAvailable((String)"DEM", (Date)d2005, (Date)d2005));
        this.assertFalse("XXX unknown code", Currency.isAvailable((String)"XXX", null, null));
        this.assertFalse("USDOLLAR invalid code", Currency.isAvailable((String)"USDOLLAR", null, null));
        try {
            Currency.isAvailable((String)"USD", (Date)d2005, (Date)d1995);
            this.errln("Expected IllegalArgumentException, because lower range is after upper range");
        }
        catch (IllegalArgumentException e) {
            this.logln("IllegalArgumentException, because lower range is after upper range");
        }
    }

    public void TestGetAvailableCurrencies() {
        Set avail1 = Currency.getAvailableCurrencies();
        avail1.add(Currency.getInstance((String)"ZZZ"));
        Set avail2 = Currency.getAvailableCurrencies();
        this.assertTrue("avail1 does not contain all currencies in avail2", avail1.containsAll(avail2));
        this.assertTrue("avail1 must have one more currency", avail1.size() - avail2.size() == 1);
    }

    public void TestGetNumericCode() {
        Object[][] NUMCODE_TESTDATA;
        for (Object[] data : NUMCODE_TESTDATA = new Object[][]{{"USD", 840}, {"Usd", 840}, {"EUR", 978}, {"JPY", 392}, {"XFU", 0}, {"ZZZ", 0}}) {
            int expected;
            Currency cur = Currency.getInstance((String)((String)data[0]));
            int numCode = cur.getNumericCode();
            if (numCode == (expected = ((Integer)data[1]).intValue())) continue;
            this.errln("FAIL: getNumericCode returned " + numCode + " for " + cur.getCurrencyCode() + " - expected: " + expected);
        }
    }

    public void TestGetDisplayName() {
        String[][] DISPNAME_TESTDATA = new String[][]{{"USD", "US Dollar"}, {"EUR", "Euro"}, {"JPY", "Japanese Yen"}};
        Locale defLocale = Locale.getDefault();
        Locale jaJP = new Locale("ja", "JP");
        Locale root = new Locale("");
        for (String[] data : DISPNAME_TESTDATA) {
            Currency cur = Currency.getInstance((String)data[0]);
            this.assertEquals("getDisplayName() for " + data[0], data[1], cur.getDisplayName());
            this.assertEquals("getDisplayName() for " + data[0] + " in locale " + defLocale, data[1], cur.getDisplayName(defLocale));
            this.assertNotEquals("getDisplayName() for " + data[0] + " in locale " + jaJP, data[1], cur.getDisplayName(jaJP));
            this.assertEquals("getDisplayName() for " + data[0] + " in locale " + root, data[0], cur.getDisplayName(root));
        }
    }
}

