/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.util.DebugUtilities;
import com.ibm.icu.impl.Utility;

public class FieldsSet {
    public static final int NO_ENUM = -1;
    protected int fEnum = -1;
    protected int fFieldsCount = 0;
    protected int[] fValues = null;
    protected boolean[] fIsSet = null;

    protected FieldsSet(int whichEnum, int fieldsCount) {
        if (fieldsCount <= 0 && whichEnum != -1) {
            fieldsCount = DebugUtilities.enumCount(whichEnum);
        }
        this.fEnum = whichEnum;
        this.fFieldsCount = fieldsCount;
        if (fieldsCount < 0) {
            throw new InternalError("Preposterous field count " + fieldsCount);
        }
        this.fValues = new int[this.fFieldsCount];
        this.fIsSet = new boolean[this.fFieldsCount];
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.fFieldsCount; ++i) {
            this.clear(i);
        }
    }

    public void clear(int field) {
        this.fValues[field] = -1;
        this.fIsSet[field] = false;
    }

    public void set(int field, int amount) {
        this.fValues[field] = amount;
        this.fIsSet[field] = true;
    }

    public boolean isSet(int field) {
        return this.fIsSet[field];
    }

    public int get(int field) {
        if (this.fIsSet[field]) {
            return this.fValues[field];
        }
        return -1;
    }

    public boolean isSameType(FieldsSet other) {
        return other.fEnum == this.fEnum && other.fFieldsCount == this.fFieldsCount;
    }

    public int fieldCount() {
        return this.fFieldsCount;
    }

    public String diffFrom(FieldsSet other) {
        StringBuffer str = new StringBuffer();
        if (!this.isSameType(other)) {
            throw new IllegalArgumentException("U_ILLEGAL_ARGUMENT_ERROR: FieldsSet of a different type!");
        }
        for (int i = 0; i < this.fieldCount(); ++i) {
            if (!this.isSet(i)) continue;
            int myVal = this.get(i);
            int theirVal = other.get(i);
            if (this.fEnum != -1) {
                String fieldName = DebugUtilities.enumString(this.fEnum, i);
                String aval = Integer.toString(myVal);
                String bval = Integer.toString(theirVal);
                str.append(fieldName + "=" + aval + " not " + bval + ", ");
                continue;
            }
            str.append(Integer.toString(i) + "=" + myVal + " not " + theirVal + ", ");
        }
        if (str.length() == 0) {
            return null;
        }
        return str.toString();
    }

    public int parseFrom(String str) {
        return this.parseFrom(str, null);
    }

    public int parseFrom(String str, FieldsSet inheritFrom) {
        int goodFields = 0;
        String[] fields = Utility.split((String)str, (char)',');
        for (int i = 0; i < fields.length; ++i) {
            int field;
            String fieldStr = fields[i];
            String[] kv = Utility.split((String)fieldStr, (char)'=');
            if (kv.length < 1 || kv.length > 2) {
                throw new InternalError("split around '=' failed: " + fieldStr);
            }
            String key = kv[0];
            String value = "";
            if (kv.length > 1) {
                value = kv[1];
            }
            if ((field = this.handleParseName(inheritFrom, key, value)) == -1) continue;
            this.handleParseValue(inheritFrom, field, value);
            ++goodFields;
        }
        return goodFields;
    }

    protected int handleParseName(FieldsSet inheritFrom, String name, String substr) {
        int field = -1;
        if (this.fEnum != -1) {
            field = DebugUtilities.enumByString(this.fEnum, name);
        }
        if (field < 0) {
            field = Integer.parseInt(name);
        }
        return field;
    }

    protected void handleParseValue(FieldsSet inheritFrom, int field, String substr) {
        this.parseValueDefault(inheritFrom, field, substr);
    }

    protected void parseValueDefault(FieldsSet inheritFrom, int field, String substr) {
        if (substr.length() == 0) {
            if (inheritFrom == null) {
                throw new InternalError("Trying to inherit from field " + field + " but inheritFrom is null");
            }
            if (!inheritFrom.isSet(field)) {
                throw new InternalError("Trying to inherit from field " + field + " but inheritFrom[" + field + "] is  not set");
            }
            this.set(field, inheritFrom.get(field));
        } else {
            int value = Integer.parseInt(substr);
            this.set(field, value);
        }
    }

    protected void parseValueEnum(int type, FieldsSet inheritFrom, int field, String substr) {
        int value = DebugUtilities.enumByString(type, substr);
        if (value >= 0) {
            this.set(field, value);
            return;
        }
        this.parseValueDefault(inheritFrom, field, substr);
    }

    public String fieldName(int field) {
        return this.fEnum != -1 ? DebugUtilities.enumString(this.fEnum, field) : Integer.toString(field);
    }

    public String toString() {
        String str = this.getClass().getName() + " [" + this.fFieldsCount + "," + (this.fEnum != -1 ? DebugUtilities.typeString(this.fEnum) : Integer.toString(this.fEnum)) + "]: ";
        for (int i = 0; i < this.fFieldsCount; ++i) {
            if (!this.isSet(i)) continue;
            str = str + this.fieldName(i) + "=" + this.get(i) + ",";
        }
        return str;
    }
}

