/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.Holiday;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceBundleIterator;
import com.ibm.icu.util.UResourceTypeMismatchException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ICUResourceBundleTest
extends TestFmwk {
    private static final ClassLoader testLoader = ICUResourceBundleTest.class.getClassLoader();
    private static final String CALENDAR_RESNAME = "calendar";
    private static final String CALENDAR_KEYWORD = "calendar";

    public static void main(String[] args) throws Exception {
        ICUResourceBundleTest test = new ICUResourceBundleTest();
        test.run(args);
    }

    public void TestGetResources() {
        try {
            Enumeration<URL> en = testLoader.getResources("com.ibm.icu.dev.data");
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                if (url == null) {
                    this.warnln("could not load resource data");
                    return;
                }
                URLConnection c = url.openConnection();
                if (c instanceof JarURLConnection) {
                    JarURLConnection jc = (JarURLConnection)c;
                    JarEntry je = jc.getJarEntry();
                    this.logln("jar entry: " + je.toString());
                    continue;
                }
                InputStream is = c.getInputStream();
                this.logln("input stream:");
                InputStreamReader r = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(r);
                String line = null;
                int n = 0;
                while ((line = br.readLine()) != null) {
                    this.logln("  " + ++n + ": " + line);
                }
            }
        }
        catch (SecurityException ex) {
            this.warnln("could not load resource data: " + ex);
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            this.warnln("could not load resource data: " + ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errln("Unexpected exception: " + ex);
        }
    }

    public void TestResourceBundleWrapper() {
        UResourceBundle bundle = UResourceBundle.getBundleInstance((String)"com.ibm.icu.impl.data.HolidayBundle", (String)"da_DK");
        Object o = bundle.getObject("holidays");
        if (o instanceof Holiday[]) {
            this.logln("wrapper mechanism works for Weekend data");
        } else {
            this.errln("Did not get the expected output for Weekend data");
        }
        bundle = UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (String)"bogus");
        if (bundle instanceof UResourceBundle && bundle.getULocale().equals((Object)"en_US")) {
            this.logln("wrapper mechanism works for bogus locale");
        } else {
            this.errln("wrapper mechanism failed for bogus locale.");
        }
        try {
            bundle = UResourceBundle.getBundleInstance((String)"bogus", (String)"bogus");
            if (bundle != null) {
                this.errln("Did not get the expected exception");
            }
        }
        catch (MissingResourceException ex) {
            this.logln("got the expected exception");
        }
    }

    public void TestJB3879() {
        try {
            UResourceBundle bundle = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)ULocale.getDefault().toString(), (ClassLoader)testLoader);
            if (bundle == null) {
                this.errln("could not create the resource bundle");
            }
        }
        catch (MissingResourceException ex) {
            this.warnln("could not load test data: " + ex.getMessage());
        }
    }

    public void TestOpen() {
        String temp;
        UResourceBundle sub;
        int i;
        UResourceBundle bundle = UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (String)"en_US_POSIX");
        if (bundle == null) {
            this.errln("could not create the resource bundle");
        }
        UResourceBundle obj = bundle.get("NumberElements").get("latn").get("patterns");
        int size = obj.getSize();
        int type = obj.getType();
        if (type == 2) {
            for (i = 0; i < size; ++i) {
                sub = obj.get(i);
                temp = sub.getString();
                if (temp.length() != 0) continue;
                this.errln("Failed to get the items from number patterns table in bundle: " + bundle.getULocale().getBaseName());
            }
        }
        obj = bundle.get("NumberElements").get("latn").get("symbols");
        size = obj.getSize();
        type = obj.getType();
        if (type == 2) {
            for (i = 0; i < size; ++i) {
                sub = obj.get(i);
                temp = sub.getString();
                if (temp.length() != 0) continue;
                this.errln("Failed to get the items from number symbols table in bundle: " + bundle.getULocale().getBaseName());
            }
        }
        if (bundle == null) {
            this.errln("could not create the resource bundle");
        }
        if (!(bundle = UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (String)"zzz_ZZ_very_very_very_long_bogus_bundle")).getULocale().equals((Object)ULocale.getDefault())) {
            this.errln("UResourceBundle did not load the default bundle when bundle was not found. Default: " + ULocale.getDefault() + ", Bundle locale: " + bundle.getULocale());
        }
    }

    public void TestBasicTypes() {
        String value;
        UResourceBundle sub2;
        UResourceBundle sub1;
        String key;
        UResourceBundle sub;
        ByteBuffer got;
        int got2;
        UResourceBundle bundle = null;
        try {
            bundle = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testtypes", (ClassLoader)testLoader);
        }
        catch (MissingResourceException e) {
            this.warnln("could not load test data: " + e.getMessage());
            return;
        }
        String expected = "abc\u0000def";
        UResourceBundle sub3 = bundle.get("zerotest");
        if (!expected.equals(sub3.getString())) {
            this.errln("Did not get the expected string for key zerotest in bundle testtypes");
        }
        if (!(expected = "").equals((sub3 = bundle.get("emptyexplicitstring")).getString())) {
            this.errln("Did not get the expected string for key emptyexplicitstring in bundle testtypes");
        }
        if (!(expected = "").equals((sub3 = bundle.get("emptystring")).getString())) {
            this.errln("Did not get the expected string for key emptystring in bundle testtypes");
        }
        if ((expected = 123) != (sub3 = bundle.get("onehundredtwentythree")).getInt()) {
            this.errln("Did not get the expected int value for key onehundredtwentythree in bundle testtypes");
        }
        if ((expected = 0) != (sub3 = bundle.get("emptyint")).getInt()) {
            this.errln("Did not get the expected int value for key emptyint in bundle testtypes");
        }
        if ((expected = 1) != (sub3 = bundle.get("one")).getInt()) {
            this.errln("Did not get the expected int value for key one in bundle testtypes");
        }
        if ((expected = -1) != (got2 = (sub3 = bundle.get("minusone")).getInt())) {
            this.errln("Did not get the expected int value for key minusone in bundle testtypes");
        }
        if ((expected = 0xFFFFFFF) != (got2 = sub3.getUInt())) {
            this.errln("Did not get the expected int value for key minusone in bundle testtypes");
        }
        if ((expected = 1) != (sub3 = bundle.get("plusone")).getInt()) {
            this.errln("Did not get the expected int value for key minusone in bundle testtypes");
        }
        if (!Utility.arrayEquals((int[])(expected = new int[]{1, 2, 3, -3, 4, 5, 6, 7}), (Object)(sub3 = bundle.get("integerarray")).getIntVector())) {
            this.errln("Did not get the expected int vector value for key integerarray in bundle testtypes");
        }
        if (!Utility.arrayEquals((int[])(expected = new int[0]), (Object)(sub3 = bundle.get("emptyintv")).getIntVector())) {
            this.errln("Did not get the expected int vector value for key emptyintv in bundle testtypes");
        }
        if ((got = (sub = bundle.get("binarytest")).getBinary()).remaining() != 15) {
            this.errln("Did not get the expected length for the binary ByteBuffer");
        }
        for (int i = 0; i < got.remaining(); ++i) {
            byte b = got.get();
            if (b == i) continue;
            this.errln("Did not get the expected value for binary buffer at index: " + i);
        }
        sub = bundle.get("emptybin");
        got = sub.getBinary();
        if (got.remaining() != 0) {
            this.errln("Did not get the expected length for the emptybin ByteBuffer");
        }
        if (!(key = (sub = bundle.get("emptyarray")).getKey()).equals("emptyarray")) {
            this.errln("Did not get the expected key for emptytable item");
        }
        if (sub.getSize() != 0) {
            this.errln("Did not get the expected length for emptytable item");
        }
        if (!(key = (sub = bundle.get("menu")).getKey()).equals("menu")) {
            this.errln("Did not get the expected key for menu item");
        }
        if (!(key = (sub1 = sub.get("file")).getKey()).equals("file")) {
            this.errln("Did not get the expected key for file item");
        }
        if (!(key = (sub2 = sub1.get("open")).getKey()).equals("open")) {
            this.errln("Did not get the expected key for file item");
        }
        if (!(value = sub2.getString()).equals("Open")) {
            this.errln("Did not get the expected value for key for oen item");
        }
        if (!(key = (sub = bundle.get("emptytable")).getKey()).equals("emptytable")) {
            this.errln("Did not get the expected key for emptytable item");
        }
        if (sub.getSize() != 0) {
            this.errln("Did not get the expected length for emptytable item");
        }
        sub = bundle.get("menu").get("file");
        int size = sub.getSize();
        for (int i = 0; i < size; ++i) {
            String expected2;
            sub1 = sub.get(i);
            switch (i) {
                case 0: {
                    expected2 = "exit";
                    break;
                }
                case 1: {
                    expected2 = "open";
                    break;
                }
                case 2: {
                    expected2 = "save";
                    break;
                }
                default: {
                    expected2 = "";
                }
            }
            String got3 = sub1.getKey();
            if (!expected2.equals(got3)) {
                this.errln("Did not get the expected key at index" + i + ". Expected: " + expected2 + " Got: " + got3);
                continue;
            }
            this.logln("Got the expected key at index: " + i);
        }
    }

    public void TestTable32() {
        UResourceBundle item;
        int i;
        int size;
        TestCase[] arr = new TestCase[]{new TestCase("ooooooooooooooooo", 0), new TestCase("oooooooooooooooo1", 1), new TestCase("ooooooooooooooo1o", 2), new TestCase("oo11ooo1ooo11111o", 25150), new TestCase("oo11ooo1ooo111111", 25151), new TestCase("o1111111111111111", 65535), new TestCase("1oooooooooooooooo", 65536), new TestCase("1ooooooo11o11ooo1", 65969), new TestCase("1ooooooo11o11oo1o", 65970), new TestCase("1ooooooo111oo1111", 65999)};
        UResourceBundle bundle = null;
        try {
            bundle = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testtable32", (ClassLoader)testLoader);
        }
        catch (MissingResourceException ex) {
            this.warnln("could not load resource data: " + ex.getMessage());
            return;
        }
        if (bundle.getType() != 2) {
            this.errln("Could not get the correct type for bundle testtable32");
        }
        if ((size = bundle.getSize()) != 66000) {
            this.errln("Could not get the correct size for bundle testtable32");
        }
        int number = -1;
        for (i = 0; i < size; ++i) {
            item = bundle.get(i);
            String key = item.getKey();
            int parsedNumber = ICUResourceBundleTest.parseTable32Key(key);
            switch (item.getType()) {
                case 0: {
                    String value = item.getString();
                    number = UTF16.charAt((String)value, (int)0);
                    break;
                }
                case 7: {
                    number = item.getInt();
                    break;
                }
                default: {
                    this.errln("Got unexpected resource type in testtable32");
                }
            }
            if (number == parsedNumber) continue;
            this.errln("Did not get expected value in testtypes32 for key" + key + ". Expected: " + parsedNumber + " Got:" + number);
        }
        for (i = 0; i < arr.length; ++i) {
            item = bundle.get(arr[i].key);
            switch (item.getType()) {
                case 0: {
                    String value = item.getString();
                    number = UTF16.charAt((String)value, (int)0);
                    break;
                }
                case 7: {
                    number = item.getInt();
                    break;
                }
                default: {
                    this.errln("Got unexpected resource type in testtable32");
                }
            }
            if (number == arr[i].value) continue;
            this.errln("Did not get expected value in testtypes32 for key" + arr[i].key + ". Expected: " + arr[i].value + " Got:" + number);
        }
    }

    private static int parseTable32Key(String key) {
        int number = 0;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            number <<= 1;
            if (c != '1') continue;
            number |= 1;
        }
        return number;
    }

    public void TestAliases() {
        String s;
        String simpleAlias = "Open";
        UResourceBundle rb = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
        if (rb == null) {
            this.warnln("could not load testaliases data");
            return;
        }
        UResourceBundle sub = rb.get("simplealias");
        String s1 = sub.getString("simplealias");
        if (s1.equals(simpleAlias)) {
            this.logln("Alias mechanism works for simplealias");
        } else {
            this.errln("Did not get the expected output for simplealias");
        }
        try {
            rb = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
            sub = rb.get("nonexisting");
            this.errln("Did not get the expected exception for nonexisting");
        }
        catch (MissingResourceException ex) {
            this.logln("Alias mechanism works for nonexisting alias");
        }
        rb = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
        sub = rb.get("referencingalias");
        s1 = sub.getString();
        if (s1.equals("Hani")) {
            this.logln("Alias mechanism works for referencingalias");
        } else {
            this.errln("Did not get the expected output for referencingalias");
        }
        UResourceBundle rb1 = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
        if (rb1 != rb) {
            this.errln("Caching of the resource bundle failed");
        } else {
            this.logln("Caching of resource bundle passed");
        }
        sub = rb1.get("testGetStringByKeyAliasing");
        s1 = sub.get("KeyAlias0PST").getString();
        if (s1.equals("America/Los_Angeles")) {
            this.logln("Alias mechanism works for KeyAlias0PST");
        } else {
            this.errln("Did not get the expected output for KeyAlias0PST");
        }
        s1 = sub.getString("KeyAlias1PacificStandardTime");
        if (s1.equals("Pacific Standard Time")) {
            this.logln("Alias mechanism works for KeyAlias1PacificStandardTime");
        } else {
            this.errln("Did not get the expected output for KeyAlias1PacificStandardTime");
        }
        s1 = sub.getString("KeyAlias2PDT");
        if (s1.equals("PDT")) {
            this.logln("Alias mechanism works for KeyAlias2PDT");
        } else {
            this.errln("Did not get the expected output for KeyAlias2PDT");
        }
        s1 = sub.getString("KeyAlias3LosAngeles");
        if (s1.equals("Los Angeles")) {
            this.logln("Alias mechanism works for KeyAlias3LosAngeles. Got: " + s1);
        } else {
            this.errln("Did not get the expected output for KeyAlias3LosAngeles. Got: " + s1);
        }
        sub = rb.get("testGetStringByIndexAliasing");
        s1 = sub.getString(0);
        if (s1.equals("America/Los_Angeles")) {
            this.logln("Alias mechanism works for testGetStringByIndexAliasing/0. Got: " + s1);
        } else {
            this.errln("Did not get the expected output for testGetStringByIndexAliasing/0. Got: " + s1);
        }
        s1 = sub.getString(1);
        if (s1.equals("Pacific Standard Time")) {
            this.logln("Alias mechanism works for testGetStringByIndexAliasing/1");
        } else {
            this.errln("Did not get the expected output for testGetStringByIndexAliasing/1");
        }
        s1 = sub.getString(2);
        if (s1.equals("PDT")) {
            this.logln("Alias mechanism works for testGetStringByIndexAliasing/2");
        } else {
            this.errln("Did not get the expected output for testGetStringByIndexAliasing/2");
        }
        s1 = sub.getString(3);
        if (s1.equals("Los Angeles")) {
            this.logln("Alias mechanism works for testGetStringByIndexAliasing/3. Got: " + s1);
        } else {
            this.errln("Did not get the expected output for testGetStringByIndexAliasing/3. Got: " + s1);
        }
        UResourceBundle bundle = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"te");
        UResourceBundle table = bundle.get("tableT7996");
        try {
            s = table.getString("a7996");
            this.logln("Alias in nested table referring one in sh worked - " + s);
        }
        catch (MissingResourceException e) {
            this.errln("Alias in nested table referring one in sh failed");
        }
        try {
            s = ((ICUResourceBundle)table).getStringWithFallback("b7996");
            this.logln("Alias with /LOCALE/ in nested table in root referring back to another key in the current locale bundle worked - " + s);
        }
        catch (MissingResourceException e) {
            this.errln("Alias with /LOCALE/ in nested table in root referring back to another key in the current locale bundle failed");
        }
    }

    public void TestAlias() {
        this.logln("Testing %%ALIAS");
        UResourceBundle rb = UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (String)"iw_IL");
        UResourceBundle b = rb.get("NumberElements");
        if (b != null) {
            if (b.getSize() > 0) {
                this.logln("%%ALIAS mechanism works");
            } else {
                this.errln("%%ALIAS mechanism failed for iw_IL NumberElements");
            }
        } else {
            this.errln("%%ALIAS mechanism failed for iw_IL");
        }
    }

    public void TestXPathAlias() {
        String expResult;
        UResourceBundle rb = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"te_IN", (ClassLoader)testLoader);
        UResourceBundle b = rb.get("aliasClient");
        String result = b.getString();
        if (!result.equals(expResult = "correct")) {
            this.errln("Did not get the expected result for XPath style alias");
        }
        try {
            UResourceBundle c = rb.get("rootAliasClient");
            result = c.getString();
            expResult = "correct";
            if (!result.equals(expResult)) {
                this.errln("Did not get the expected result for XPath style alias for rootAliasClient");
            }
        }
        catch (MissingResourceException ex) {
            this.errln("Could not get rootAliasClient");
        }
    }

    public void TestCircularAliases() {
        try {
            UResourceBundle rb = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"testaliases", (ClassLoader)testLoader);
            UResourceBundle sub = rb.get("aaa");
            String s1 = sub.getString();
            if (s1 != null) {
                this.errln("Did not get the expected exception");
            }
        }
        catch (IllegalArgumentException ex) {
            this.logln("got expected exception for circular references");
        }
        catch (MissingResourceException ex) {
            this.warnln("could not load resource data: " + ex.getMessage());
        }
    }

    public void TestGetWithFallback() {
        String defaultWidth;
        String defaultContext;
        ICUResourceBundle b2;
        ICUResourceBundle b3;
        ICUResourceBundle b4;
        ICUResourceBundle b5;
        ICUResourceBundle bundle = null;
        bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (String)"fr_FR");
        ICUResourceBundle b1 = bundle.getWithFallback("calendar");
        String defaultCal = b1.getStringWithFallback("default");
        if (!defaultCal.equals("gregorian")) {
            this.errln("Did not get the expected default calendar string: Expected: gregorian, Got: " + defaultCal);
        }
        if ((b5 = (b4 = (b3 = (b2 = b1.getWithFallback(defaultCal)).getWithFallback("monthNames")).getWithFallback(defaultContext = b3.getStringWithFallback("default"))).getWithFallback(defaultWidth = b4.getStringWithFallback("default"))).getSize() != 12) {
            this.errln("Did not get the expected size for the default monthNames");
        }
    }

    public void TestLocaleDisplayNames() {
        ULocale[] locales = ULocale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!ICUResourceBundleTest.hasLocalizedCountryFor(ULocale.ENGLISH, locales[i]) && locales[i].getLanguage().compareTo("ti") != 0) {
                this.errln("Could not get localized country for " + locales[i]);
            }
            if (!ICUResourceBundleTest.hasLocalizedLanguageFor(ULocale.ENGLISH, locales[i])) {
                this.errln("Could not get localized language for " + locales[i]);
            }
            if (!ICUResourceBundleTest.hasLocalizedCountryFor(locales[i], locales[i]) && locales[i].getLanguage().compareTo("ti") != 0 && locales[i].getBaseName().compareTo("nl_CW") != 0 && locales[i].getBaseName().compareTo("nl_SX") != 0) {
                this.errln("Could not get localized country for " + locales[i]);
                ICUResourceBundleTest.hasLocalizedCountryFor(locales[i], locales[i]);
            }
            if (!ICUResourceBundleTest.hasLocalizedLanguageFor(locales[i], locales[i]) && locales[i].getLanguage().compareTo("nmg") != 0) {
                this.errln("Could not get localized language for " + locales[i]);
            }
            this.logln(locales[i] + "\t" + locales[i].getDisplayName(ULocale.ENGLISH) + "\t" + locales[i].getDisplayName(locales[i]));
        }
    }

    private static boolean hasLocalizedLanguageFor(ULocale locale, ULocale otherLocale) {
        String localizedVersion;
        String lang = otherLocale.getLanguage();
        return !lang.equals(localizedVersion = otherLocale.getDisplayLanguage(locale));
    }

    private static boolean hasLocalizedCountryFor(ULocale locale, ULocale otherLocale) {
        String country = otherLocale.getCountry();
        if (country.equals("")) {
            return true;
        }
        String localizedVersion = otherLocale.getDisplayCountry(locale);
        return !country.equals(localizedVersion);
    }

    public void TestFunctionalEquivalent() {
        String[] calCases = new String[]{"t", "en_US_POSIX", "en@calendar=gregorian", "f", "ja_JP_TOKYO", "ja@calendar=gregorian", "f", "ja_JP_TOKYO@calendar=japanese", "ja@calendar=japanese", "t", "sr@calendar=gregorian", "sr@calendar=gregorian", "t", "en", "en@calendar=gregorian", "t", "th_TH", "th@calendar=buddhist", "t", "th_TH@calendar=gregorian", "th@calendar=gregorian", "f", "th_TH_Bangkok", "th@calendar=buddhist"};
        this.logln("Testing functional equivalents for calendar...");
        this.getFunctionalEquivalentTestCases("com/ibm/icu/impl/data/icudt50b", Calendar.class.getClassLoader(), "calendar", "calendar", false, calCases);
        this.logln("Testing error conditions:");
        try {
            ClassLoader cl = BreakIterator.class.getClassLoader();
            ICUResourceBundle.getFunctionalEquivalent((String)"com/ibm/icu/impl/data/icudt50b/brkitr", (ClassLoader)cl, (String)"calendar", (String)"calendar", (ULocale)new ULocale("ar_EG@calendar=islamic"), (boolean[])new boolean[1], (boolean)true);
            this.errln("Err: expected MissingResourceException");
        }
        catch (MissingResourceException t) {
            this.logln("expected MissingResourceException caught (PASS): " + t.toString());
        }
    }

    private void getFunctionalEquivalentTestCases(String path, ClassLoader cl, String resName, String keyword, boolean truncate, String[] testCases) {
        String T_STR = "t";
        boolean[] isAvail = new boolean[1];
        this.logln("Testing functional equivalents...");
        for (int i = 0; i < testCases.length; i += 3) {
            boolean expectAvail = T_STR.equals(testCases[i + 0]);
            ULocale inLocale = new ULocale(testCases[i + 1]);
            ULocale expectLocale = new ULocale(testCases[i + 2]);
            this.logln(new Integer(i / 3).toString() + ": " + new Boolean(expectAvail).toString() + "\t\t" + inLocale.toString() + "\t\t" + expectLocale.toString());
            ULocale equivLocale = ICUResourceBundle.getFunctionalEquivalent((String)path, (ClassLoader)cl, (String)resName, (String)keyword, (ULocale)inLocale, (boolean[])isAvail, (boolean)truncate);
            boolean gotAvail = isAvail[0];
            if (gotAvail == expectAvail && equivLocale.equals((Object)expectLocale)) continue;
            this.errln(new Integer(i / 3).toString() + ":  Error, expected  Equiv=" + new Boolean(expectAvail).toString() + "\t\t" + inLocale.toString() + "\t\t--> " + expectLocale.toString() + ",  but got " + new Boolean(gotAvail).toString() + " " + equivLocale.toString());
        }
    }

    public void TestNorwegian() {
        try {
            UResourceBundle rb = UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b/region", (String)"no_NO_NY");
            UResourceBundle sub = rb.get("Countries");
            String s1 = sub.getString("NO");
            if (s1.equals("Noreg")) {
                this.logln("got expected output ");
            } else {
                this.errln("did not get the expected result");
            }
        }
        catch (IllegalArgumentException ex) {
            this.errln("Caught an unexpected expected");
        }
    }

    public void TestJB4102() {
        try {
            ICUResourceBundle root = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (String)"root");
            ICUResourceBundle t = null;
            try {
                t = root.getWithFallback("calendar/islamic-civil/eras/abbreviated/0/mikimaus/pera");
                this.errln("Second resource does not exist. How did it get here?\n");
            }
            catch (MissingResourceException ex) {
                this.logln("Got the expected exception");
            }
            if (t != null) {
                this.errln("t is not null!");
            }
        }
        catch (MissingResourceException e) {
            this.warnln("Could not load the locale data: " + e.getMessage());
        }
    }

    public void TestCLDRStyleAliases() {
        String result = null;
        Object expected = null;
        String[] expects = new String[]{"", "a41", "a12", "a03", "ar4"};
        this.logln("Testing CLDR style aliases......\n");
        UResourceBundle rb = UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"te_IN_REVISED", (ClassLoader)testLoader);
        ICUResourceBundle alias = (ICUResourceBundle)rb.get("a");
        for (int i = 1; i < 5; ++i) {
            String resource = "a" + i;
            ICUResourceBundle a = alias.getWithFallback(resource);
            result = a.getString();
            if (!result.equals(expected)) continue;
            this.errln("CLDR style aliases failed resource with name " + resource + "resource, exp " + expects[i] + " , got " + result);
        }
    }

    private String getLSString(int status) {
        switch (status) {
            case 1: {
                return "FROM_FALLBACK";
            }
            case 3: {
                return "FROM_DEFAULT";
            }
            case 2: {
                return "FROM_ROOT";
            }
            case 4: {
                return "FROM_LOCALE";
            }
        }
        return "UNKNOWN";
    }

    private void assertEqualLoadingStatus(String msg, int target, int result) {
        if (result != target) {
            this.errln(msg + " expected: " + this.getLSString(target) + " got: " + this.getLSString(result));
        }
    }

    private void assertDefaultLoadingStatus(String msg, int result) {
        this.assertEqualLoadingStatus(msg, 3, result);
    }

    private void assertFallbackLoadingStatus(String msg, int result) {
        this.assertEqualLoadingStatus(msg, 1, result);
    }

    private void assertRootLoadingStatus(String msg, int result) {
        this.assertEqualLoadingStatus(msg, 2, result);
    }

    private void assertLocaleLoadingStatus(String msg, int result) {
        this.assertEqualLoadingStatus(msg, 4, result);
    }

    public void TestLoadingStatus() {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (String)"yi_IL");
        this.assertDefaultLoadingStatus("base/yi_IL", bundle.getLoadingStatus());
        bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (String)"eo_DE");
        this.assertFallbackLoadingStatus("base/eo_DE", bundle.getLoadingStatus());
        this.logln("Test to verify loading status of get(String)");
        bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b/lang", (String)"zh_Hant_TW");
        ICUResourceBundle countries = (ICUResourceBundle)bundle.get("Languages");
        this.assertFallbackLoadingStatus("lang/Languages/zh_Hant_TW", countries.getLoadingStatus());
        this.logln("Test to verify loading status of get(int)");
        bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (String)"te_IN");
        ICUResourceBundle ms = (ICUResourceBundle)bundle.get("MeasurementSystem");
        this.assertRootLoadingStatus("base/MeasurementSystem/te_IN", ms.getLoadingStatus());
        this.logln("Test to verify loading status of getwithFallback");
        bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/dev/data/testdata", (String)"sh_YU", (ClassLoader)testLoader);
        ICUResourceBundle temp = bundle.getWithFallback("a/a2");
        this.assertLocaleLoadingStatus("testdata/a/a2/sh_YU", temp.getLoadingStatus());
        temp = bundle.getWithFallback("a/a1");
        this.assertFallbackLoadingStatus("testdata/a/a1/sh_YU", temp.getLoadingStatus());
        temp = bundle.getWithFallback("a/a4");
        this.assertRootLoadingStatus("testdata/a/a4/sh_YU", temp.getLoadingStatus());
    }

    public void TestCoverage() {
        Stub stub;
        UResourceBundle bundle = UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b");
        if (bundle == null) {
            this.errln("UResourceBundle.getBundleInstance(String baseName) failed");
        }
        bundle = null;
        bundle = UResourceBundle.getBundleInstance((ULocale)ULocale.getDefault());
        if (bundle == null) {
            this.errln("UResourceBundle.getBundleInstance(ULocale) failed");
            return;
        }
        if (new UResourceTypeMismatchException("coverage") == null) {
            this.errln("Create UResourceTypeMismatchException error");
        }
        class Stub
        extends UResourceBundle {
            Stub() {
            }

            public ULocale getULocale() {
                return ULocale.ROOT;
            }

            protected String getLocaleID() {
                return null;
            }

            protected String getBaseName() {
                return null;
            }

            protected UResourceBundle getParent() {
                return null;
            }

            protected void setLoadingStatus(int newStatus) {
            }

            public Enumeration getKeys() {
                return null;
            }

            protected Object handleGetObject(String aKey) {
                return null;
            }
        }
        if (!(stub = new Stub()).getLocale().equals(ULocale.ROOT.toLocale())) {
            this.errln("UResourceBundle.getLoclae(Locale) should delegate to (ULocale)");
        }
    }

    public void TestJavaULocaleBundleLoading() {
        UResourceBundle bundle4;
        UResourceBundle bundle3;
        UResourceBundle bundle2;
        UResourceBundle bundle1;
        String fromEnLatnUs;
        String fromEnLatn;
        String fromEn;
        String baseName = "com.ibm.icu.dev.data.resources.TestDataElements";
        String locName = "en_Latn_US";
        UResourceBundle bundle = UResourceBundle.getBundleInstance((String)baseName, (String)locName, (ClassLoader)testLoader);
        String fromRoot = bundle.getString("from_root");
        if (!fromRoot.equals("This data comes from root")) {
            this.errln("Did not get the expected string for from_root");
        }
        if (!(fromEn = bundle.getString("from_en")).equals("This data comes from en")) {
            this.errln("Did not get the expected string for from_en");
        }
        if (!(fromEnLatn = bundle.getString("from_en_Latn")).equals("This data comes from en_Latn")) {
            this.errln("Did not get the expected string for from_en_Latn");
        }
        if (!(fromEnLatnUs = bundle.getString("from_en_Latn_US")).equals("This data comes from en_Latn_US")) {
            this.errln("Did not get the expected string for from_en_Latn_US");
        }
        if (!(bundle1 = UResourceBundle.getBundleInstance((String)baseName, (ULocale)new ULocale(locName), (ClassLoader)testLoader)).equals(bundle)) {
            this.errln("Did not get the expected bundle for " + baseName + "." + locName);
        }
        if (bundle1 != bundle) {
            this.errln("Did not load the bundle from cache");
        }
        if (!(bundle2 = UResourceBundle.getBundleInstance((String)baseName, (String)"en_IN", (ClassLoader)testLoader)).getLocale().toString().equals("en")) {
            this.errln("Did not get the expected fallback locale. Expected: en Got: " + bundle2.getLocale().toString());
        }
        if (!(bundle3 = UResourceBundle.getBundleInstance((String)baseName, (String)"te_IN", (ClassLoader)testLoader)).getLocale().toString().equals("te")) {
            this.errln("Did not get the expected fallback locale. Expected: te Got: " + bundle2.getLocale().toString());
        }
        UResourceBundle defaultBundle = UResourceBundle.getBundleInstance((String)baseName, (String)"hi_IN", (ClassLoader)testLoader);
        ULocale defaultLocale = ULocale.getDefault();
        if (!defaultBundle.getULocale().equals((Object)defaultLocale)) {
            this.errln("Did not get the default bundle for non-existent bundle");
        }
        ULocale.setDefault((ULocale)ULocale.CANADA_FRENCH);
        UResourceBundle root = UResourceBundle.getBundleInstance((String)baseName, (String)"hi_IN", (ClassLoader)testLoader);
        if (!root.getULocale().toString().equals("")) {
            this.errln("Did not get the root bundle for non-existent default bundle for non-existent bundle");
        }
        ULocale.setDefault((ULocale)defaultLocale);
        Enumeration keys = bundle.getKeys();
        int i = 0;
        while (keys.hasMoreElements()) {
            this.logln("key: " + keys.nextElement());
            ++i;
        }
        if (i != 4) {
            this.errln("Did not get the expected number of keys: got " + i + ", expected 4");
        }
        if ((bundle4 = UResourceBundle.getBundleInstance((String)baseName, (String)"fr_Latn_FR", (ClassLoader)testLoader)) == null) {
            this.errln("Could not load bundle fr_Latn_FR");
        }
    }

    public void TestAliasFallback() {
        try {
            ULocale loc = new ULocale("en_US");
            ICUResourceBundle b = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (ULocale)loc);
            ICUResourceBundle b1 = b.getWithFallback("calendar/hebrew/monthNames/format/abbreviated");
            if (b1 != null) {
                this.logln("loaded data for abbreviated month names: " + b1.getKey());
            }
        }
        catch (MissingResourceException ex) {
            this.warnln("Failed to load data for abbreviated month names");
        }
    }

    private Set<String> setFromEnumeration(Enumeration<String> e) {
        TreeSet<String> set = new TreeSet<String>();
        while (e.hasMoreElements()) {
            set.add(e.nextElement());
        }
        return set;
    }

    public void TestICUGetKeysAtTopLevel() {
        String baseName = "com/ibm/icu/dev/data/testdata";
        UResourceBundle te_IN = UResourceBundle.getBundleInstance((String)baseName, (String)"te_IN", (ClassLoader)testLoader);
        UResourceBundle te = UResourceBundle.getBundleInstance((String)baseName, (String)"te", (ClassLoader)testLoader);
        Set<String> te_set = this.setFromEnumeration(te.getKeys());
        Set<String> te_IN_set = this.setFromEnumeration(te_IN.getKeys());
        this.assertTrue("te.getKeys().contains(string_only_in_Root)", te_set.contains("string_only_in_Root"));
        this.assertTrue("te.getKeys().contains(string_only_in_te)", te_set.contains("string_only_in_te"));
        this.assertFalse("te.getKeys().contains(string_only_in_te_IN)", te_set.contains("string_only_in_te_IN"));
        this.assertTrue("te_IN.getKeys().contains(string_only_in_Root)", te_IN_set.contains("string_only_in_Root"));
        this.assertTrue("te_IN.getKeys().contains(string_only_in_te)", te_IN_set.contains("string_only_in_te"));
        this.assertTrue("te_IN.getKeys().contains(string_only_in_te_IN)", te_IN_set.contains("string_only_in_te_IN"));
    }

    public void TestICUGetKeysForResourceItem() {
        String baseName = "com/ibm/icu/dev/data/testdata";
        UResourceBundle te = UResourceBundle.getBundleInstance((String)baseName, (String)"te", (ClassLoader)testLoader);
        UResourceBundle tagged_array_in_Root_te = te.get("tagged_array_in_Root_te");
        Set<String> keys = this.setFromEnumeration(tagged_array_in_Root_te.getKeys());
        this.assertTrue("tagged_array_in_Root_te.getKeys().contains(tag0)", keys.contains("tag0"));
        this.assertTrue("tagged_array_in_Root_te.getKeys().contains(tag1)", keys.contains("tag1"));
        this.assertFalse("tagged_array_in_Root_te.getKeys().contains(tag7)", keys.contains("tag7"));
        this.assertFalse("tagged_array_in_Root_te.getKeys().contains(tag12)", keys.contains("tag12"));
        UResourceBundle array_in_Root_te = te.get("array_in_Root_te");
        this.assertFalse("array_in_Root_te.getKeys().hasMoreElements()", array_in_Root_te.getKeys().hasMoreElements());
        UResourceBundle string_in_Root_te = te.get("string_in_Root_te");
        this.assertFalse("string_in_Root_te.getKeys().hasMoreElements()", string_in_Root_te.getKeys().hasMoreElements());
    }

    public void TestT6844() {
        try {
            UResourceBundle rb1 = UResourceBundle.getBundleInstance((String)"com.ibm.icu.dev.data.resources.TestMessages");
            this.assertEquals("bundleContainer in TestMessages", "TestMessages.class", rb1.getString("bundleContainer"));
            UResourceBundle rb2 = UResourceBundle.getBundleInstance((String)"com.ibm.icu.dev.data.resources.testmessages");
            this.assertEquals("bundleContainer in testmessages", "testmessages.properties", rb2.getString("bundleContainer"));
        }
        catch (Throwable t) {
            this.errln(t.getMessage());
        }
    }

    public void TestUResourceBundleCoverage() {
        UResourceBundle rb7;
        Locale locale = null;
        ULocale ulocale = null;
        String baseName = null;
        UResourceBundle rb1 = UResourceBundle.getBundleInstance(ulocale);
        UResourceBundle rb2 = UResourceBundle.getBundleInstance(baseName);
        UResourceBundle rb3 = UResourceBundle.getBundleInstance(baseName, ulocale);
        UResourceBundle rb4 = UResourceBundle.getBundleInstance(baseName, locale);
        UResourceBundle rb5 = UResourceBundle.getBundleInstance(baseName, ulocale, (ClassLoader)this.getClass().getClassLoader());
        UResourceBundle rb6 = UResourceBundle.getBundleInstance(baseName, locale, (ClassLoader)this.getClass().getClassLoader());
        try {
            rb7 = UResourceBundle.getBundleInstance((String)"bogus", (Locale)Locale.getDefault(), (ClassLoader)this.getClass().getClassLoader());
            this.errln("Should have thrown exception with bogus baseName.");
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (rb1 == null || rb2 == null || rb3 == null || rb4 == null || rb5 == null || rb6 == null) {
            this.errln("Error getting resource bundle.");
        }
        rb7 = UResourceBundle.getBundleInstance((String)"com.ibm.icu.dev.data.resources.TestDataElements");
        UResourceBundle.resetBundleCache();
        try {
            rb1.getBinary();
            this.errln("getBinary() call should have thrown UResourceTypeMismatchException.");
        }
        catch (UResourceTypeMismatchException ex) {
            // empty catch block
        }
        try {
            rb1.getStringArray();
            this.errln("getStringArray() call should have thrown UResourceTypeMismatchException.");
        }
        catch (UResourceTypeMismatchException ex) {
            // empty catch block
        }
        try {
            byte[] ba = new byte[]{0};
            rb1.getBinary(ba);
            this.errln("getBinary(byte[]) call should have thrown UResourceTypeMismatchException.");
        }
        catch (UResourceTypeMismatchException ex) {
            // empty catch block
        }
        try {
            rb1.getInt();
            this.errln("getInt() call should have thrown UResourceTypeMismatchException.");
        }
        catch (UResourceTypeMismatchException ex) {
            // empty catch block
        }
        try {
            rb1.getIntVector();
            this.errln("getIntVector() call should have thrown UResourceTypeMismatchException.");
        }
        catch (UResourceTypeMismatchException ex) {
            // empty catch block
        }
        try {
            rb1.getUInt();
            this.errln("getUInt() call should have thrown UResourceTypeMismatchException.");
        }
        catch (UResourceTypeMismatchException ex) {
            // empty catch block
        }
        if (rb1.getVersion() != null) {
            this.errln("getVersion() call should have returned null.");
        }
        if (rb7.getType() != -1) {
            this.errln("getType() call should have returned NONE.");
        }
        if (rb7.getKey() != null) {
            this.errln("getKey() call should have returned null.");
        }
        if (((ICUResourceBundle)rb1).getResPath() == null) {
            this.errln("Error calling getResPath().");
        }
        if (((ICUResourceBundle)rb1).findTopLevel(0) == null) {
            this.errln("Error calling findTopLevel().");
        }
        if (ICUResourceBundle.getFullLocaleNameSet() == null) {
            this.errln("Error calling getFullLocaleNameSet().");
        }
        UResourceBundleIterator itr = rb1.getIterator();
        while (itr.hasNext()) {
            itr.next();
        }
        try {
            itr.next();
            this.errln("NoSuchElementException exception should have been thrown.");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            itr.nextString();
            this.errln("NoSuchElementException exception should have been thrown.");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
    }

    private static final class TestCase {
        String key;
        int value;

        TestCase(String key, int value) {
            this.key = key;
            this.value = value;
        }
    }
}

