/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.HashMap;

public class LocaleAliasTest
extends TestFmwk {
    private static final ULocale[][] _LOCALES = new ULocale[][]{{new ULocale("en", "RH"), new ULocale("en", "ZW")}, {new ULocale("in"), new ULocale("id")}, {new ULocale("in", "ID"), new ULocale("id", "ID")}, {new ULocale("iw"), new ULocale("he")}, {new ULocale("iw", "IL"), new ULocale("he", "IL")}, {new ULocale("ji"), new ULocale("yi")}, {new ULocale("en", "BU"), new ULocale("en", "MM")}, {new ULocale("en", "DY"), new ULocale("en", "BJ")}, {new ULocale("en", "HV"), new ULocale("en", "BF")}, {new ULocale("en", "NH"), new ULocale("en", "VU")}, {new ULocale("en", "TP"), new ULocale("en", "TL")}, {new ULocale("en", "ZR"), new ULocale("en", "CD")}};
    private static final int _LOCALE_NUMBER = _LOCALES.length;
    private static ULocale[] available = null;
    private HashMap availableMap = new HashMap();
    private static final ULocale _DEFAULT_LOCALE = ULocale.US;

    protected void init() {
        available = ULocale.getAvailableLocales();
        for (int i = 0; i < available.length; ++i) {
            this.availableMap.put(available[i].toString(), "");
        }
    }

    public static void main(String[] args) {
        new LocaleAliasTest().run(args);
    }

    public void TestCalendar() {
        ULocale defLoc = ULocale.getDefault();
        ULocale.setDefault((ULocale)_DEFAULT_LOCALE);
        for (int i = 0; i < _LOCALE_NUMBER; ++i) {
            ULocale oldLoc = _LOCALES[i][0];
            ULocale newLoc = _LOCALES[i][1];
            if (this.availableMap.get(_LOCALES[i][1]) == null) {
                this.logln(_LOCALES[i][1] + " is not available. Skipping!");
                continue;
            }
            Calendar c1 = Calendar.getInstance((ULocale)oldLoc);
            Calendar c2 = Calendar.getInstance((ULocale)newLoc);
            c1.setTime(c2.getTime());
            ULocale l1 = c1.getLocale(ULocale.VALID_LOCALE);
            ULocale l2 = c2.getLocale(ULocale.VALID_LOCALE);
            if (!newLoc.equals((Object)l1)) {
                this.errln("CalendarTest: newLoc!=l1: newLoc= " + newLoc + " l1= " + l1);
            }
            if (!l1.equals((Object)l2)) {
                this.errln("CalendarTest: l1!=l2: l1= " + l1 + " l2= " + l2);
            }
            if (!c1.equals((Object)c2)) {
                this.errln("CalendarTest: c1!=c2.  newLoc= " + newLoc + " oldLoc= " + oldLoc);
            }
            this.logln("Calendar(getLocale) old:" + l1 + "   new:" + l2);
        }
        ULocale.setDefault((ULocale)defLoc);
    }

    public void TestDateFormat() {
        ULocale defLoc = ULocale.getDefault();
        ULocale.setDefault((ULocale)_DEFAULT_LOCALE);
        for (int i = 0; i < _LOCALE_NUMBER; ++i) {
            ULocale oldLoc = _LOCALES[i][0];
            ULocale newLoc = _LOCALES[i][1];
            if (this.availableMap.get(_LOCALES[i][1]) == null) {
                this.logln(_LOCALES[i][1] + " is not available. Skipping!");
                continue;
            }
            DateFormat df1 = DateFormat.getDateInstance((int)0, (ULocale)oldLoc);
            DateFormat df2 = DateFormat.getDateInstance((int)0, (ULocale)newLoc);
            ULocale l1 = df1.getLocale(ULocale.VALID_LOCALE);
            ULocale l2 = df2.getLocale(ULocale.VALID_LOCALE);
            if (!newLoc.equals((Object)l1)) {
                this.errln("DateFormatTest: newLoc!=l1: newLoc= " + newLoc + " l1= " + l1);
            }
            if (!l1.equals((Object)l2)) {
                this.errln("DateFormatTest: l1!=l2: l1= " + l1 + " l2= " + l2);
            }
            if (!df1.equals((Object)df2)) {
                this.errln("DateFormatTest: df1!=df2: newLoc= " + newLoc + " oldLoc= " + oldLoc);
            }
            this.logln("DateFormat(getLocale) old:" + l1 + "   new:" + l2);
        }
        ULocale.setDefault((ULocale)defLoc);
    }

    public void TestULocale() {
        ULocale defLoc = ULocale.getDefault();
        ULocale.setDefault((ULocale)_DEFAULT_LOCALE);
        for (int i = 0; i < _LOCALE_NUMBER; ++i) {
            String name2;
            ULocale oldLoc = _LOCALES[i][0];
            ULocale newLoc = _LOCALES[i][1];
            if (this.availableMap.get(_LOCALES[i][1]) == null) {
                this.logln(_LOCALES[i][1] + " is not available. Skipping!");
                continue;
            }
            ULocale ul1 = new ULocale(oldLoc.toString());
            ULocale ul2 = new ULocale(newLoc.toString());
            String name1 = ul1.getDisplayName();
            if (!name1.equals(name2 = ul2.getDisplayName())) {
                this.errln("name1!=name2. name1 = " + name1 + " name2 = " + name2);
            }
            this.logln("ULocale(getDisplayName) old:" + name1 + "   new:" + name2);
        }
        ULocale.setDefault((ULocale)defLoc);
    }

    public void TestDisplayName() {
        ULocale defLoc = ULocale.getDefault();
        ULocale.setDefault((ULocale)_DEFAULT_LOCALE);
        for (int i = 0; i < _LOCALE_NUMBER; ++i) {
            ULocale oldLoc = _LOCALES[i][0];
            ULocale newLoc = _LOCALES[i][1];
            for (int j = 0; j < available.length; ++j) {
                String oldCountry = oldLoc.getDisplayCountry(available[j]);
                String newCountry = newLoc.getDisplayCountry(available[j]);
                String oldLang = oldLoc.getDisplayLanguage(available[j]);
                String newLang = newLoc.getDisplayLanguage(available[j]);
                if (!newCountry.equals(newLoc.getCountry()) && !oldCountry.equals(newCountry)) {
                    this.errln("getCountry() failed for " + oldLoc + " oldCountry= " + LocaleAliasTest.prettify(oldCountry) + " newCountry = " + LocaleAliasTest.prettify(newCountry) + " in display locale " + available[j].toString());
                }
                if (newLang.equals(newLoc.getLanguage()) || oldLang.equals(newLang)) continue;
                this.errln("getLanguage() failed for " + oldLoc + " oldLang = " + LocaleAliasTest.prettify(oldLang) + " newLang = " + LocaleAliasTest.prettify(newLang) + " in display locale " + available[j].toString());
            }
        }
        ULocale.setDefault((ULocale)defLoc);
    }

    public void TestUResourceBundle() {
        ULocale defLoc = ULocale.getDefault();
        ULocale.setDefault((ULocale)_DEFAULT_LOCALE);
        for (int i = 0; i < _LOCALE_NUMBER; ++i) {
            if (this.availableMap.get(_LOCALES[i][1]) == null) {
                this.logln(_LOCALES[i][1] + " is not available. Skipping!");
                continue;
            }
            ULocale oldLoc = _LOCALES[i][0];
            ULocale newLoc = _LOCALES[i][1];
            UResourceBundle urb1 = null;
            UResourceBundle urb2 = null;
            urb1 = UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (ULocale)oldLoc);
            urb2 = UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt50b", (ULocale)newLoc);
            ULocale l1 = urb1.getULocale();
            ULocale l2 = urb2.getULocale();
            if (!newLoc.equals((Object)l1)) {
                this.errln("ResourceBundleTest: newLoc!=l1: newLoc= " + newLoc + " l1= " + l1);
            }
            if (!l1.equals((Object)l2)) {
                this.errln("ResourceBundleTest: l1!=l2: l1= " + l1 + " l2= " + l2);
            }
            this.logln("UResourceBundle old:" + l1 + "   new:" + l2);
        }
        ULocale.setDefault((ULocale)defLoc);
    }
}

