/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.util.IllformedLocaleException;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;

public class LocaleBuilderTest
extends TestFmwk {
    public static void main(String[] args) throws Exception {
        new LocaleBuilderTest().run(args);
    }

    public void TestLocaleBuilder() {
        String[][] TESTCASE = new String[][]{{"L", "en", "R", "us", "T", "en-US", "en_US"}, {"L", "en", "R", "CA", "L", null, "T", "und-CA", "_CA"}, {"L", "en", "R", "CA", "L", "", "T", "und-CA", "_CA"}, {"L", "en", "R", "FR", "L", "fr", "T", "fr-FR", "fr_FR"}, {"L", "123", "X"}, {"R", "us", "T", "und-US", "_US"}, {"R", "usa", "X"}, {"R", "123", "L", "it", "R", null, "T", "it", "it"}, {"R", "123", "L", "it", "R", "", "T", "it", "it"}, {"R", "123", "L", "en", "T", "en-123", "en_123"}, {"S", "LATN", "L", "DE", "T", "de-Latn", "de_Latn"}, {"L", "De", "S", "latn", "R", "de", "S", "", "T", "de-DE", "de_DE"}, {"L", "De", "S", "latn", "R", "de", "S", null, "T", "de-DE", "de_DE"}, {"S", "latin", "X"}, {"V", "1234", "L", "en", "T", "en-1234", "en__1234"}, {"V", "1234", "L", "en", "V", "5678", "T", "en-5678", "en__5678"}, {"V", "1234", "L", "en", "V", null, "T", "en", "en"}, {"V", "1234", "L", "en", "V", "", "T", "en", "en"}, {"V", "123", "X"}, {"U", "en_US", "T", "en-US", "en_US"}, {"U", "en_US_WIN", "X"}, {"B", "fr-FR-1606nict-u-ca-gregory-x-test", "T", "fr-FR-1606nict-u-ca-gregory-x-test", "fr_FR_1606NICT@calendar=gregorian;x=test"}, {"B", "ab-cde-fghij", "T", "cde-fghij", "cde__FGHIJ"}, {"B", "und-CA", "T", "und-CA", "_CA"}, {"B", "en-US-x-test-lvariant-var", "T", "en-US-x-test-lvariant-var", "en_US_VAR@x=test"}, {"B", "en-US-VAR", "X"}, {"U", "ja_JP@calendar=japanese;currency=JPY", "L", "ko", "T", "ko-JP-u-ca-japanese-cu-jpy", "ko_JP@calendar=japanese;currency=jpy"}, {"U", "ja_JP@calendar=japanese;currency=JPY", "K", "ca", null, "T", "ja-JP-u-cu-jpy", "ja_JP@currency=jpy"}, {"U", "ja_JP@calendar=japanese;currency=JPY", "E", "u", "attr1-ca-gregory", "T", "ja-JP-u-attr1-ca-gregory", "ja_JP@attribute=attr1;calendar=gregorian"}, {"U", "en@colnumeric=yes", "K", "kn", "", "T", "en-u-kn-true", "en@colnumeric=yes"}, {"L", "th", "R", "th", "K", "nu", "thai", "T", "th-TH-u-nu-thai", "th_TH@numbers=thai"}, {"U", "zh_Hans", "R", "sg", "K", "ca", "badcalendar", "X"}, {"U", "zh_Hans", "R", "sg", "K", "cal", "gregory", "X"}, {"E", "z", "ExtZ", "L", "en", "T", "en-z-extz", "en@z=extz"}, {"E", "z", "ExtZ", "L", "en", "E", "z", "", "T", "en", "en"}, {"E", "z", "ExtZ", "L", "en", "E", "z", null, "T", "en", "en"}, {"E", "a", "x", "X"}, {"E", "a", "abc_def", "T", "und-a-abc-def", "@a=abc-def"}, {"L", "en", "E", "u", "bbb-aaa-00", "T", "en-u-aaa-bbb-00-yes", "en@00=yes;attribute=aaa-bbb"}, {"L", "fr", "R", "FR", "P", "Yoshito-ICU", "T", "fr-FR-x-yoshito-icu", "fr_FR@x=yoshito-icu"}, {"L", "ja", "R", "jp", "K", "ca", "japanese", "T", "ja-JP-u-ca-japanese", "ja_JP@calendar=japanese"}, {"K", "co", "PHONEBK", "K", "ca", "gregory", "L", "De", "T", "de-u-ca-gregory-co-phonebk", "de@calendar=gregorian;collation=phonebook"}, {"E", "o", "OPQR", "E", "a", "aBcD", "T", "und-a-abcd-o-opqr", "@a=abcd;o=opqr"}, {"E", "u", "nu-thai-ca-gregory", "L", "TH", "T", "th-u-ca-gregory-nu-thai", "th@calendar=gregorian;numbers=thai"}, {"L", "en", "K", "tz", "usnyc", "R", "US", "T", "en-US-u-tz-usnyc", "en_US@timezone=America/New_York"}, {"L", "de", "K", "co", "phonebk", "K", "ks", "level1", "K", "kk", "true", "T", "de-u-co-phonebk-kk-true-ks-level1", "de@collation=phonebook;colnormalization=yes;colstrength=primary"}, {"L", "en", "R", "US", "K", "ca", "gregory", "T", "en-US-u-ca-gregory", "en_US@calendar=gregorian"}, {"L", "en", "R", "US", "K", "cal", "gregory", "X"}, {"L", "en", "R", "US", "K", "ca", "gregorian", "X"}, {"L", "en", "R", "US", "K", "kn", "", "T", "en-US-u-kn-true", "en_US@colnumeric=yes"}, {"B", "de-DE-u-co-phonebk", "C", "L", "pt", "T", "pt", "pt"}, {"B", "ja-jp-u-ca-japanese", "N", "T", "ja-JP", "ja_JP"}, {"B", "es-u-def-abc-co-trad", "A", "hij", "D", "def", "T", "es-u-abc-hij-co-trad", "es@attribute=abc-hij;collation=traditional"}, {"B", "es-u-def-abc-co-trad", "A", "hij", "D", "def", "D", "def", "T", "es-u-abc-hij-co-trad", "es@attribute=abc-hij;collation=traditional"}, {"L", "en", "A", "aa", "X"}, {"B", "fr-u-attr1-cu-eur", "D", "attribute1", "X"}};
        ULocale.Builder bld_st = new ULocale.Builder();
        for (int tidx = 0; tidx < TESTCASE.length; ++tidx) {
            ULocale loc1;
            String langtag;
            int i = 0;
            String[] expected = null;
            ULocale.Builder bld = bld_st;
            bld.clear();
            while (true) {
                String method = TESTCASE[tidx][i++];
                try {
                    String key;
                    if (method.equals("L")) {
                        bld.setLanguage(TESTCASE[tidx][i++]);
                        continue;
                    }
                    if (method.equals("S")) {
                        bld.setScript(TESTCASE[tidx][i++]);
                        continue;
                    }
                    if (method.equals("R")) {
                        bld.setRegion(TESTCASE[tidx][i++]);
                        continue;
                    }
                    if (method.equals("V")) {
                        bld.setVariant(TESTCASE[tidx][i++]);
                        continue;
                    }
                    if (method.equals("K")) {
                        key = TESTCASE[tidx][i++];
                        String type = TESTCASE[tidx][i++];
                        bld.setUnicodeLocaleKeyword(key, type);
                        continue;
                    }
                    if (method.equals("A")) {
                        bld.addUnicodeLocaleAttribute(TESTCASE[tidx][i++]);
                        continue;
                    }
                    if (method.equals("E")) {
                        key = TESTCASE[tidx][i++];
                        String value = TESTCASE[tidx][i++];
                        bld.setExtension(key.charAt(0), value);
                        continue;
                    }
                    if (method.equals("P")) {
                        bld.setExtension('x', TESTCASE[tidx][i++]);
                        continue;
                    }
                    if (method.equals("U")) {
                        bld.setLocale(new ULocale(TESTCASE[tidx][i++]));
                        continue;
                    }
                    if (method.equals("B")) {
                        bld.setLanguageTag(TESTCASE[tidx][i++]);
                        continue;
                    }
                    if (method.equals("C")) {
                        bld.clear();
                        continue;
                    }
                    if (method.equals("N")) {
                        bld.clearExtensions();
                        continue;
                    }
                    if (method.equals("D")) {
                        bld.removeUnicodeLocaleAttribute(TESTCASE[tidx][i++]);
                        continue;
                    }
                    if (method.equals("X")) {
                        this.errln("FAIL: No excetion was thrown - test csae: " + Arrays.toString(TESTCASE[tidx]));
                        continue;
                    }
                    if (method.equals("T")) {
                        expected = new String[]{TESTCASE[tidx][i], TESTCASE[tidx][i + 1]};
                        break;
                    }
                    this.errln("Unknown test case method: There is an error in the test case data.");
                }
                catch (IllformedLocaleException e) {
                    if (TESTCASE[tidx][i].equals("X")) break;
                    this.errln("FAIL: IllformedLocaleException at offset " + i + " in test case: " + Arrays.toString(TESTCASE[tidx]));
                }
            }
            if (expected == null) continue;
            ULocale loc = bld.build();
            if (!expected[1].equals(loc.toString())) {
                this.errln("FAIL: Wrong locale ID - " + loc + " for test case: " + Arrays.toString(TESTCASE[tidx]));
            }
            if (!expected[0].equals(langtag = loc.toLanguageTag())) {
                this.errln("FAIL: Wrong language tag - " + langtag + " for test case: " + Arrays.toString(TESTCASE[tidx]));
            }
            if (loc.equals((Object)(loc1 = ULocale.forLanguageTag((String)langtag)))) continue;
            this.errln("FAIL: Language tag round trip failed for " + loc);
        }
    }

    public void TestSetLocale() {
        ULocale loc = new ULocale("th_TH@calendar=gregorian");
        ULocale.Builder bld = new ULocale.Builder();
        try {
            bld.setLocale(loc);
            ULocale loc1 = bld.build();
            if (!loc.equals((Object)loc1)) {
                this.errln("FAIL: Locale loc1 " + loc1 + " was returned by the builder.  Expected " + loc);
            }
            bld.setLanguage("").setUnicodeLocaleKeyword("ca", "buddhist").setLanguage("TH").setUnicodeLocaleKeyword("ca", "gregory");
            ULocale loc2 = bld.build();
            if (!loc.equals((Object)loc2)) {
                this.errln("FAIL: Locale loc2 " + loc2 + " was returned by the builder.  Expected " + loc);
            }
        }
        catch (IllformedLocaleException e) {
            this.errln("FAIL: IllformedLocaleException: " + e.getMessage());
        }
    }
}

