/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.util.LocaleMatcher;
import com.ibm.icu.util.LocalePriorityList;
import com.ibm.icu.util.ULocale;

public class LocaleMatcherTest
extends TestFmwk {
    public static void main(String[] args) throws Exception {
        new LocaleMatcherTest().run(args);
    }

    public void testBasics() {
        LocaleMatcher matcher = new LocaleMatcher(LocalePriorityList.add((ULocale)ULocale.FRENCH).add(ULocale.UK).add(ULocale.ENGLISH).build());
        this.logln(matcher.toString());
        this.assertEquals(ULocale.UK, matcher.getBestMatch(ULocale.UK));
        this.assertEquals(ULocale.ENGLISH, matcher.getBestMatch(ULocale.US));
        this.assertEquals(ULocale.FRENCH, matcher.getBestMatch(ULocale.FRANCE));
        this.assertEquals(ULocale.FRENCH, matcher.getBestMatch(ULocale.JAPAN));
    }

    public void testFallback() {
        LocaleMatcher matcher = new LocaleMatcher("zh_CN, zh_TW, iw");
        this.assertEquals(new ULocale("zh_TW"), matcher.getBestMatch("zh_Hant"));
        this.assertEquals(new ULocale("zh_CN"), matcher.getBestMatch("zh"));
        this.assertEquals(new ULocale("zh_CN"), matcher.getBestMatch("zh_Hans_CN"));
        this.assertEquals(new ULocale("zh_TW"), matcher.getBestMatch("zh_Hant_HK"));
        this.assertEquals(new ULocale("he"), matcher.getBestMatch("iw_IT"));
    }

    public void testSpecials() {
        LocaleMatcher matcher = new LocaleMatcher("en, fil, ro, nn");
        this.assertEquals(new ULocale("fil"), matcher.getBestMatch("tl"));
        this.assertEquals(new ULocale("ro"), matcher.getBestMatch("mo"));
        this.assertEquals(new ULocale("nn"), matcher.getBestMatch("nb"));
        this.assertEquals(new ULocale("en"), matcher.getBestMatch("ja"));
    }

    public void testRegionalSpecials() {
        LocaleMatcher matcher = new LocaleMatcher("en, en_GB, es, es_419");
        this.assertEquals("en_AU in {en, en_GB, es, es_419}", new ULocale("en_GB"), matcher.getBestMatch("en_AU"));
        this.assertEquals("es_MX in {en, en_GB, es, es_419}", new ULocale("es_419"), matcher.getBestMatch("es_MX"));
        this.assertEquals("es_ES in {en, en_GB, es, es_419}", new ULocale("es"), matcher.getBestMatch("es_ES"));
    }

    public void TestLocaleMatcherCoverage() {
        LocaleMatcher matcher = new LocaleMatcher(LocalePriorityList.add(null, (double)0.0).build(), null);
        this.logln(matcher.toString());
        LocaleMatcher.LanguageMatcherData data = new LocaleMatcher.LanguageMatcherData();
        LocaleMatcher.LanguageMatcherData clone = data.cloneAsThawed();
        if (clone.equals(data)) {
            this.errln("Error cloneAsThawed() is equal.");
        }
        if (data.isFrozen()) {
            this.errln("Error LanguageMatcherData is frozen!");
        }
    }

    private void assertEquals(Object expected, Object string) {
        this.assertEquals("", expected, string);
    }
}

