/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.ReplaceableString;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.StringTokenizer;

public final class StringTokenizerTest
extends TestFmwk {
    public void TestConstructors() {
        String str = "this\tis\na\rstring\ftesting\tStringTokenizer\nconstructors!";
        String delimiter = " \t\n\r\f";
        String[] expected = new String[]{"this", "is", "a", "string", "testing", "StringTokenizer", "constructors!"};
        StringTokenizer defaultst = new StringTokenizer(str);
        StringTokenizer stdelimiter = new StringTokenizer(str, delimiter);
        StringTokenizer stdelimiterreturn = new StringTokenizer(str, delimiter, false);
        UnicodeSet delimiterset = new UnicodeSet("[" + delimiter + "]", false);
        StringTokenizer stdelimiterset = new StringTokenizer(str, delimiterset);
        StringTokenizer stdelimitersetreturn = new StringTokenizer(str, delimiterset, false);
        for (int i = 0; i < expected.length; ++i) {
            if (defaultst.nextElement().equals(expected[i]) && stdelimiter.nextElement().equals(expected[i]) && stdelimiterreturn.nextElement().equals(expected[i]) && stdelimiterset.nextElement().equals(expected[i]) && stdelimitersetreturn.nextElement().equals(expected[i])) continue;
            this.errln("Constructor with default delimiter gives wrong results");
        }
        UnicodeSet delimiterset1 = new UnicodeSet("[" + delimiter + "]", true);
        StringTokenizer stdelimiterset1 = new StringTokenizer(str, delimiterset1);
        if (!stdelimiterset1.nextElement().equals(str)) {
            this.errln("Constructor with a UnicodeSet to ignoreWhiteSpace is to return the same string.");
        }
        String[] expected1 = new String[]{"this", "\t", "is", "\n", "a", "\r", "string", "\f", "testing", "\t", "StringTokenizer", "\n", "constructors!"};
        stdelimiterreturn = new StringTokenizer(str, delimiter, true);
        stdelimitersetreturn = new StringTokenizer(str, delimiterset, true);
        for (int i = 0; i < expected1.length; ++i) {
            if (stdelimiterreturn.nextElement().equals(expected1[i]) && stdelimitersetreturn.nextElement().equals(expected1[i])) continue;
            this.errln("Constructor with default delimiter and delimiter tokens gives wrong results");
        }
        stdelimiter = new StringTokenizer(str, (String)null);
        stdelimiterreturn = new StringTokenizer(str, (String)null, false);
        delimiterset = null;
        stdelimiterset = new StringTokenizer(str, delimiterset);
        stdelimitersetreturn = new StringTokenizer(str, delimiterset, false);
        if (!(stdelimiter.nextElement().equals(str) && stdelimiterreturn.nextElement().equals(str) && stdelimiterset.nextElement().equals(str) && stdelimitersetreturn.nextElement().equals(str))) {
            this.errln("Constructor with null delimiter gives wrong results");
        }
        delimiter = "";
        stdelimiter = new StringTokenizer(str, delimiter);
        stdelimiterreturn = new StringTokenizer(str, delimiter, false);
        delimiterset = new UnicodeSet();
        stdelimiterset = new StringTokenizer(str, delimiterset);
        stdelimitersetreturn = new StringTokenizer(str, delimiterset, false);
        if (!(stdelimiter.nextElement().equals(str) && stdelimiterreturn.nextElement().equals(str) && stdelimiterset.nextElement().equals(str) && stdelimitersetreturn.nextElement().equals(str))) {
            this.errln("Constructor with empty delimiter gives wrong results");
        }
        try {
            defaultst = new StringTokenizer(null);
            this.errln("null string should throw an exception");
        }
        catch (Exception e) {
            this.logln("PASS: Constructor with null string failed as expected");
        }
        try {
            stdelimiter = new StringTokenizer(null, delimiter);
            this.errln("null string should throw an exception");
        }
        catch (Exception e) {
            this.logln("PASS: Constructor with null string failed as expected");
        }
        try {
            stdelimiterreturn = new StringTokenizer(null, delimiter, false);
            this.errln("null string should throw an exception");
        }
        catch (Exception e) {
            this.logln("PASS: Constructor with null string failed as expected");
        }
        try {
            stdelimiterset = new StringTokenizer(null, delimiterset);
            this.errln("null string should throw an exception");
        }
        catch (Exception e) {
            this.logln("PASS: Constructor with null string failed as expected");
        }
        try {
            stdelimitersetreturn = new StringTokenizer(null, delimiterset, false);
            this.errln("null string should throw an exception");
        }
        catch (Exception e) {
            this.logln("PASS: Constructor with null string failed as expected");
        }
    }

    public void TestSupplementary() {
        String str = "bmp string \ud800 with a unmatched surrogate character";
        String delimiter = "\ud800\udc00";
        String[] expected = new String[]{str};
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter);
        if (!tokenizer.nextElement().equals(expected[0])) {
            this.errln("Error parsing \"" + Utility.hex((CharSequence)str) + "\"");
        }
        if (tokenizer.hasMoreElements()) {
            this.errln("Number of tokens exceeded expected");
        }
        delimiter = "\ud800";
        String[] expected1 = new String[]{"bmp string ", " with a unmatched surrogate character"};
        tokenizer = new StringTokenizer(str, delimiter);
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            if (tokenizer.nextElement().equals(expected1[i++])) continue;
            this.errln("Error parsing \"" + Utility.hex((CharSequence)str) + "\"");
        }
        if (tokenizer.hasMoreElements()) {
            this.errln("Number of tokens exceeded expected");
        }
        str = "string \ud800\udc00 with supplementary character";
        delimiter = "\ud800";
        String[] expected2 = new String[]{str};
        tokenizer = new StringTokenizer(str, delimiter);
        if (!tokenizer.nextElement().equals(expected2[0])) {
            this.errln("Error parsing \"" + Utility.hex((CharSequence)str) + "\"");
        }
        if (tokenizer.hasMoreElements()) {
            this.errln("Number of tokens exceeded expected");
        }
        delimiter = "\ud800\udc00";
        String[] expected3 = new String[]{"string ", " with supplementary character"};
        tokenizer = new StringTokenizer(str, delimiter);
        i = 0;
        while (tokenizer.hasMoreElements()) {
            if (tokenizer.nextElement().equals(expected3[i++])) continue;
            this.errln("Error parsing \"" + Utility.hex((CharSequence)str) + "\"");
        }
        if (tokenizer.hasMoreElements()) {
            this.errln("Number of tokens exceeded expected");
        }
        str = "\ud800 \ud800\udc00 \ud800 \ud800\udc00";
        delimiter = "\ud800";
        String[] expected4 = new String[]{" \ud800\udc00 ", " \ud800\udc00"};
        i = 0;
        while (tokenizer.hasMoreElements()) {
            if (tokenizer.nextElement().equals(expected4[i++])) continue;
            this.errln("Error parsing \"" + Utility.hex((CharSequence)str) + "\"");
        }
        if (tokenizer.hasMoreElements()) {
            this.errln("Number of tokens exceeded expected");
        }
        delimiter = "\ud800\udc00";
        String[] expected5 = new String[]{"\ud800 ", " \ud800 "};
        i = 0;
        while (tokenizer.hasMoreElements()) {
            if (tokenizer.nextElement().equals(expected5[i++])) continue;
            this.errln("Error parsing \"" + Utility.hex((CharSequence)str) + "\"");
        }
        if (tokenizer.hasMoreElements()) {
            this.errln("Number of tokens exceeded expected");
        }
    }

    public void TestNextNonDelimiterToken() {
        String str = "  ,  1 2 3  AHHHHH! 5.5 6 7    ,        8\n";
        String[] expected = new String[]{",", "1", "2", "3", "AHHHHH!", "5.5", "6", "7", ",", "8\n"};
        String delimiter = " ";
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter);
        int currtoken = 0;
        while (tokenizer.hasMoreElements()) {
            if (!tokenizer.nextElement().equals(expected[currtoken])) {
                this.errln("Error token mismatch, expected " + expected[currtoken]);
            }
            ++currtoken;
        }
        if (currtoken != expected.length) {
            this.errln("Didn't get correct number of tokens");
        }
        if ((tokenizer = new StringTokenizer("", delimiter)).hasMoreElements()) {
            this.errln("Empty string should not have any tokens");
        }
        try {
            tokenizer.nextElement();
            this.errln("Empty string should not have any tokens");
        }
        catch (Exception e) {
            this.logln("PASS: empty string failed as expected");
        }
        tokenizer = new StringTokenizer(", ,", ", ");
        if (tokenizer.hasMoreElements()) {
            this.errln("String with only delimiters should not have any tokens");
        }
        try {
            tokenizer.nextElement();
            this.errln("String with only delimiters should not have any tokens");
        }
        catch (Exception e) {
            this.logln("PASS: String with only delimiters failed as expected");
        }
        tokenizer = new StringTokenizer("q, ,", ", ");
        if (!tokenizer.hasMoreElements()) {
            this.errln("String that does not begin with delimiters should have some tokens");
        }
        if (!tokenizer.nextElement().equals("q")) {
            this.errln("String that does not begin with delimiters should have some tokens");
        }
        try {
            tokenizer.nextElement();
            this.errln("String has only one token");
        }
        catch (Exception e) {
            this.logln("PASS: String with only one token failed as expected");
        }
        try {
            tokenizer = new StringTokenizer(null, delimiter);
            this.errln("StringTokenizer constructed with null source should throw a nullpointerexception");
        }
        catch (Exception e) {
            this.logln("PASS: StringTokenizer constructed with null source failed as expected");
        }
        tokenizer = new StringTokenizer(str, "q");
        if (!tokenizer.nextElement().equals(str)) {
            this.errln("Should have received the same string when there are no delimiters");
        }
    }

    public void TestNoCoalesce() {
        String str = "This is   a test\rto see if\nwhitespace is handled \n\r unusually\r\n by our tokenizer\n\n\n!!!plus some other odd ones like \ttab\ttab\ttab\nand form\ffeed\ffoo.\n";
        String delims = " \t\n\r\f\ud800\udc00";
        java.util.StringTokenizer jt = new java.util.StringTokenizer(str, delims, true);
        StringTokenizer it = new StringTokenizer(str, delims, true);
        int n = 0;
        while (jt.hasMoreTokens() && it.hasMoreTokens()) {
            this.assertEquals("[" + String.valueOf(n++) + "]", jt.nextToken(), it.nextToken());
        }
        this.assertFalse("java tokenizer has no more tokens", jt.hasMoreTokens());
        this.assertFalse("icu tokenizer has no more tokens", it.hasMoreTokens());
        String sur = "Even\ud800\udc00 works.\n\n";
        it = new StringTokenizer(sur, delims, true);
        this.assertEquals("sur1", it.nextToken(), "Even");
        this.assertEquals("sur2", it.nextToken(), "\ud800\udc00");
        this.assertEquals("sur3", it.nextToken(), " ");
        this.assertEquals("sur4", it.nextToken(), "works.");
        this.assertEquals("sur5", it.nextToken(), "\n");
        this.assertEquals("sur6", it.nextToken(), "\n");
        this.assertFalse("sur7", it.hasMoreTokens());
    }

    public void TestNextDelimiterToken() {
        String str = "  ,  1 2 3  AHHHHH! 5.5 6 7    ,        8\n";
        String[] expected = new String[]{"  ", ",", "  ", "1", " ", "2", " ", "3", "  ", "AHHHHH!", " ", "5.5", " ", "6", " ", "7", "    ", ",", "        ", "8\n"};
        String delimiter = " ";
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter, true, true);
        int currtoken = 0;
        while (tokenizer.hasMoreElements()) {
            if (!tokenizer.nextElement().equals(expected[currtoken])) {
                this.errln("Error token mismatch, expected " + expected[currtoken]);
            }
            ++currtoken;
        }
        if (currtoken != expected.length) {
            this.errln("Didn't get correct number of tokens");
        }
        if ((tokenizer = new StringTokenizer("", delimiter, true)).hasMoreElements()) {
            this.errln("Empty string should not have any tokens");
        }
        try {
            tokenizer.nextElement();
            this.errln("Empty string should not have any tokens");
        }
        catch (Exception e) {
            this.logln("PASS: Empty string failed as expected");
        }
        tokenizer = new StringTokenizer(", ,", ", ", true, true);
        if (!tokenizer.hasMoreElements()) {
            this.errln("String with only delimiters should have tokens when delimiter is treated as tokens");
        }
        if (!tokenizer.nextElement().equals(", ,")) {
            this.errln("String with only delimiters should return itself when delimiter is treated as tokens");
        }
        if (!(tokenizer = new StringTokenizer("q, ,", ", ", true, true)).hasMoreElements()) {
            this.errln("String should have some tokens");
        }
        if (!tokenizer.nextElement().equals("q") || !tokenizer.nextElement().equals(", ,")) {
            this.errln("String tokens do not match expected results");
        }
        try {
            tokenizer = new StringTokenizer(null, delimiter, true);
            this.errln("StringTokenizer constructed with null source should throw a nullpointerexception");
        }
        catch (Exception e) {
            this.logln("PASS: StringTokenizer constructed with null source failed as expected");
        }
        tokenizer = new StringTokenizer(str, "q", true);
        if (!tokenizer.nextElement().equals(str)) {
            this.errln("Should have recieved the same string when there are no delimiters");
        }
    }

    public void TestCountTokens() {
        int i;
        String str = "this\tis\na\rstring\ftesting\tStringTokenizer\nconstructors!";
        String delimiter = " \t\n\r\f";
        String[] expected = new String[]{"this", "is", "a", "string", "testing", "StringTokenizer", "constructors!"};
        String[] expectedreturn = new String[]{"this", "\t", "is", "\n", "a", "\r", "string", "\f", "testing", "\t", "StringTokenizer", "\n", "constructors!"};
        StringTokenizer st = new StringTokenizer(str, delimiter);
        StringTokenizer streturn = new StringTokenizer(str, delimiter, true);
        if (st.countTokens() != expected.length) {
            this.errln("CountTokens failed for non-delimiter tokens");
        }
        if (streturn.countTokens() != expectedreturn.length) {
            this.errln("CountTokens failed for delimiter tokens");
        }
        for (i = 0; i < expected.length; ++i) {
            if (st.nextElement().equals(expected[i]) && st.countTokens() == expected.length - i - 1) continue;
            this.errln("CountTokens default delimiter gives wrong results");
        }
        for (i = 0; i < expectedreturn.length; ++i) {
            if (streturn.nextElement().equals(expectedreturn[i]) && streturn.countTokens() == expectedreturn.length - i - 1) continue;
            this.errln("CountTokens with default delimiter and delimiter tokens gives wrong results");
        }
    }

    public void TestNextNewDelimiters() {
        String str = "abc0def1ghi2jkl3mno4pqr0stu1vwx2yza3bcd4efg0hij1klm2nop3qrs4tuv";
        String[] delimiter = new String[]{"0", "1", "2", "3", "4"};
        String[][] expected = new String[][]{{"abc", "pqr", "efg"}, {"def", "stu", "hij"}, {"ghi", "vwx", "klm"}, {"jkl", "yza", "nop"}, {"mno", "bcd", "qrs"}};
        StringTokenizer st = new StringTokenizer(str);
        int size = expected[0].length;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < delimiter.length; ++j) {
                if (!st.nextToken(delimiter[j]).equals(expected[j][i])) {
                    this.errln("nextToken() with delimiters error " + i + " " + j);
                }
                if (st.countTokens() == expected[j].length - i) continue;
                this.errln("countTokens() after nextToken() with delimiters error" + i + " " + j);
            }
        }
        st = new StringTokenizer(str);
        String[] delimiter1 = new String[]{"0", "2", "4"};
        String[] expected1 = new String[]{"abc", "def1ghi", "jkl3mno", "pqr", "stu1vwx", "yza3bcd", "efg", "hij1klm", "nop3qrs", "tuv"};
        for (int i = 0; i < expected1.length; ++i) {
            if (st.nextToken(delimiter1[i % delimiter1.length]).equals(expected1[i])) continue;
            this.errln("nextToken() with delimiters error " + i);
        }
    }

    public void TestBug4423() {
        String s1 = "This is a test";
        StringTokenizer tzr = new StringTokenizer(s1);
        int tokenCount = 0;
        int t = tzr.countTokens();
        if (t != 4) {
            this.errln("tzr.countTokens() returned " + t + ".  Expected 4");
        }
        while (tzr.hasMoreTokens()) {
            String tok = tzr.nextToken();
            if (tok.length() == 0) {
                this.errln("token with length == 0");
            }
            ++tokenCount;
        }
        if (tokenCount != 4) {
            this.errln("Incorrect number of tokens found = " + tokenCount);
        }
        String s2 = "";
        for (int i = 1; i < 250; ++i) {
            StringTokenizer tzb = new StringTokenizer(s2 = s2 + " " + i);
            int t2 = tzb.countTokens();
            if (t2 != i) {
                this.errln("tzb.countTokens() returned " + t + ".  Expected " + i);
                break;
            }
            int j = 0;
            while (tzb.hasMoreTokens()) {
                String tok = tzb.nextToken();
                if (tok.equals(Integer.toString(++j))) continue;
                this.errln("Wrong token string.  Expected \"" + j + "\", got \"" + tok + "\".");
                break;
            }
            if (j == i) continue;
            this.errln("Wrong number of tokens.  Expected " + i + ".  Got " + j + ".");
            break;
        }
    }

    public void TestCountTokensNoCoalesce() {
        String str = "\"\"";
        String del = "\"";
        StringTokenizer st = new StringTokenizer(str, del, true);
        int count = 0;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            this.logln("[" + count + "] '" + t + "'");
            ++count;
        }
        st = new StringTokenizer(str, del, true);
        int ncount = st.countTokens();
        int xcount = 0;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            this.logln("[" + xcount + "] '" + t + "'");
            ++xcount;
        }
        if (count != ncount || count != xcount) {
            this.errln("inconsistent counts " + count + ", " + ncount + ", " + xcount);
        }
    }

    public static void main(String[] arg) {
        try {
            StringTokenizerTest test = new StringTokenizerTest();
            test.run(arg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Test_GeneratePattern() {
        UnicodeSet us = new UnicodeSet();
        StringBuffer sb = new StringBuffer();
        try {
            us._generatePattern(sb, true);
            us._generatePattern(sb, false);
            us._generatePattern(sb.append(1), true);
            us._generatePattern(sb.append(1.0), true);
            us._generatePattern(sb.reverse(), true);
        }
        catch (Exception e) {
            this.errln("UnicodeSet._generatePattern is not suppose to return an exception.");
        }
        try {
            us._generatePattern(null, true);
            this.errln("UnicodeSet._generatePattern is suppose to return an exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void TestMatches() {
        ReplaceableString rs = new ReplaceableString("dummy");
        UnicodeSet us = new UnicodeSet(0, 100000);
        us.add((CharSequence)"dummy");
        int[] offset = new int[]{0};
        int limit = 0;
        if (us.matches(null, offset, limit, true) != 1) {
            this.errln("UnicodeSet.matches is suppose to return 1 but got " + us.matches(null, offset, limit, true));
        }
        if (us.matches(null, offset, limit, false) != 2) {
            this.errln("UnicodeSet.matches is suppose to return 2 but got " + us.matches(null, offset, limit, false));
        }
        try {
            offset[0] = 0;
            us.matches((Replaceable)rs, offset, 1, true);
            offset[0] = 4;
            us.matches((Replaceable)rs, offset, 1, true);
        }
        catch (Exception e) {
            this.errln("UnicodeSet.matches is not suppose to return an exception");
        }
    }

    public void TestMatchRest() {
    }

    public void TestMatchesAt() {
        UnicodeSet us = new UnicodeSet();
        us.matchesAt((CharSequence)"dummy", 0);
        us.add((CharSequence)"dummy");
        us.matchesAt((CharSequence)"dummy", 0);
        us.add((CharSequence)"dummy2");
        us.matchesAt((CharSequence)"yummy", 0);
        us.matchesAt((CharSequence)"amy", 0);
        UnicodeSet us1 = new UnicodeSet(0, 100000);
        us1.matchesAt((CharSequence)"dummy", 0);
    }

    public void TestIndexOf() {
        int i;
        UnicodeSet us = new UnicodeSet();
        int[] invalid = new int[]{-1, -2, 0x110000, 0x110001};
        int[] valid = new int[]{0, 1, 0x10FFFF, 1114110};
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.indexOf(invalid[i]);
                this.errln("UnicodeSet.indexOf is suppose to return an exception for a value of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < valid.length; ++i) {
            try {
                us.indexOf(valid[i]);
                continue;
            }
            catch (Exception e) {
                this.errln("UnicodeSet.indexOf is not suppose to return an exception for a value of " + valid[i]);
            }
        }
    }

    public void TestCharAt() {
        UnicodeSet us = new UnicodeSet();
        int[] invalid = new int[]{-100, -10, -5, -2, -1};
        for (int i = 0; i < invalid.length; ++i) {
            if (us.charAt(invalid[i]) == -1) continue;
            this.errln("UnicodeSet.charAt(int index) was suppose to return -1 for an invalid input of " + invalid[i]);
        }
    }

    public void TestAdd_int_int() {
        int i;
        UnicodeSet us = new UnicodeSet();
        int[] invalid = new int[]{-1, -2, 0x110000, 0x110001};
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.add(invalid[i], 0x10FFFF);
                this.errln("UnicodeSet.add(int start, int end) was suppose to give an exception for an start invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.add(0, invalid[i]);
                this.errln("UnicodeSet.add(int start, int end) was suppose to give an exception for an end invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!us.add(1, 0).equals((Object)us)) {
            this.errln("UnicodeSet.add(int start, int end) was suppose to return the same object because start of value 1 is greater than end of value 0");
        }
        if (!us.add(0x10FFFF, 1114110).equals((Object)us)) {
            this.errln("UnicodeSet.add(int start, int end) was suppose to return the same object because start of value 1114111 is greater than end of value 1114110");
        }
    }

    public void TestAdd_int() {
        UnicodeSet us = new UnicodeSet();
        int[] invalid = new int[]{-1, -2, 0x110000, 0x110001};
        for (int i = 0; i < invalid.length; ++i) {
            try {
                us.add(invalid[i]);
                this.errln("UnicodeSet.add(int c) was suppose to give an exception for an start invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void TestGetSingleCP() {
        UnicodeSet us = new UnicodeSet();
        try {
            us.contains("");
            this.errln("UnicodeSet.getSingleCP is suppose to give an exception for an empty string.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            us.contains((String)null);
            this.errln("UnicodeSet.getSingleCP is suppose to give an exception for a null string.");
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] cases = new String[]{"\ud811\udc00", "\ud811\udc11", "\ud811\udc22"};
        for (int i = 0; i < cases.length; ++i) {
            try {
                us.contains(cases[i]);
                continue;
            }
            catch (Exception e) {
                this.errln("UnicodeSet.getSingleCP is not suppose to give an exception for a null string.");
            }
        }
    }

    public void TestRemoveAllString() {
        UnicodeSet us = new UnicodeSet();
        try {
            us.removeAllStrings();
        }
        catch (Exception e) {
            this.errln("UnicodeSet.removeAllString() was not suppose to given an exception for a strings size of 0");
        }
    }

    public void TestRetain_int_int() {
        int i;
        UnicodeSet us = new UnicodeSet();
        int[] invalid = new int[]{-1, -2, 0x110000, 0x110001};
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.retain(invalid[i], 0x10FFFF);
                this.errln("UnicodeSet.retain(int start, int end) was suppose to give an exception for an start invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.retain(0, invalid[i]);
                this.errln("UnicodeSet.retain(int start, int end) was suppose to give an exception for an end invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            us.retain(1, 0);
        }
        catch (Exception e) {
            this.errln("UnicodeSet.retain(int start, int end) was not suppose to give an exception.");
        }
        try {
            us.retain(0x10FFFF, 1114110);
        }
        catch (Exception e) {
            this.errln("UnicodeSet.retain(int start, int end) was not suppose to give an exception.");
        }
    }

    public void TestRetain_String() {
        UnicodeSet us = new UnicodeSet();
        us.add((CharSequence)"dummy");
        if (!us.retain("dummy").equals((Object)us)) {
            this.errln("UnicodeSet.retain(String s) was suppose to return the same UnicodeSet since the string was found in the original.");
        }
    }

    public void TestRemove() {
        int i;
        UnicodeSet us = new UnicodeSet();
        int[] invalid = new int[]{-1, -2, 0x110000, 0x110001};
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.remove(invalid[i], 0x10FFFF);
                this.errln("UnicodeSet.remove(int start, int end) was suppose to give an exception for an start invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.remove(0, invalid[i]);
                this.errln("UnicodeSet.remove(int start, int end) was suppose to give an exception for an end invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            us.remove(1, 0);
        }
        catch (Exception e) {
            this.errln("UnicodeSet.remove(int start, int end) was not suppose to give an exception.");
        }
        try {
            us.remove(0x10FFFF, 1114110);
        }
        catch (Exception e) {
            this.errln("UnicodeSet.remove(int start, int end) was not suppose to give an exception.");
        }
    }

    public void TestComplement_int_int() {
        int i;
        UnicodeSet us = new UnicodeSet();
        int[] invalid = new int[]{-1, -2, 0x110000, 0x110001};
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.complement(invalid[i], 0x10FFFF);
                this.errln("UnicodeSet.complement(int start, int end) was suppose to give an exception for an start invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.complement(0, invalid[i]);
                this.errln("UnicodeSet.complement(int start, int end) was suppose to give an exception for an end invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            us.complement(1, 0);
        }
        catch (Exception e) {
            this.errln("UnicodeSet.complement(int start, int end) was not suppose to give an exception.");
        }
        try {
            us.complement(0x10FFFF, 1114110);
        }
        catch (Exception e) {
            this.errln("UnicodeSet.complement(int start, int end) was not suppose to give an exception.");
        }
    }

    public void TestComplement_String() {
        UnicodeSet us = new UnicodeSet();
        us.add((CharSequence)"dummy");
        try {
            us.complement("dummy");
        }
        catch (Exception e) {
            this.errln("UnicodeSet.complement(String s) was not suppose to give an exception for 'dummy'.");
        }
        us = new UnicodeSet();
        us.add((CharSequence)"\udc11");
        try {
            us.complement("\udc11");
        }
        catch (Exception e) {
            this.errln("UnicodeSet.complement(String s) was not suppose to give an exception for '\udc11'.");
        }
    }

    public void TestContains_int() {
        UnicodeSet us = new UnicodeSet();
        int[] invalid = new int[]{-1, -2, 0x110000, 0x110001};
        for (int i = 0; i < invalid.length; ++i) {
            try {
                us.contains(invalid[i]);
                this.errln("UnicodeSet.contains(int c) was suppose to give an exception for an start invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void TestContains_int_int() {
        int i;
        UnicodeSet us = new UnicodeSet();
        int[] invalid = new int[]{-1, -2, 0x110000, 0x110001};
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.contains(invalid[i], 0x10FFFF);
                this.errln("UnicodeSet.contains(int start, int end) was suppose to give an exception for an start invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.contains(0, invalid[i]);
                this.errln("UnicodeSet.contains(int start, int end) was suppose to give an exception for an end invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void TestGetRegexEquivalent() {
        UnicodeSet us = new UnicodeSet();
        String res = us.getRegexEquivalent();
        if (!res.equals("[]")) {
            this.errln("UnicodeSet.getRegexEquivalent is suppose to return '[]' but got " + res);
        }
    }

    public void TestContainsNone() {
        int i;
        UnicodeSet us = new UnicodeSet();
        int[] invalid = new int[]{-1, -2, 0x110000, 0x110001};
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.containsNone(invalid[i], 0x10FFFF);
                this.errln("UnicodeSet.containsNoneint start, int end) was suppose to give an exception for an start invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < invalid.length; ++i) {
            try {
                us.containsNone(0, invalid[i]);
                this.errln("UnicodeSet.containsNone(int start, int end) was suppose to give an exception for an end invalid input of " + invalid[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            us.add(0);
            us.containsNone(1, 2);
        }
        catch (Exception e) {
            this.errln("UnicodeSet.containsNone(int start, int end) was not suppose to give an exception.");
        }
    }
}

