/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import java.util.ArrayList;
import java.util.List;

public abstract class Tabber {
    public static final byte LEFT = 0;
    public static final byte CENTER = 1;
    public static final byte RIGHT = 2;
    private static final String[] ALIGNMENT_NAMES = new String[]{"Left", "Center", "Right"};
    private String prefix = "";
    private String postfix = "";
    public static Tabber NULL_TABBER = new Tabber(){

        public void process_field(int count, String source, int start, int limit, StringBuffer output) {
            if (count > 0) {
                output.append("\t");
            }
            output.append(source.substring(start, limit));
        }
    };

    public static String repeat(String source, int times) {
        if (times <= 0) {
            return "";
        }
        if (times == 1) {
            return source;
        }
        StringBuffer result = new StringBuffer();
        while (times > 0) {
            result.append(source);
            --times;
        }
        return result.toString();
    }

    public String process(String source) {
        StringBuffer result = new StringBuffer();
        int lastPos = 0;
        int count = 0;
        while (lastPos < source.length()) {
            int pos = source.indexOf(9, lastPos);
            if (pos < 0) {
                pos = source.length();
            }
            this.process_field(count, source, lastPos, pos, result);
            lastPos = pos + 1;
            ++count;
        }
        return this.prefix + result.toString() + this.postfix;
    }

    public abstract void process_field(int var1, String var2, int var3, int var4, StringBuffer var5);

    public Tabber clear() {
        return this;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Tabber setPostfix(String string) {
        this.postfix = string;
        return this;
    }

    public Tabber setPrefix(String string) {
        this.prefix = string;
        return this;
    }

    public Tabber add(int i, byte left2) {
        return this;
    }

    public static class HTMLTabber
    extends Tabber {
        private List<String> parameters = new ArrayList<String>();
        private String element = "td";

        public HTMLTabber() {
            this.setPrefix("<tr>");
            this.setPostfix("</tr>");
        }

        public HTMLTabber setParameters(int count, String params) {
            while (this.parameters.size() <= count) {
                this.parameters.add(null);
            }
            this.parameters.set(count, params);
            return this;
        }

        public String getElement() {
            return this.element;
        }

        public HTMLTabber setElement(String element) {
            this.element = element;
            return this;
        }

        public void process_field(int count, String source, int start, int limit, StringBuffer output) {
            output.append("<" + this.element);
            String params = null;
            if (count < this.parameters.size()) {
                params = this.parameters.get(count);
            }
            if (params != null) {
                output.append(' ');
                output.append(params);
            }
            output.append(">");
            output.append(source.substring(start, limit));
            output.append("</" + this.element + ">");
        }
    }

    public static class MonoTabber
    extends Tabber {
        int minGap = 0;
        private List stops = new ArrayList();
        private List types = new ArrayList();

        public Tabber clear() {
            this.stops.clear();
            this.types.clear();
            this.minGap = 0;
            return this;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.stops.size(); ++i) {
                if (i != 0) {
                    buffer.append("; ");
                }
                buffer.append(ALIGNMENT_NAMES[(Integer)this.types.get(i)]).append(",").append(this.stops.get(i));
            }
            return buffer.toString();
        }

        public MonoTabber addAbsolute(int tabPos, int type) {
            this.stops.add(new Integer(tabPos));
            this.types.add(new Integer(type));
            return this;
        }

        public Tabber add(int fieldWidth, byte type) {
            int last = this.getStop(this.stops.size() - 1);
            this.stops.add(new Integer(last + fieldWidth));
            this.types.add(new Integer(type));
            return this;
        }

        public int getStop(int fieldNumber) {
            if (fieldNumber < 0) {
                return 0;
            }
            if (fieldNumber >= this.stops.size()) {
                fieldNumber = this.stops.size() - 1;
            }
            return (Integer)this.stops.get(fieldNumber);
        }

        public int getType(int fieldNumber) {
            if (fieldNumber < 0) {
                return 0;
            }
            if (fieldNumber >= this.stops.size()) {
                return 0;
            }
            return (Integer)this.types.get(fieldNumber);
        }

        public void process_field(int count, String source, int start, int limit, StringBuffer output) {
            String piece = source.substring(start, limit);
            int startPos = this.getStop(count - 1);
            int endPos = this.getStop(count) - this.minGap;
            int type = this.getType(count);
            switch (type) {
                case 0: {
                    break;
                }
                case 2: {
                    startPos = endPos - piece.length();
                    break;
                }
                case 1: {
                    startPos = (startPos + endPos - piece.length() + 1) / 2;
                }
            }
            int gap = startPos - output.length();
            if (count != 0 && gap < this.minGap) {
                gap = this.minGap;
            }
            if (gap > 0) {
                output.append(MonoTabber.repeat(" ", gap));
            }
            output.append(piece);
        }
    }
}

