/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.AbstractTestLog;
import com.ibm.icu.dev.test.TestBoilerplate;
import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.dev.test.util.CollectionUtilities;
import com.ibm.icu.dev.test.util.ICUPropertyFactory;
import com.ibm.icu.dev.test.util.UnicodeMap;
import com.ibm.icu.dev.test.util.UnicodeMapIterator;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TestUtilities
extends TestFmwk {
    static final int LIMIT = 21;
    static final int ITERATIONS = 1000000;
    static final boolean SHOW_PROGRESS = false;
    static final boolean DEBUG = false;
    UnicodeMap map1 = new UnicodeMap();
    Map map2 = new HashMap();
    Map map3 = new TreeMap();
    SortedSet log = new TreeSet();
    static String[] TEST_VALUES = new String[]{null, "A", "B", "C", "D", "E", "F"};
    static Random random = new Random(12345L);
    static final String[] RelationName = new String[]{"ALL_EMPTY", "NOT_A_SUPERSET_B", "NOT_A_DISJOINT_B", "NOT_A_SUBSET_B", "A_PROPER_SUBSET_OF_B", "A_PROPER_DISJOINT_B", "A_PROPER_SUPERSET_B", "A_PROPER_OVERLAPS_B"};
    static Comparator ENTRY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Map.Entry a = (Map.Entry)o1;
            Map.Entry b = (Map.Entry)o2;
            int result = this.compare2(a.getKey(), b.getKey());
            if (result != 0) {
                return result;
            }
            return this.compare2(a.getValue(), b.getValue());
        }

        private int compare2(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    };
    static final int SET_LIMIT = 0x10FFFF;
    static final int CHECK_LIMIT = 65535;
    static final NumberFormat pf = NumberFormat.getPercentInstance();
    static final NumberFormat nf = NumberFormat.getInstance();
    int propEnum = 4101;

    public static void main(String[] args) throws Exception {
        new TestUtilities().run(args);
    }

    public void TestUnicodeMap() {
        String value;
        random.setSeed(12345L);
        this.logln("Comparing against HashMap");
        for (int counter = 0; counter < 1000000; ++counter) {
            int start = random.nextInt(21);
            value = TEST_VALUES[random.nextInt(TEST_VALUES.length)];
            String logline = Utility.hex((long)start) + "\t" + value;
            this.log.add(logline);
            this.map1.put(start, value);
            this.map2.put(new Integer(start), value);
            this.check(counter);
        }
        this.checkNext(21);
        this.logln("Setting General Category");
        this.map1 = new UnicodeMap();
        this.map2 = new TreeMap();
        for (int cp = 0; cp <= 0x10FFFF; ++cp) {
            int enumValue = UCharacter.getIntPropertyValue((int)cp, (int)this.propEnum);
            value = UCharacter.getPropertyValueName((int)this.propEnum, (int)enumValue, (int)1);
            this.map1.put(cp, value);
            this.map2.put(new Integer(cp), value);
        }
        this.checkNext(Integer.MAX_VALUE);
        this.logln("Comparing General Category");
        this.check(-1);
        this.logln("Comparing Values");
        Set values1 = this.map1.getAvailableValues(new TreeSet());
        TreeSet values2 = new TreeSet(this.map2.values());
        if (!TestBoilerplate.verifySetsIdentical((AbstractTestLog)this, (Set)values1, values2)) {
            throw new IllegalArgumentException("Halting");
        }
        this.logln("Comparing Sets");
        for (Object value2 : values1) {
            UnicodeSet set2;
            this.logln(value2 == null ? "null" : value2.toString());
            UnicodeSet set1 = this.map1.keySet(value2);
            if (TestBoilerplate.verifySetsIdentical((AbstractTestLog)this, (UnicodeSet)set1, (UnicodeSet)(set2 = TestBoilerplate.getSet((Map)this.map2, value2)))) continue;
            throw new IllegalArgumentException("Halting");
        }
        this.logln("Getting Scripts");
        UnicodeMap scripts = ICUPropertyFactory.make().getProperty("script").getUnicodeMap_internal();
        UnicodeMap.Composer composer = new UnicodeMap.Composer(){

            public Object compose(int codepoint, String string, Object a, Object b) {
                return a.toString() + "_" + b.toString();
            }
        };
        this.logln("Trying Compose");
        UnicodeMap composed = ((UnicodeMap)scripts.cloneAsThawed()).composeWith(this.map1, composer);
        String last = "";
        for (int i = 0; i < 0x10FFFF; ++i) {
            Object sc;
            Object gc;
            Object comp = composed.getValue(i);
            if (!comp.equals(composer.compose(i, null, gc = this.map1.getValue(i), sc = scripts.getValue(i)))) {
                this.errln("Failed compose at: " + i);
            }
            if (last.equals(comp)) continue;
            this.logln(Utility.hex((long)i) + "\t" + comp);
            last = comp;
        }
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("TestMain");
        if (this.params.nothrow) {
            argList.add("-nothrow");
        }
        if (this.params.verbose) {
            argList.add("-verbose");
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        new UnicodeMapBoilerplate().run(args);
        new UnicodeSetBoilerplate().run(args);
    }

    public void TestCollectionUtilitySpeed() {
        TreeSet<String> ts1 = new TreeSet<String>();
        TreeSet<String> ts2 = new TreeSet<String>();
        int size = 1000;
        int iterations = 1000;
        String prefix = "abc";
        String postfix = "nop";
        for (int i = 0; i < size; ++i) {
            ts1.add(prefix + String.valueOf(i) + postfix);
            ts2.add(prefix + String.valueOf(i) + postfix);
        }
        CollectionUtilities.containsAll(ts1, ts2);
        ts1.containsAll(ts2);
        this.timeAndCompare(ts1, ts2, iterations, true, 0.75);
        ts1.add("Able");
        this.timeAndCompare(ts1, ts2, iterations, true, 0.75);
        this.timeAndCompare(ts2, ts1, iterations * 100, false, 1.05);
    }

    private void timeAndCompare(TreeSet ts1, TreeSet ts2, int iterations, boolean expected, double factorOfStandard) {
        double standardTimeSorted;
        double utilityTimeSorted = (double)this.timeUtilityContainsAll(iterations, ts1, ts2, expected) / (double)iterations;
        if (utilityTimeSorted < (standardTimeSorted = (double)this.timeStandardContainsAll(iterations, ts1, ts2, expected) / (double)iterations) * factorOfStandard) {
            this.logln("Sorted: Utility time (" + utilityTimeSorted + ") << Standard duration (" + standardTimeSorted + "); " + 100.0 * (utilityTimeSorted / standardTimeSorted) + "%");
        } else {
            this.errln("Sorted: Utility time (" + utilityTimeSorted + ") !<< Standard duration (" + standardTimeSorted + "); " + 100.0 * (utilityTimeSorted / standardTimeSorted) + "%");
        }
    }

    private long timeStandardContainsAll(int iterations, Set hs1, Set hs2, boolean expected) {
        boolean temp = false;
        long start = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            temp = hs1.containsAll(hs2);
            if (temp == expected) continue;
            this.errln("Bad result");
        }
        long end = System.currentTimeMillis();
        long standardTime = end - start;
        return standardTime;
    }

    private long timeUtilityContainsAll(int iterations, Set hs1, Set hs2, boolean expected) {
        boolean temp = false;
        long start = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            temp = CollectionUtilities.containsAll(hs1, hs2);
            if (temp == expected) continue;
            this.errln("Bad result");
        }
        long end = System.currentTimeMillis();
        long utilityTime = end - start;
        return utilityTime;
    }

    public void TestCollectionUtilities() {
        String[][] test = new String[][]{{"a", "c", "e", "g", "h", "z"}, {"b", "d", "f", "h", "w"}, {"a", "b"}, {"a", "d"}, {"d"}, new String[0]};
        int resultMask = 0;
        for (int i = 0; i < test.length; ++i) {
            TreeSet<String> a = new TreeSet<String>(Arrays.asList(test[i]));
            block11: for (int j = 0; j < test.length; ++j) {
                TreeSet<String> b = new TreeSet<String>(Arrays.asList(test[j]));
                int relation = CollectionUtilities.getContainmentRelation(a, b);
                resultMask |= 1 << relation;
                switch (relation) {
                    case 0: {
                        this.checkContainment(a.size() == 0 && b.size() == 0, a, relation, b);
                        continue block11;
                    }
                    case 1: {
                        this.checkContainment(a.size() == 0 && b.size() != 0, a, relation, b);
                        continue block11;
                    }
                    case 2: {
                        this.checkContainment(((Object)a).equals(b) && a.size() != 0, a, relation, b);
                        continue block11;
                    }
                    case 4: {
                        this.checkContainment(a.size() != 0 && b.size() == 0, a, relation, b);
                        continue block11;
                    }
                    case 3: {
                        this.checkContainment(b.containsAll(a) && !((Object)a).equals(b), a, relation, b);
                        continue block11;
                    }
                    case 5: {
                        this.checkContainment(!CollectionUtilities.containsSome(a, b) && a.size() != 0 && b.size() != 0, a, relation, b);
                        continue block11;
                    }
                    case 6: {
                        this.checkContainment(a.containsAll(b) && !((Object)a).equals(b), a, relation, b);
                        continue block11;
                    }
                    case 7: {
                        this.checkContainment(!b.containsAll(a) && !a.containsAll(b) && CollectionUtilities.containsSome(a, b), a, relation, b);
                    }
                }
            }
        }
        if (resultMask != 255) {
            String missing = "";
            for (int i = 0; i < 8; ++i) {
                if ((resultMask & 1 << i) != 0) continue;
                if (missing.length() != 0) {
                    missing = missing + ", ";
                }
                missing = missing + RelationName[i];
            }
            this.errln("Not all ContainmentRelations checked: " + missing);
        }
    }

    private void checkContainment(boolean c, Collection a, int relation, Collection b) {
        if (!c) {
            this.errln("Fails relation: " + a + " \t" + RelationName[relation] + " \t" + b);
        }
    }

    private void checkNext(int limit) {
        this.logln("Comparing nextRange");
        UnicodeMapIterator mi = new UnicodeMapIterator(this.map1);
        TreeMap localMap = new TreeMap();
        while (mi.nextRange()) {
            this.logln(Utility.hex((long)mi.codepoint) + ".." + Utility.hex((long)mi.codepointEnd) + " => " + mi.value);
            for (int i = mi.codepoint; i <= mi.codepointEnd; ++i) {
                if (i >= limit) continue;
                localMap.put(new Integer(i), mi.value);
            }
        }
        this.checkMap(this.map2, localMap);
        this.logln("Comparing next");
        mi.reset();
        localMap = new TreeMap();
        Object lastValue = new Object();
        while (mi.next()) {
            if (!UnicodeMap.areEqual(lastValue, mi.value)) {
                lastValue = mi.value;
            }
            if (mi.codepoint >= limit) continue;
            localMap.put(new Integer(mi.codepoint), mi.value);
        }
        this.checkMap(this.map2, localMap);
    }

    public void check(int counter) {
        for (int i = 0; i < 21; ++i) {
            Object value2;
            Object value1 = this.map1.getValue(i);
            if (UnicodeMap.areEqual(value1, value2 = this.map2.get(new Integer(i)))) continue;
            this.errln(counter + " Difference at " + Utility.hex((long)i) + "\t UnicodeMap: " + value1 + "\t HashMap: " + value2);
            this.errln("UnicodeMap: " + this.map1);
            this.errln("Log: " + TestBoilerplate.show((Collection)this.log));
            this.errln("HashMap: " + TestBoilerplate.show((Map)this.map2));
        }
    }

    void checkMap(Map m1, Map m2) {
        if (((Object)m1).equals(m2)) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        Set m1entries = m1.entrySet();
        Set m2entries = m2.entrySet();
        this.getEntries("\r\nIn First, and not Second", m1entries, m2entries, buffer, 20);
        this.getEntries("\r\nIn Second, and not First", m2entries, m1entries, buffer, 20);
        this.errln(buffer.toString());
    }

    private void getEntries(String title, Set m1entries, Set m2entries, StringBuffer buffer, int limit) {
        TreeSet m1_m2 = new TreeSet(ENTRY_COMPARATOR);
        m1_m2.addAll(m1entries);
        m1_m2.removeAll(m2entries);
        buffer.append(title + ": " + m1_m2.size() + "\r\n");
        Iterator it = m1_m2.iterator();
        while (it.hasNext()) {
            if (limit-- < 0) {
                return;
            }
            Map.Entry entry = (Map.Entry)it.next();
            buffer.append(entry.getKey()).append(" => ").append(entry.getValue()).append("\r\n");
        }
    }

    public void TestTime() {
        double umTime = this.checkSetTime(20, 0);
        double hashTime = this.checkSetTime(20, 1);
        this.logln("Percentage: " + pf.format(hashTime / umTime));
        double treeTime = this.checkSetTime(20, 3);
        this.logln("Percentage: " + pf.format(treeTime / umTime));
        umTime = this.checkGetTime(1000, 0);
        hashTime = this.checkGetTime(1000, 1);
        this.logln("Percentage: " + pf.format(hashTime / umTime));
        double icuTime = this.checkGetTime(1000, 2);
        this.logln("Percentage: " + pf.format(icuTime / umTime));
        treeTime = this.checkGetTime(1000, 3);
        this.logln("Percentage: " + pf.format(treeTime / umTime));
    }

    double checkSetTime(int iterations, int type) {
        this._checkSetTime(1, type);
        double result = this._checkSetTime(iterations, type);
        this.logln((type == 0 ? "UnicodeMap" : (type == 1 ? "HashMap" : (type == 2 ? "ICU" : "TreeMap"))) + "\t" + nf.format(result));
        return result;
    }

    double _checkSetTime(int iterations, int type) {
        this.map1 = new UnicodeMap();
        this.map2 = new HashMap();
        System.gc();
        double start = System.currentTimeMillis();
        for (int j = 0; j < iterations; ++j) {
            block6: for (int cp = 0; cp <= 0x10FFFF; ++cp) {
                int enumValue = UCharacter.getIntPropertyValue((int)cp, (int)this.propEnum);
                if (enumValue <= 0) continue;
                String value = UCharacter.getPropertyValueName((int)this.propEnum, (int)enumValue, (int)1);
                switch (type) {
                    case 0: {
                        this.map1.put(cp, value);
                        continue block6;
                    }
                    case 1: {
                        this.map2.put(new Integer(cp), value);
                        continue block6;
                    }
                    case 3: {
                        this.map3.put(new Integer(cp), value);
                    }
                }
            }
        }
        double end = System.currentTimeMillis();
        return (end - start) / 1000.0 / (double)iterations;
    }

    double checkGetTime(int iterations, int type) {
        this._checkGetTime(1, type);
        double result = this._checkGetTime(iterations, type);
        this.logln((type == 0 ? "UnicodeMap" : (type == 1 ? "HashMap" : (type == 2 ? "ICU" : "TreeMap"))) + "\t" + nf.format(result));
        return result;
    }

    double _checkGetTime(int iterations, int type) {
        System.gc();
        double start = System.currentTimeMillis();
        for (int j = 0; j < iterations; ++j) {
            block7: for (int cp = 0; cp < 65535; ++cp) {
                switch (type) {
                    case 0: {
                        this.map1.getValue(cp);
                        continue block7;
                    }
                    case 1: {
                        this.map2.get(new Integer(cp));
                        continue block7;
                    }
                    case 2: {
                        int enumValue = UCharacter.getIntPropertyValue((int)cp, (int)this.propEnum);
                        UCharacter.getPropertyValueName((int)this.propEnum, (int)enumValue, (int)1);
                        continue block7;
                    }
                    case 3: {
                        this.map3.get(new Integer(cp));
                    }
                }
            }
        }
        double end = System.currentTimeMillis();
        return (end - start) / 1000.0 / (double)iterations;
    }

    static class UnicodeSetBoilerplate
    extends TestBoilerplate {
        UnicodeSetBoilerplate() {
        }

        protected boolean _hasSameBehavior(Object a, Object b) {
            return true;
        }

        protected boolean _addTestObject(List list) {
            if (list.size() > 32) {
                return false;
            }
            UnicodeSet result = new UnicodeSet();
            for (int i = 0; i < 50; ++i) {
                result.add(random.nextInt(100));
            }
            list.add(result.toString());
            return true;
        }
    }

    static class StringBoilerplate
    extends TestBoilerplate {
        StringBoilerplate() {
        }

        protected boolean _hasSameBehavior(Object a, Object b) {
            return true;
        }

        protected boolean _addTestObject(List list) {
            if (list.size() > 31) {
                return false;
            }
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < 10; ++i) {
                result.append((char)random.nextInt(255));
            }
            list.add(result.toString());
            return true;
        }
    }

    static class UnicodeMapBoilerplate
    extends TestBoilerplate {
        UnicodeMapBoilerplate() {
        }

        protected boolean _hasSameBehavior(Object a, Object b) {
            return true;
        }

        protected boolean _addTestObject(List list) {
            if (list.size() > 30) {
                return false;
            }
            UnicodeMap<String> result = new UnicodeMap<String>();
            for (int i = 0; i < 50; ++i) {
                int start = random.nextInt(25);
                String value = TEST_VALUES[random.nextInt(TEST_VALUES.length)];
                result.put(start, value);
            }
            list.add(result);
            return true;
        }
    }
}

