/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.TextTrieMap;
import java.util.Iterator;

public class TextTrieMapTest
extends TestFmwk {
    private static final Integer SUN = new Integer(1);
    private static final Integer MON = new Integer(2);
    private static final Integer TUE = new Integer(3);
    private static final Integer WED = new Integer(4);
    private static final Integer THU = new Integer(5);
    private static final Integer FRI = new Integer(6);
    private static final Integer SAT = new Integer(7);
    private static final Integer FOO = new Integer(-1);
    private static final Integer BAR = new Integer(-2);
    private static final Object[][] TESTDATA = new Object[][]{{"Sunday", SUN}, {"Monday", MON}, {"Tuesday", TUE}, {"Wednesday", WED}, {"Thursday", THU}, {"Friday", FRI}, {"Saturday", SAT}, {"Sun", SUN}, {"Mon", MON}, {"Tue", TUE}, {"Wed", WED}, {"Thu", THU}, {"Fri", FRI}, {"Sat", SAT}, {"S", SUN}, {"M", MON}, {"T", TUE}, {"W", WED}, {"T", THU}, {"F", FRI}, {"S", SAT}};
    private static final Object[][] TESTCASES = new Object[][]{{"Sunday", SUN, SUN}, {"sunday", null, SUN}, {"Mo", MON, MON}, {"mo", null, MON}, {"Thursday Friday", THU, THU}, {"T", new Object[]{TUE, THU}, new Object[]{TUE, THU}}, {"TEST", new Object[]{TUE, THU}, new Object[]{TUE, THU}}, {"SUN", new Object[]{SUN, SAT}, SUN}, {"super", null, SUN}, {"NO", null, null}};

    public static void main(String[] args) throws Exception {
        TextTrieMapTest test = new TextTrieMapTest();
        test.run(args);
    }

    public void TestCaseSensitive() {
        int i;
        Iterator itr = null;
        TextTrieMap map = new TextTrieMap(false);
        for (i = 0; i < TESTDATA.length; ++i) {
            map.put((CharSequence)((String)TESTDATA[i][0]), TESTDATA[i][1]);
        }
        this.logln("Test for get(String)");
        for (i = 0; i < TESTCASES.length; ++i) {
            itr = map.get((String)TESTCASES[i][0]);
            this.checkResult(itr, TESTCASES[i][1]);
        }
        this.logln("Test for get(String, int)");
        StringBuffer textBuf = new StringBuffer();
        for (int i2 = 0; i2 < TESTCASES.length; ++i2) {
            textBuf.setLength(0);
            for (int j = 0; j < i2; ++j) {
                textBuf.append('X');
            }
            textBuf.append(TESTCASES[i2][0]);
            itr = map.get((CharSequence)textBuf.toString(), i2);
            this.checkResult(itr, TESTCASES[i2][1]);
        }
        map.put((CharSequence)"Sunday", (Object)FOO);
        map.put((CharSequence)"sunday", (Object)BAR);
        itr = map.get("Sunday");
        this.checkResult(itr, new Object[]{FOO, SUN});
    }

    public void TestCaseInsensitive() {
        int i;
        Iterator itr = null;
        TextTrieMap map = new TextTrieMap(true);
        for (i = 0; i < TESTDATA.length; ++i) {
            map.put((CharSequence)((String)TESTDATA[i][0]), TESTDATA[i][1]);
        }
        this.logln("Test for get(String)");
        for (i = 0; i < TESTCASES.length; ++i) {
            itr = map.get((String)TESTCASES[i][0]);
            this.checkResult(itr, TESTCASES[i][2]);
        }
        this.logln("Test for get(String, int)");
        StringBuffer textBuf = new StringBuffer();
        for (int i2 = 0; i2 < TESTCASES.length; ++i2) {
            textBuf.setLength(0);
            for (int j = 0; j < i2; ++j) {
                textBuf.append('X');
            }
            textBuf.append(TESTCASES[i2][0]);
            itr = map.get((CharSequence)textBuf.toString(), i2);
            this.checkResult(itr, TESTCASES[i2][2]);
        }
        map.put((CharSequence)"Sunday", (Object)FOO);
        map.put((CharSequence)"sunday", (Object)BAR);
        itr = map.get("Sunday");
        this.checkResult(itr, new Object[]{SUN, FOO, BAR});
    }

    private boolean eql(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == null && o2 == null;
        }
        return o1.equals(o2);
    }

    private void checkResult(Iterator itr, Object expected) {
        if (itr == null) {
            if (expected != null) {
                this.errln("FAIL: Empty results - Expected: " + expected);
            }
            return;
        }
        if (expected == null && itr != null) {
            this.errln("FAIL: Empty result is expected");
            return;
        }
        Object[] exp = expected instanceof Object[] ? (Object[])expected : new Object[]{expected};
        boolean[] found = new boolean[exp.length];
        while (itr.hasNext()) {
            Object val = itr.next();
            for (int i = 0; i < exp.length; ++i) {
                if (!this.eql(exp[i], val)) continue;
                found[i] = true;
            }
        }
        for (int i = 0; i < exp.length; ++i) {
            if (found[i]) continue;
            this.errln("FAIL: The search result does not contain " + exp[i]);
        }
    }
}

