/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;

public final class Timer {
    public static final long SECONDS = 100000000L;
    private long startTime;
    private long duration;
    private boolean timing = false;
    private int iterations;
    private long timingPeriod = 500000000L;
    private DecimalFormat nf;
    private DecimalFormat pf;

    public Timer() {
        this.start();
        this.nf = (DecimalFormat)NumberFormat.getNumberInstance((ULocale)ULocale.ENGLISH);
        this.pf = (DecimalFormat)NumberFormat.getPercentInstance((ULocale)ULocale.ENGLISH);
        this.pf.setMaximumFractionDigits(1);
        this.pf.setPositivePrefix("+");
    }

    public Timer start() {
        this.startTime = System.nanoTime();
        this.timing = true;
        this.duration = Long.MIN_VALUE;
        return this;
    }

    public long getDuration() {
        if (this.timing) {
            this.duration = System.nanoTime() - this.startTime;
            this.timing = false;
        }
        return this.duration;
    }

    public long stop() {
        return this.getDuration();
    }

    public int getIterations() {
        return this.iterations;
    }

    public long getTimingPeriod() {
        return this.timingPeriod;
    }

    public Timer setTimingPeriod(long timingPeriod) {
        this.timingPeriod = timingPeriod;
        return this;
    }

    public DecimalFormat getNumberFormat() {
        return this.nf;
    }

    public DecimalFormat getPercentFormat() {
        return this.pf;
    }

    public String toString() {
        return this.nf.format(this.getDuration()) + "\tns";
    }

    public String toString(Timer other) {
        return this.toString(1L, other.getDuration());
    }

    public String toString(long iterations) {
        return this.nf.format(this.getDuration() / iterations) + "\tns";
    }

    public String toString(long iterations, long other) {
        return this.nf.format(this.getDuration() / iterations) + "\tns\t" + this.pf.format((double)this.getDuration() / (double)other - 1.0) + "";
    }

    public long timeIterations(Loop loop, Object ... params) {
        loop.init(params);
        System.gc();
        this.start();
        loop.time(1);
        this.stop();
        this.iterations = 1;
        long shortest = Long.MAX_VALUE;
        while (true) {
            System.gc();
            this.start();
            loop.time(this.iterations);
            this.stop();
            if (this.duration >= this.timingPeriod) {
                this.duration /= (long)this.iterations;
                return Math.min(this.duration, shortest);
            }
            if (this.duration >= this.timingPeriod / 4L) {
                this.duration /= (long)this.iterations;
                shortest = Math.min(this.duration, shortest);
                this.iterations = this.iterations * 4 / 3 + 1;
                continue;
            }
            this.iterations *= 2;
        }
    }

    public static abstract class Loop {
        public void init(Object ... params) {
        }

        public abstract void time(int var1);
    }
}

