/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.text.Transliterator;
import java.io.BufferedReader;
import java.io.IOException;

public class TransliteratorUtilities {
    public static boolean DEBUG = false;
    private static final String BASE_RULES = ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; ";
    private static final String CONTENT_RULES = "'>' > '&gt;' ;";
    private static final String HTML_RULES = ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; ";
    private static final String HTML_RULES_CONTROLS = ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; :: [[:C:][:Z:][:whitespace:][:Default_Ignorable_Code_Point:]] hex/unicode ; ";
    private static final String HTML_RULES_ASCII = ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; :: [[:C:][:^ASCII:]] any-hex/xml ; ";
    private static final String XML_RULES = ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; '' > '&apos;' ; ";
    public static final Transliterator toXML = Transliterator.createFromRules((String)"any-xml", (String)":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; '' > '&apos;' ; ", (int)0);
    public static final Transliterator fromXML = Transliterator.createFromRules((String)"xml-any", (String)":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; '' > '&apos;' ; ", (int)1);
    public static final Transliterator toHTML = Transliterator.createFromRules((String)"any-html", (String)":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; ", (int)0);
    public static final Transliterator toHTMLControl = Transliterator.createFromRules((String)"any-html", (String)":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; :: [[:C:][:Z:][:whitespace:][:Default_Ignorable_Code_Point:]] hex/unicode ; ", (int)0);
    public static final Transliterator toHTMLAscii = Transliterator.createFromRules((String)"any-html", (String)":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; :: [[:C:][:^ASCII:]] any-hex/xml ; ", (int)0);
    public static final Transliterator fromHTML = Transliterator.createFromRules((String)"html-any", (String)":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; ", (int)1);

    public static void registerTransliteratorFromFile(String dir, String id) {
        try {
            String rid;
            String filename = id.replace('-', '_') + ".txt";
            String rules = TransliteratorUtilities.getFileContents(dir, filename);
            int pos = id.indexOf(45);
            if (pos < 0) {
                rid = id + "-Any";
                id = "Any-" + id;
            } else {
                rid = id.substring(pos + 1) + "-" + id.substring(0, pos);
            }
            Transliterator t = Transliterator.createFromRules((String)id, (String)rules, (int)0);
            Transliterator.unregister((String)id);
            Transliterator.registerInstance((Transliterator)t);
            t = Transliterator.createFromRules((String)rid, (String)rules, (int)1);
            Transliterator.unregister((String)rid);
            Transliterator.registerInstance((Transliterator)t);
            if (DEBUG) {
                System.out.println("Registered new Transliterator: " + id + ", " + rid);
            }
        }
        catch (IOException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't open " + dir + ", " + id).initCause(e);
        }
    }

    public static String getFileContents(String dir, String filename) throws IOException {
        String line;
        BufferedReader br = BagFormatter.openUTF8Reader(dir, filename);
        StringBuffer buffer = new StringBuffer();
        while ((line = br.readLine()) != null) {
            if (line.length() > 0 && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
            }
            buffer.append(line).append("\r\n");
        }
        br.close();
        return buffer.toString();
    }
}

