/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.Trie2;
import com.ibm.icu.impl.Trie2Writable;
import com.ibm.icu.impl.Trie2_16;
import com.ibm.icu.impl.Trie2_32;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

public class Trie2Test
extends TestFmwk {
    String[] trieNames = new String[]{"setRanges1", "setRanges2", "setRanges3", "setRangesEmpty", "setRangesSingleValue"};
    private static int[][] setRanges1 = new int[][]{{0, 0, 0, 0}, {0, 64, 0, 0}, {64, 231, 4660, 0}, {231, 13312, 0, 0}, {13312, 40870, 24930, 0}, {40870, 55966, 12594, 0}, {56026, 61166, 34815, 0}, {61166, 69905, 1, 0}, {69905, 279620, 24930, 0}, {279620, 393219, 0, 0}, {983043, 983044, 15, 0}, {983044, 983046, 16, 0}, {983046, 983047, 17, 0}, {983047, 983104, 18, 0}, {983104, 0x110000, 0, 0}};
    private static int[][] checkRanges1 = new int[][]{{0, 0}, {64, 0}, {231, 4660}, {13312, 0}, {40870, 24930}, {55966, 12594}, {56026, 0}, {61166, 34815}, {69905, 1}, {279620, 24930}, {983043, 0}, {983044, 15}, {983046, 16}, {983047, 17}, {983104, 18}, {0x110000, 0}};
    private static int[][] setRanges2 = new int[][]{{0, 0, 0, 0}, {33, 127, 21845, 1}, {194560, 196316, 122, 1}, {114, 221, 3, 1}, {221, 222, 4, 0}, {513, 576, 6, 1}, {577, 640, 6, 1}, {641, 704, 6, 1}, {194951, 195224, 5, 1}, {194423, 194691, 0, 1}, {194816, 196522, 1, 0}, {196522, 196523, 2, 1}, {196539, 196544, 7, 1}};
    private static int[][] checkRanges2 = new int[][]{{0, 0}, {33, 0}, {114, 21845}, {221, 3}, {222, 4}, {513, 0}, {576, 6}, {577, 0}, {640, 6}, {641, 0}, {704, 6}, {194691, 0}, {194951, 122}, {195224, 5}, {196316, 122}, {196522, 1}, {196523, 2}, {196539, 0}, {196544, 7}, {0x110000, 0}};
    private static int[][] setRanges3 = new int[][]{{0, 0, 9, 0}, {49, 164, 1, 0}, {13312, 26505, 2, 0}, {32768, 35243, 9, 1}, {36864, 40960, 4, 1}, {43981, 48350, 3, 1}, {349525, 0x110000, 6, 1}, {52428, 349525, 6, 1}};
    private static int[][] checkRanges3 = new int[][]{{0, 9}, {49, 9}, {164, 1}, {13312, 9}, {26505, 2}, {36864, 9}, {40960, 4}, {43981, 9}, {48350, 3}, {52428, 9}, {0x110000, 6}};
    private static int[][] setRangesEmpty = new int[][]{{0, 0, 3, 0}};
    private static int[][] checkRangesEmpty = new int[][]{{0, 3}, {0x110000, 3}};
    private static int[][] setRangesSingleValue = new int[][]{{0, 0, 3, 0}, {0, 0x110000, 5, 1}};
    private static int[][] checkRangesSingleValue = new int[][]{{0, 3}, {0x110000, 5}};

    public static void main(String[] arg) {
        Trie2Test test = new Trie2Test();
        try {
            test.run(arg);
        }
        catch (Exception e) {
            test.errln("Error testing trietest");
        }
    }

    public void TestTrie2API() {
        Trie2Writable trie;
        try {
            trie = new Trie2Writable(0, 0);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            trie.toTrie2_16().serialize((OutputStream)os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            this.assertEquals((String)null, 2L, Trie2.getVersion((InputStream)is, (boolean)true));
        }
        catch (IOException e) {
            this.errln(this.where() + e.toString());
        }
        Trie2Writable trieWA = new Trie2Writable(0, 0);
        Trie2Writable trieWB = new Trie2Writable(0, 0);
        Trie2Writable trieA = trieWA;
        Trie2Writable trieB = trieWB;
        this.assertTrue("", trieA.equals((Object)trieB));
        this.assertEquals("", trieA, trieB);
        this.assertEquals("", trieA.hashCode(), trieB.hashCode());
        trieWA.set(500, 2);
        this.assertNotEquals("", trieA, trieB);
        this.assertNotEquals("", trieA.hashCode(), trieB.hashCode());
        trieWB.set(500, 2);
        trieA = trieWA.toTrie2_16();
        this.assertEquals("", trieA, trieB);
        this.assertEquals("", trieA.hashCode(), trieB.hashCode());
        trie = new Trie2Writable(17, 0);
        Iterator it = trie.iterator();
        Trie2.Range r = (Trie2.Range)it.next();
        this.assertEquals("", 0L, r.startCodePoint);
        this.assertEquals("", 0x10FFFFL, r.endCodePoint);
        this.assertEquals("", 17L, r.value);
        this.assertEquals("", false, r.leadSurrogate);
        r = (Trie2.Range)it.next();
        this.assertEquals("", 55296L, r.startCodePoint);
        this.assertEquals("", 56319L, r.endCodePoint);
        this.assertEquals("", 17L, r.value);
        this.assertEquals("", true, r.leadSurrogate);
        int i = 0;
        for (Trie2.Range rr : trie) {
            switch (i) {
                case 0: {
                    this.assertEquals("", 0L, rr.startCodePoint);
                    this.assertEquals("", 0x10FFFFL, rr.endCodePoint);
                    this.assertEquals("", 17L, rr.value);
                    this.assertEquals("", false, rr.leadSurrogate);
                    break;
                }
                case 1: {
                    this.assertEquals("", 55296L, rr.startCodePoint);
                    this.assertEquals("", 56319L, rr.endCodePoint);
                    this.assertEquals("", 17L, rr.value);
                    this.assertEquals("", true, rr.leadSurrogate);
                    break;
                }
                default: {
                    this.errln(this.where() + " Unexpected iteration result");
                }
            }
            ++i;
        }
        trie = new Trie2Writable(195952365, 0);
        trie.set(65827, 42);
        Trie2.ValueMapper vm = new Trie2.ValueMapper(){

            public int map(int v) {
                if (v == 195952365) {
                    v = 42;
                }
                return v;
            }
        };
        Iterator it2 = trie.iterator(vm);
        Trie2.Range r2 = (Trie2.Range)it2.next();
        this.assertEquals("", 0L, r2.startCodePoint);
        this.assertEquals("", 0x10FFFFL, r2.endCodePoint);
        this.assertEquals("", 42L, r2.value);
        this.assertEquals("", false, r2.leadSurrogate);
        trie = new Trie2Writable(14613015, 0);
        trie.set(194576, 10);
        it = trie.iteratorForLeadSurrogate('\ud87e');
        r = (Trie2.Range)it.next();
        this.assertEquals("", 194560L, r.startCodePoint);
        this.assertEquals("", 194575L, r.endCodePoint);
        this.assertEquals("", 14613015L, r.value);
        this.assertEquals("", false, r.leadSurrogate);
        r = (Trie2.Range)it.next();
        this.assertEquals("", 194576L, r.startCodePoint);
        this.assertEquals("", 194576L, r.endCodePoint);
        this.assertEquals("", 10L, r.value);
        this.assertEquals("", false, r.leadSurrogate);
        r = (Trie2.Range)it.next();
        this.assertEquals("", 194577L, r.startCodePoint);
        this.assertEquals("", 195583L, r.endCodePoint);
        this.assertEquals("", 14613015L, r.value);
        this.assertEquals("", false, r.leadSurrogate);
        this.assertFalse("", it.hasNext());
        trie = new Trie2Writable(14613015, 0);
        trie.set(194576, 10);
        Trie2.ValueMapper m = new Trie2.ValueMapper(){

            public int map(int in) {
                if (in == 10) {
                    in = 14613015;
                }
                return in;
            }
        };
        it2 = trie.iteratorForLeadSurrogate('\ud87e', m);
        r2 = (Trie2.Range)it2.next();
        this.assertEquals("", 194560L, r2.startCodePoint);
        this.assertEquals("", 195583L, r2.endCodePoint);
        this.assertEquals("", 14613015L, r2.value);
        this.assertEquals("", false, r2.leadSurrogate);
        this.assertFalse("", it2.hasNext());
        trie = new Trie2Writable(101, 0);
        trie.setRange(61440, 245760, 200, true);
        trie.set(65518, 300);
        Trie2_16 frozen16 = trie.toTrie2_16();
        Trie2_32 frozen32 = trie.toTrie2_32();
        this.assertEquals("", trie, frozen16);
        this.assertEquals("", trie, frozen32);
        this.assertEquals("", frozen16, frozen32);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            frozen16.serialize((OutputStream)os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            Trie2 unserialized16 = Trie2.createFromSerialized((InputStream)is);
            this.assertEquals("", trie, unserialized16);
            this.assertEquals("", Trie2_16.class, unserialized16.getClass());
            os.reset();
            frozen32.serialize((OutputStream)os);
            is = new ByteArrayInputStream(os.toByteArray());
            Trie2 unserialized32 = Trie2.createFromSerialized((InputStream)is);
            this.assertEquals("", trie, unserialized32);
            this.assertEquals("", Trie2_32.class, unserialized32.getClass());
        }
        catch (IOException e) {
            this.errln(this.where() + " Unexpected exception:  " + e);
        }
    }

    public void TestTrie2WritableAPI() {
        Trie2Writable t1 = new Trie2Writable(6, 666);
        Trie2Writable t2 = new Trie2Writable((Trie2)t1);
        this.assertTrue("", t1.equals((Object)t2));
        Trie2Writable t1w = new Trie2Writable(10, 666);
        t1w.set(17767, 99);
        this.assertEquals("", 10L, t1w.get(17766));
        this.assertEquals("", 99L, t1w.get(17767));
        this.assertEquals("", 666L, t1w.get(-1));
        this.assertEquals("", 666L, t1w.get(0x110000));
        t1w = new Trie2Writable(10, 666);
        t1w.setRange(13, 6666, 7788, false);
        t1w.setRange(6000, 7000, 9900, true);
        this.assertEquals("", 10L, t1w.get(12));
        this.assertEquals("", 7788L, t1w.get(13));
        this.assertEquals("", 7788L, t1w.get(5999));
        this.assertEquals("", 9900L, t1w.get(6000));
        this.assertEquals("", 9900L, t1w.get(7000));
        this.assertEquals("", 10L, t1w.get(7001));
        this.assertEquals("", 666L, t1w.get(0x110000));
        Trie2.Range r = new Trie2.Range();
        r.startCodePoint = 50;
        r.endCodePoint = 52;
        r.value = 305419896;
        r.leadSurrogate = false;
        t1w = new Trie2Writable(0, 2989);
        t1w.setRange(r, true);
        this.assertEquals((String)null, 0L, t1w.get(49));
        this.assertEquals("", 305419896L, t1w.get(50));
        this.assertEquals("", 305419896L, t1w.get(52));
        this.assertEquals("", 0L, t1w.get(53));
        t1w = new Trie2Writable(10, 2989);
        this.assertEquals("", 10L, t1w.getFromU16SingleLead('\ud801'));
        t1w.setForLeadSurrogateCodeUnit('\ud801', 5000);
        t1w.set(55297, 6000);
        this.assertEquals("", 5000L, t1w.getFromU16SingleLead('\ud801'));
        this.assertEquals("", 6000L, t1w.get(55297));
        t1w = new Trie2Writable(10, 666);
        t1w.set(42, 5555);
        t1w.set(130816, 224);
        Trie2_16 t1_16 = t1w.toTrie2_16();
        this.assertTrue("", t1w.equals((Object)t1_16));
        t1w.set(152, 129);
        t1_16 = t1w.toTrie2_16();
        this.assertTrue("", t1w.equals((Object)t1_16));
        this.assertEquals("", 129L, t1w.get(152));
        t1w = new Trie2Writable(10, 666);
        t1w.set(42, 5555);
        t1w.set(130816, 224);
        Trie2_32 t1_32 = t1w.toTrie2_32();
        this.assertTrue("", t1w.equals((Object)t1_32));
        t1w.set(152, 129);
        this.assertNotEquals("", t1_32, t1w);
        t1_32 = t1w.toTrie2_32();
        this.assertTrue("", t1w.equals((Object)t1_32));
        this.assertEquals("", 129L, t1w.get(152));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        t1w = new Trie2Writable(0, 2989);
        t1w.set(65, 256);
        t1w.set(194, 512);
        t1w.set(1028, 768);
        t1w.set(55555, 1280);
        t1w.set(56617, 1536);
        t1w.set(1070547, 1792);
        t1w.setForLeadSurrogateCodeUnit('\uda1a', 2048);
        try {
            int serializedLen = t1w.toTrie2_16().serialize((OutputStream)os);
            this.assertEquals("", 3508L, serializedLen);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            Trie2 t1ws16 = Trie2.createFromSerialized((InputStream)is);
            this.assertEquals("", t1ws16.getClass(), Trie2_16.class);
            this.assertEquals("", t1w, t1ws16);
            os.reset();
            serializedLen = t1w.toTrie2_32().serialize((OutputStream)os);
            this.assertEquals("", 4332L, serializedLen);
            is = new ByteArrayInputStream(os.toByteArray());
            Trie2 t1ws32 = Trie2.createFromSerialized((InputStream)is);
            this.assertEquals("", t1ws32.getClass(), Trie2_32.class);
            this.assertEquals("", t1w, t1ws32);
        }
        catch (IOException e) {
            this.errln(this.where() + e.toString());
        }
    }

    public void TestCharSequenceIterator() {
        int expectedCP;
        Trie2.CharSequenceValues ir;
        String text = "abc123\ud800\udc01 ";
        String vals = "LLLNNNX?S";
        Trie2Writable tw = new Trie2Writable(0, 666);
        tw.setRange(97, 122, 76, false);
        tw.setRange(49, 57, 78, false);
        tw.set(32, 83);
        tw.set(65537, 88);
        Trie2.CharSequenceIterator it = tw.charSequenceIterator((CharSequence)text, 0);
        int i = 0;
        while (it.hasNext()) {
            ir = it.next();
            expectedCP = Character.codePointAt(text, i);
            this.assertEquals(" i=" + i, expectedCP, ir.codePoint);
            this.assertEquals(" i=" + i, i, ir.index);
            this.assertEquals(" i=" + i, vals.charAt(i), ir.value);
            if (expectedCP >= 65536) {
                ++i;
            }
            ++i;
        }
        this.assertEquals("", text.length(), i);
        it.set(5);
        i = 5;
        while (it.hasPrevious()) {
            ir = it.previous();
            this.assertEquals(" i=" + (i -= (expectedCP = Character.codePointBefore(text, i)) < 65536 ? 1 : 2), expectedCP, ir.codePoint);
            this.assertEquals(" i=" + i, i, ir.index);
            this.assertEquals(" i=" + i, vals.charAt(i), ir.value);
        }
        this.assertEquals("", 0L, i);
    }

    private Trie2Writable genTrieFromSetRanges(int[][] ranges) {
        int i = 0;
        int initialValue = 0;
        int errorValue = 2989;
        if (ranges[i][1] < 0) {
            errorValue = ranges[i][2];
        }
        int n = ++i;
        ++i;
        initialValue = ranges[n][2];
        Trie2Writable trie = new Trie2Writable(initialValue, errorValue);
        while (i < ranges.length) {
            int rangeStart = ranges[i][0];
            int rangeEnd = ranges[i][1] - 1;
            int value = ranges[i][2];
            boolean overwrite = ranges[i][3] != 0;
            trie.setRange(rangeStart, rangeEnd, value, overwrite);
            ++i;
        }
        trie.setForLeadSurrogateCodeUnit('\ud800', 90);
        trie.setForLeadSurrogateCodeUnit('\ud999', 94);
        trie.setForLeadSurrogateCodeUnit('\udbff', 99);
        return trie;
    }

    private void trieGettersTest(String testName, Trie2 trie, int[][] checkRanges) {
        int value2;
        int value;
        int countCheckRanges = checkRanges.length;
        int countSpecials = 0;
        int errorValue = 2989;
        int initialValue = 0;
        if (checkRanges[countSpecials][0] == 0) {
            initialValue = checkRanges[countSpecials][1];
            ++countSpecials;
        }
        int start = 0;
        for (int i = countSpecials; i < countCheckRanges; ++i) {
            int limit = checkRanges[i][0];
            value = checkRanges[i][1];
            while (start < limit) {
                value2 = trie.get(start);
                if (value != value2) {
                    this.assertEquals("wrong value for " + testName + " of " + Integer.toHexString(start), value, value2);
                }
                ++start;
            }
        }
        if (!testName.startsWith("dummy") && !testName.startsWith("trie1")) {
            for (start = 55295; start < 56321; ++start) {
                switch (start) {
                    case 55295: 
                    case 56320: {
                        value = trie.get(start);
                        break;
                    }
                    case 55296: {
                        value = 90;
                        break;
                    }
                    case 55705: {
                        value = 94;
                        break;
                    }
                    case 56319: {
                        value = 99;
                        break;
                    }
                    default: {
                        value = initialValue;
                    }
                }
                value2 = trie.getFromU16SingleLead((char)start);
                if (value2 == value) continue;
                this.errln(this.where() + " testName: " + testName + " getFromU16SingleLead() failed." + "char, exected, actual = " + Integer.toHexString(start) + ", " + Integer.toHexString(value) + ", " + Integer.toHexString(value2));
            }
        }
        value = trie.get(-1);
        value2 = trie.get(0x110000);
        if (value != errorValue || value2 != errorValue) {
            this.errln("trie2.get() error value test.  Expected, actual1, actual2 = " + errorValue + ", " + value + ", " + value2);
        }
        for (Trie2.Range range : trie) {
            for (int cp = range.startCodePoint; cp <= range.endCodePoint; ++cp) {
                if (range.leadSurrogate) {
                    this.assertTrue(testName, cp >= 55296 && cp < 56320);
                    this.assertEquals(testName, range.value, trie.getFromU16SingleLead((char)cp));
                    continue;
                }
                this.assertEquals(testName, range.value, trie.get(cp));
            }
        }
    }

    private void checkTrieRanges(String testName, String serializedName, boolean withClone, int[][] setRanges, int[][] checkRanges) throws IOException {
        String fileName16 = "Trie2Test." + serializedName + ".16.tri2";
        String fileName32 = "Trie2Test." + serializedName + ".32.tri2";
        InputStream is = Trie2Test.class.getResourceAsStream(fileName16);
        Trie2 trie16 = Trie2.createFromSerialized((InputStream)is);
        is.close();
        this.trieGettersTest(testName, trie16, checkRanges);
        is = Trie2Test.class.getResourceAsStream(fileName32);
        Trie2 trie32 = Trie2.createFromSerialized((InputStream)is);
        is.close();
        this.trieGettersTest(testName, trie32, checkRanges);
        Trie2Writable trieW = this.genTrieFromSetRanges(setRanges);
        this.trieGettersTest(testName, (Trie2)trieW, checkRanges);
        this.assertEquals("", trieW, trie16);
        this.assertEquals("", trieW, trie32);
        Trie2_32 trie32a = trieW.toTrie2_32();
        this.trieGettersTest(testName, (Trie2)trie32a, checkRanges);
        Trie2_16 trie16a = trieW.toTrie2_16();
        this.trieGettersTest(testName, (Trie2)trie16a, checkRanges);
    }

    public void TestRanges() throws IOException {
        this.checkTrieRanges("set1", "setRanges1", false, setRanges1, checkRanges1);
        this.checkTrieRanges("set2-overlap", "setRanges2", false, setRanges2, checkRanges2);
        this.checkTrieRanges("set3-initial-9", "setRanges3", false, setRanges3, checkRanges3);
        this.checkTrieRanges("set-empty", "setRangesEmpty", false, setRangesEmpty, checkRangesEmpty);
        this.checkTrieRanges("set-single-value", "setRangesSingleValue", false, setRangesSingleValue, checkRangesSingleValue);
        this.checkTrieRanges("set2-overlap.withClone", "setRanges2", true, setRanges2, checkRanges2);
    }

    private String where() {
        StackTraceElement[] st = new Throwable().getStackTrace();
        String w = "File: " + st[1].getFileName() + ", Line " + st[1].getLineNumber();
        return w;
    }
}

