/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.util.BytesTrie;
import com.ibm.icu.util.BytesTrieBuilder;
import com.ibm.icu.util.CharsTrie;
import com.ibm.icu.util.CharsTrieBuilder;
import com.ibm.icu.util.StringTrieBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TrieMap<V>
implements Iterable<Map.Entry<CharSequence, V>> {
    private static final boolean DEBUG = true;
    protected final V[] intToValue;
    protected final int size;

    protected TrieMap(V[] intToValue, int size) {
        this.intToValue = intToValue;
        this.size = size;
    }

    public int keyByteSize() {
        return this.size;
    }

    public abstract V get(CharSequence var1);

    @Override
    public abstract Iterator<Map.Entry<CharSequence, V>> iterator();

    public abstract Matcher<V> getMatcher();

    public static String toString(BytesTrie bytesTrie2) {
        return TrieMap.toString(bytesTrie2, " : ", "\n");
    }

    public static String toString(BytesTrie bytesTrie2, String keyValueSeparator, String itemSeparator) {
        StringBuilder buffer = new StringBuilder();
        for (BytesTrie.Entry bytesEntry : bytesTrie2) {
            int len = bytesEntry.bytesLength();
            byte[] bytes = new byte[len];
            bytesEntry.copyBytesTo(bytes, 0);
            buffer.append(Utility.hex((byte[])bytes, (int)0, (int)len, (String)" ")).append(keyValueSeparator).append(bytesEntry.value).append(itemSeparator);
        }
        return buffer.toString();
    }

    public static String toString(CharsTrie bytesTrie2, String keyValueSeparator, String itemSeparator) {
        StringBuilder buffer = new StringBuilder();
        for (CharsTrie.Entry bytesEntry : bytesTrie2) {
            buffer.append(Utility.hex((CharSequence)bytesEntry.chars)).append(keyValueSeparator).append(bytesEntry.value).append(itemSeparator);
        }
        return buffer.toString();
    }

    static class ByteConverter {
        ByteConverter() {
        }

        public static int getBytes(char source, byte[] bytes, int limit) {
            if (source < '\u0080') {
                bytes[limit++] = (byte)source;
            } else if (source < '\u7f00') {
                bytes[limit++] = (byte)(0x80 | source >> 8);
                bytes[limit++] = (byte)source;
            } else {
                bytes[limit++] = -1;
                bytes[limit++] = (byte)(source >> 8);
                bytes[limit++] = (byte)source;
            }
            return limit;
        }

        public static int getBytes(CharSequence source, byte[] bytes, int limit) {
            for (int i = 0; i < source.length(); ++i) {
                limit = ByteConverter.getBytes(source.charAt(i), bytes, limit);
            }
            return limit;
        }

        public static String getChars(byte[] bytes, int start, int limit) {
            StringBuilder buffer = new StringBuilder();
            char[] output = new char[1];
            int i = start;
            while (i < limit) {
                i = ByteConverter.getChar(bytes, i, output);
                buffer.append(output[0]);
            }
            return buffer.toString();
        }

        public static int getChar(byte[] bytes, int start, char[] output) {
            byte b;
            if ((b = bytes[start++]) >= 0) {
                output[0] = (char)b;
            } else if (b != -1) {
                int b1 = 0x7F & b;
                int b2 = 0xFF & bytes[start++];
                output[0] = (char)(b1 << 8 | b2);
            } else {
                byte b2 = bytes[start++];
                int b3 = 0xFF & bytes[start++];
                output[0] = (char)(b2 << 8 | b3);
            }
            return start;
        }

        private static void getChars(BytesTrie.Entry entry, StringBuilder stringBuilder) {
            int len = entry.bytesLength();
            int i = 0;
            while (i < len) {
                byte b;
                if ((b = entry.byteAt(i++)) >= 0) {
                    stringBuilder.append((char)b);
                    continue;
                }
                if (b != -1) {
                    int b1 = 0x7F & b;
                    int b2 = 0xFF & entry.byteAt(i++);
                    stringBuilder.append((char)(b1 << 8 | b2));
                    continue;
                }
                byte b2 = entry.byteAt(i++);
                int b3 = 0xFF & entry.byteAt(i++);
                stringBuilder.append((char)(b2 << 8 | b3));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharsBuilder<V>
    extends Builder<V> {
        CharsTrieBuilder builder = new CharsTrieBuilder();

        @Override
        public CharsBuilder<V> add(CharSequence key, V value) {
            Integer index;
            if (this.option == StringTrieBuilder.Option.SMALL) {
                index = (Integer)this.valueToIntegerTemp.get(value);
                if (index == null) {
                    index = this.intToValueTemp.size();
                    this.intToValueTemp.add(value);
                    this.valueToIntegerTemp.put(value, index);
                }
            } else {
                index = this.intToValueTemp.size();
                this.intToValueTemp.add(value);
            }
            try {
                this.builder.add((CharSequence)((Object)key).toString(), index.intValue());
                return this;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to add " + value + ", " + key + "=" + Utility.hex((CharSequence)key), e);
            }
        }

        @Override
        public <K extends CharSequence> CharsBuilder<V> addAll(Map<K, V> keyValuePairs) {
            for (Map.Entry<K, V> entry : keyValuePairs.entrySet()) {
                this.add((CharSequence)entry.getKey(), (Object)entry.getValue());
            }
            return this;
        }

        @Override
        public TrieMap<V> build() {
            CharSequence buildCharSequence = this.builder.buildCharSequence(this.option);
            int size = 2 * buildCharSequence.length();
            CharsTrie charsTrie = new CharsTrie(buildCharSequence, 0);
            Object[] intToValueArray = this.intToValueTemp.toArray(new Object[this.intToValueTemp.size()]);
            return new CharsTrieMap(charsTrie, intToValueArray, size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharsTrieMap<V>
    extends TrieMap<V> {
        private final CharsTrie charsTrie;

        private CharsTrieMap(CharsTrie charsTrie, V[] intToValue, int size) {
            super(intToValue, size);
            this.charsTrie = charsTrie;
        }

        @Override
        public V get(CharSequence test) {
            BytesTrie.Result result = this.charsTrie.reset().next(test, 0, test.length());
            return (V)(result.hasValue() ? this.intToValue[this.charsTrie.getValue()] : null);
        }

        public String toString() {
            return CharsTrieMap.toString(this.charsTrie, " : ", "\n");
        }

        @Override
        public Iterator<Map.Entry<CharSequence, V>> iterator() {
            return new CharsIterator();
        }

        @Override
        public Matcher<V> getMatcher() {
            return new CharsMatcher();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CharsMatcher
        extends Matcher<V> {
            private V value = null;

            @Override
            public void set(CharSequence text, int start) {
                this.text = text;
                this.start = start;
                this.current = start;
            }

            @Override
            public int getStart() {
                return this.start;
            }

            @Override
            public int getEnd() {
                return this.current;
            }

            @Override
            public boolean next() {
                while (this.current < this.text.length()) {
                    char c = this.text.charAt(this.current++);
                    BytesTrie.Result result = CharsTrieMap.this.charsTrie.next((int)c);
                    if (result.hasValue()) {
                        this.value = CharsTrieMap.this.intToValue[CharsTrieMap.this.charsTrie.getValue()];
                        return result.hasNext();
                    }
                    if (result.matches()) continue;
                    this.value = null;
                    return false;
                }
                this.value = null;
                return false;
            }

            @Override
            public boolean nextStart() {
                if (this.start >= this.text.length()) {
                    return false;
                }
                ++this.start;
                this.current = this.start;
                CharsTrieMap.this.charsTrie.reset();
                return true;
            }

            @Override
            public V getValue() {
                return this.value;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CharsEntry
        implements Map.Entry<CharSequence, V> {
            public CharsTrie.Entry charsEntry;

            private CharsEntry() {
            }

            @Override
            public CharSequence getKey() {
                return this.charsEntry.chars;
            }

            @Override
            public V getValue() {
                return CharsTrieMap.this.intToValue[this.charsEntry.value];
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CharsIterator
        implements Iterator<Map.Entry<CharSequence, V>> {
            CharsTrie.Iterator iterator;
            CharsEntry entry;

            private CharsIterator() {
                this.iterator = CharsTrieMap.this.charsTrie.iterator();
                this.entry = new CharsEntry();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<CharSequence, V> next() {
                this.entry.charsEntry = this.iterator.next();
                return this.entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BytesBuilder<V>
    extends Builder<V> {
        BytesTrieBuilder builder = new BytesTrieBuilder();
        byte[] bytes = new byte[200];
        List<String> debugBytes = new ArrayList<String>();

        @Override
        public BytesBuilder<V> add(CharSequence key, V value) {
            Integer index;
            if (this.option == StringTrieBuilder.Option.SMALL) {
                index = (Integer)this.valueToIntegerTemp.get(value);
                if (index == null) {
                    index = this.intToValueTemp.size();
                    this.intToValueTemp.add(value);
                    this.valueToIntegerTemp.put(value, index);
                }
            } else {
                index = this.intToValueTemp.size();
                this.intToValueTemp.add(value);
            }
            if (this.bytes.length < key.length() * 3) {
                this.bytes = new byte[64 + key.length() * 3];
            }
            int limit = 0;
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                limit = ByteConverter.getBytes(c, this.bytes, limit);
            }
            try {
                this.builder.add(this.bytes, limit, index.intValue());
                return this;
            }
            catch (Exception e) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < limit; ++i) {
                    list.add(Utility.hex((long)this.bytes[i]));
                }
                throw new IllegalArgumentException("Failed to add " + value + ", " + key + "=" + list, e);
            }
        }

        @Override
        public <K extends CharSequence> BytesBuilder<V> addAll(Map<K, V> keyValuePairs) {
            for (Map.Entry<K, V> entry : keyValuePairs.entrySet()) {
                this.add((CharSequence)entry.getKey(), (Object)entry.getValue());
            }
            return this;
        }

        @Override
        public TrieMap<V> build() {
            int size = this.builder.buildByteBuffer(this.option).remaining();
            BytesTrie bytesTrie = this.builder.build(this.option);
            Object[] intToValueArray = this.intToValueTemp.toArray(new Object[this.intToValueTemp.size()]);
            return new BytesTrieMap(bytesTrie, intToValueArray, size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BytesTrieMap<V>
    extends TrieMap<V> {
        private final BytesTrie bytesTrie;
        private byte[] bytes = new byte[3];

        private BytesTrieMap(BytesTrie bytesTrie, V[] intToValue, int size) {
            super(intToValue, size);
            this.bytesTrie = bytesTrie;
        }

        @Override
        public V get(CharSequence test) {
            int length = test.length();
            this.bytesTrie.reset();
            if (length == 0) {
                return (V)(this.bytesTrie.current().hasValue() ? this.intToValue[this.bytesTrie.getValue()] : null);
            }
            BytesTrie.Result result = BytesTrie.Result.NO_VALUE;
            for (int i = 0; i < length; ++i) {
                if (!result.hasNext()) {
                    return null;
                }
                char c = test.charAt(i);
                int limit = ByteConverter.getBytes(c, this.bytes, 0);
                result = limit == 1 ? this.bytesTrie.next((int)this.bytes[0]) : this.bytesTrie.next(this.bytes, 0, limit);
            }
            return (V)(result.hasValue() ? this.intToValue[this.bytesTrie.getValue()] : null);
        }

        public String toString() {
            return BytesTrieMap.toString(this.bytesTrie, " : ", "\n");
        }

        @Override
        public Iterator<Map.Entry<CharSequence, V>> iterator() {
            return new BytesIterator();
        }

        @Override
        public Matcher<V> getMatcher() {
            return new BytesMatcher();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class BytesMatcher
        extends Matcher<V> {
            private byte[] bytes = new byte[3];
            private V value = null;

            @Override
            public void set(CharSequence text, int start) {
                this.text = text;
                this.start = start;
                this.current = start;
            }

            @Override
            public int getStart() {
                return this.start;
            }

            @Override
            public int getEnd() {
                return this.current;
            }

            @Override
            public boolean next() {
                while (this.current < this.text.length()) {
                    char c = this.text.charAt(this.current++);
                    int limit = ByteConverter.getBytes(c, this.bytes, 0);
                    for (int j = 0; j < limit; ++j) {
                        BytesTrie.Result result = BytesTrieMap.this.bytesTrie.next((int)this.bytes[j]);
                        if (result.hasValue()) {
                            if (j < limit - 1) {
                                throw new IllegalArgumentException("Data corrupt");
                            }
                            this.value = BytesTrieMap.this.intToValue[BytesTrieMap.this.bytesTrie.getValue()];
                            return result.hasNext();
                        }
                        if (result.matches()) continue;
                        this.value = null;
                        return false;
                    }
                }
                this.value = null;
                return false;
            }

            @Override
            public boolean nextStart() {
                if (this.start >= this.text.length()) {
                    return false;
                }
                ++this.start;
                this.current = this.start;
                BytesTrieMap.this.bytesTrie.reset();
                return true;
            }

            @Override
            public V getValue() {
                return this.value;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class BytesEntry
        implements Map.Entry<CharSequence, V> {
            public BytesTrie.Entry bytesEntry;
            StringBuilder buffer = new StringBuilder();

            private BytesEntry() {
            }

            @Override
            public CharSequence getKey() {
                this.buffer.setLength(0);
                ByteConverter.getChars(this.bytesEntry, this.buffer);
                return this.buffer;
            }

            @Override
            public V getValue() {
                return BytesTrieMap.this.intToValue[this.bytesEntry.value];
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class BytesIterator
        implements Iterator<Map.Entry<CharSequence, V>> {
            BytesTrie.Iterator iterator;
            BytesEntry entry;

            private BytesIterator() {
                this.iterator = BytesTrieMap.this.bytesTrie.iterator();
                this.entry = new BytesEntry();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<CharSequence, V> next() {
                this.entry.bytesEntry = this.iterator.next();
                return this.entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Matcher<V> {
        protected CharSequence text = "";
        protected int start = 0;
        protected int current = 0;

        abstract void set(CharSequence var1, int var2);

        abstract boolean next();

        abstract V getValue();

        abstract int getStart();

        abstract int getEnd();

        abstract boolean nextStart();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<V> {
        StringTrieBuilder.Option option;
        protected List<V> intToValueTemp = new ArrayList<V>();
        protected Map<V, Integer> valueToIntegerTemp = new HashMap<V, Integer>();

        public static <K extends CharSequence, V> Builder<V> with(Style style, Map<K, V> keyValuePairs) {
            return Builder.with(style, StringTrieBuilder.Option.SMALL, keyValuePairs);
        }

        public static <K extends CharSequence, V> Builder<V> with(Style style, StringTrieBuilder.Option option, Map<K, V> keyValuePairs) {
            Builder result = style == Style.BYTES ? new BytesBuilder() : new CharsBuilder();
            result.option = option;
            return result.addAll(keyValuePairs);
        }

        public static <K extends CharSequence, V> Builder<V> with(Style style, K key, V value) {
            return Builder.with(style, StringTrieBuilder.Option.SMALL, key, value);
        }

        public static <K extends CharSequence, V> Builder<V> with(Style style, StringTrieBuilder.Option option, K key, V value) {
            Builder result = style == Style.BYTES ? new BytesBuilder() : new CharsBuilder();
            result.option = option;
            return result.add(key, value);
        }

        public abstract Builder<V> add(CharSequence var1, V var2);

        public abstract <K extends CharSequence> Builder<V> addAll(Map<K, V> var1);

        public abstract TrieMap<V> build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        BYTES,
        CHARS;

    }
}

