/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.dev.test.util.Timer;
import com.ibm.icu.dev.test.util.TrieMap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.StringTrieBuilder;
import com.ibm.icu.util.ULocale;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieMapTest
extends TestFmwk {
    static final boolean SHORT = false;
    static final boolean HACK_TO_MAKE_TESTS_PASS = false;
    static final int MASK = 3;
    private Map<String, Integer> unicodeTestMap = new HashMap<String, Integer>();
    private boolean useSmallList = true;
    private Timer t = new Timer();
    private DecimalFormat nf = this.t.getNumberFormat();
    private DecimalFormat pf = this.t.getPercentFormat();

    public TrieMapTest() {
        this.pf.setMaximumFractionDigits(0);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.unicodeTestMap.size() == 0) {
            ULocale[] locales;
            ULocale[] uLocaleArray;
            if (this.getInclusion() < 5) {
                this.logln("\tShort version, timing for 1s:\t to get more accurate figures and test for reasonable times, use -e5 or more");
                this.t.setTimingPeriod(100000000L);
            } else {
                int seconds = this.getInclusion();
                this.logln("\tExhaustive version, timing for " + seconds + "s");
                this.t.setTimingPeriod((long)seconds * 100000000L);
                this.useSmallList = false;
            }
            int i = 0;
            UnicodeSet testSet = new UnicodeSet("[[:^C:]-[:sc=han:]]");
            for (String s : testSet) {
                int codePoint = s.codePointAt(0);
                String extendedName = UCharacter.getExtendedName((int)codePoint);
                if (!this.unicodeTestMap.containsKey(extendedName)) {
                    this.unicodeTestMap.put(extendedName, i++);
                }
                if (i <= 500 || !this.useSmallList) continue;
                break;
            }
            if (this.useSmallList) {
                ULocale[] uLocaleArray2 = new ULocale[2];
                uLocaleArray2[0] = new ULocale("zh");
                uLocaleArray = uLocaleArray2;
                uLocaleArray2[1] = new ULocale("el");
            } else {
                uLocaleArray = ULocale.getAvailableLocales();
            }
            for (ULocale locale : locales = uLocaleArray) {
                String localeName;
                if (locale.getDisplayCountry().length() != 0) continue;
                for (String languageCode : ULocale.getISOLanguages()) {
                    localeName = ULocale.getDisplayName((String)languageCode, (ULocale)locale);
                    if (localeName.equals(languageCode) || this.unicodeTestMap.containsKey(localeName)) continue;
                    this.unicodeTestMap.put(localeName, 3 & i++);
                }
                for (String countryCode : ULocale.getISOCountries()) {
                    localeName = ULocale.getDisplayCountry((String)("und-" + countryCode), (ULocale)locale);
                    if (localeName.equals(countryCode) || this.unicodeTestMap.containsKey(localeName)) continue;
                    this.unicodeTestMap.put(localeName, 3 & i++);
                }
            }
            int charCount = 0;
            for (String key : this.unicodeTestMap.keySet()) {
                charCount += key.length();
            }
            this.logln("\tTest Data Elements:\t\t\t" + this.nf.format((long)this.unicodeTestMap.size()));
            this.logln("\tTotal chars:\t\t\t" + this.nf.format((long)charCount));
        }
    }

    public static void main(String[] args) {
        new TrieMapTest().run(args);
    }

    public void TestByteConversion() {
        byte[] bytes = new byte[200];
        for (Map.Entry<String, Integer> entry : this.unicodeTestMap.entrySet()) {
            int limit;
            String recovered;
            String source = entry.getKey();
            if (source.equals(recovered = TrieMap.ByteConverter.getChars(bytes, 0, limit = TrieMap.ByteConverter.getBytes(source, bytes, 0)))) continue;
            this.assertEquals("Char/Byte Conversion", source, recovered);
        }
    }

    public void TestGet() {
        this.checkGet(this.unicodeTestMap, TrieMap.Style.BYTES);
        this.checkGet(this.unicodeTestMap, TrieMap.Style.CHARS);
    }

    private void checkGet(Map<String, Integer> testmap, TrieMap.Style style) {
        if (testmap.size() == 0) {
            return;
        }
        TrieMap<Map<String, Integer>> trieMap = TrieMap.Builder.with(style, StringTrieBuilder.Option.SMALL, testmap).build();
        for (Map.Entry<String, Integer> entry : testmap.entrySet()) {
            String key;
            Integer foundValue;
            Integer value = entry.getValue();
            if (value.equals(foundValue = (Integer)((Object)trieMap.get(key = entry.getKey())))) continue;
            this.assertEquals((Object)((Object)style) + "\tGet of '" + key + "' = {" + Utility.hex((CharSequence)key) + "}", value, foundValue);
        }
    }

    public void TestTimeIteration() {
        long comparisonTime = this.timeIteration(this.unicodeTestMap, 0L, null, 0.0);
        this.timeIteration(this.unicodeTestMap, comparisonTime, null, 0.0);
        this.timeIteration(this.unicodeTestMap, comparisonTime, TrieMap.Style.BYTES, 5.0);
        this.timeIteration(this.unicodeTestMap, comparisonTime, TrieMap.Style.CHARS, 3.0);
    }

    public long timeIteration(Map<String, Integer> testMap, long comparisonTime, TrieMap.Style style, double ratioToMap) {
        TrieMap<Map<String, Integer>> trieMap = TrieMap.BytesBuilder.with(style, StringTrieBuilder.Option.SMALL, testMap).build();
        TreeMap<String, Integer> expected = new TreeMap<String, Integer>(testMap);
        System.gc();
        this.t.start();
        if (style == null) {
            AbstractMap map = comparisonTime == 0L ? new TreeMap<String, Integer>(testMap) : new HashMap<String, Integer>(testMap);
            long mapTime = this.t.timeIterations(new MyLoop(){

                public void time(int repeat) {
                    for (int tt = 0; tt < repeat; ++tt) {
                        for (Map.Entry entry : this.map.entrySet()) {
                            String key = (String)entry.getKey();
                            Integer value = (Integer)entry.getValue();
                        }
                    }
                }
            }, null, map);
            if (comparisonTime == 0L) {
                this.logln("\titeration time\tTREEMAP\tn/a\t" + this.t.toString(testMap.size()) + "\t\titerations=" + this.t.getIterations());
            } else {
                this.logln("\titeration time\tHASHMAP\tn/a\t" + this.t.toString(testMap.size(), comparisonTime) + "\titerations=" + this.t.getIterations());
            }
            return mapTime;
        }
        long trieTime = this.t.timeIterations(new MyLoop(){

            public void time(int repeat) {
                for (int tt = 0; tt < repeat; ++tt) {
                    for (Map.Entry entry : this.trieMap) {
                        CharSequence key = entry.getKey();
                        Integer value = (Integer)entry.getValue();
                    }
                }
            }
        }, null, trieMap);
        this.logln("\titeration time\t" + (Object)((Object)style) + "\tn/a\t" + this.t.toString(testMap.size(), comparisonTime) + "\titerations=" + this.t.getIterations());
        if (!this.useSmallList && (double)trieTime > ratioToMap * (double)comparisonTime) {
            this.errln((Object)((Object)style) + "\tTime iteration takes too long. Expected:\t< " + ratioToMap * (double)comparisonTime + ", Actual:\t" + trieTime);
        }
        return trieTime;
    }

    public void TestContents() {
        this.checkContents(this.unicodeTestMap, TrieMap.Style.BYTES);
        this.checkContents(this.unicodeTestMap, TrieMap.Style.CHARS);
    }

    public void checkContents(Map<String, Integer> testMap, TrieMap.Style style) {
        if (testMap.size() == 0) {
            return;
        }
        TrieMap<Map<String, Integer>> trieMap = TrieMap.BytesBuilder.with(style, StringTrieBuilder.Option.SMALL, testMap).build();
        TreeMap<String, Integer> expected = new TreeMap<String, Integer>(testMap);
        Iterator<Map.Entry<CharSequence, Map<String, Integer>>> trieIterator = trieMap.iterator();
        Iterator<Map.Entry<String, Integer>> mapIterator = expected.entrySet().iterator();
        while (true) {
            Integer trieValue;
            Integer mapValue;
            CharSequence trieKey;
            boolean trieOk = trieIterator.hasNext();
            boolean mapOk = mapIterator.hasNext();
            if (mapOk != trieOk) {
                this.assertEquals("Iterators end at same point", mapOk, trieOk);
            }
            if (!mapOk) break;
            Map.Entry<CharSequence, Map<String, Integer>> trieEntry = trieIterator.next();
            Map.Entry<String, Integer> mapEntry = mapIterator.next();
            String mapKey = mapEntry.getKey();
            if (!mapKey.contentEquals(trieKey = trieEntry.getKey())) {
                this.assertEquals((Object)((Object)style) + "\tKeys match", mapKey, ((Object)trieKey).toString());
            }
            if ((mapValue = mapEntry.getValue()).equals(trieValue = (Integer)((Object)trieEntry.getValue()))) continue;
            this.assertEquals((Object)((Object)style) + "\tValues match", mapValue, trieValue);
        }
    }

    public void TestSearch() {
        this.checkSearch(TrieMap.Style.BYTES);
        this.checkSearch(TrieMap.Style.CHARS);
    }

    public void checkSearch(TrieMap.Style style) {
        boolean hasMore;
        TrieMap<String> trieMap = TrieMap.BytesBuilder.with(style, StringTrieBuilder.Option.SMALL, "abc", "first").add("cdab", "fifth").add("abcde", "second").add("abdfg", "third").build();
        String string = "xabcdab abcde abdfg";
        Row.R3[] expected = new Row.R3[]{Row.of((Object)1, (Object)4, (Object)"first"), Row.of((Object)3, (Object)7, (Object)"fifth"), Row.of((Object)8, (Object)11, (Object)"first"), Row.of((Object)8, (Object)13, (Object)"second"), Row.of((Object)14, (Object)19, (Object)"third")};
        List<Row.R3> expectedList = Arrays.asList(expected);
        ArrayList<Row.R3> actualList = new ArrayList<Row.R3>();
        TrieMap.Matcher<String> matcher = trieMap.getMatcher();
        matcher.set(string, 0);
        do {
            hasMore = matcher.next();
            String value = matcher.getValue();
            if (value == null) continue;
            int start = matcher.getStart();
            int end = matcher.getEnd();
            actualList.add(Row.of((Object)start, (Object)end, (Object)value));
        } while (hasMore || matcher.nextStart());
        this.assertEquals((Object)((Object)style) + "\tTrieMap matcher", expectedList, actualList);
    }

    public void TestTimeBuilding() {
        long comparisonTime = this.timeBuilding(this.unicodeTestMap, 0L, null, StringTrieBuilder.Option.SMALL, 0.0);
        this.timeBuilding(this.unicodeTestMap, comparisonTime, null, StringTrieBuilder.Option.SMALL, 0.0);
        this.timeBuilding(this.unicodeTestMap, comparisonTime, TrieMap.Style.BYTES, StringTrieBuilder.Option.SMALL, 20.0);
        this.timeBuilding(this.unicodeTestMap, comparisonTime, TrieMap.Style.BYTES, StringTrieBuilder.Option.FAST, 20.0);
        this.timeBuilding(this.unicodeTestMap, comparisonTime, TrieMap.Style.CHARS, StringTrieBuilder.Option.SMALL, 20.0);
        this.timeBuilding(this.unicodeTestMap, comparisonTime, TrieMap.Style.CHARS, StringTrieBuilder.Option.FAST, 20.0);
    }

    public long timeBuilding(Map<String, Integer> testmap, long comparisonTime, TrieMap.Style style, StringTrieBuilder.Option option, double ratioToMap) {
        System.gc();
        this.t.start();
        if (style == null) {
            if (comparisonTime == 0L) {
                long mapTime = this.t.timeIterations(new MyLoop(){

                    public void time(int repeat) {
                        for (int tt = 0; tt < repeat; ++tt) {
                            TreeMap treeMap = new TreeMap(this.map);
                        }
                    }
                }, null, testmap);
                this.logln("\tbuild time\tTREEMAP\tn/a\t" + this.t.toString(testmap.size()) + "\t\titerations=" + this.t.getIterations());
                return mapTime;
            }
            long mapTime = this.t.timeIterations(new MyLoop(){

                public void time(int repeat) {
                    for (int tt = 0; tt < repeat; ++tt) {
                        HashMap hashMap = new HashMap(this.map);
                    }
                }
            }, null, testmap);
            this.logln("\tbuild time\tHASHMAP\tn/a\t" + this.t.toString(testmap.size(), comparisonTime) + "\titerations=" + this.t.getIterations());
            return mapTime;
        }
        long trieTime = this.t.timeIterations(new MyLoop(){

            public void time(int repeat) {
                for (int tt = 0; tt < repeat; ++tt) {
                    this.trieMap = TrieMap.BytesBuilder.with(this.style, this.option, this.map).build();
                }
            }
        }, new Object[]{null, testmap, style, option});
        this.logln("\tbuild time\t" + (Object)((Object)style) + "\t" + option + "\t" + this.t.toString(testmap.size(), comparisonTime) + "\titerations=" + this.t.getIterations());
        if (!this.useSmallList && (double)trieTime > ratioToMap * (double)comparisonTime) {
            this.errln((Object)((Object)style) + "\t" + option + "\tTrie build takes too long. Expected:\t< " + this.nf.format(ratioToMap * (double)comparisonTime) + ", Actual:\t" + this.nf.format(trieTime));
        }
        return trieTime;
    }

    public void TestSize() {
        int size = this.checkSize(0, null, StringTrieBuilder.Option.SMALL, 0.0);
        this.checkSize(size, TrieMap.Style.BYTES, StringTrieBuilder.Option.SMALL, 0.2);
        this.checkSize(size, TrieMap.Style.BYTES, StringTrieBuilder.Option.FAST, 0.2);
        this.checkSize(size, TrieMap.Style.CHARS, StringTrieBuilder.Option.SMALL, 0.3);
        this.checkSize(size, TrieMap.Style.CHARS, StringTrieBuilder.Option.FAST, 0.3);
    }

    private int checkSize(int comparisonSize, TrieMap.Style style, StringTrieBuilder.Option option, double ratioToMap) {
        if (style == null) {
            int mapKeyByteSize = 0;
            TreeMap<String, Integer> map = new TreeMap<String, Integer>(this.unicodeTestMap);
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                mapKeyByteSize += 8 * ((entry.getKey().length() * 2 + 45) / 8);
            }
            this.logln("\tkey byte size\tTREEMAP\tn/a\t" + this.nf.format((long)mapKeyByteSize));
            return mapKeyByteSize;
        }
        TrieMap<Map<String, Integer>> trieMap = TrieMap.BytesBuilder.with(style, option, this.unicodeTestMap).build();
        int trieKeyByteSize = trieMap.keyByteSize();
        this.logln("\tkey byte size\t" + (Object)((Object)style) + "\t" + option + "\t" + this.nf.format((long)trieKeyByteSize) + "\t\t" + this.pf.format((double)trieKeyByteSize / (double)comparisonSize - 1.0) + "");
        if (!this.useSmallList && (double)trieKeyByteSize > ratioToMap * (double)comparisonSize) {
            this.errln((Object)((Object)style) + "\t" + option + "\ttrieKeyByteSize too large. Expected:\t< " + this.nf.format(ratioToMap * (double)comparisonSize) + ", Actual:\t" + this.nf.format((long)trieKeyByteSize));
        }
        return trieKeyByteSize;
    }

    public void TestTimeGet() {
        HashSet<String> keySet = new HashSet<String>(this.unicodeTestMap.keySet());
        ULocale[] locales = ULocale.getAvailableLocales();
        int i = 0;
        for (ULocale locale : locales) {
            if (locale.getDisplayCountry().length() != 0) continue;
            for (int scriptCodeInt = 0; scriptCodeInt < 159; ++scriptCodeInt) {
                String scriptCode = UScript.getShortName((int)scriptCodeInt);
                String localeName = ULocale.getDisplayScript((String)("und-" + scriptCode), (ULocale)locale);
                if (localeName.equals(scriptCode) || keySet.contains(localeName)) continue;
                keySet.add(localeName);
                ++i;
            }
        }
        this.logln("\tExtra Key Elements\t" + i);
        ArrayList<String> keys = new ArrayList<String>(keySet);
        long comparisonTime = this.timeGet(keys, this.unicodeTestMap, 0L, null, 0);
        this.timeGet(keys, this.unicodeTestMap, comparisonTime, null, 0);
        this.timeGet(keys, this.unicodeTestMap, comparisonTime, TrieMap.Style.BYTES, 3);
        this.timeGet(keys, this.unicodeTestMap, comparisonTime, TrieMap.Style.CHARS, 3);
    }

    public long timeGet(ArrayList<String> keys, Map<String, Integer> testmap, long comparisonTime, TrieMap.Style style, int ratioToMap) {
        TrieMap<Map<String, Integer>> trieMap = TrieMap.Builder.with(style, StringTrieBuilder.Option.SMALL, testmap).build();
        if (style == null) {
            AbstractMap map = comparisonTime == 0L ? new TreeMap<String, Integer>(testmap) : new HashMap<String, Integer>(testmap);
            long mapTime = this.t.timeIterations(new MyLoop(){

                public void time(int repeat) {
                    for (int tt = 0; tt < repeat; ++tt) {
                        for (String key : this.keys) {
                            Integer foundValue = (Integer)this.map.get(key);
                        }
                    }
                }
            }, keys, map);
            if (comparisonTime == 0L) {
                this.logln("\tget() time\tTREEMAP\tn/a\t" + this.t.toString(keys.size()) + "\t\titerations=" + this.t.getIterations());
            } else {
                this.logln("\tget() time\tHASHMAP\tn/a\t" + this.t.toString(keys.size(), comparisonTime) + "\titerations=" + this.t.getIterations());
            }
            return mapTime;
        }
        long trieTime = this.t.timeIterations(new MyLoop(){

            public void time(int repeat) {
                for (int tt = 0; tt < repeat; ++tt) {
                    for (String key : this.keys) {
                        Integer foundValue = (Integer)this.trieMap.get(key);
                    }
                }
            }
        }, keys, trieMap);
        this.logln("\tget() time\t" + (Object)((Object)style) + "\tn/a\t" + this.t.toString(keys.size(), comparisonTime) + "\titerations=" + this.t.getIterations());
        if (!this.useSmallList && trieTime > (long)ratioToMap * comparisonTime) {
            this.errln((Object)((Object)style) + "\tTime iteration takes too long. Expected:\t< " + (long)ratioToMap * comparisonTime + ", Actual:\t" + trieTime);
        }
        return trieTime;
    }

    static abstract class MyLoop
    extends Timer.Loop {
        ArrayList<String> keys;
        TrieMap<Integer> trieMap;
        Map<String, Integer> map;
        TrieMap.Style style;
        StringTrieBuilder.Option option;

        MyLoop() {
        }

        public void init(Object ... params) {
            if (params.length > 0) {
                this.keys = (ArrayList)params[0];
            }
            if (params.length > 1) {
                if (params[1] instanceof Map) {
                    this.map = (Map)params[1];
                } else {
                    this.trieMap = (TrieMap)params[1];
                }
            }
            if (params.length > 2) {
                this.style = (TrieMap.Style)((Object)params[2]);
            }
            if (params.length > 3) {
                this.option = (StringTrieBuilder.Option)params[3];
            }
        }

        public abstract void time(int var1);
    }
}

