/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.CharTrie;
import com.ibm.icu.impl.IntTrie;
import com.ibm.icu.impl.IntTrieBuilder;
import com.ibm.icu.impl.Trie;
import com.ibm.icu.impl.TrieBuilder;
import com.ibm.icu.impl.TrieIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.RangeValueIterator;

public final class TrieTest
extends TestFmwk {
    private static SetRange[] setRanges1 = new SetRange[]{new SetRange(0, 32, 0, false), new SetRange(32, 167, 4660, false), new SetRange(167, 13312, 0, false), new SetRange(13312, 40870, 24930, false), new SetRange(40870, 55966, 12594, false), new SetRange(56026, 61166, 34815, false), new SetRange(61166, 69905, 1, false), new SetRange(69905, 279620, 24930, false), new SetRange(279620, 393219, 0, false), new SetRange(983043, 983044, 15, false), new SetRange(983044, 983046, 16, false), new SetRange(983046, 983047, 17, false), new SetRange(983047, 983072, 18, false), new SetRange(983072, 0x110000, 0, false)};
    private static CheckRange[] checkRanges1 = new CheckRange[]{new CheckRange(0, 0), new CheckRange(32, 0), new CheckRange(167, 4660), new CheckRange(13312, 0), new CheckRange(40870, 24930), new CheckRange(55966, 12594), new CheckRange(56026, 0), new CheckRange(61166, 34815), new CheckRange(69905, 1), new CheckRange(279620, 24930), new CheckRange(983043, 0), new CheckRange(983044, 15), new CheckRange(983046, 16), new CheckRange(983047, 17), new CheckRange(983072, 18), new CheckRange(0x110000, 0)};
    private static SetRange[] setRanges2 = new SetRange[]{new SetRange(33, 127, 21845, true), new SetRange(194560, 196316, 122, true), new SetRange(114, 221, 3, true), new SetRange(221, 222, 4, false), new SetRange(194951, 195224, 5, true), new SetRange(194423, 194611, 0, true), new SetRange(194816, 196590, 1, false), new SetRange(196590, 196591, 2, true)};
    private static CheckRange[] checkRanges2 = new CheckRange[]{new CheckRange(0, 0), new CheckRange(33, 0), new CheckRange(114, 21845), new CheckRange(221, 3), new CheckRange(222, 4), new CheckRange(194611, 0), new CheckRange(194951, 122), new CheckRange(195224, 5), new CheckRange(196316, 122), new CheckRange(196590, 1), new CheckRange(196591, 2), new CheckRange(0x110000, 0)};
    private static SetRange[] setRanges3 = new SetRange[]{new SetRange(49, 164, 1, false), new SetRange(13312, 26505, 2, false), new SetRange(196608, 214375, 9, true), new SetRange(284280, 354185, 3, true)};
    private static CheckRange[] checkRanges3 = new CheckRange[]{new CheckRange(0, 9), new CheckRange(49, 9), new CheckRange(164, 1), new CheckRange(13312, 9), new CheckRange(26505, 2), new CheckRange(284280, 9), new CheckRange(354185, 3), new CheckRange(0x110000, 9)};

    public static void main(String[] arg) {
        TrieTest test = new TrieTest();
        try {
            test.run(arg);
        }
        catch (Exception e) {
            test.errln("Error testing trietest");
        }
    }

    private void _testTrieIteration(IntTrie trie, CheckRange[] checkRanges, int countCheckRanges) {
        int countValues = 0;
        StringBuffer s = new StringBuffer();
        int[] values = new int[30];
        for (int i = 0; i < countCheckRanges; ++i) {
            int c = checkRanges[i].limit;
            if (c == 0) continue;
            UTF16.append((StringBuffer)s, (int)(--c));
            values[countValues++] = checkRanges[i].value;
        }
        int limit = s.length();
        int p = 0;
        int i = 0;
        while (p < limit) {
            int c = UTF16.charAt((StringBuffer)s, (int)p);
            p += UTF16.getCharCount((int)c);
            int value = trie.getCodePointValue(c);
            if (value != values[i]) {
                this.errln("wrong value from UTRIE_NEXT(U+" + Integer.toHexString(c) + "): 0x" + Integer.toHexString(value) + " instead of 0x" + Integer.toHexString(values[i]));
            }
            char lead = UTF16.getLeadSurrogate((int)c);
            char trail = UTF16.getTrailSurrogate((int)c);
            if (lead == '\u0000' ? trail != s.charAt(p - 1) : !UTF16.isLeadSurrogate((char)lead) || !UTF16.isTrailSurrogate((char)trail) || lead != s.charAt(p - 2) || trail != s.charAt(p - 1)) {
                this.errln("wrong (lead, trail) from UTRIE_NEXT(U+" + Integer.toHexString(c));
                continue;
            }
            if (lead != '\u0000') {
                value = trie.getLeadValue(lead);
                if ((value = trie.getTrailValue(value, trail)) != trie.getSurrogateValue(lead, trail) && value != values[i]) {
                    this.errln("wrong value from getting supplementary values (U+" + Integer.toHexString(c) + "): 0x" + Integer.toHexString(value) + " instead of 0x" + Integer.toHexString(values[i]));
                }
            }
            ++i;
        }
    }

    private void _testTrieRanges(SetRange[] setRanges, int countSetRanges, CheckRange[] checkRanges, int countCheckRanges, boolean latin1Linear) {
        int value;
        int limit;
        int i;
        int value2;
        int limit2;
        IntTrieBuilder newTrie = new IntTrieBuilder(null, 2000, checkRanges[0].value, checkRanges[0].value, latin1Linear);
        boolean ok = true;
        for (int i2 = 0; i2 < countSetRanges; ++i2) {
            int start = setRanges[i2].start;
            limit2 = setRanges[i2].limit;
            value2 = setRanges[i2].value;
            boolean overwrite = setRanges[i2].overwrite;
            if (limit2 - start == 1 && overwrite) {
                ok &= newTrie.setValue(start, value2);
                continue;
            }
            ok &= newTrie.setRange(start, limit2, value2, overwrite);
        }
        if (!ok) {
            this.errln("setting values into a trie failed");
            return;
        }
        int start = 0;
        for (int i3 = 0; i3 < countCheckRanges; ++i3) {
            limit2 = checkRanges[i3].limit;
            value2 = checkRanges[i3].value;
            while (start < limit2) {
                if (value2 != newTrie.getValue(start)) {
                    this.errln("newTrie [U+" + Integer.toHexString(start) + "]==0x" + Integer.toHexString(newTrie.getValue(start)) + " instead of 0x" + Integer.toHexString(value2));
                }
                ++start;
            }
        }
        IntTrie trie = newTrie.serialize((TrieBuilder.DataManipulate)new _testFoldedValue(newTrie), (Trie.DataManipulate)new _testFoldingOffset());
        if (latin1Linear) {
            start = 0;
            for (i = 0; i < countCheckRanges && start <= 255; ++i) {
                limit = checkRanges[i].limit;
                value = checkRanges[i].value;
                while (start < limit && start <= 255) {
                    if (value != trie.getLatin1LinearValue((char)start)) {
                        this.errln("IntTrie.getLatin1LinearValue[U+" + Integer.toHexString(start) + "]==0x" + Integer.toHexString(trie.getLatin1LinearValue((char)start)) + " instead of 0x" + Integer.toHexString(value));
                    }
                    ++start;
                }
            }
        }
        if (latin1Linear != trie.isLatin1Linear()) {
            this.errln("trie serialization did not preserve Latin-1-linearity");
        }
        start = 0;
        for (i = 0; i < countCheckRanges; ++i) {
            limit = checkRanges[i].limit;
            value = checkRanges[i].value;
            if (start == 55296) {
                start = limit;
                continue;
            }
            while (start < limit) {
                int value22;
                if (start <= 65535) {
                    value22 = trie.getBMPValue((char)start);
                    if (value != value22) {
                        this.errln("serialized trie.getBMPValue(U+" + Integer.toHexString(start) + " == 0x" + Integer.toHexString(value22) + " instead of 0x" + Integer.toHexString(value));
                    }
                    if (!UTF16.isLeadSurrogate((char)((char)start)) && value != (value22 = trie.getLeadValue((char)start))) {
                        this.errln("serialized trie.getLeadValue(U+" + Integer.toHexString(start) + " == 0x" + Integer.toHexString(value22) + " instead of 0x" + Integer.toHexString(value));
                    }
                }
                if (value != (value22 = trie.getCodePointValue(start))) {
                    this.errln("serialized trie.getCodePointValue(U+" + Integer.toHexString(start) + ")==0x" + Integer.toHexString(value22) + " instead of 0x" + Integer.toHexString(value));
                }
                ++start;
            }
        }
        int enumRanges = 1;
        _testEnumValue iter = new _testEnumValue((Trie)trie);
        RangeValueIterator.Element result = new RangeValueIterator.Element();
        while (iter.next(result)) {
            if (result.start != checkRanges[enumRanges - 1].limit || result.limit != checkRanges[enumRanges].limit || (result.value ^ 0x5555) != checkRanges[enumRanges].value) {
                this.errln("utrie_enum() delivers wrong range [U+" + Integer.toHexString(result.start) + "..U+" + Integer.toHexString(result.limit) + "].0x" + Integer.toHexString(result.value ^ 0x5555) + " instead of [U+" + Integer.toHexString(checkRanges[enumRanges - 1].limit) + "..U+" + Integer.toHexString(checkRanges[enumRanges].limit) + "].0x" + Integer.toHexString(checkRanges[enumRanges].value));
            }
            ++enumRanges;
        }
        if (trie.isLatin1Linear()) {
            for (start = 0; start < 256; ++start) {
                if (trie.getLatin1LinearValue((char)start) == trie.getLeadValue((char)start)) continue;
                this.errln("trie.getLatin1LinearValue[U+" + Integer.toHexString(start) + "]=0x" + Integer.toHexString(trie.getLatin1LinearValue((char)start)) + " instead of 0x" + Integer.toHexString(trie.getLeadValue((char)start)));
            }
        }
        this._testTrieIteration(trie, checkRanges, countCheckRanges);
    }

    private void _testTrieRanges2(SetRange[] setRanges, int countSetRanges, CheckRange[] checkRanges, int countCheckRanges) {
        this._testTrieRanges(setRanges, countSetRanges, checkRanges, countCheckRanges, false);
        this._testTrieRanges(setRanges, countSetRanges, checkRanges, countCheckRanges, true);
    }

    private void _testTrieRanges4(SetRange[] setRanges, int countSetRanges, CheckRange[] checkRanges, int countCheckRanges) {
        this._testTrieRanges2(setRanges, countSetRanges, checkRanges, countCheckRanges);
    }

    public void TestIntTrie() {
        this._testTrieRanges4(setRanges1, setRanges1.length, checkRanges1, checkRanges1.length);
        this._testTrieRanges4(setRanges2, setRanges2.length, checkRanges2, checkRanges2.length);
        this._testTrieRanges4(setRanges3, setRanges3.length, checkRanges3, checkRanges3.length);
    }

    public void TestDummyCharTrie() {
        char value;
        int c;
        int initialValue = 787;
        int leadUnitValue = 45054;
        CharTrie trie = new CharTrie(787, 45054, (Trie.DataManipulate)new DummyGetFoldingOffset());
        for (c = 0; c <= 0x10FFFF; ++c) {
            value = trie.getCodePointValue(c);
            if (value == '\u0313') continue;
            this.errln("CharTrie/dummy.getCodePointValue(c)(U+" + TrieTest.hex(c) + ")=0x" + TrieTest.hex((int)value) + " instead of 0x" + TrieTest.hex(787));
        }
        for (c = 55296; c <= 56319; ++c) {
            value = trie.getLeadValue((char)c);
            if (value == '\uaffe') continue;
            this.errln("CharTrie/dummy.getLeadValue(c)(U+" + TrieTest.hex(c) + ")=0x" + TrieTest.hex((int)value) + " instead of 0x" + TrieTest.hex(45054));
        }
    }

    public void TestDummyIntTrie() {
        int value;
        int c;
        int initialValue = 19088743;
        int leadUnitValue = -1985229329;
        IntTrie trie = new IntTrie(19088743, -1985229329, (Trie.DataManipulate)new DummyGetFoldingOffset());
        for (c = 0; c <= 0x10FFFF; ++c) {
            value = trie.getCodePointValue(c);
            if (value == 19088743) continue;
            this.errln("IntTrie/dummy.getCodePointValue(c)(U+" + TrieTest.hex(c) + ")=0x" + TrieTest.hex(value) + " instead of 0x" + TrieTest.hex(19088743));
        }
        for (c = 55296; c <= 56319; ++c) {
            value = trie.getLeadValue((char)c);
            if (value == -1985229329) continue;
            this.errln("IntTrie/dummy.getLeadValue(c)(U+" + TrieTest.hex(c) + ")=0x" + TrieTest.hex(value) + " instead of 0x" + TrieTest.hex(-1985229329));
        }
    }

    private static class DummyGetFoldingOffset
    implements Trie.DataManipulate {
        private DummyGetFoldingOffset() {
        }

        public int getFoldingOffset(int value) {
            return -1;
        }
    }

    private static final class _testEnumValue
    extends TrieIterator {
        public _testEnumValue(Trie data) {
            super(data);
        }

        protected int extract(int value) {
            return value ^ 0x5555;
        }
    }

    private static final class _testFoldingOffset
    implements Trie.DataManipulate {
        private _testFoldingOffset() {
        }

        public int getFoldingOffset(int value) {
            return value >>> 16;
        }
    }

    private static final class _testFoldedValue
    implements TrieBuilder.DataManipulate {
        private IntTrieBuilder m_builder_;

        public _testFoldedValue(IntTrieBuilder builder) {
            this.m_builder_ = builder;
        }

        public int getFoldedValue(int start, int offset) {
            int foldedValue = 0;
            int limit = start + 1024;
            while (start < limit) {
                int value = this.m_builder_.getValue(start);
                if (this.m_builder_.isInZeroBlock(start)) {
                    start += 32;
                    continue;
                }
                foldedValue |= value;
                ++start;
            }
            if (foldedValue != 0) {
                return offset << 16 | foldedValue;
            }
            return 0;
        }
    }

    private static final class CheckRange {
        int limit;
        int value;

        CheckRange(int limit, int value) {
            this.limit = limit;
            this.value = value;
        }
    }

    private static final class SetRange {
        int start;
        int limit;
        int value;
        boolean overwrite;

        SetRange(int start, int limit, int value, boolean overwrite) {
            this.start = start;
            this.limit = limit;
            this.value = value;
            this.overwrite = overwrite;
        }
    }
}

