/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UTF16;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnicodeLabel
implements Transform<Integer, String> {
    public static final UnicodeLabel NULL = new Constant("");
    public static final UnicodeLabel HEX = new Hex();

    public abstract String getValue(int var1, boolean var2);

    public String transform(Integer codepoint) {
        return this.getValue(codepoint, true);
    }

    public String getValue(String s, String separator, boolean withCodePoint) {
        int cp;
        if (s.length() == 1) {
            return this.getValue(s.charAt(0), withCodePoint);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(this.getValue(cp, withCodePoint));
        }
        return sb.toString();
    }

    public int getMaxWidth(boolean isShort) {
        return 0;
    }

    public static class Constant
    extends UnicodeLabel {
        private String value;

        public Constant(String value) {
            if (value == null) {
                value = "";
            }
            this.value = value;
        }

        public String getValue(int codepoint, boolean isShort) {
            return this.value;
        }

        public int getMaxWidth(boolean isShort) {
            return this.value.length();
        }
    }

    private static class Hex
    extends UnicodeLabel {
        private Hex() {
        }

        public String getValue(int codepoint, boolean isShort) {
            if (isShort) {
                return Utility.hex((long)codepoint, (int)4);
            }
            return "U+" + Utility.hex((long)codepoint, (int)4);
        }
    }
}

