/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.util.UnicodeProperty;
import com.ibm.icu.impl.UnicodeRegex;
import com.ibm.icu.text.SymbolTable;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class UnicodePropertySymbolTable
extends UnicodeSet.XSymbolTable {
    UnicodeRegex unicodeRegex;
    final UnicodeProperty.Factory factory;
    static final HashMap<String, String[]> GC_REMAP = new HashMap();

    public UnicodePropertySymbolTable(UnicodeProperty.Factory factory) {
        GC_REMAP.put("c", "Cc Cf Cn Co Cs".split(" "));
        GC_REMAP.put("other", GC_REMAP.get("c"));
        GC_REMAP.put("l", "Ll Lm Lo Lt Lu".split(" "));
        GC_REMAP.put("letter", GC_REMAP.get("l"));
        GC_REMAP.put("lc", "Ll Lt Lu".split(" "));
        GC_REMAP.put("casedletter", GC_REMAP.get("lc"));
        GC_REMAP.put("m", "Mc Me Mn".split(" "));
        GC_REMAP.put("mark", GC_REMAP.get("m"));
        GC_REMAP.put("n", "Nd Nl No".split(" "));
        GC_REMAP.put("number", GC_REMAP.get("n"));
        GC_REMAP.put("p", "Pc Pd Pe Pf Pi Po Ps".split(" "));
        GC_REMAP.put("punctuation", GC_REMAP.get("p"));
        GC_REMAP.put("punct", GC_REMAP.get("p"));
        GC_REMAP.put("s", "Sc Sk Sm So".split(" "));
        GC_REMAP.put("symbol", GC_REMAP.get("s"));
        GC_REMAP.put("z", "Zl Zp Zs".split(" "));
        GC_REMAP.put("separator", GC_REMAP.get("z"));
        this.unicodeRegex = new UnicodeRegex().setSymbolTable((SymbolTable)this);
        this.factory = factory;
    }

    public boolean applyPropertyAlias(String propertyName, String propertyValue, UnicodeSet result) {
        boolean status = false;
        boolean invert = false;
        int posNotEqual = propertyName.indexOf(8800);
        int posColon = propertyName.indexOf(58);
        if (posNotEqual >= 0 || posColon >= 0) {
            if (posNotEqual < 0) {
                posNotEqual = propertyName.length();
            }
            if (posColon < 0) {
                posColon = propertyName.length();
            }
            int opPos = posNotEqual < posColon ? posNotEqual : posColon;
            propertyValue = propertyValue.length() == 0 ? propertyName.substring(opPos + 1) : propertyName.substring(opPos + 1) + "=" + propertyValue;
            propertyName = propertyName.substring(0, opPos);
            if (posNotEqual < posColon) {
                invert = true;
            }
        }
        if (propertyName.endsWith("!")) {
            propertyName = propertyName.substring(0, propertyName.length() - 1);
            boolean bl = invert = !invert;
        }
        if ((propertyValue = propertyValue.trim()).length() != 0) {
            status = this.applyPropertyAlias0(propertyName, propertyValue, result);
        } else {
            try {
                status = this.applyPropertyAlias0("gc", propertyName, result);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!status) {
                try {
                    status = this.applyPropertyAlias0("sc", propertyName, result);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!status) {
                    try {
                        status = this.applyPropertyAlias0(propertyName, "Yes", result);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!status) {
                        status = this.applyPropertyAlias0(propertyName, "", result);
                    }
                }
            }
        }
        if (status && invert) {
            result.complement();
        }
        return status;
    }

    public boolean applyPropertyAlias0(String propertyName, String propertyValue, UnicodeSet result) {
        String[] parts;
        result.clear();
        UnicodeProperty prop = this.factory.getProperty(propertyName);
        String canonicalName = prop.getName();
        boolean isAge = UnicodeProperty.equalNames("Age", canonicalName);
        if (canonicalName.equals("General_Category") && (parts = GC_REMAP.get(UnicodeProperty.toSkeleton(propertyValue))) != null) {
            for (String part : parts) {
                prop.getSet(part, result);
            }
            return true;
        }
        UnicodeProperty.PatternMatcher patternMatcher = null;
        if (propertyValue.length() > 1 && propertyValue.startsWith("/") && propertyValue.endsWith("/")) {
            String fixedRegex = this.unicodeRegex.transform(propertyValue.substring(1, propertyValue.length() - 1));
            patternMatcher = new UnicodeProperty.RegexMatcher().set(fixedRegex);
        }
        UnicodeProperty otherProperty = null;
        boolean testCp = false;
        if (propertyValue.length() > 1 && propertyValue.startsWith("@") && propertyValue.endsWith("@")) {
            String otherPropName = propertyValue.substring(1, propertyValue.length() - 1).trim();
            if ("cp".equalsIgnoreCase(otherPropName)) {
                testCp = true;
            } else {
                otherProperty = this.factory.getProperty(otherPropName);
            }
        }
        if (prop != null) {
            UnicodeSet set;
            if (testCp) {
                set = new UnicodeSet();
                for (int i = 0; i <= 0x10FFFF; ++i) {
                    if (!UnicodeProperty.equals(i, prop.getValue(i))) continue;
                    set.add(i);
                }
            } else if (otherProperty != null) {
                set = new UnicodeSet();
                for (int i = 0; i <= 0x10FFFF; ++i) {
                    String v2;
                    String v1 = prop.getValue(i);
                    if (!UnicodeProperty.equals(v1, v2 = otherProperty.getValue(i))) continue;
                    set.add(i);
                }
            } else if (patternMatcher == null) {
                if (!this.isValid(prop, propertyValue)) {
                    throw new IllegalArgumentException("The value '" + propertyValue + "' is illegal. Values for " + propertyName + " must be in " + prop.getAvailableValues() + " or in " + prop.getValueAliases());
                }
                set = isAge ? prop.getSet(new ComparisonMatcher(propertyValue, Relation.geq)) : prop.getSet(propertyValue);
            } else if (isAge) {
                set = new UnicodeSet();
                List values = prop.getAvailableValues();
                for (String value : values) {
                    if (!patternMatcher.matches(value)) continue;
                    for (String other : values) {
                        if (other.compareTo(value) > 0) continue;
                        set.addAll(prop.getSet(other));
                    }
                }
            } else {
                set = prop.getSet(patternMatcher);
            }
            result.addAll(set);
            return true;
        }
        throw new IllegalArgumentException("Illegal property: " + propertyName);
    }

    private boolean isValid(UnicodeProperty prop, String propertyValue) {
        return prop.isValidValue(propertyValue);
    }

    public static class ComparisonMatcher
    implements UnicodeProperty.PatternMatcher {
        Relation relation;
        static Comparator comparator = new UTF16.StringComparator(true, false, 0);
        String pattern;

        public ComparisonMatcher(String pattern, Relation comparator) {
            this.relation = comparator;
            this.pattern = pattern;
        }

        public boolean matches(Object value) {
            int comp = comparator.compare(this.pattern, value.toString());
            switch (this.relation) {
                case less: {
                    return comp < 0;
                }
                case leq: {
                    return comp <= 0;
                }
                default: {
                    return comp == 0;
                }
                case geq: {
                    return comp >= 0;
                }
                case greater: 
            }
            return comp > 0;
        }

        public UnicodeProperty.PatternMatcher set(String pattern) {
            this.pattern = pattern;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Relation {
        less,
        leq,
        equal,
        geq,
        greater;

    }
}

