/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.Assert;
import com.ibm.icu.impl.InvalidFormatException;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ByteArrayWrapper;
import com.ibm.icu.util.CaseInsensitiveString;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class UtilityTest
extends TestFmwk {
    public static void main(String[] args) throws Exception {
        new UtilityTest().run(args);
    }

    public void TestUnescape() {
        String input = "Sch\\u00f6nes Auto: \\u20ac 11240.\\fPrivates Zeichen: \\U00102345\\e\\cC\\n \\x1b\\x{263a}";
        String expect = "Sch\u00f6nes Auto: \u20ac 11240.\fPrivates Zeichen: \udbc8\udf45\u001b\u0003\n \u001b\u263a";
        String result = Utility.unescape((String)"Sch\\u00f6nes Auto: \\u20ac 11240.\\fPrivates Zeichen: \\U00102345\\e\\cC\\n \\x1b\\x{263a}");
        if (!result.equals("Sch\u00f6nes Auto: \u20ac 11240.\fPrivates Zeichen: \udbc8\udf45\u001b\u0003\n \u001b\u263a")) {
            this.errln("FAIL: Utility.unescape() returned " + result + ", exp. " + "Sch\u00f6nes Auto: \u20ac 11240.\fPrivates Zeichen: \udbc8\udf45\u001b\u0003\n \u001b\u263a");
        }
    }

    public void TestFormat() {
        int i;
        String[] data = new String[]{"the quick brown fox jumps over the lazy dog", "testing space , quotations \"", "testing weird supplementary characters \ud800\udc00", "testing control characters \u0001 and line breaking!! \n are we done yet?"};
        String[] result = new String[]{"        \"the quick brown fox jumps over the lazy dog\"", "        \"testing space , quotations \\042\"", "        \"testing weird supplementary characters \\uD800\\uDC00\"", "        \"testing control characters \\001 and line breaking!! \\n are we done ye\"+" + Utility.LINE_SEPARATOR + "        \"t?\""};
        String[] result1 = new String[]{"\"the quick brown fox jumps over the lazy dog\"", "\"testing space , quotations \\042\"", "\"testing weird supplementary characters \\uD800\\uDC00\"", "\"testing control characters \\001 and line breaking!! \\n are we done yet?\""};
        for (i = 0; i < data.length; ++i) {
            this.assertEquals("formatForSource(\"" + data[i] + "\")", result[i], Utility.formatForSource((String)data[i]));
        }
        for (i = 0; i < data.length; ++i) {
            this.assertEquals("format1ForSource(\"" + data[i] + "\")", result1[i], Utility.format1ForSource((String)data[i]));
        }
    }

    public void TestHighBit() {
        int[] data = new int[]{-1, -1276, 0, 65535, 4660};
        byte[] result = new byte[]{-1, -1, -1, 15, 12};
        for (int i = 0; i < data.length; ++i) {
            if (Utility.highBit((int)data[i]) == result[i]) continue;
            this.errln("Fail: Highest bit of \\u" + Integer.toHexString(data[i]) + " should be " + result[i]);
        }
    }

    public void TestCompareUnsigned() {
        int[] data = new int[]{0, 1, -1879048193, -1, Integer.MAX_VALUE, Integer.MIN_VALUE, 2342423, -2342423};
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data.length; ++j) {
                if (Utility.compareUnsigned((int)data[i], (int)data[j]) == this.compareLongUnsigned(data[i], data[j])) continue;
                this.errln("Fail: Unsigned comparison failed with " + data[i] + " " + data[i + 1]);
            }
        }
    }

    public void TestByteArrayWrapper() {
        byte[] ba = new byte[]{0, 1, 2};
        byte[] bb = new byte[]{0, 1, 2, -1};
        ByteBuffer buffer = ByteBuffer.wrap(ba);
        ByteArrayWrapper x = new ByteArrayWrapper(buffer);
        ByteArrayWrapper y = new ByteArrayWrapper(ba, 3);
        ByteArrayWrapper z = new ByteArrayWrapper(bb, 3);
        if (!y.toString().equals("00 01 02")) {
            this.errln("FAIL: test toString : Failed!");
        }
        if (!x.equals((Object)y) || !x.equals((Object)z)) {
            this.errln("FAIL: test (operator ==): Failed!");
        }
        if (x.hashCode() != y.hashCode()) {
            this.errln("FAIL: identical objects have different hash codes.");
        }
        if (x.equals((Object)(y = new ByteArrayWrapper(bb, 4)))) {
            this.errln("FAIL: test (operator !=): Failed!");
        }
        if (x.compareTo(y) > 0 != y.compareTo(x) < 0) {
            this.errln("FAIL: comparisons not opposite sign");
        }
    }

    private int compareLongUnsigned(int x, int y) {
        long x1 = (long)x & 0xFFFFFFFFL;
        long y1 = (long)y & 0xFFFFFFFFL;
        if (x1 < y1) {
            return -1;
        }
        if (x1 > y1) {
            return 1;
        }
        return 0;
    }

    public void TestUnicodeSet() {
        String[] array = new String[]{"a", "b", "c", "{de}"};
        List<String> list = Arrays.asList(array);
        HashSet<String> aset = new HashSet<String>(list);
        this.logln(" *** The source set's size is: " + aset.size());
        UnicodeSet set = new UnicodeSet();
        set.clear();
        set.addAll(aset);
        this.logln(" *** After addAll, the UnicodeSet size is: " + set.size());
    }

    public void TestAssert() {
        try {
            Assert.assrt((boolean)false);
            this.errln("FAIL: Assert.assrt(false)");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals("assert failed")) {
                this.logln("Assert.assrt(false) works");
            }
            this.errln("FAIL: Assert.assrt(false) returned " + e.getMessage());
        }
        try {
            Assert.assrt((String)"Assert message", (boolean)false);
            this.errln("FAIL: Assert.assrt(false)");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals("assert 'Assert message' failed")) {
                this.logln("Assert.assrt(false) works");
            }
            this.errln("FAIL: Assert.assrt(false) returned " + e.getMessage());
        }
        try {
            Assert.fail((String)"Assert message");
            this.errln("FAIL: Assert.fail");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals("failure 'Assert message'")) {
                this.logln("Assert.fail works");
            }
            this.errln("FAIL: Assert.fail returned " + e.getMessage());
        }
        try {
            Assert.fail((Exception)new InvalidFormatException());
            this.errln("FAIL: Assert.fail with an exception");
        }
        catch (IllegalStateException e) {
            this.logln("Assert.fail works");
        }
    }

    public void TestCaseInsensitiveString() {
        CaseInsensitiveString str1 = new CaseInsensitiveString("ThIs is A tEst");
        CaseInsensitiveString str2 = new CaseInsensitiveString("This IS a test");
        if (!str1.equals((Object)str2) || !str1.toString().equals(str1.getString()) || str1.toString().equals(str2.toString())) {
            this.errln("FAIL: str1(" + str1 + ") != str2(" + str2 + ")");
        }
    }
}

