/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.text.NumberingSystem;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;

class CompactDecimalDataCache {
    private static final int MAX_DIGITS = 15;
    private final ICUCache<ULocale, Data> cache = new SimpleCache<ULocale, Data>();

    CompactDecimalDataCache() {
    }

    Data get(ULocale locale) {
        Data result = this.cache.get(locale);
        if (result == null) {
            result = CompactDecimalDataCache.load(locale);
            this.cache.put(locale, result);
        }
        return result;
    }

    private static Data load(ULocale ulocale) {
        NumberingSystem ns = NumberingSystem.getInstance(ulocale);
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt50b", ulocale);
        r = r.getWithFallback("NumberElements/" + ns.getName() + "/patternsShort/decimalFormat");
        int size = r.getSize();
        Data result = new Data(new long[15], new String[15], new String[15]);
        for (int i = 0; i < size; ++i) {
            CompactDecimalDataCache.populateData((ICUResourceBundle)r.get(i), result);
        }
        CompactDecimalDataCache.fillInMissing(result);
        return result;
    }

    private static void populateData(ICUResourceBundle divisorData, Data result) {
        long divisor = Long.parseLong(divisorData.getKey());
        int thisIndex = (int)Math.log10(divisor);
        if (thisIndex >= 15) {
            return;
        }
        ICUResourceBundle other = (ICUResourceBundle)divisorData.get("other");
        int numZeros = CompactDecimalDataCache.populatePrefixSuffix(other.getString(), thisIndex, result);
        for (int i = 1; i < numZeros; ++i) {
            divisor /= 10L;
        }
        result.divisors[thisIndex] = divisor;
    }

    private static int populatePrefixSuffix(String template, int idx, Data result) {
        int i;
        int firstIdx = template.indexOf("0");
        int lastIdx = template.lastIndexOf("0");
        result.prefixes[idx] = template.substring(0, firstIdx);
        result.suffixes[idx] = template.substring(lastIdx + 1);
        for (i = firstIdx + 1; i <= lastIdx && template.charAt(i) == '0'; ++i) {
        }
        return i - firstIdx;
    }

    private static void fillInMissing(Data result) {
        long lastDivisor = 1L;
        String lastPrefix = "";
        String lastSuffix = "";
        for (int i = 0; i < result.divisors.length; ++i) {
            if (result.prefixes[i] == null) {
                result.divisors[i] = lastDivisor;
                result.prefixes[i] = lastPrefix;
                result.suffixes[i] = lastSuffix;
                continue;
            }
            lastDivisor = result.divisors[i];
            lastPrefix = result.prefixes[i];
            lastSuffix = result.suffixes[i];
        }
    }

    static class Data {
        long[] divisors;
        String[] prefixes;
        String[] suffixes;

        Data(long[] divisors, String[] prefixes, String[] suffixes) {
            this.divisors = divisors;
            this.prefixes = prefixes;
            this.suffixes = suffixes;
        }
    }
}

