/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.CompactDecimalDataCache;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactDecimalFormat
extends DecimalFormat {
    private static final long serialVersionUID = 4716293295276629682L;
    private static final int MINIMUM_ARRAY_LENGTH = 15;
    private static final int POSITIVE_PREFIX = 0;
    private static final int POSITIVE_SUFFIX = 1;
    private static final int AFFIX_SIZE = 2;
    private static final CompactDecimalDataCache cache = new CompactDecimalDataCache();
    private final String[] prefix;
    private final String[] suffix;
    private final long[] divisor;
    private final String[] currencyAffixes;

    CompactDecimalFormat(ULocale locale, NumberFormat.CompactStyle style) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(locale);
        CompactDecimalDataCache.Data data = cache.get(locale);
        this.prefix = data.prefixes;
        this.suffix = data.suffixes;
        this.divisor = data.divisors;
        this.applyPattern(format.toPattern());
        this.setDecimalFormatSymbols(format.getDecimalFormatSymbols());
        this.setMaximumSignificantDigits(2);
        this.setSignificantDigitsUsed(true);
        this.setGroupingUsed(false);
        DecimalFormat currencyFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
        this.currencyAffixes = new String[2];
        this.currencyAffixes[0] = currencyFormat.getPositivePrefix();
        this.currencyAffixes[1] = currencyFormat.getPositiveSuffix();
    }

    public CompactDecimalFormat(String pattern, DecimalFormatSymbols formatSymbols, String[] prefix, String[] suffix, long[] divisor, Collection<String> debugCreationErrors, NumberFormat.CompactStyle style, String[] currencyAffixes) {
        if (prefix.length < 15) {
            this.recordError(debugCreationErrors, "Must have at least 15 prefix items.");
        }
        if (prefix.length != suffix.length || prefix.length != divisor.length) {
            this.recordError(debugCreationErrors, "Prefix, suffix, and divisor arrays must have the same length.");
        }
        long oldDivisor = 0L;
        HashMap<String, Integer> seen = new HashMap<String, Integer>();
        for (int i = 0; i < prefix.length; ++i) {
            String key;
            Integer old;
            long roundTrip;
            int log;
            if (prefix[i] == null || suffix[i] == null) {
                this.recordError(debugCreationErrors, "Prefix or suffix is null for " + i);
            }
            if ((log = (int)Math.log10(divisor[i])) > i) {
                this.recordError(debugCreationErrors, "Divisor[" + i + "] must be less than or equal to 10^" + i + ", but is: " + divisor[i]);
            }
            if ((roundTrip = (long)Math.pow(10.0, log)) != divisor[i]) {
                this.recordError(debugCreationErrors, "Divisor[" + i + "] must be a power of 10, but is: " + divisor[i]);
            }
            if ((old = (Integer)seen.get(key = prefix[i] + "\uffff" + suffix[i] + "\uffff" + (i - log))) != null) {
                this.recordError(debugCreationErrors, "Collision between values for " + i + " and " + old + " for [prefix/suffix/index-log(divisor)" + key.replace('\uffff', ';'));
            } else {
                seen.put(key, i);
            }
            if (divisor[i] < oldDivisor) {
                this.recordError(debugCreationErrors, "Bad divisor, the divisor for 10E" + i + "(" + divisor[i] + ") is less than the divisor for the divisor for 10E" + (i - 1) + "(" + oldDivisor + ")");
            }
            oldDivisor = divisor[i];
        }
        this.prefix = (String[])prefix.clone();
        this.suffix = (String[])suffix.clone();
        this.divisor = (long[])divisor.clone();
        this.applyPattern(pattern);
        this.setDecimalFormatSymbols(formatSymbols);
        this.setMaximumSignificantDigits(2);
        this.setSignificantDigitsUsed(true);
        this.setGroupingUsed(false);
        this.currencyAffixes = (String[])currencyAffixes.clone();
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number < 0.0) {
            throw new UnsupportedOperationException("CompactDecimalFormat doesn't handle negative numbers yet.");
        }
        int integerCount = number <= 1.0 ? 0 : (int)Math.log10(number);
        int base = integerCount > 14 ? 14 : integerCount;
        this.setPositivePrefix(this.prefix[base]);
        this.setPositiveSuffix(this.suffix[base]);
        this.setCurrency(null);
        return super.format(number /= (double)this.divisor[base], toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((double)number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(com.ibm.icu.math.BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    @Override
    public Number parse(String text, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new NotSerializableException();
    }

    private void recordError(Collection<String> creationErrors, String errorMessage) {
        if (creationErrors == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        creationErrors.add(errorMessage);
    }
}

