/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.util.UResourceBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Region
implements Comparable<Region> {
    public static final int UNDEFINED_NUMERIC_CODE = -1;
    private String id;
    private int code;
    private RegionType type;
    private static boolean hasData = false;
    private static boolean hasContainmentData = false;
    private static Map<String, Integer> regionIndexMap = null;
    private static Map<Integer, Integer> numericIndexMap = null;
    private static Map<String, String> territoryAliasMap = null;
    private static Map<String, Integer> numericCodeMap = null;
    private static Region[] regions = null;
    private static BitSet[] subRegionData = null;
    private static Integer[] containingRegionData = null;
    private static ArrayList<Set<Region>> availableRegions = null;
    private static final String UNKNOWN_REGION_ID = "ZZ";
    private static final String WORLD_ID = "001";

    private Region() {
    }

    private static synchronized void initRegionData() {
        int i;
        if (hasData) {
            return;
        }
        territoryAliasMap = new HashMap<String, String>();
        numericCodeMap = new HashMap<String, Integer>();
        regionIndexMap = new HashMap<String, Integer>();
        numericIndexMap = new HashMap<Integer, Integer>();
        availableRegions = new ArrayList(RegionType.values().length);
        for (int i2 = 0; i2 < RegionType.values().length; ++i2) {
            availableRegions.add(null);
        }
        UResourceBundle regionCodes = null;
        UResourceBundle territoryAlias = null;
        UResourceBundle codeMappings = null;
        UResourceBundle worldContainment = null;
        UResourceBundle territoryContainment = null;
        UResourceBundle groupingContainment = null;
        UResourceBundle rb = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt50b", "metadata", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        regionCodes = rb.get("regionCodes");
        territoryAlias = rb.get("territoryAlias");
        UResourceBundle rb2 = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt50b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        codeMappings = rb2.get("codeMappings");
        territoryContainment = rb2.get("territoryContainment");
        worldContainment = territoryContainment.get(WORLD_ID);
        groupingContainment = territoryContainment.get("grouping");
        String[] continentsArr = worldContainment.getStringArray();
        List<String> continents = Arrays.asList(continentsArr);
        String[] groupingArr = groupingContainment.getStringArray();
        List<String> groupings = Arrays.asList(groupingArr);
        for (i = 0; i < codeMappings.getSize(); ++i) {
            UResourceBundle mapping = codeMappings.get(i);
            if (mapping.getType() != 8) continue;
            String[] codeStrings = mapping.getStringArray();
            if (!territoryAliasMap.containsKey(codeStrings[1])) {
                territoryAliasMap.put(codeStrings[1], codeStrings[0]);
            }
            territoryAliasMap.put(codeStrings[2], codeStrings[0]);
            numericCodeMap.put(codeStrings[0], Integer.valueOf(codeStrings[1]));
        }
        for (i = 0; i < territoryAlias.getSize(); ++i) {
            UResourceBundle res = territoryAlias.get(i);
            String key = res.getKey();
            String value = res.getString();
            if (territoryAliasMap.containsKey(key)) continue;
            territoryAliasMap.put(key, value);
        }
        regions = new Region[regionCodes.getSize()];
        for (i = 0; i < regions.length; ++i) {
            String id;
            Region.regions[i] = new Region();
            Region.regions[i].id = id = regionCodes.getString(i);
            regionIndexMap.put(id, i);
            if (id.matches("[0-9]{3}")) {
                Region.regions[i].code = Integer.valueOf(id);
                numericIndexMap.put(Region.regions[i].code, i);
            } else if (numericCodeMap.containsKey(id)) {
                Region.regions[i].code = numericCodeMap.get(id);
                if (!numericIndexMap.containsKey(Region.regions[i].code)) {
                    numericIndexMap.put(Region.regions[i].code, i);
                }
            } else {
                Region.regions[i].code = -1;
            }
            Region.regions[i].type = territoryAliasMap.containsKey(id) ? RegionType.DEPRECATED : (id.equals(WORLD_ID) ? RegionType.WORLD : (id.equals(UNKNOWN_REGION_ID) ? RegionType.UNKNOWN : (continents.contains(id) ? RegionType.CONTINENT : (groupings.contains(id) ? RegionType.GROUPING : (id.matches("[0-9]{3}|QO") ? RegionType.SUBCONTINENT : RegionType.TERRITORY)))));
        }
        hasData = true;
    }

    private static synchronized void initContainmentData() {
        if (hasContainmentData) {
            return;
        }
        Region.initRegionData();
        subRegionData = new BitSet[regions.length];
        containingRegionData = new Integer[regions.length];
        for (int i = 0; i < regions.length; ++i) {
            Region.subRegionData[i] = new BitSet(regions.length);
            Region.containingRegionData[i] = null;
        }
        UResourceBundle territoryContainment = null;
        UResourceBundle rb = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt50b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        territoryContainment = rb.get("territoryContainment");
        for (int i = 0; i < territoryContainment.getSize(); ++i) {
            UResourceBundle mapping = territoryContainment.get(i);
            String parent = mapping.getKey();
            Integer parentRegionIndex = regionIndexMap.get(parent);
            for (int j = 0; j < mapping.getSize(); ++j) {
                String child = mapping.getString(j);
                Integer childRegionIndex = regionIndexMap.get(child);
                if (parentRegionIndex == null || childRegionIndex == null) continue;
                subRegionData[parentRegionIndex].set(childRegionIndex);
                if (regions[parentRegionIndex].isOfType(RegionType.GROUPING)) continue;
                Region.containingRegionData[childRegionIndex.intValue()] = parentRegionIndex;
            }
        }
        hasContainmentData = true;
    }

    public static Region get(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        String canonicalID = Region.canonicalize(id);
        if (canonicalID.equals(UNKNOWN_REGION_ID) && !id.equals(UNKNOWN_REGION_ID)) {
            throw new IllegalArgumentException("Unknown region id: " + id);
        }
        return regions[regionIndexMap.get(canonicalID)];
    }

    public static Region get(int code) {
        Integer index = numericIndexMap.get(code);
        if (index != null) {
            Region r = regions[index];
            return Region.get(r.id);
        }
        throw new IllegalArgumentException("Unknown region code: " + code);
    }

    public static String canonicalize(String id) {
        Region.initRegionData();
        String result = territoryAliasMap.get(id);
        if (result != null && regionIndexMap.containsKey(result)) {
            return result;
        }
        if (regionIndexMap.containsKey(id)) {
            return id;
        }
        return UNKNOWN_REGION_ID;
    }

    public static boolean isCanonical(String id) {
        return Region.canonicalize(id).equals(id);
    }

    public static Set<Region> getAvailable(RegionType type) {
        Region.initRegionData();
        if (availableRegions.get(type.ordinal()) == null) {
            TreeSet<Region> result = new TreeSet<Region>();
            for (Region r : regions) {
                if (r.type != type) continue;
                result.add(r);
            }
            availableRegions.set(type.ordinal(), Collections.unmodifiableSet(result));
        }
        return availableRegions.get(type.ordinal());
    }

    public Region getContainingRegion() {
        Region.initContainmentData();
        Integer index = regionIndexMap.get(this.id);
        assert (index != null);
        if (containingRegionData[index] == null) {
            return null;
        }
        return regions[containingRegionData[index]];
    }

    public Set<Region> getSubRegions() {
        Region.initContainmentData();
        TreeSet<Region> result = new TreeSet<Region>();
        Integer index = regionIndexMap.get(this.id);
        BitSet contains = subRegionData[index];
        int i = contains.nextSetBit(0);
        while (i >= 0) {
            result.add(regions[i]);
            i = contains.nextSetBit(i + 1);
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<Region> getContainedTerritories() {
        Region.initContainmentData();
        TreeSet<Region> result = new TreeSet<Region>();
        Set<Region> subRegions = this.getSubRegions();
        for (Region r : subRegions) {
            if (r.isOfType(RegionType.TERRITORY)) {
                result.add(r);
                continue;
            }
            if (!r.isOfType(RegionType.CONTINENT) && !r.isOfType(RegionType.SUBCONTINENT)) continue;
            result.addAll(r.getContainedTerritories());
        }
        return Collections.unmodifiableSet(result);
    }

    public String toString() {
        return this.id;
    }

    public int getNumericCode() {
        return this.code;
    }

    public RegionType getType() {
        return this.type;
    }

    public boolean isOfType(RegionType type) {
        return this.type.equals((Object)type);
    }

    @Override
    public int compareTo(Region other) {
        return this.id.compareTo(other.id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RegionType {
        UNKNOWN,
        TERRITORY,
        WORLD,
        CONTINENT,
        SUBCONTINENT,
        GROUPING,
        DEPRECATED;

    }
}

