/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.util;

import com.ibm.icu.impl.MultiComparator;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.StringTransform;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.io.IOException;
import java.text.FieldPosition;
import java.util.Comparator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrinter {
    private static final UTF16.StringComparator CODEPOINT_ORDER = new UTF16.StringComparator(true, false, 0);
    private static final UnicodeSet PATTERN_WHITESPACE = new UnicodeSet("[[:Cn:][:Default_Ignorable_Code_Point:][:patternwhitespace:]]").freeze();
    private static final UnicodeSet SORT_AT_END = new UnicodeSet("[[:Cn:][:Cs:][:Co:][:Ideographic:]]").freeze();
    private static final UnicodeSet QUOTED_SYNTAX = new UnicodeSet("[\\[\\]\\-\\^\\&\\\\\\{\\}\\$\\:]").addAll(PATTERN_WHITESPACE).freeze();
    private boolean first = true;
    private StringBuffer target = new StringBuffer();
    private int firstCodePoint = -2;
    private int lastCodePoint = -2;
    private boolean compressRanges = true;
    private String lastString = "";
    private UnicodeSet toQuote = new UnicodeSet(PATTERN_WHITESPACE);
    private StringTransform quoter = null;
    private Comparator<String> ordering;
    private Comparator<String> spaceComp;

    public StringTransform getQuoter() {
        return this.quoter;
    }

    public PrettyPrinter setQuoter(StringTransform quoter) {
        this.quoter = quoter;
        return this;
    }

    public boolean isCompressRanges() {
        return this.compressRanges;
    }

    public PrettyPrinter setCompressRanges(boolean compressRanges) {
        this.compressRanges = compressRanges;
        return this;
    }

    public Comparator<String> getOrdering() {
        return this.ordering;
    }

    public PrettyPrinter setOrdering(Comparator ordering) {
        this.ordering = ordering == null ? CODEPOINT_ORDER : new MultiComparator(new Comparator[]{ordering, CODEPOINT_ORDER});
        return this;
    }

    public Comparator<String> getSpaceComparator() {
        return this.spaceComp;
    }

    public PrettyPrinter setSpaceComparator(Comparator spaceComp) {
        this.spaceComp = spaceComp;
        return this;
    }

    public UnicodeSet getToQuote() {
        return this.toQuote;
    }

    public PrettyPrinter setToQuote(UnicodeSet toQuote) {
        if (toQuote != null) {
            toQuote = toQuote.cloneAsThawed();
            toQuote.addAll(PATTERN_WHITESPACE);
            this.toQuote = toQuote;
        }
        return this;
    }

    public String format(UnicodeSet uset) {
        this.first = true;
        UnicodeSet putAtEnd = new UnicodeSet(uset).retainAll(SORT_AT_END);
        TreeSet<String> orderedStrings = new TreeSet<String>(this.ordering);
        UnicodeSetIterator it = new UnicodeSetIterator(uset);
        while (it.nextRange()) {
            if (it.codepoint == UnicodeSetIterator.IS_STRING) {
                orderedStrings.add(it.string);
                continue;
            }
            for (int i = it.codepoint; i <= it.codepointEnd; ++i) {
                if (putAtEnd.contains(i)) continue;
                orderedStrings.add(UTF16.valueOf((int)i));
            }
        }
        this.target.setLength(0);
        this.target.append("[");
        for (String item : orderedStrings) {
            this.appendUnicodeSetItem(item);
        }
        it = new UnicodeSetIterator(putAtEnd);
        while (it.next()) {
            this.appendUnicodeSetItem(it.codepoint);
        }
        this.flushLast();
        this.target.append("]");
        String sresult = this.target.toString();
        return sresult;
    }

    private PrettyPrinter appendUnicodeSetItem(String s) {
        if (UTF16.hasMoreCodePointsThan((String)s, (int)1)) {
            this.flushLast();
            this.addSpaceAsNeededBefore(s);
            this.appendQuoted(s);
            this.lastString = s;
        } else {
            this.appendUnicodeSetItem(UTF16.charAt((String)s, (int)0));
        }
        return this;
    }

    private void appendUnicodeSetItem(int cp) {
        if (!this.compressRanges) {
            this.flushLast();
        }
        if (cp == this.lastCodePoint + 1) {
            this.lastCodePoint = cp;
        } else {
            this.flushLast();
            this.firstCodePoint = this.lastCodePoint = cp;
        }
    }

    private void addSpaceAsNeededBefore(String s) {
        if (this.first) {
            this.first = false;
        } else if (this.spaceComp != null && this.spaceComp.compare(s, this.lastString) != 0) {
            this.target.append(' ');
        } else {
            int cp = UTF16.charAt((String)s, (int)0);
            if (!this.toQuote.contains(cp) && !QUOTED_SYNTAX.contains(cp)) {
                int type = UCharacter.getType((int)cp);
                if (type == 6 || type == 7) {
                    this.target.append(' ');
                } else if (type == 18 && cp >= 56320) {
                    this.target.append(' ');
                }
            }
        }
    }

    private void addSpaceAsNeededBefore(int codepoint) {
        this.addSpaceAsNeededBefore(UTF16.valueOf((int)codepoint));
    }

    private void flushLast() {
        if (this.lastCodePoint >= 0) {
            this.addSpaceAsNeededBefore(this.firstCodePoint);
            if (this.firstCodePoint != this.lastCodePoint) {
                this.appendQuoted(this.firstCodePoint);
                if (this.firstCodePoint + 1 != this.lastCodePoint) {
                    this.target.append('-');
                } else {
                    this.addSpaceAsNeededBefore(this.lastCodePoint);
                }
            }
            this.appendQuoted(this.lastCodePoint);
            this.lastString = UTF16.valueOf((int)this.lastCodePoint);
            this.lastCodePoint = -2;
            this.firstCodePoint = -2;
        }
    }

    private void appendQuoted(String s) {
        if (this.toQuote.containsSome((CharSequence)s) && this.quoter != null) {
            this.target.append(this.quoter.transform(s));
        } else {
            int cp;
            this.target.append("{");
            for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
                cp = UTF16.charAt((String)s, (int)i);
                this.appendQuoted(cp);
            }
            this.target.append("}");
        }
    }

    PrettyPrinter appendQuoted(int codePoint) {
        if (this.toQuote.contains(codePoint)) {
            if (this.quoter != null) {
                this.target.append(this.quoter.transform(UTF16.valueOf((int)codePoint)));
                return this;
            }
            if (codePoint > 65535) {
                this.target.append("\\U");
                this.target.append(Utility.hex((long)codePoint, (int)8));
            } else {
                this.target.append("\\u");
                this.target.append(Utility.hex((long)codePoint, (int)4));
            }
            return this;
        }
        switch (codePoint) {
            case 36: 
            case 38: 
            case 45: 
            case 58: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 125: {
                this.target.append('\\');
                break;
            }
            default: {
                if (!PATTERN_WHITESPACE.contains(codePoint)) break;
                this.target.append('\\');
            }
        }
        UTF16.append((StringBuffer)this.target, (int)codePoint);
        return this;
    }

    public Appendable format(UnicodeSet obj, Appendable toAppendTo, FieldPosition pos) {
        try {
            return toAppendTo.append(this.format(obj));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

