/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SortedBag
implements Collection {
    private Map m;
    private int size;
    static Iterator EMPTY_ITERATOR = new HashSet().iterator();

    public SortedBag(Comparator c) {
        this.m = new TreeMap(c);
    }

    public boolean add(Object s) {
        boolean result;
        HashSet<Object> o = (HashSet<Object>)this.m.get(s);
        if (o == null) {
            o = new HashSet<Object>(1);
            this.m.put(s, o);
        }
        if (result = o.add(s)) {
            ++this.size;
        }
        return result;
    }

    public Iterator iterator() {
        return new MyIterator();
    }

    public void clear() {
        this.m.clear();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        Set set = (Set)this.m.get(o);
        if (set == null) {
            return false;
        }
        return set.contains(o);
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    public Object[] toArray(Object[] a) {
        int count = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            a[count++] = it.next();
        }
        return a;
    }

    public boolean remove(Object o) {
        Set set = (Set)this.m.get(o);
        if (set == null) {
            return false;
        }
        if (!set.remove(o)) {
            return false;
        }
        if (set.size() == 0) {
            this.m.remove(o);
        }
        --this.size;
        return true;
    }

    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        boolean result = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (!this.add(it.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean removeAll(Collection c) {
        boolean result = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean retainAll(Collection c) {
        HashSet stuffToRemove = new HashSet();
        for (Object item : this) {
            if (c.contains(item)) continue;
            stuffToRemove.add(item);
        }
        return this.removeAll((Collection)stuffToRemove);
    }

    private class MyIterator
    implements Iterator {
        private Iterator mapIterator;
        private Iterator setIterator;

        private MyIterator() {
            this.mapIterator = SortedBag.this.m.keySet().iterator();
            this.setIterator = null;
            this.mapIterator = SortedBag.this.m.keySet().iterator();
            this.setIterator = this.getSetIterator();
        }

        private Iterator getSetIterator() {
            if (!this.mapIterator.hasNext()) {
                return EMPTY_ITERATOR;
            }
            return ((Set)SortedBag.this.m.get(this.mapIterator.next())).iterator();
        }

        public boolean hasNext() {
            return this.setIterator.hasNext() || this.mapIterator.hasNext();
        }

        public Object next() {
            if (!this.setIterator.hasNext()) {
                this.setIterator = this.getSetIterator();
            }
            return this.setIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

