/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.util;

import com.ibm.icu.impl.Row;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XEquivalenceMap<K, V, R>
implements Iterable<Set<K>> {
    Map<K, Row.R2<V, Set<R>>> source_target_reasons = new HashMap<K, Row.R2<V, Set<R>>>();
    Map<V, Set<K>> target_sourceSet;
    Map<K, Set<K>> source_Set = new HashMap<K, Set<K>>();

    public XEquivalenceMap() {
        this(new HashMap());
    }

    public XEquivalenceMap(Map<V, Set<K>> storage) {
        this.target_sourceSet = storage;
    }

    public XEquivalenceMap clear() {
        this.source_target_reasons.clear();
        this.target_sourceSet.clear();
        this.source_Set.clear();
        return this;
    }

    public XEquivalenceMap add(K source, V target) {
        return this.add(source, target, null);
    }

    public XEquivalenceMap add(K source, V target, R reason) {
        HashSet<R> reasons;
        Row.R2 target_reasons = this.source_target_reasons.get(source);
        if (target_reasons == null) {
            reasons = new HashSet<R>();
            if (reason != null) {
                reasons.add(reason);
            }
        } else {
            Object otherTarget = target_reasons.get0();
            Set reasons2 = (Set)target_reasons.get1();
            if (otherTarget.equals(target)) {
                if (reason != null) {
                    reasons2.add(reason);
                }
                return this;
            }
            throw new IllegalArgumentException("Same source mapping to different targets: " + source + " => " + otherTarget + " & " + target);
        }
        target_reasons = Row.of(target, reasons);
        this.source_target_reasons.put(source, target_reasons);
        Set<K> s = this.target_sourceSet.get(target);
        if (s == null) {
            s = new HashSet<K>();
            this.target_sourceSet.put((HashSet<K>)target, (Set<V>)s);
        }
        s.add(source);
        this.source_Set.put(source, s);
        return this;
    }

    public Set<K> getEquivalences(K source) {
        Set<K> s = this.source_Set.get(source);
        if (s == null) {
            return null;
        }
        return Collections.unmodifiableSet(s);
    }

    public boolean areEquivalent(K source1, K source2) {
        Set<K> s = this.source_Set.get(source1);
        if (s == null) {
            return false;
        }
        return s.contains(source2);
    }

    public V getTarget(K source) {
        return (V)this.source_target_reasons.get(source).get0();
    }

    public Set<R> getReasons(K source) {
        return Collections.unmodifiableSet((Set)this.source_target_reasons.get(source).get1());
    }

    public Set<K> getSources(V target) {
        Set<K> s = this.target_sourceSet.get(target);
        return Collections.unmodifiableSet(s);
    }

    @Override
    public Iterator<Set<K>> iterator() {
        return UnmodifiableIterator.from(this.target_sourceSet.values());
    }

    public int size() {
        return this.target_sourceSet.size();
    }

    public boolean isEmpty() {
        return this.target_sourceSet.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnmodifiableIterator<T>
    implements Iterator<T> {
        private Iterator<T> source;

        public static <T> UnmodifiableIterator<T> from(Iterator<T> source) {
            UnmodifiableIterator<T> result = new UnmodifiableIterator<T>();
            result.source = source;
            return result;
        }

        public static <T> UnmodifiableIterator<T> from(Iterable<T> source) {
            return UnmodifiableIterator.from(source.iterator());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public T next() {
            return this.source.next();
        }
    }
}

