/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.util;

import com.ibm.icu.text.UTF16;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public final class DataInputCompressor
implements ObjectInput {
    static final boolean SHOW = false;
    private ObjectInput dataInput;
    private transient StringBuffer stringBuffer = new StringBuffer();

    public DataInputCompressor(ObjectInput dataInput) {
        this.dataInput = dataInput;
    }

    public DataInput getDataInput() {
        return this.dataInput;
    }

    public void setDataInput(ObjectInput dataInput) {
        this.dataInput = dataInput;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.dataInput.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.dataInput.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.dataInput.readUnsignedByte();
    }

    @Override
    public double readDouble() throws IOException {
        return this.dataInput.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.dataInput.readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.dataInput.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dataInput.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.dataInput.skipBytes(n);
    }

    @Override
    public String readLine() throws IOException {
        return this.dataInput.readLine();
    }

    @Override
    public int available() throws IOException {
        return this.dataInput.available();
    }

    @Override
    public void close() throws IOException {
        this.dataInput.close();
    }

    @Override
    public int read() throws IOException {
        return this.dataInput.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.dataInput.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.dataInput.read(b, off, len);
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        return this.dataInput.readObject();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.dataInput.skip(n);
    }

    public String toString() {
        return this.dataInput.toString();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readULong();
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readLong();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return (int)this.readULong();
    }

    public int readUShort() throws IOException {
        return (int)this.readULong();
    }

    @Override
    public int readInt() throws IOException {
        return (int)this.readLong();
    }

    public int readUInt() throws IOException {
        return (int)this.readULong();
    }

    public String readChars(int len) throws IOException {
        this.stringBuffer.setLength(0);
        for (int i = 0; i < len; ++i) {
            int cp = (int)this.readULong();
            UTF16.append((StringBuffer)this.stringBuffer, (int)cp);
        }
        return this.stringBuffer.toString();
    }

    @Override
    public String readUTF() throws IOException {
        int len = (int)this.readULong();
        return this.readChars(len);
    }

    @Override
    public long readLong() throws IOException {
        long result = 0L;
        int offset = 0;
        while (true) {
            long input = this.readByte();
            result |= (input & 0x7FL) << offset;
            if ((input & 0x80L) == 0L) break;
            offset += 7;
        }
        boolean negative = (result & 1L) != 0L;
        result >>>= 1;
        if (negative) {
            result ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return result;
    }

    public long readULong() throws IOException {
        long result = 0L;
        int offset = 0;
        while (true) {
            byte input = this.readByte();
            result |= (long)((input & 0x7F) << offset);
            if ((input & 0x80) == 0) {
                return result;
            }
            offset += 7;
        }
    }

    public Object[] readStringSet(Collection availableValues) throws IOException {
        int size = this.readUInt();
        Object[] valuesList = new Object[size + 1];
        String lastString = "";
        ReadPool trailingPool = new ReadPool();
        for (int i = 0; i < size; ++i) {
            String current;
            int common = this.readUInt();
            boolean inPool = (common & 1) != 0;
            common >>>= 1;
            if (inPool) {
                int poolIndex = this.readUInt();
                current = (String)trailingPool.get(poolIndex);
            } else {
                current = this.readUTF();
                trailingPool.add(current);
            }
            lastString = lastString.substring(0, common) + current;
            valuesList[i + 1] = lastString;
            if (availableValues == null) continue;
            availableValues.add(current);
        }
        return valuesList;
    }

    public Object[] readCollection(LinkedHashSet availableValues) throws ClassNotFoundException, IOException {
        int size = this.readUInt();
        Object[] valuesList = new Object[size + 1];
        for (int i = 0; i < size; ++i) {
            valuesList[i + 1] = this.readObject();
        }
        return valuesList;
    }

    public static class ReadPool {
        private List trailingPool = new ArrayList();

        public Object get(int index) {
            return this.trailingPool.get(index);
        }

        public void add(Object o) {
            this.trailingPool.add(o);
        }
    }
}

