/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.util;

import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.text.UTF16;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;

public final class DataOutputCompressor
implements ObjectOutput {
    static final boolean SHOW = false;
    private ObjectOutput dataOutput;

    public DataOutputCompressor(ObjectOutput dataOutput) {
        this.dataOutput = dataOutput;
    }

    public DataOutput getDataOutput() {
        return this.dataOutput;
    }

    public void setDataOutput(ObjectOutput dataOutput) {
        this.dataOutput = dataOutput;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.dataOutput.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.dataOutput.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.dataOutput.write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dataOutput.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dataOutput.writeByte(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.dataOutput.writeBytes(s);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dataOutput.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dataOutput.writeFloat(v);
    }

    @Override
    public void close() throws IOException {
        this.dataOutput.close();
    }

    @Override
    public void flush() throws IOException {
        this.dataOutput.flush();
    }

    public String toString() {
        return this.dataOutput.toString();
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.dataOutput.writeObject(obj);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeULong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeLong(v);
    }

    public void writeUShort(int v) throws IOException {
        this.writeULong(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeLong(v);
    }

    public void writeUInt(int v) throws IOException {
        this.writeULong(v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.writeULong(UTF16.countCodePoint((String)str));
        this.writeChars(str);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int cp = 0;
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            this.writeULong(cp);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        long flag = 0L;
        if (v < 0L) {
            v ^= 0xFFFFFFFFFFFFFFFFL;
            flag = 1L;
        }
        v <<= 1;
        v |= flag;
        while (true) {
            if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.dataOutput.writeByte((byte)(0x80L | v));
            v >>>= 7;
        }
        this.dataOutput.writeByte((byte)v);
    }

    public void writeULong(long v) throws IOException {
        while (true) {
            if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.dataOutput.writeByte((byte)(0x80L | v));
            v >>>= 7;
        }
        this.dataOutput.writeByte((byte)v);
    }

    public void writeStringSet(SortedSet c, Map object_index) throws IOException {
        this.writeUInt(c.size());
        int i = 0;
        object_index.put(null, new Integer(i++));
        WritePool trailingPool = new WritePool();
        String lastString = "";
        for (String s : c) {
            object_index.put(s, new Integer(i++));
            int common = UnicodeMap.findCommonPrefix(lastString, s);
            lastString = s;
            String piece = s.substring(common);
            common <<= 1;
            int inPool = trailingPool.getIndex(piece);
            if (inPool < 0) {
                this.writeUInt(common);
                this.writeUTF(piece);
                trailingPool.put(piece);
                continue;
            }
            this.writeUInt(common | 1);
            this.writeUInt(inPool);
        }
    }

    public void writeCollection(Collection c, Map object_index) throws IOException {
        this.writeUInt(c.size());
        int i = 0;
        object_index.put(null, new Integer(i++));
        for (Object s : c) {
            this.dataOutput.writeObject(s);
            if (object_index == null) continue;
            object_index.put(s, new Integer(i++));
        }
    }

    public static class WritePool {
        private Map trailingPool = new HashMap();
        private int poolCount = 0;

        public int getIndex(Object o) {
            Integer inPool = (Integer)this.trailingPool.get(o);
            if (inPool == null) {
                return -1;
            }
            return inPool;
        }

        public void put(Object o) {
            this.trailingPool.put(o, new Integer(this.poolCount++));
        }
    }
}

