/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.util;

import com.ibm.icu.dev.util.UnicodeTransform;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer2;

public class IcuUnicodeNormalizerFactory
implements UnicodeTransform.Factory {
    @Override
    public UnicodeTransform getInstance(UnicodeTransform.Type type) {
        switch (type) {
            case NFC: {
                return new IcuUnicodeNormalizer(Normalizer2.getNFCInstance());
            }
            case NFKC: {
                return new IcuUnicodeNormalizer(Normalizer2.getNFKCInstance());
            }
            case NFD: {
                return new IcuUnicodeNormalizer(Normalizer2.getNFDInstance());
            }
            case NFKD: {
                return new IcuUnicodeNormalizer(Normalizer2.getNFKDInstance());
            }
            case CASEFOLD: {
                return new CaseFolder();
            }
        }
        throw new IllegalArgumentException();
    }

    private static class IcuUnicodeNormalizer
    extends UnicodeTransform {
        private Normalizer2 normalizer;

        private IcuUnicodeNormalizer(Normalizer2 normalizer) {
            this.normalizer = normalizer;
        }

        @Override
        public String transform(String src) {
            return this.normalizer.normalize((CharSequence)src);
        }

        @Override
        public boolean isTransformed(String s) {
            return this.normalizer.isNormalized((CharSequence)s);
        }
    }

    private static class CaseFolder
    extends UnicodeTransform {
        private CaseFolder() {
        }

        @Override
        public String transform(String source) {
            return UCharacter.foldCase((String)source.toString(), (boolean)true);
        }
    }
}

