package org.unicode.cldr.draft.picker;
public class CharData {
public static String[][] CHARACTERS_TO_NAME = {
{" ","SPACE"},
{"-","HYPHEN-MINUS"},
{" ","NO-BREAK SPACE"},
{"­","SOFT HYPHEN"},
{"͏","COMBINING GRAPHEME JOINER"},
{"֊","ARMENIAN HYPHEN"},
{"־","HEBREW PUNCTUATION MAQAF"},
{"؀","ARABIC NUMBER SIGN"},
{"؁","ARABIC SIGN SANAH"},
{"؂","ARABIC FOOTNOTE MARKER"},
{"؃","ARABIC SIGN SAFHA"},
{"؄","ARABIC SIGN SAMVAT"},
{"؅","ARABIC NUMBER MARK ABOVE"},
{"؜","ARABIC LETTER MARK"},
{"۝","ARABIC END OF AYAH"},
{"܏","SYRIAC ABBREVIATION MARK"},
{"ᅟ","HANGUL CHOSEONG FILLER"},
{"ᅠ","HANGUL JUNGSEONG FILLER"},
{"᐀","CANADIAN SYLLABICS HYPHEN"},
{" ","OGHAM SPACE MARK"},
{"឴","KHMER VOWEL INHERENT AQ"},
{"឵","KHMER VOWEL INHERENT AA"},
{"᠆","MONGOLIAN TODO SOFT HYPHEN"},
{"᠋","MONGOLIAN FREE VARIATION SELECTOR ONE"},
{"᠌","MONGOLIAN FREE VARIATION SELECTOR TWO"},
{"᠍","MONGOLIAN FREE VARIATION SELECTOR THREE"},
{"᠎","MONGOLIAN VOWEL SEPARATOR"},
{" ","EN QUAD"},
{" ","EM QUAD"},
{" ","EN SPACE"},
{" ","EM SPACE"},
{" ","THREE-PER-EM SPACE"},
{" ","FOUR-PER-EM SPACE"},
{" ","SIX-PER-EM SPACE"},
{" ","FIGURE SPACE"},
{" ","PUNCTUATION SPACE"},
{" ","THIN SPACE"},
{" ","HAIR SPACE"},
{"​","ZERO WIDTH SPACE"},
{"‌","ZERO WIDTH NON-JOINER"},
{"‍","ZERO WIDTH JOINER"},
{"‎","LEFT-TO-RIGHT MARK"},
{"‏","RIGHT-TO-LEFT MARK"},
{"‐","HYPHEN"},
{"‑","NON-BREAKING HYPHEN"},
{"‒","FIGURE DASH"},
{"–","EN DASH"},
{"—","EM DASH"},
{"―","HORIZONTAL BAR"},
{" ","LINE SEPARATOR"},
{" ","PARAGRAPH SEPARATOR"},
{"‪","LEFT-TO-RIGHT EMBEDDING"},
{"‫","RIGHT-TO-LEFT EMBEDDING"},
{"‬","POP DIRECTIONAL FORMATTING"},
{"‭","LEFT-TO-RIGHT OVERRIDE"},
{"‮","RIGHT-TO-LEFT OVERRIDE"},
{" ","NARROW NO-BREAK SPACE"},
{" ","MEDIUM MATHEMATICAL SPACE"},
{"⁠","WORD JOINER"},
{"⁡","FUNCTION APPLICATION"},
{"⁢","INVISIBLE TIMES"},
{"⁣","INVISIBLE SEPARATOR"},
{"⁤","INVISIBLE PLUS"},
{"⁦","LEFT-TO-RIGHT ISOLATE"},
{"⁧","RIGHT-TO-LEFT ISOLATE"},
{"⁨","FIRST STRONG ISOLATE"},
{"⁩","POP DIRECTIONAL ISOLATE"},
{"⸗","DOUBLE OBLIQUE HYPHEN"},
{"⸚","HYPHEN WITH DIAERESIS"},
{"⸺","TWO-EM DASH"},
{"⸻","THREE-EM DASH"},
{"⹀","DOUBLE HYPHEN"},
{"　","IDEOGRAPHIC SPACE"},
{"〜","WAVE DASH"},
{"〰","WAVY DASH"},
{"゠","KATAKANA-HIRAGANA DOUBLE HYPHEN"},
{"ㅤ","HANGUL FILLER"},
{"︀","VARIATION SELECTOR-1"},
{"︁","VARIATION SELECTOR-2"},
{"︂","VARIATION SELECTOR-3"},
{"︃","VARIATION SELECTOR-4"},
{"︄","VARIATION SELECTOR-5"},
{"︅","VARIATION SELECTOR-6"},
{"︆","VARIATION SELECTOR-7"},
{"︇","VARIATION SELECTOR-8"},
{"︈","VARIATION SELECTOR-9"},
{"︉","VARIATION SELECTOR-10"},
{"︊","VARIATION SELECTOR-11"},
{"︋","VARIATION SELECTOR-12"},
{"︌","VARIATION SELECTOR-13"},
{"︍","VARIATION SELECTOR-14"},
{"︎","VARIATION SELECTOR-15"},
{"️","VARIATION SELECTOR-16"},
{"︱","PRESENTATION FORM FOR VERTICAL EM DASH"},
{"︲","PRESENTATION FORM FOR VERTICAL EN DASH"},
{"﹘","SMALL EM DASH"},
{"﹣","SMALL HYPHEN-MINUS"},
{"﻿","ZERO WIDTH NO-BREAK SPACE"},
{"－","FULLWIDTH HYPHEN-MINUS"},
{"ﾠ","HALFWIDTH HANGUL FILLER"},
{"￹","INTERLINEAR ANNOTATION ANCHOR"},
{"￺","INTERLINEAR ANNOTATION SEPARATOR"},
{"￻","INTERLINEAR ANNOTATION TERMINATOR"},
{"𑂽","KAITHI NUMBER SIGN"},
{"𛲠","SHORTHAND FORMAT LETTER OVERLAP"},
{"𛲡","SHORTHAND FORMAT CONTINUING OVERLAP"},
{"𛲢","SHORTHAND FORMAT DOWN STEP"},
{"𛲣","SHORTHAND FORMAT UP STEP"},
{"𝅳","MUSICAL SYMBOL BEGIN BEAM"},
{"𝅴","MUSICAL SYMBOL END BEAM"},
{"𝅵","MUSICAL SYMBOL BEGIN TIE"},
{"𝅶","MUSICAL SYMBOL END TIE"},
{"𝅷","MUSICAL SYMBOL BEGIN SLUR"},
{"𝅸","MUSICAL SYMBOL END SLUR"},
{"𝅹","MUSICAL SYMBOL BEGIN PHRASE"},
{"𝅺","MUSICAL SYMBOL END PHRASE"},
{"󠀠","TAG SPACE"},
{"󠀡","TAG EXCLAMATION MARK"},
{"󠀢","TAG QUOTATION MARK"},
{"󠀣","TAG NUMBER SIGN"},
{"󠀤","TAG DOLLAR SIGN"},
{"󠀥","TAG PERCENT SIGN"},
{"󠀦","TAG AMPERSAND"},
{"󠀧","TAG APOSTROPHE"},
{"󠀨","TAG LEFT PARENTHESIS"},
{"󠀩","TAG RIGHT PARENTHESIS"},
{"󠀪","TAG ASTERISK"},
{"󠀫","TAG PLUS SIGN"},
{"󠀬","TAG COMMA"},
{"󠀭","TAG HYPHEN-MINUS"},
{"󠀮","TAG FULL STOP"},
{"󠀯","TAG SOLIDUS"},
{"󠀰","TAG DIGIT ZERO"},
{"󠀱","TAG DIGIT ONE"},
{"󠀲","TAG DIGIT TWO"},
{"󠀳","TAG DIGIT THREE"},
{"󠀴","TAG DIGIT FOUR"},
{"󠀵","TAG DIGIT FIVE"},
{"󠀶","TAG DIGIT SIX"},
{"󠀷","TAG DIGIT SEVEN"},
{"󠀸","TAG DIGIT EIGHT"},
{"󠀹","TAG DIGIT NINE"},
{"󠀺","TAG COLON"},
{"󠀻","TAG SEMICOLON"},
{"󠀼","TAG LESS-THAN SIGN"},
{"󠀽","TAG EQUALS SIGN"},
{"󠀾","TAG GREATER-THAN SIGN"},
{"󠀿","TAG QUESTION MARK"},
{"󠁀","TAG COMMERCIAL AT"},
{"󠁁","TAG LATIN CAPITAL LETTER A"},
{"󠁂","TAG LATIN CAPITAL LETTER B"},
{"󠁃","TAG LATIN CAPITAL LETTER C"},
{"󠁄","TAG LATIN CAPITAL LETTER D"},
{"󠁅","TAG LATIN CAPITAL LETTER E"},
{"󠁆","TAG LATIN CAPITAL LETTER F"},
{"󠁇","TAG LATIN CAPITAL LETTER G"},
{"󠁈","TAG LATIN CAPITAL LETTER H"},
{"󠁉","TAG LATIN CAPITAL LETTER I"},
{"󠁊","TAG LATIN CAPITAL LETTER J"},
{"󠁋","TAG LATIN CAPITAL LETTER K"},
{"󠁌","TAG LATIN CAPITAL LETTER L"},
{"󠁍","TAG LATIN CAPITAL LETTER M"},
{"󠁎","TAG LATIN CAPITAL LETTER N"},
{"󠁏","TAG LATIN CAPITAL LETTER O"},
{"󠁐","TAG LATIN CAPITAL LETTER P"},
{"󠁑","TAG LATIN CAPITAL LETTER Q"},
{"󠁒","TAG LATIN CAPITAL LETTER R"},
{"󠁓","TAG LATIN CAPITAL LETTER S"},
{"󠁔","TAG LATIN CAPITAL LETTER T"},
{"󠁕","TAG LATIN CAPITAL LETTER U"},
{"󠁖","TAG LATIN CAPITAL LETTER V"},
{"󠁗","TAG LATIN CAPITAL LETTER W"},
{"󠁘","TAG LATIN CAPITAL LETTER X"},
{"󠁙","TAG LATIN CAPITAL LETTER Y"},
{"󠁚","TAG LATIN CAPITAL LETTER Z"},
{"󠁛","TAG LEFT SQUARE BRACKET"},
{"󠁜","TAG REVERSE SOLIDUS"},
{"󠁝","TAG RIGHT SQUARE BRACKET"},
{"󠁞","TAG CIRCUMFLEX ACCENT"},
{"󠁟","TAG LOW LINE"},
{"󠁠","TAG GRAVE ACCENT"},
{"󠁡","TAG LATIN SMALL LETTER A"},
{"󠁢","TAG LATIN SMALL LETTER B"},
{"󠁣","TAG LATIN SMALL LETTER C"},
{"󠁤","TAG LATIN SMALL LETTER D"},
{"󠁥","TAG LATIN SMALL LETTER E"},
{"󠁦","TAG LATIN SMALL LETTER F"},
{"󠁧","TAG LATIN SMALL LETTER G"},
{"󠁨","TAG LATIN SMALL LETTER H"},
{"󠁩","TAG LATIN SMALL LETTER I"},
{"󠁪","TAG LATIN SMALL LETTER J"},
{"󠁫","TAG LATIN SMALL LETTER K"},
{"󠁬","TAG LATIN SMALL LETTER L"},
{"󠁭","TAG LATIN SMALL LETTER M"},
{"󠁮","TAG LATIN SMALL LETTER N"},
{"󠁯","TAG LATIN SMALL LETTER O"},
{"󠁰","TAG LATIN SMALL LETTER P"},
{"󠁱","TAG LATIN SMALL LETTER Q"},
{"󠁲","TAG LATIN SMALL LETTER R"},
{"󠁳","TAG LATIN SMALL LETTER S"},
{"󠁴","TAG LATIN SMALL LETTER T"},
{"󠁵","TAG LATIN SMALL LETTER U"},
{"󠁶","TAG LATIN SMALL LETTER V"},
{"󠁷","TAG LATIN SMALL LETTER W"},
{"󠁸","TAG LATIN SMALL LETTER X"},
{"󠁹","TAG LATIN SMALL LETTER Y"},
{"󠁺","TAG LATIN SMALL LETTER Z"},
{"󠁻","TAG LEFT CURLY BRACKET"},
{"󠁼","TAG VERTICAL LINE"},
{"󠁽","TAG RIGHT CURLY BRACKET"},
{"󠁾","TAG TILDE"},
{"󠄀","VARIATION SELECTOR-17"},
{"󠄁","VARIATION SELECTOR-18"},
{"󠄂","VARIATION SELECTOR-19"},
{"󠄃","VARIATION SELECTOR-20"},
{"󠄄","VARIATION SELECTOR-21"},
{"󠄅","VARIATION SELECTOR-22"},
{"󠄆","VARIATION SELECTOR-23"},
{"󠄇","VARIATION SELECTOR-24"},
{"󠄈","VARIATION SELECTOR-25"},
{"󠄉","VARIATION SELECTOR-26"},
{"󠄊","VARIATION SELECTOR-27"},
{"󠄋","VARIATION SELECTOR-28"},
{"󠄌","VARIATION SELECTOR-29"},
{"󠄍","VARIATION SELECTOR-30"},
{"󠄎","VARIATION SELECTOR-31"},
{"󠄏","VARIATION SELECTOR-32"},
{"󠄐","VARIATION SELECTOR-33"},
{"󠄑","VARIATION SELECTOR-34"},
{"󠄒","VARIATION SELECTOR-35"},
{"󠄓","VARIATION SELECTOR-36"},
{"󠄔","VARIATION SELECTOR-37"},
{"󠄕","VARIATION SELECTOR-38"},
{"󠄖","VARIATION SELECTOR-39"},
{"󠄗","VARIATION SELECTOR-40"},
{"󠄘","VARIATION SELECTOR-41"},
{"󠄙","VARIATION SELECTOR-42"},
{"󠄚","VARIATION SELECTOR-43"},
{"󠄛","VARIATION SELECTOR-44"},
{"󠄜","VARIATION SELECTOR-45"},
{"󠄝","VARIATION SELECTOR-46"},
{"󠄞","VARIATION SELECTOR-47"},
{"󠄟","VARIATION SELECTOR-48"},
{"󠄠","VARIATION SELECTOR-49"},
{"󠄡","VARIATION SELECTOR-50"},
{"󠄢","VARIATION SELECTOR-51"},
{"󠄣","VARIATION SELECTOR-52"},
{"󠄤","VARIATION SELECTOR-53"},
{"󠄥","VARIATION SELECTOR-54"},
{"󠄦","VARIATION SELECTOR-55"},
{"󠄧","VARIATION SELECTOR-56"},
{"󠄨","VARIATION SELECTOR-57"},
{"󠄩","VARIATION SELECTOR-58"},
{"󠄪","VARIATION SELECTOR-59"},
{"󠄫","VARIATION SELECTOR-60"},
{"󠄬","VARIATION SELECTOR-61"},
{"󠄭","VARIATION SELECTOR-62"},
{"󠄮","VARIATION SELECTOR-63"},
{"󠄯","VARIATION SELECTOR-64"},
{"󠄰","VARIATION SELECTOR-65"},
{"󠄱","VARIATION SELECTOR-66"},
{"󠄲","VARIATION SELECTOR-67"},
{"󠄳","VARIATION SELECTOR-68"},
{"󠄴","VARIATION SELECTOR-69"},
{"󠄵","VARIATION SELECTOR-70"},
{"󠄶","VARIATION SELECTOR-71"},
{"󠄷","VARIATION SELECTOR-72"},
{"󠄸","VARIATION SELECTOR-73"},
{"󠄹","VARIATION SELECTOR-74"},
{"󠄺","VARIATION SELECTOR-75"},
{"󠄻","VARIATION SELECTOR-76"},
{"󠄼","VARIATION SELECTOR-77"},
{"󠄽","VARIATION SELECTOR-78"},
{"󠄾","VARIATION SELECTOR-79"},
{"󠄿","VARIATION SELECTOR-80"},
{"󠅀","VARIATION SELECTOR-81"},
{"󠅁","VARIATION SELECTOR-82"},
{"󠅂","VARIATION SELECTOR-83"},
{"󠅃","VARIATION SELECTOR-84"},
{"󠅄","VARIATION SELECTOR-85"},
{"󠅅","VARIATION SELECTOR-86"},
{"󠅆","VARIATION SELECTOR-87"},
{"󠅇","VARIATION SELECTOR-88"},
{"󠅈","VARIATION SELECTOR-89"},
{"󠅉","VARIATION SELECTOR-90"},
{"󠅊","VARIATION SELECTOR-91"},
{"󠅋","VARIATION SELECTOR-92"},
{"󠅌","VARIATION SELECTOR-93"},
{"󠅍","VARIATION SELECTOR-94"},
{"󠅎","VARIATION SELECTOR-95"},
{"󠅏","VARIATION SELECTOR-96"},
{"󠅐","VARIATION SELECTOR-97"},
{"󠅑","VARIATION SELECTOR-98"},
{"󠅒","VARIATION SELECTOR-99"},
{"󠅓","VARIATION SELECTOR-100"},
{"󠅔","VARIATION SELECTOR-101"},
{"󠅕","VARIATION SELECTOR-102"},
{"󠅖","VARIATION SELECTOR-103"},
{"󠅗","VARIATION SELECTOR-104"},
{"󠅘","VARIATION SELECTOR-105"},
{"󠅙","VARIATION SELECTOR-106"},
{"󠅚","VARIATION SELECTOR-107"},
{"󠅛","VARIATION SELECTOR-108"},
{"󠅜","VARIATION SELECTOR-109"},
{"󠅝","VARIATION SELECTOR-110"},
{"󠅞","VARIATION SELECTOR-111"},
{"󠅟","VARIATION SELECTOR-112"},
{"󠅠","VARIATION SELECTOR-113"},
{"󠅡","VARIATION SELECTOR-114"},
{"󠅢","VARIATION SELECTOR-115"},
{"󠅣","VARIATION SELECTOR-116"},
{"󠅤","VARIATION SELECTOR-117"},
{"󠅥","VARIATION SELECTOR-118"},
{"󠅦","VARIATION SELECTOR-119"},
{"󠅧","VARIATION SELECTOR-120"},
{"󠅨","VARIATION SELECTOR-121"},
{"󠅩","VARIATION SELECTOR-122"},
{"󠅪","VARIATION SELECTOR-123"},
{"󠅫","VARIATION SELECTOR-124"},
{"󠅬","VARIATION SELECTOR-125"},
{"󠅭","VARIATION SELECTOR-126"},
{"󠅮","VARIATION SELECTOR-127"},
{"󠅯","VARIATION SELECTOR-128"},
{"󠅰","VARIATION SELECTOR-129"},
{"󠅱","VARIATION SELECTOR-130"},
{"󠅲","VARIATION SELECTOR-131"},
{"󠅳","VARIATION SELECTOR-132"},
{"󠅴","VARIATION SELECTOR-133"},
{"󠅵","VARIATION SELECTOR-134"},
{"󠅶","VARIATION SELECTOR-135"},
{"󠅷","VARIATION SELECTOR-136"},
{"󠅸","VARIATION SELECTOR-137"},
{"󠅹","VARIATION SELECTOR-138"},
{"󠅺","VARIATION SELECTOR-139"},
{"󠅻","VARIATION SELECTOR-140"},
{"󠅼","VARIATION SELECTOR-141"},
{"󠅽","VARIATION SELECTOR-142"},
{"󠅾","VARIATION SELECTOR-143"},
{"󠅿","VARIATION SELECTOR-144"},
{"󠆀","VARIATION SELECTOR-145"},
{"󠆁","VARIATION SELECTOR-146"},
{"󠆂","VARIATION SELECTOR-147"},
{"󠆃","VARIATION SELECTOR-148"},
{"󠆄","VARIATION SELECTOR-149"},
{"󠆅","VARIATION SELECTOR-150"},
{"󠆆","VARIATION SELECTOR-151"},
{"󠆇","VARIATION SELECTOR-152"},
{"󠆈","VARIATION SELECTOR-153"},
{"󠆉","VARIATION SELECTOR-154"},
{"󠆊","VARIATION SELECTOR-155"},
{"󠆋","VARIATION SELECTOR-156"},
{"󠆌","VARIATION SELECTOR-157"},
{"󠆍","VARIATION SELECTOR-158"},
{"󠆎","VARIATION SELECTOR-159"},
{"󠆏","VARIATION SELECTOR-160"},
{"󠆐","VARIATION SELECTOR-161"},
{"󠆑","VARIATION SELECTOR-162"},
{"󠆒","VARIATION SELECTOR-163"},
{"󠆓","VARIATION SELECTOR-164"},
{"󠆔","VARIATION SELECTOR-165"},
{"󠆕","VARIATION SELECTOR-166"},
{"󠆖","VARIATION SELECTOR-167"},
{"󠆗","VARIATION SELECTOR-168"},
{"󠆘","VARIATION SELECTOR-169"},
{"󠆙","VARIATION SELECTOR-170"},
{"󠆚","VARIATION SELECTOR-171"},
{"󠆛","VARIATION SELECTOR-172"},
{"󠆜","VARIATION SELECTOR-173"},
{"󠆝","VARIATION SELECTOR-174"},
{"󠆞","VARIATION SELECTOR-175"},
{"󠆟","VARIATION SELECTOR-176"},
{"󠆠","VARIATION SELECTOR-177"},
{"󠆡","VARIATION SELECTOR-178"},
{"󠆢","VARIATION SELECTOR-179"},
{"󠆣","VARIATION SELECTOR-180"},
{"󠆤","VARIATION SELECTOR-181"},
{"󠆥","VARIATION SELECTOR-182"},
{"󠆦","VARIATION SELECTOR-183"},
{"󠆧","VARIATION SELECTOR-184"},
{"󠆨","VARIATION SELECTOR-185"},
{"󠆩","VARIATION SELECTOR-186"},
{"󠆪","VARIATION SELECTOR-187"},
{"󠆫","VARIATION SELECTOR-188"},
{"󠆬","VARIATION SELECTOR-189"},
{"󠆭","VARIATION SELECTOR-190"},
{"󠆮","VARIATION SELECTOR-191"},
{"󠆯","VARIATION SELECTOR-192"},
{"󠆰","VARIATION SELECTOR-193"},
{"󠆱","VARIATION SELECTOR-194"},
{"󠆲","VARIATION SELECTOR-195"},
{"󠆳","VARIATION SELECTOR-196"},
{"󠆴","VARIATION SELECTOR-197"},
{"󠆵","VARIATION SELECTOR-198"},
{"󠆶","VARIATION SELECTOR-199"},
{"󠆷","VARIATION SELECTOR-200"},
{"󠆸","VARIATION SELECTOR-201"},
{"󠆹","VARIATION SELECTOR-202"},
{"󠆺","VARIATION SELECTOR-203"},
{"󠆻","VARIATION SELECTOR-204"},
{"󠆼","VARIATION SELECTOR-205"},
{"󠆽","VARIATION SELECTOR-206"},
{"󠆾","VARIATION SELECTOR-207"},
{"󠆿","VARIATION SELECTOR-208"},
{"󠇀","VARIATION SELECTOR-209"},
{"󠇁","VARIATION SELECTOR-210"},
{"󠇂","VARIATION SELECTOR-211"},
{"󠇃","VARIATION SELECTOR-212"},
{"󠇄","VARIATION SELECTOR-213"},
{"󠇅","VARIATION SELECTOR-214"},
{"󠇆","VARIATION SELECTOR-215"},
{"󠇇","VARIATION SELECTOR-216"},
{"󠇈","VARIATION SELECTOR-217"},
{"󠇉","VARIATION SELECTOR-218"},
{"󠇊","VARIATION SELECTOR-219"},
{"󠇋","VARIATION SELECTOR-220"},
{"󠇌","VARIATION SELECTOR-221"},
{"󠇍","VARIATION SELECTOR-222"},
{"󠇎","VARIATION SELECTOR-223"},
{"󠇏","VARIATION SELECTOR-224"},
{"󠇐","VARIATION SELECTOR-225"},
{"󠇑","VARIATION SELECTOR-226"},
{"󠇒","VARIATION SELECTOR-227"},
{"󠇓","VARIATION SELECTOR-228"},
{"󠇔","VARIATION SELECTOR-229"},
{"󠇕","VARIATION SELECTOR-230"},
{"󠇖","VARIATION SELECTOR-231"},
{"󠇗","VARIATION SELECTOR-232"},
{"󠇘","VARIATION SELECTOR-233"},
{"󠇙","VARIATION SELECTOR-234"},
{"󠇚","VARIATION SELECTOR-235"},
{"󠇛","VARIATION SELECTOR-236"},
{"󠇜","VARIATION SELECTOR-237"},
{"󠇝","VARIATION SELECTOR-238"},
{"󠇞","VARIATION SELECTOR-239"},
{"󠇟","VARIATION SELECTOR-240"},
{"󠇠","VARIATION SELECTOR-241"},
{"󠇡","VARIATION SELECTOR-242"},
{"󠇢","VARIATION SELECTOR-243"},
{"󠇣","VARIATION SELECTOR-244"},
{"󠇤","VARIATION SELECTOR-245"},
{"󠇥","VARIATION SELECTOR-246"},
{"󠇦","VARIATION SELECTOR-247"},
{"󠇧","VARIATION SELECTOR-248"},
{"󠇨","VARIATION SELECTOR-249"},
{"󠇩","VARIATION SELECTOR-250"},
{"󠇪","VARIATION SELECTOR-251"},
{"󠇫","VARIATION SELECTOR-252"},
{"󠇬","VARIATION SELECTOR-253"},
{"󠇭","VARIATION SELECTOR-254"},
{"󠇮","VARIATION SELECTOR-255"},
{"󠇯","VARIATION SELECTOR-256"},

  };
  public static String[][][] CATEGORIES = {
{{"Symbol"},
/*116,6*/ {"Alchemical Symbols@Other ","A2j1dA"},
/*589,116*/ {"Arrows","%=68k11I3706:%M%G7AnTMm6e6HDk%`O728F1f4V1PNF2WF1G}58?]514M]Ol1%2l2%1#1GsGV1f172otW06gQ01U:1Un2MH$|W}4$,ml3f1MW|L+%0M"},
/*256,6*/ {"Braille",";oA0FN"},
/*3,6*/ {"Common Indic Number Forms@Other ","wgi068"},
/*39,6*/ {"Control Pictures","(j90d3"},
/*53,50*/ {"Currency","H3XBMQQ10HB(2106uPM]N:qol202S20#2;.Z0^xM0:91E]J6O6"},
/*613,223*/ {"Emoji",";O906vIMOG%I9UGOun294v1O%1916$6n16]1]1u68WGWGGUGG88:48WE891X4EH2f@695^O1091vs8g0U1nE6916P1G,P9692:1G!]16HH]26G68#18M8-3W#191-1$s888]1M8|f2EG68Gt18#188738cGt58sGt4G8U868Mmm?8EeF1GM$Mv1|fE@18E8U8E8@2W?X4GE88GG8E8886u868kWOGc8"},
/*80,6*/ {"Emoticons@Other ",";(i1F7"},
/*272,42*/ {"Game Pieces","Q6A06f5#1H2,]4MeEY[W1@3W}891N1GN18N18N3P#k"},
/*14,7*/ {"Gender and Genealogical","2JA0sOc"},
/*434,65*/ {"Geometric Shapes","oG90nMcPTFNfFEQE10t2v2EO71%26f1cGsH26O|8sX2M;>t0%E6OW6^<$0sW6Xq#5"},
/*63,30*/ {"Keyboard and UI","Qz80XqUGv771.Uv46%7Y^Y1F2mc]1M"},
/*2,4*/ {"Latin 1 Supplement@Other Punctuation","9FP1"},
/*1182,227*/ {"Math","wug1M8V2868G8,8M88mW888E868G8888868GM8k8M8M88,8d1eE8U8d1++g1f1E:2v2894WX3:2v+]lEQ?60f2E11OH1P1M]1U11U]571WO6WUv3f111MuUmH6Ue6WGGu:26G8:2NO$M:16H8%2V28H211cvg.]4s9AnU#5PNdkX4-1Gc24P1P2:2P2:2P2:2P2:2P2QB606bf$0:;c8%Ef1Ev28v28]BmM"},
/*1052,127*/ {"Math Alphanumeric","w010EGX26G6gy70bm806e2Y806Gce?]Au,8OUmOO68E86uMeU^`Q1t78V686GG6GM8|88k8-58MGs8k8d28M8U8Ok8-UGF28F28#28F28#28F28#28F28#28F28sGd4"},
/*470,200*/ {"Miscellaneous","w=B0rzB0GW8Y040Mg%50EHB686WU8l1$Uv4?8En1E8|:29168U8718k8kG8M868M8686e686888,v2M118MO8|8E]7(V10c2tN1cYf8068n2EG6G:1W]3M:1Mm6X3888-1W91,e|O6G86%1:18H3m6%5$6%468eGWc8c11126v1V191t28t38#7X29DuM8E86m8ULN%0"},
/*568,29*/ {"Musical",";DA0k2mO1NM[d3GVH92N6g-80c92s"},
/*2,5*/ {"Number Forms@Other ","g=806"},
/*48,6*/ {"Ornamental Dingbats@Other ","A;i1N4"},
/*82,28*/ {"Stars/Asterisks",";OA0v5l2W,g510E^jW1WV1:lvx-1"},
/*29,13*/ {"Subscript","Qq80N1871QC30"},
/*35,41*/ {"Superscript","XFX1x6e1oUg2701+6G|nE8I0302QW069JPC6^A}06"},
/*14,10*/ {"Supplemental Arrows C@Other ","gcj1sWM916"},
/*15,10*/ {"Supplemental Symbols And Pictographs@Other ","Aoj1!X9UX5"},
/*200,26*/ {"Technical","gM90-2G6$l7H1!%2N2O?mF2P6?"},
/*4,5*/ {"Tibetan@Other ","YG40M"},
/*98,12*/ {"Transport And Map Symbols@Other ","g?i1N7X171OM"},
/*10,9*/ {"Vedic Extensions@Other Letter","(u70M8MO6"},
/*79,26*/ {"Weather and Astrological","Q4A0F1mv3}1v8,uUe^zX171:1|"},
/*165,20*/ {"Yijing / Tai Xuan Jing","w8A0sf7c2WA0#5A>E1-7"},
/*158,16*/ {"Compatibility","^dh1#28F5m-3:6N2"},
/*67,14*/ {"Historic","I{)0%4!P7|%4}3"},
/*60,18*/ {"Compatibility","(PD0M(ZU16H1-3e!u6"},
},
{{"Punctuation"},
/*20,22*/ {"ASCII Based","]2E8EG886[6O6f2H6eP16u"},
/*17,28*/ {"Dash/Connector","14f4gX80c%36%1gu30:26W;2t0XG"},
/*47,39*/ {"Other","(s70:<.MO$EGGG8OEms88Iu3068G6n1!GM8(iW0"},
/*139,93*/ {"Paired","n36f48v2894X1;P80sP26[6]46P16nvMPF6f3c1^F1H76:2,va@1%5M]26;7106G,H2Hf,Gs2Ms06nPcXF6f48v288686"},
/*50,23*/ {"Historic","gm808kQT30MnN72v1?(%t0E"},
/*105,63*/ {"Compatibility","Ig80e91E91686W8$EH1X36P162pw0,12-1G|8F18W86nDE8c8M[6O6X2E8f2886"},
},
{{"Number"},
/*500,166*/ {"Decimal","P4,]A6egh10,HC,1I,fb,%A,%A,%A,%A,%A,%A,%A,%A,%A,%8,%A,X6,PP,X6,Q]10,f3,PR,vB,9F,m,nG,]K,m,A710Ocm,^SZ0,vz,f3,1I,12,:7,]a,w{L0,oo40,vB,f5,9D,PP,%g,1Y,P9,P9,Xc,;lL0,]K,"},
/*198,37*/ {"Enclosed/Dotted","gs90#7%4@1Pvt2g+20,%2s8N1]2,n3N1g2U16"},
/*40,20*/ {"Fractions/Related","9G6eGEoX80Ocm,1IV1%3"},
/*427,153*/ {"Other","ot20cHYc]AE9Ck]Lcvd,^910#1oF10,vh2}1073GMQ:30P2!P1EHVMI2V0,9TcA|N0V2(a10sP2kn3!:6U9H6GV1G74XB6%2E:6Uf9sH2s%3k1Uc1W#2fg#1fY#1wY1069d!;+L0kIiR0l1gu50!oE20?"},
/*271,60*/ {"Historic","o560EgM10,Yk10EGMo230w6u0}39175n16%aMv2$HCUXI,^E10cnQso,60}9"},
/*60,24*/ {"Compatibility","w.80-2o?30EHVM2Us0,w{#0?"},
},
{{"Format & Whitespace"},
/*140,53*/ {"Format","vF;Z10c12o%40;920UX2Uf4U8M2n#0Iej0MQi50sY)W9l8bk0AvME"},
/*262,22*/ {"Variation Selector","]=oY506%7E^$zA#LDF1AV1"},
/*18,25*/ {"Whitespace","^a)05Y)0nBQQ80,n26eP4wB40"},
/*7,23*/ {"Historic","w-10f4^#206IV10(970ols0"},
/*16,19*/ {"Compatibility","fEAQ80?P3P4wB40^@s0"},
},
{{"Modifier"},
/*8,11*/ {"Enclosing","Q670Ys10M8E"},
/*225,67*/ {"Nonspacing","%+#5GG,8t1QE60F1HmE8718kWmO6XI,P2N1m6v%71WO|A(x0Yss0En1sGk%2MT_t0F1"},
/*132,54*/ {"Spacing","f!!.M%3M91gz30(C30f1695E8?8l18d2X4N32D40XH2zW0]ZUo@|0U"},
/*47,22*/ {"Historic","%?71HP62x60M[F2926^Py0"},
/*4,5*/ {"Compatibility","n<686"},
},
{{"Latin"},
/*403,153*/ {"Common",":5N2mN2P6}18#28V1G,GcGcGcGMW68cGs8MGcGMGMGsGd1GWG6OU8GEOG6H168E11M.s$$6f16%2MG6P3P168688uW.128$IN706126f16m6W6:16m6$6P16Gc916[878QAa06zph0696UG6OX2.o2706"},
/*89,16*/ {"Enclosed","Q!90t4Y#X1M8-2:5"},
/*105,257*/ {"Flipped/Mirrored","]r=i1jKjnjQq40L!401GCpwGi0Trh04pM83:liJK1qQMnmaJQE10jm10(;50Lj50wX50{W50A1i0TJd0bB506(T40v]a8zE50I0105010IUi0{Zh0:7=w*Uc:V%Dih:h`h9X%B41n1WSL1Qau9q`jh_Bnm4lPm*mHn6amfmSmH6;+80j630Lj50wX50{W50QW80P1T#806f=^Y40(d30gtZ0bUi06AL10D9102g70+M70(#80+q80P3*jA#80{z80"},
/*729,223*/ {"Other","]N6[6m6m6m6m6G]16m6W6W6$6v186O6G6m86OE86GUGGEGOEv2s8sG!OEOt2$F38?A570@3%5718}2H9|G@1GV1GcGMG#1GcGsGF1G6m|GcXyf2o]20}1u62cW0F1v6N1e@2Gs%5Gv;-3eUDKj081s868EG?8E8EGcu8E8UGEw^60t5H193N3v!H1f171X9O11G6e6O88m11X186IWZ072f9E]96%?M"},
/*183,87*/ {"Phonetics (IPA)","%8N2%96$uH4H3u:9M%CF28718M868UO?86G68E8868GHOeP1SPE8GW11OO6918Of26868886OV3WU%2Wg|70EO6"},
/*24,20*/ {"Phonetics (X-IPA)","1uH1WGeE11G6GO8G868s"},
/*148,53*/ {"Historic","HZ6uP268691s15P361Jd1oQ7068H8cHw!Y?20kAZW0sH26P1l6:BU"},
/*358,91*/ {"Compatibility","HF8WWO8:A6116v5H6!P3E%KcgT706vtM8E8?86GUGE8O8M8E86W8.U12-2X.}6;l30HBMvE,et8:2Qtq0kg710N2mN2"},
},
{{"Other European Scripts"},
/*303,20*/ {"Cyrillic","2510#B$}E`uHfWE;1(06"},
/*277,79*/ {"Greek","P]m8E88#18@3P3$wC70@1GcGV3GcGs8888l1888888O#48U8eE8E88OEOUeE8k8eE8E88Y=a0bai06W"},
/*53,8*/ {"Historic - Caucasian Albanian","g6+0t411"},
/*130,17*/ {"Historic - Cyrillic","^G106g^A0-2o,V0t8"},
/*143,15*/ {"Historic - Duployan","2bT1t9e71O!u,GM"},
/*40,6*/ {"Historic - Elbasan","A2+0l3"},
/*94,9*/ {"Historic - Glagolitic","^tB0F48F4"},
/*27,6*/ {"Historic - Gothic","^l*0V2"},
/*183,34*/ {"Historic - Greek","]@MG6OEX7EO71f18GU8E;{(0@6%1Y9t0N6"},
/*341,11*/ {"Historic - Linear A","YP+0FS.@1[s"},
/*211,23*/ {"Historic - Linear B","(z)0|8N28t1868N1GF1937B"},
/*29,6*/ {"Historic - Ogham","o_50l2"},
/*108,12*/ {"Historic - Old Hungarian","w0-0l4H1l4uc"},
/*36,6*/ {"Historic - Old Italic","oh*0F3"},
/*43,6*/ {"Historic - Old Permic",";o*0-3"},
/*89,6*/ {"Historic - Runic","g|50}7"},
/*48,6*/ {"Historic - Shavian","A;*0N4"},
/*44,46*/ {"Compatibility - Greek","XG%$e68%6Ef26OoN70888888n58Uu88EOu8EOu8E.886:Q"},
},
{{"American Scripts"},
/*710,20*/ {"Canadian Aboriginal","gP50NuGd1]oN6TR10Xu6"},
/*172,14*/ {"Historic - Cherokee","wG50#7Gco4e0F7"},
/*80,6*/ {"Historic - Deseret",";(*0F7"},
/*672,12*/ {"Historic - SignWriting","w.a1FxX1U8N1"},
},
{{"African Scripts"},
/*495,87*/ {"Ethiopic",";(40l68MGk88MGt38MG@28MGk88MGN18758MG}5X3V1w<60}1.k8k8k8k8k8k8k8kI8X0cGcGc.k8kDDe0-2%1,"},
/*59,10*/ {"Tifinagh","o_B0}4u6P1"},
/*657,12*/ {"Historic - Bamum","(5i0@7Y4p0tp"},
/*36,8*/ {"Historic - Bassa Vah","o_71t2Gc"},
/*137,14*/ {"Historic - Coptic","Q210F12$A0dAek"},
/*1071,8*/ {"Historic - Egyptian Hieroglyphs",";Y[0}}N9"},
/*213,9*/ {"Historic - Mende Kikakui","25f1-HGV1"},
/*90,12*/ {"Historic - Meroitic Cursive","(L,072W#1G74"},
/*32,6*/ {"Historic - Meroitic Hieroglyphs",";I,0-2"},
/*59,6*/ {"Historic - Nko","Q420N5"},
/*40,8*/ {"Historic - Osmanya","g?*0t2G,"},
/*300,6*/ {"Historic - Vai","^th0FR"},
},
{{"Middle Eastern Scripts"},
/*357,84*/ {"Arabic","gs10V2m,f368W-18F68H26[EGP774XQ-1A}$05!%0U8N1mG6]2[73G19f2,O61il2^A+0#2YVx06{S$0V1]p"},
/*88,17*/ {"Armenian","(W10V3[V344k%36GE"},
/*44,20*/ {"Georgian","Yc40eG@2mMGEz230Y230"},
/*53,19*/ {"Hebrew","Il10V2eE`5#1P46o:$0"},
/*583,6*/ {"Historic - Anatolian Hieroglyphs","Qy{0@q"},
/*39,22*/ {"Historic - Arabic","gr10c]2UH46%2f6k8V19D6"},
/*49,6*/ {"Historic - Carian",";Y*0V4"},
/*1234,16*/ {"Historic - Cuneiform","gE=0#_P9}98U11#H"},
/*55,13*/ {"Historic - Cypriot","^-+0cG8@386OG"},
/*85,18*/ {"Historic - Georgian",";Y40V3]3cW2a70V38e"},
/*26,10*/ {"Historic - Hatran","Q4,0t186eU"},
/*45,16*/ {"Historic - Hebrew","gf10#2:1M;>$0!f3"},
/*29,6*/ {"Historic - Lycian","^V*0l2"},
/*27,7*/ {"Historic - Lydian","AA,0N2e"},
/*40,8*/ {"Historic - Nabataean","o_+0#2$!"},
/*32,6*/ {"Historic - Old North Arabian","Ag,0-2"},
/*32,6*/ {"Historic - Old South Arabian","Id,0-2"},
/*32,6*/ {"Historic - Palmyrene","w[+0-2"},
/*29,7*/ {"Historic - Phoenician","I7,0d2O"},
/*61,9*/ {"Historic - Samaritan","AA2074GN1"},
/*93,22*/ {"Historic - Syriac","wq10P1O]2[?X21DF18V5GE"},
/*31,7*/ {"Historic - Ugaritic","It*0t28"},
/*876,89*/ {"Compatibility - Arabic","I!10MA($0-813@Wv1#5G-4v371fAE88FCgI#0M8V2868G8,8M88mW888E868G8888868GM8k8M8M88,8d1eE8U8d1"},
/*6,9*/ {"Compatibility - Armenian","oe10g^$0U"},
/*35,17*/ {"Compatibility - Hebrew","2a(08.F18U886868!"},
},
{{"South Asian Scripts"},
/*94,49*/ {"Bengali","2j20WsG6G@18k8OMOf1n16P16%+6y^6f2E958kG6GE.[6G,G,"},
/*152,51*/ {"Devanagari","(X20-4Ov1X16f1F19[6gMf0cO8TRg0M]4E8l18k[V1YEg0l1mE8"},
/*87,43*/ {"Gujarati","(*20!8E8@18k868UOv1X1692%j6*uE958s8E8E:16G|"},
/*77,43*/ {"Gurmukhi","Av20cW6G@18k8GG693]1E:v6y^69EE958UW6GEO:1|O"},
/*86,39*/ {"Kannada","QR30s8E8}18,8UO936X16KAE958k8E8Mu6116G,"},
/*102,39*/ {"Malayalam","Ab306v1s8E8t3Gf1f1EH2caBEP5k8E8M.[6GV1O"},
/*92,47*/ {"Oriya","Y[20sG6G@18k868UO13EX1:Y6y^6XbE958kG6GE$6[6G?8c"},
/*110,34*/ {"Sinhala","oo30l1O728!8GkC66X6Wc88sm,GEA%*0#1"},
/*74,40*/ {"Tamil",";3308cOE8MO6886O6OEO|12HQ6aXX5UOE8M.P1-1"},
/*98,41*/ {"Telugu","wF30s8E8}18V1OX2Ee61D6`LMP5k8E8Mu6116G,$s"},
/*63,19*/ {"Thaana","g|10V311KcP1O:5,%S?"},
/*57,12*/ {"Historic - Ahom","2+:0N2ON1WV1"},
/*61,8*/ {"Historic - Avestan","(r,0-4Ok"},
/*109,11*/ {"Historic - Brahmi","A^-0}6Wt2X1"},
/*67,9*/ {"Historic - Chakma","YH.0#48F1"},
/*85,32*/ {"Historic - Grantha","^#.0M8sG6G@18k868UG!G6GEGmekGkOU"},
/*31,8*/ {"Historic - Imperial Aramaic","(>+0@18!"},
/*27,8*/ {"Historic - Inscriptional Pahlavi","g!,0t1es"},
/*30,8*/ {"Historic - Inscriptional Parthian","ox,0@1Gs"},
/*66,6*/ {"Historic - Kaithi","(5.0@5"},
/*1,4*/ {"Historic - Kannada","YZ30"},
/*65,20*/ {"Historic - Kharoshthi","gU,0M86es8E8V2WEW!$!"},
/*61,9*/ {"Historic - Khojki","we.0l18-3"},
/*69,8*/ {"Historic - Khudawadi","wu.0N5e,"},
/*74,11*/ {"Historic - Lepcha","oZ70}4ON1OE"},
/*68,13*/ {"Historic - Limbu","(r60#28|W|WO|"},
/*39,6*/ {"Historic - Mahajani","wO.0d3"},
/*29,7*/ {"Historic - Mandaic","^F20d2G"},
/*79,12*/ {"Historic - Meetei Mayek","wGj0}1PI74G,"},
/*79,9*/ {"Historic - Modi","(j:0F611,"},
/*43,10*/ {"Historic - Mro","g,71#28,W6"},
/*38,13*/ {"Historic - Multani","Qq.0k88M8N18?"},
/*48,6*/ {"Historic - Ol Chiki",";g70N4"},
/*50,9*/ {"Historic - Old Persian","Aw*0F3WF1"},
/*81,8*/ {"Historic - Saurashtra","Yni0F6.|"},
/*94,9*/ {"Historic - Sharada","2T.0}6GV1"},
/*92,9*/ {"Historic - Siddham","AY:0-4GV3"},
/*35,8*/ {"Historic - Sora Sompeng","2D.0F2u,"},
/*44,6*/ {"Historic - Syloti Nagri","(bi0@3"},
/*66,8*/ {"Historic - Takri","Yv:0}4$,"},
/*82,8*/ {"Historic - Tirhuta",";A:0d6$,"},
/*84,8*/ {"Historic - Warang Citi",";I;0d791"},
/*3,6*/ {"Compatibility - Bengali","Yr2068"},
/*8,5*/ {"Compatibility - Devanagari","Yf20s"},
/*6,9*/ {"Compatibility - Gurmukhi","Qz20G93EG"},
/*2,5*/ {"Compatibility - Oriya","Q0306"},
},
{{"Southeast Asian Scripts"},
/*141,26*/ {"Khmer",";I6073GE8?v3q3l28,W,m,Hi-2"},
/*67,41*/ {"Lao","g:3068G68GmM8k8E88G68M86.GU92MC4Gc86.8cG,"},
/*223,79*/ {"Myanmar","QK40-3:1f1cWMOO6uEW7191Ame0UG![U:8V18cOO6r-e0#18V1mMWE8EGkOMH1|8d12le06.,%AmE8E"},
/*86,19*/ {"Thai",";z30N48691c*1Gk11@1"},
/*121,9*/ {"Historic - Balinese","QC70-6W}3"},
/*56,8*/ {"Historic - Batak","(T70t4$M"},
/*30,8*/ {"Historic - Buginese","2>60d2G6"},
/*22,8*/ {"Historic - Buhid","2C606.#1"},
/*83,13*/ {"Historic - Cham","Q`i0@4.F1G,GM"},
/*23,6*/ {"Historic - Hanunoo","AA60}1"},
/*90,10*/ {"Historic - Javanese","w.i0}6G,W6"},
/*47,7*/ {"Historic - Kayah Li","2zi0748"},
/*3,8*/ {"Historic - Khmer","gM60v311"},
/*127,16*/ {"Historic - Pahawh Hmong","^}71N6[,8k8-1et1"},
/*57,6*/ {"Historic - Pau Cin Hau","Q*;075"},
/*37,8*/ {"Historic - Rejang","Y%i0F311"},
/*72,9*/ {"Historic - Sundanese","^N70#5PNs"},
/*22,11*/ {"Historic - Tagalog","I760718k]26"},
/*20,13*/ {"Historic - Tagbanwa","2C606%3718E86"},
/*127,16*/ {"Historic - Tai Tham","^@60t58l2G?m,mF1"},
/*72,9*/ {"Historic - Tai Viet","^7j0}5H2U"},
},
{{"Hangul"},
/*112,38*/ {"Other","ozC0:42Pi0}1WV4Lbi0MO,8F1H1EmeEPqQ?r06"},
/*1176,8*/ {"ᄀ HANGUL CHOSEONG KIYEOK",";gj0}}-I"},
/*588,6*/ {"ᄂ HANGUL CHOSEONG NIEUN","(zk0Vr"},
/*1180,13*/ {"ᄃ HANGUL CHOSEONG TIKEUT","(+i0MAj20}}-I"},
/*599,11*/ {"ᄅ HANGUL CHOSEONG RIEUL","A,i0?2#30Vr"},
/*591,11*/ {"ᄆ HANGUL CHOSEONG MIEUM","A-i0EIS40Vr"},
/*1179,13*/ {"ᄇ HANGUL CHOSEONG PIEUP","Y-i0EY]40}}-I"},
/*1177,12*/ {"ᄉ HANGUL CHOSEONG SIOS","w-i0IC60}}-I"},
/*590,11*/ {"ᄋ HANGUL CHOSEONG IEUNG","(-i06^U70Vr"},
/*1177,12*/ {"ᄌ HANGUL CHOSEONG CIEUC","^-i0Q`70}}-I"},
/*588,6*/ {"ᄎ HANGUL CHOSEONG CHIEUCH","I}r0Vr"},
/*588,6*/ {"ᄏ HANGUL CHOSEONG KHIEUKH","wqs0Vr"},
/*589,10*/ {"ᄐ HANGUL CHOSEONG THIEUTH","2.i02YA0Vr"},
/*589,10*/ {"ᄑ HANGUL CHOSEONG PHIEUPH","A.i0Y}A0Vr"},
/*589,10*/ {"ᄒ HANGUL CHOSEONG HIEUH","I.i0(qB0Vr"},
/*1,4*/ {"ᅙ HANGUL CHOSEONG YEORINHIEUH","Q.i0"},
/*350,12*/ {"Historic","oh40FN^L80d8"},
/*118,27*/ {"Compatibility","oJD0#2]5#2IGs0MX5#2OcGcGcGE"},
},
{{"Other East Asian Scripts"},
/*111,40*/ {"Bopomofo","ozC0:4HIt3XAV2bXC06I]B0MO,8F1.MGmeEwgs06"},
/*142,49*/ {"Hiragana","ozC0:4W#7AZD1zmD1MOF2X1c8eE986G68H86XD6^Bs061R946"},
/*162,52*/ {"Katakana","ozC0:49978PMV1I2D1rmD1MOF2X1c8eE986eH8MHD6^Bs061R946"},
/*133,14*/ {"Miao","2591F611F4f1d1"},
/*156,23*/ {"Mongolian","YX60738t4$t38aFN18,%3H9"},
/*207,70*/ {"Tibetan","2{30%5E8M8M8M8M8M8|8Ef2UqC?8l4f468ek8cec8M8M8M8M8M8|8E8N18kW6Ii806e,Gs"},
/*1240,30*/ {"Yi","oRg0-18}}-FL.U06e,Gs^rT0IG10@4"},
/*48,6*/ {"Historic - Lisu","oph0N4"},
/*51,8*/ {"Historic - Manichaean","^l,0d3W|"},
/*83,13*/ {"Historic - New Tai Lue","Y%60@3WN2m?O6"},
/*73,6*/ {"Historic - Old Turkic","2>,0l6"},
/*83,26*/ {"Historic - Phags Pa","wU6068AU606e,Gs2*V0}4w|M0M"},
/*29,11*/ {"Historic - Psalter Pahlavi","Y%,0l1uM91k"},
/*35,8*/ {"Historic - Tai Le","2z60t2GU"},
/*4,5*/ {"Compatibility - Bopomofo","Ql)0M"},
/*24,21*/ {"Compatibility - Hiragana","^%C0996G1MF1gas0U2E$0"},
/*213,29*/ {"Compatibility - Katakana","^%C0996]8PDF1vRF48@7g`r0N18}3"},
/*22,30*/ {"Compatibility - Tibetan","A|30]4.WWW91.868$n1.WWW91YX#0M"},
/*4,5*/ {"Compatibility - Yi","Ql)0M"},
},
{{"Han - Other"},
/*149,15*/ {"CJK Strokes","AQC0N28M8d7H%F3"},
/*12,5*/ {"Ideographic Description","oxC0|"},
/*21003,66*/ {"Other","AzC0d18V2GmOUY=70}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}du({O06"},
/*1383,65*/ {"Compatibility","^SC0n791VJ]8E9iF3f5V4X1|%CF2[U%8#2;8q0dOG8G,88G6O76Gl9YH10Modj1Fn"},
/*59438,155*/ {"Less Common","A(D0}}}}}}}}}}}}N,^oj06886[886GEwL+0}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}#A%3}}}}}}}}7P117KG}}}}}}}}}}#_"},
},
{{"TODO"},
/*29,40*/ {"Missing","A-80A4R1f6G686G6W918u]5W6$un2We8Eu]U6nQ6"},
},

  };
}
