/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test;

import com.ibm.icu.dev.test.TestLog;
import com.ibm.icu.util.VersionInfo;
import java.util.Date;
import java.util.GregorianCalendar;

public abstract class AbstractTestLog
implements TestLog {
    public static boolean isICUVersionBefore(int major, int minor) {
        return AbstractTestLog.isICUVersionBefore(major, minor, 0);
    }

    public static boolean isICUVersionBefore(int major, int minor, int milli) {
        return VersionInfo.ICU_VERSION.compareTo(VersionInfo.getInstance((int)major, (int)minor, (int)milli)) < 0;
    }

    public static boolean isICUVersionAtLeast(int major, int minor) {
        return AbstractTestLog.isICUVersionAtLeast(major, minor, 0);
    }

    public static boolean isICUVersionAtLeast(int major, int minor, int milli) {
        return !AbstractTestLog.isICUVersionBefore(major, minor, milli);
    }

    @Override
    public final void log(String message) {
        this.msg(message, 0, true, false);
    }

    @Override
    public final void logln(String message) {
        this.msg(message, 0, true, true);
    }

    @Override
    public final void err(String message) {
        this.msg(message, 2, true, false);
    }

    @Override
    public final void errln(String message) {
        this.msg(message, 2, true, true);
    }

    @Override
    public final void warn(String message) {
        this.msg(message, 1, true, false);
    }

    @Override
    public final void warnln(String message) {
        this.msg(message, 1, true, true);
    }

    @Override
    public abstract void msg(String var1, int var2, boolean var3, boolean var4);

    public boolean isDateAtLeast(int year, int month, int day) {
        Date now = new Date();
        GregorianCalendar c = new GregorianCalendar(year, month, day);
        Date dt = c.getTime();
        return now.compareTo(dt) >= 0;
    }

    public static final class DelegatingLog
    extends AbstractTestLog {
        private TestLog delegate;

        public DelegatingLog(TestLog delegate) {
            this.delegate = delegate;
        }

        @Override
        public void msg(String message, int level, boolean incCount, boolean newln) {
            if (this.delegate != null) {
                this.delegate.msg(message, level, incCount, newln);
            }
        }
    }
}

