/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test;

import com.ibm.icu.dev.test.AbstractTestLog;
import com.ibm.icu.dev.test.TestLogWriter;
import com.ibm.icu.dev.test.TestUtil;
import com.ibm.icu.dev.test.UTF16Util;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.TreeMap;

public class TestFmwk
extends AbstractTestLog {
    private static final TimeZone defaultTimeZone = TimeZone.getTimeZone((String)"America/Los_Angeles");
    private static final Locale defaultLocale = Locale.US;
    static final String ICU_TRAC_URL = "http://bugs.icu-project.org/trac/ticket/";
    static final String CLDR_TRAC_URL = "http://unicode.org/cldr/trac/ticket/";
    static final String CLDR_TICKET_PREFIX = "cldrbug:";
    private static GregorianCalendar cal;
    protected TestParams params = null;
    private static final String spaces = "                                          ";

    protected void handleException(Throwable e) {
        Throwable ex = e.getCause();
        if (ex == null) {
            ex = e;
        }
        if (ex instanceof OutOfMemoryError) {
            throw new RuntimeException(ex);
        }
        if (ex instanceof ICUTestError) {
            return;
        }
        if (ex instanceof ExceptionInInitializerError) {
            ex = ((ExceptionInInitializerError)ex).getException();
        }
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(caw);
        ex.printStackTrace(pw);
        pw.close();
        String msg = caw.toString();
        if (ex instanceof MissingResourceException || ex instanceof NoClassDefFoundError || msg.indexOf("java.util.MissingResourceException") >= 0) {
            if (this.params.warnings || this.params.nodata) {
                this.warnln(ex.toString() + '\n' + msg);
            } else {
                this.errln(ex.toString() + '\n' + msg);
            }
        } else {
            this.errln(ex.toString() + '\n' + msg);
        }
    }

    protected Random createRandom() {
        return new Random(this.params.seed);
    }

    protected TestFmwk() {
    }

    protected void init() throws Exception {
    }

    public void run(String[] args) {
        System.exit(this.run(args, new PrintWriter(System.out)));
    }

    public int run(String[] args, PrintWriter log) {
        boolean prompt = false;
        int wx = 0;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-p") || arg.equals("-prompt")) {
                prompt = true;
                continue;
            }
            if (wx < i) {
                args[wx] = arg;
            }
            ++wx;
        }
        while (wx < args.length) {
            args[wx++] = null;
        }
        TestParams localParams = TestParams.create(args, log);
        if (localParams == null) {
            return -1;
        }
        int errorCount = this.runTests(localParams, args);
        if (localParams.seed != 0L) {
            localParams.log.println("-random:" + localParams.seed);
            localParams.log.flush();
        }
        if (localParams.timeLog != null && localParams.timeLog.length() > 0) {
            localParams.log.println("\nTest cases taking excessive time (>" + localParams.maxTargetSec + "s):");
            localParams.log.println(localParams.timeLog.toString());
        }
        if (localParams.knownIssues != null) {
            localParams.log.println("\nKnown Issues:");
            for (Map.Entry entry : localParams.knownIssues.entrySet()) {
                String ticketLink = (String)entry.getKey();
                localParams.log.println("[" + ticketLink + "]");
                for (String line : (List)entry.getValue()) {
                    localParams.log.println("  - " + line);
                }
            }
        }
        if (localParams.errorSummary != null && localParams.errorSummary.length() > 0) {
            localParams.log.println("\nError summary:");
            localParams.log.println(localParams.errorSummary.toString());
        }
        if (errorCount > 0) {
            localParams.log.println("\n<< " + errorCount + " TEST(S) FAILED >>");
        } else {
            localParams.log.println("\n<< ALL TESTS PASSED >>");
        }
        if (prompt) {
            System.out.println("Hit RETURN to exit...");
            System.out.flush();
            try {
                System.in.read();
            }
            catch (IOException e) {
                localParams.log.println("Exception: " + e.toString() + e.getMessage());
            }
        }
        localParams.log.flush();
        return errorCount;
    }

    public int runTests(TestParams _params, String[] tests) {
        int ec = 0;
        StringBuffer summary = null;
        try {
            if (tests.length == 0 || tests[0] == null) {
                _params.init();
                this.resolveTarget(_params).run();
                ec = _params.errorCount;
            } else {
                for (int i = 0; i < tests.length; ++i) {
                    if (tests[i] == null) continue;
                    if (i > 0) {
                        _params.log.println();
                    }
                    _params.init();
                    this.resolveTarget(_params, tests[i]).run();
                    ec += _params.errorCount;
                    if (_params.errorSummary == null || _params.errorSummary.length() <= 0) continue;
                    if (summary == null) {
                        summary = new StringBuffer();
                    }
                    summary.append("\nTest Root: " + tests[i] + "\n");
                    summary.append(_params.errorSummary());
                }
                _params.errorSummary = summary;
            }
        }
        catch (Exception e) {
            ++ec;
            _params.log.println("\nencountered a test failure, exiting\n" + e);
            e.printStackTrace(_params.log);
        }
        return ec;
    }

    public Target resolveTarget(TestParams paramsArg) {
        this.params = paramsArg;
        return new ClassTarget();
    }

    public Target resolveTarget(TestParams paramsArg, String targetPath) {
        TestFmwk test = this;
        test.params = paramsArg;
        if (targetPath != null) {
            if (targetPath.length() == 0) {
                targetPath = null;
            } else {
                int p = 0;
                int e = targetPath.length();
                while (targetPath.charAt(p) == '/') {
                    ++p;
                }
                while (e > p && targetPath.charAt(e - 1) == '/') {
                    --e;
                }
                if (p > 0 || e < targetPath.length()) {
                    targetPath = targetPath.substring(p, e - p);
                    p = 0;
                    e = targetPath.length();
                }
                try {
                    int n;
                    String prefix;
                    TestFmwk subtest;
                    while ((subtest = test.getSubtest(prefix = (n = targetPath.indexOf(47)) == -1 ? targetPath : targetPath.substring(0, n))) != null) {
                        test = subtest;
                        if (n == -1) {
                            targetPath = null;
                            break;
                        }
                        targetPath = targetPath.substring(n + 1);
                    }
                }
                catch (TestFmwkException ex) {
                    TestFmwk testFmwk = test;
                    testFmwk.getClass();
                    return testFmwk.new Target(targetPath);
                }
            }
        }
        TestFmwk testFmwk = test;
        testFmwk.getClass();
        return testFmwk.new ClassTarget(targetPath);
    }

    protected boolean validate() {
        return true;
    }

    protected Target getTargets(String targetName) {
        return this.getClassTargets(this.getClass(), targetName);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected Target getClassTargets(Class cls, String targetName) {
        if (cls == null) {
            return null;
        }
        target /* !! */  = null;
        if (targetName != null) {
            try {
                method = cls.getMethod(targetName, null);
                target /* !! */  = new MethodTarget(targetName, method);
            }
            catch (NoSuchMethodException e) {
                if (this.inheritTargets()) ** GOTO lbl22
                return new Target(targetName);
            }
            catch (SecurityException e) {
                return null;
            }
        } else if (this.params.doMethods()) {
            methods = cls.getDeclaredMethods();
            i = methods.length;
            while (--i >= 0) {
                name = methods[i].getName();
                if (!name.startsWith("Test") && !name.startsWith("test")) continue;
                target /* !! */  = new MethodTarget(name, methods[i]).setNext(target /* !! */ );
            }
        }
lbl22:
        // 5 sources

        if (this.inheritTargets()) {
            parentTarget = this.getClassTargets(cls.getSuperclass(), targetName);
            if (parentTarget == null) {
                return target /* !! */ ;
            }
            if (target /* !! */  == null) {
                return parentTarget;
            }
            return parentTarget.append(target /* !! */ );
        }
        return target /* !! */ ;
    }

    protected boolean inheritTargets() {
        return false;
    }

    protected String getDescription() {
        return null;
    }

    protected boolean validateMethod(String name) {
        return true;
    }

    protected String getMethodDescription(String name) {
        return null;
    }

    protected TestFmwk getSubtest(String prefix) throws TestFmwkException {
        return null;
    }

    public boolean isVerbose() {
        return this.params.verbose;
    }

    public boolean noData() {
        return this.params.nodata;
    }

    public boolean isTiming() {
        return this.params.timing < Long.MAX_VALUE;
    }

    public boolean isMemTracking() {
        return this.params.memusage;
    }

    public int getInclusion() {
        return this.params.inclusion;
    }

    public boolean isModularBuild() {
        return this.params.warnings;
    }

    public boolean isQuick() {
        return this.params.inclusion == 0;
    }

    @Override
    public void msg(String message, int level, boolean incCount, boolean newln) {
        this.params.msg(message, level, incCount, newln);
    }

    public boolean logKnownIssue(String ticket, String comment) {
        ArrayList<String> lines;
        if (!this.getBooleanProperty("logKnownIssue", true)) {
            return false;
        }
        StringBuffer descBuf = new StringBuffer();
        this.params.stack.appendPath(descBuf);
        if (comment != null && comment.length() > 0) {
            descBuf.append(" (" + comment + ")");
        }
        String description = descBuf.toString();
        String ticketLink = "Unknown Ticket";
        if (ticket != null && ticket.length() > 0) {
            boolean isCldr = false;
            if ((ticket = ticket.toLowerCase(Locale.ENGLISH)).startsWith(CLDR_TICKET_PREFIX)) {
                isCldr = true;
                ticket = ticket.substring(CLDR_TICKET_PREFIX.length());
            }
            ticketLink = (isCldr ? CLDR_TRAC_URL : ICU_TRAC_URL) + ticket;
        }
        if (this.params.knownIssues == null) {
            this.params.knownIssues = new TreeMap();
        }
        if ((lines = (ArrayList<String>)this.params.knownIssues.get(ticketLink)) == null) {
            lines = new ArrayList<String>();
            this.params.knownIssues.put(ticketLink, lines);
        }
        if (!lines.contains(description)) {
            lines.add(description);
        }
        return true;
    }

    protected int getErrorCount() {
        return this.params.errorCount;
    }

    public String getProperty(String key) {
        String val = null;
        if (key != null && key.length() > 0 && this.params.props != null) {
            val = (String)this.params.props.get(key.toLowerCase());
        }
        return val;
    }

    public boolean getBooleanProperty(String key, boolean defVal) {
        String s = this.getProperty(key);
        if (s != null) {
            if (s.equalsIgnoreCase("yes") || s.equals("true")) {
                return true;
            }
            if (s.equalsIgnoreCase("no") || s.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return defVal;
    }

    protected TimeZone safeGetTimeZone(String id) {
        TimeZone tz = TimeZone.getTimeZone((String)id);
        if (tz == null) {
            this.errln("FAIL: TimeZone.getTimeZone(" + id + ") => null");
        }
        if (!tz.getID().equals(id)) {
            this.warnln("FAIL: TimeZone.getTimeZone(" + id + ") => " + tz.getID());
        }
        return tz;
    }

    public void usage() {
        TestFmwk.usage(new PrintWriter(System.out), this.getClass().getName());
    }

    public static void usage(PrintWriter pw, String className) {
        pw.println("Usage: " + className + " option* target*");
        pw.println();
        pw.println("Options:");
        pw.println(" -d[escribe] Print a short descriptive string for this test and all");
        pw.println("       listed targets.");
        pw.println(" -e<n> Set exhaustiveness from 0..10.  Default is 0, fewest tests.\n       To run all tests, specify -e10.  Giving -e with no <n> is\n       the same as -e5.");
        pw.println(" -filter:<str> Only tests matching filter will be run or listed.\n       <str> is of the form ['^']text[','['^']text].\n       Each string delimited by ',' is a separate filter argument.\n       If '^' is prepended to an argument, its matches are excluded.\n       Filtering operates on test groups as well as tests, if a test\n       group is included, all its subtests that are not excluded will\n       be run.  Examples:\n    -filter:A -- only tests matching A are run.  If A matches a group,\n       all subtests of this group are run.\n    -filter:^A -- all tests except those matching A are run.  If A matches\n        a group, no subtest of that group will be run.\n    -filter:A,B,^C,^D -- tests matching A or B and not C and not D are run\n       Note: Filters are case insensitive.");
        pw.println(" -h[elp] Print this help text and exit.");
        pw.println(" -hex Display non-ASCII characters in hexadecimal format");
        pw.println(" -l[ist] List immediate targets of this test");
        pw.println("   -la, -listAll List immediate targets of this test, and all subtests");
        pw.println("   -le, -listExaustive List all subtests and targets");
        pw.println(" -n[othrow] Message on test failure rather than exception.\n       This is the default behavior and has no effects on ICU 55+.");
        pw.println(" -p[rompt] Prompt before exiting");
        pw.println(" -prop:<key>=<value> Set optional property used by this test");
        pw.println(" -q[uiet] Do not show warnings");
        pw.println(" -r[andom][:<n>] If present, randomize targets.  If n is present,\n       use it as the seed.  If random is not set, targets will\n       be in alphabetical order to ensure cross-platform consistency.");
        pw.println(" -s[ilent] No output except error summary or exceptions.");
        pw.println(" -tfilter:<str> Transliterator Test filter of ids.");
        pw.println(" -t[ime]:<n> Print elapsed time only for tests exceeding n milliseconds.");
        pw.println(" -v[erbose] Show log messages");
        pw.println(" -u[nicode] Don't escape error or log messages (Default on ICU 55+)");
        pw.println(" -w[arning] Continue in presence of warnings, and disable missing test warnings.");
        pw.println(" -nodata | -nd Do not warn if resource data is not present.");
        pw.println();
        pw.println(" If a list or describe option is provided, no tests are run.");
        pw.println();
        pw.println("Targets:");
        pw.println(" If no target is specified, all targets for this test are run.");
        pw.println(" If a target contains no '/' characters, and matches a target");
        pw.println(" of this test, the target is run.  Otherwise, the part before the");
        pw.println(" '/' is used to match a subtest, which then evaluates the");
        pw.println(" remainder of the target as above.  Target matching is case-insensitive.");
        pw.println();
        pw.println(" If multiple targets are provided, each is executed in order.");
        pw.flush();
    }

    public static String hex(char[] s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            if (i != 0) {
                result.append(',');
            }
            result.append(TestFmwk.hex(s[i]));
        }
        return result.toString();
    }

    public static String hex(byte[] s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            if (i != 0) {
                result.append(',');
            }
            result.append(TestFmwk.hex(s[i]));
        }
        return result.toString();
    }

    public static String hex(char ch) {
        StringBuffer result = new StringBuffer();
        String foo = Integer.toString(ch, 16).toUpperCase();
        for (int i = foo.length(); i < 4; ++i) {
            result.append('0');
        }
        return result + foo;
    }

    public static String hex(int ch) {
        StringBuffer result = new StringBuffer();
        String foo = Integer.toString(ch, 16).toUpperCase();
        for (int i = foo.length(); i < 4; ++i) {
            result.append('0');
        }
        return result + foo;
    }

    public static String hex(CharSequence s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (i != 0) {
                result.append(',');
            }
            result.append(TestFmwk.hex(s.charAt(i)));
        }
        return result.toString();
    }

    public static String prettify(CharSequence s) {
        int ch;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); i += Character.charCount(ch)) {
            ch = Character.codePointAt(s, i);
            if (ch > 1048575) {
                result.append("\\U00");
                result.append(TestFmwk.hex(ch));
                continue;
            }
            if (ch > 65535) {
                result.append("\\U000");
                result.append(TestFmwk.hex(ch));
                continue;
            }
            if (ch < 32 || 126 < ch) {
                result.append("\\u");
                result.append(TestFmwk.hex(ch));
                continue;
            }
            result.append((char)ch);
        }
        return result.toString();
    }

    protected static synchronized Date getDate(int year, int month, int dom) {
        if (cal == null) {
            cal = new GregorianCalendar();
        }
        cal.clear();
        cal.set(year, month, dom);
        return cal.getTime();
    }

    public String getTranslitTestFilter() {
        return this.params.tfilter;
    }

    private static String getClassTargetName(Class testClass) {
        String name;
        block3: {
            name = testClass.getName();
            try {
                Field f = testClass.getField("CLASS_TARGET_NAME");
                name = (String)f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("static field CLASS_TARGET_NAME must be accessible");
            }
            catch (NoSuchFieldException e) {
                int n = Math.max(name.lastIndexOf(46), name.lastIndexOf(36));
                if (n == -1) break block3;
                name = name.substring(n + 1);
            }
        }
        return name;
    }

    protected int checkArray(String msg, String[] array, String[] expected) {
        int i;
        int explen;
        int n = explen = expected != null ? expected.length : 0;
        if (explen < 0 || explen >= 31) {
            this.errln("Internal error");
            return -1;
        }
        StringBuffer buf = new StringBuffer();
        int seenMask = 0;
        for (i = 0; i < array.length; ++i) {
            String s = array[i];
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(s);
            int j = 0;
            int bit = 1;
            while (j < explen) {
                if (!(seenMask & bit) && s.equals(expected[j])) {
                    seenMask |= bit;
                    this.logln("Ok: \"" + s + "\" seen");
                }
                ++j;
                bit <<= 1;
            }
        }
        this.logln(msg + " = [" + buf + "] (" + i + ")");
        if ((1 << explen) - 1 != seenMask) {
            int j = 0;
            int bit = 1;
            while (j < expected.length) {
                if ((seenMask & bit) == 0) {
                    this.errln("\"" + expected[j] + "\" not seen");
                }
                ++j;
                bit <<= 1;
            }
        }
        return array.length;
    }

    protected int checkArray(String msg, Locale[] array, String[] expected) {
        String[] strs = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            strs[i] = array[i].toString();
        }
        return this.checkArray(msg, strs, expected);
    }

    protected int checkArray(String msg, ULocale[] array, String[] expected) {
        String[] strs = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            strs[i] = array[i].toString();
        }
        return this.checkArray(msg, strs, expected);
    }

    protected boolean assertTrue(String message, boolean condition) {
        return this.handleAssert(condition, message, "true", null);
    }

    protected boolean assertFalse(String message, boolean condition) {
        return this.handleAssert(!condition, message, "false", null);
    }

    protected boolean assertEquals(String message, boolean expected, boolean actual) {
        return this.handleAssert(expected == actual, message, String.valueOf(expected), String.valueOf(actual));
    }

    protected boolean assertEquals(String message, long expected, long actual) {
        return this.handleAssert(expected == actual, message, String.valueOf(expected), String.valueOf(actual));
    }

    protected boolean assertEquals(String message, float expected, float actual, double error) {
        boolean result = Float.isInfinite(expected) ? expected == actual : !((double)Math.abs(expected - actual) > error);
        return this.handleAssert(result, message, String.valueOf(expected) + (error == 0.0 ? "" : " (within " + error + ")"), String.valueOf(actual));
    }

    protected boolean assertEquals(String message, double expected, double actual, double error) {
        boolean result = Double.isInfinite(expected) ? expected == actual : !(Math.abs(expected - actual) > error);
        return this.handleAssert(result, message, String.valueOf(expected) + (error == 0.0 ? "" : " (within " + error + ")"), String.valueOf(actual));
    }

    protected <T> boolean assertEquals(String message, T[] expected, T[] actual) {
        String expectedString = expected == null ? "null" : Arrays.asList(expected).toString();
        String actualString = actual == null ? "null" : Arrays.asList(actual).toString();
        return this.assertEquals(message, expectedString, actualString);
    }

    protected boolean assertEquals(String message, Object expected, Object actual) {
        boolean result = expected == null ? actual == null : expected.equals(actual);
        return this.handleAssert(result, message, this.stringFor(expected), this.stringFor(actual));
    }

    protected boolean assertNotEquals(String message, Object expected, Object actual) {
        boolean result = !(expected != null ? expected.equals(actual) : actual == null);
        return this.handleAssert(result, message, this.stringFor(expected), this.stringFor(actual), "not equal to", true);
    }

    protected boolean assertSame(String message, Object expected, Object actual) {
        return this.handleAssert(expected == actual, message, this.stringFor(expected), this.stringFor(actual), "==", false);
    }

    protected boolean assertNotSame(String message, Object expected, Object actual) {
        return this.handleAssert(expected != actual, message, this.stringFor(expected), this.stringFor(actual), "!=", true);
    }

    protected boolean assertNull(String message, Object actual) {
        return this.handleAssert(actual == null, message, null, this.stringFor(actual));
    }

    protected boolean assertNotNull(String message, Object actual) {
        return this.handleAssert(actual != null, message, null, this.stringFor(actual), "!=", true);
    }

    protected void fail() {
        this.fail("");
    }

    protected void fail(String message) {
        if (message == null) {
            message = "";
        }
        if (!message.equals("")) {
            message = ": " + message;
        }
        this.errln(TestFmwk.sourceLocation() + message);
    }

    private boolean handleAssert(boolean result, String message, String expected, String actual) {
        return this.handleAssert(result, message, expected, actual, null, false);
    }

    public boolean handleAssert(boolean result, String message, Object expected, Object actual, String relation, boolean flip) {
        if (!result || this.isVerbose()) {
            if (message == null) {
                message = "";
            }
            if (!message.equals("")) {
                message = ": " + message;
            }
            String string = relation = relation == null ? ", got " : " " + relation + " ";
            if (result) {
                this.logln("OK " + message + ": " + (flip ? expected + relation + actual : expected));
            } else {
                this.errln(message + ": expected" + (flip ? relation + expected : " " + expected + (actual != null ? relation + actual : "")));
            }
        }
        return result;
    }

    private final String stringFor(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return "\"" + obj + '\"';
        }
        return obj.getClass().getName() + "<" + obj + ">";
    }

    public static String sourceLocation() {
        for (StackTraceElement st : new Throwable().getStackTrace()) {
            String methodName;
            String source = st.getFileName();
            if (source == null || source.equals("TestFmwk.java") || source.equals("AbstractTestLog.java") || (methodName = st.getMethodName()) == null || !methodName.startsWith("Test") && !methodName.startsWith("test") && !methodName.equals("main")) continue;
            return "(" + source + ":" + st.getLineNumber() + ") ";
        }
        throw new InternalError();
    }

    public PrintWriter getErrorLogPrintWriter() {
        return new PrintWriter(new TestLogWriter(this, 2));
    }

    public PrintWriter getLogPrintWriter() {
        return new PrintWriter(new TestLogWriter(this, 0));
    }

    public static class TestParams {
        public boolean prompt;
        public boolean verbose;
        public boolean quiet;
        public int listlevel;
        public boolean describe;
        public boolean warnings;
        public boolean nodata;
        public long timing = 0L;
        public boolean memusage;
        public int inclusion;
        public String filter;
        public long seed;
        public String tfilter;
        public State stack;
        public StringBuffer errorSummary = new StringBuffer();
        private StringBuffer timeLog;
        private Map<String, List<String>> knownIssues;
        public PrintWriter log;
        public int indentLevel;
        private boolean needLineFeed;
        private boolean suppressIndent;
        public int errorCount;
        public int warnCount;
        public int invalidCount;
        public int testCount;
        private NumberFormat tformat;
        public Random random;
        public int maxTargetSec = 10;
        public HashMap props;

        private TestParams() {
        }

        public static TestParams create(String arglist, PrintWriter log) {
            String[] args = null;
            if (arglist != null && arglist.length() > 0) {
                args = arglist.split("\\s");
            }
            return TestParams.create(args, log);
        }

        public static TestParams create(String[] args, PrintWriter log) {
            TestParams params = new TestParams();
            params.log = log == null ? new NullWriter() : log;
            boolean usageError = false;
            String filter = null;
            String fmt = "#,##0.000s";
            int wx = 0;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg == null || arg.length() == 0) continue;
                    if (arg.charAt(0) == '-') {
                        if ((arg = arg.toLowerCase()).equals("-verbose") || arg.equals("-v")) {
                            params.verbose = true;
                            params.quiet = false;
                            continue;
                        }
                        if (arg.equals("-quiet") || arg.equals("-q")) {
                            params.quiet = true;
                            params.verbose = false;
                            continue;
                        }
                        if (arg.equals("-hex")) {
                            params.log = new ASCIIWriter(log, true);
                            continue;
                        }
                        if (arg.equals("-help") || arg.equals("-h")) {
                            usageError = true;
                            continue;
                        }
                        if (arg.equals("-warning") || arg.equals("-w")) {
                            params.warnings = true;
                            continue;
                        }
                        if (arg.equals("-nodata") || arg.equals("-nd")) {
                            params.nodata = true;
                            continue;
                        }
                        if (arg.equals("-list") || arg.equals("-l")) {
                            params.listlevel = 1;
                            continue;
                        }
                        if (arg.equals("-listall") || arg.equals("-la")) {
                            params.listlevel = 2;
                            continue;
                        }
                        if (arg.equals("-listexaustive") || arg.equals("-le")) {
                            params.listlevel = 3;
                            continue;
                        }
                        if (arg.equals("-memory") || arg.equals("-m")) {
                            params.memusage = true;
                            continue;
                        }
                        if (arg.equals("-nothrow") || arg.equals("-n")) continue;
                        if (arg.equals("-describe") || arg.equals("-d")) {
                            params.describe = true;
                            continue;
                        }
                        if (arg.startsWith("-r")) {
                            String s = null;
                            int n = arg.indexOf(58);
                            if (n != -1) {
                                s = arg.substring(n + 1);
                                arg = arg.substring(0, n);
                            }
                            if (arg.equals("-r") || arg.equals("-random")) {
                                if (s == null) {
                                    params.seed = System.currentTimeMillis();
                                    continue;
                                }
                                params.seed = Long.parseLong(s);
                                continue;
                            }
                            log.println("*** Error: unrecognized argument: " + arg);
                            usageError = true;
                            break;
                        }
                        if (arg.startsWith("-e")) {
                            int n = params.inclusion = arg.length() == 2 ? 5 : Integer.parseInt(arg.substring(2));
                            if (params.inclusion >= 0 && params.inclusion <= 10) continue;
                            usageError = true;
                            break;
                        }
                        if (arg.startsWith("-tfilter:")) {
                            params.tfilter = arg.substring(8);
                            continue;
                        }
                        if (arg.startsWith("-time") || arg.startsWith("-t")) {
                            long val = 0L;
                            int inx = arg.indexOf(58);
                            if (inx > 0) {
                                String num = arg.substring(inx + 1);
                                try {
                                    val = Long.parseLong(num);
                                }
                                catch (Exception e) {
                                    log.println("*** Error: could not parse time threshold '" + num + "'");
                                    usageError = true;
                                    break;
                                }
                            }
                            params.timing = val;
                            if (val <= 10L) {
                                fmt = "#,##0.000s";
                                continue;
                            }
                            if (val <= 100L) {
                                fmt = "#,##0.00s";
                                continue;
                            }
                            if (val > 1000L) continue;
                            fmt = "#,##0.0s";
                            continue;
                        }
                        if (arg.startsWith("-filter:")) {
                            String temp = arg.substring(8).toLowerCase();
                            filter = filter == null ? temp : filter + "," + temp;
                            continue;
                        }
                        if (arg.startsWith("-f:")) {
                            String temp = arg.substring(3).toLowerCase();
                            filter = filter == null ? temp : filter + "," + temp;
                            continue;
                        }
                        if (arg.startsWith("-s")) {
                            params.log = new NullWriter();
                            continue;
                        }
                        if (arg.startsWith("-u")) {
                            if (!(params.log instanceof ASCIIWriter)) continue;
                            params.log = log;
                            continue;
                        }
                        if (arg.startsWith("-prop:")) {
                            String temp = arg.substring(6);
                            int eql = temp.indexOf(61);
                            if (eql <= 0) {
                                log.println("*** Error: could not parse custom property '" + arg + "'");
                                usageError = true;
                                break;
                            }
                            if (params.props == null) {
                                params.props = new HashMap();
                            }
                            params.props.put(temp.substring(0, eql), temp.substring(eql + 1));
                            continue;
                        }
                        log.println("*** Error: unrecognized argument: " + args[i]);
                        usageError = true;
                        break;
                    }
                    args[wx++] = arg;
                }
                while (wx < args.length) {
                    args[wx++] = null;
                }
            }
            params.tformat = new DecimalFormat(fmt);
            if (usageError) {
                TestFmwk.usage(log, "TestAll");
                return null;
            }
            if (filter != null) {
                params.filter = filter.toLowerCase();
            }
            params.init();
            return params;
        }

        public String errorSummary() {
            return this.errorSummary == null ? "" : this.errorSummary.toString();
        }

        public void init() {
            this.indentLevel = 0;
            this.needLineFeed = false;
            this.suppressIndent = false;
            this.errorCount = 0;
            this.warnCount = 0;
            this.invalidCount = 0;
            this.testCount = 0;
            this.random = this.seed == 0L ? null : new Random(this.seed);
        }

        public void push(String name, String description, boolean included) {
            if (this.inDocMode() && this.describe && description != null) {
                name = name + ": " + description;
            }
            this.stack = new State(this.stack, name, included);
        }

        public void pop() {
            if (this.stack != null) {
                this.writeTestResult();
                this.stack = this.stack.link;
            }
        }

        public boolean inDocMode() {
            return this.describe || this.listlevel != 0;
        }

        public boolean doMethods() {
            return !this.inDocMode() || this.listlevel == 3 || this.indentLevel == 1 && this.listlevel > 0;
        }

        public boolean doRecurse() {
            return !this.inDocMode() || this.listlevel > 1 || this.indentLevel == 1 && this.listlevel > 0;
        }

        public boolean doRecurseGroupsOnly() {
            return this.inDocMode() && (this.listlevel == 2 || this.indentLevel == 1 && this.listlevel > 0);
        }

        public int filter(String testName) {
            int result = 0;
            if (this.filter == null) {
                result = 1;
            } else {
                boolean noIncludes = true;
                boolean noExcludes = this.filter.indexOf(94) == -1;
                testName = testName.toLowerCase();
                int ix = 0;
                while (ix < this.filter.length()) {
                    int nix = this.filter.indexOf(44, ix);
                    if (nix == -1) {
                        nix = this.filter.length();
                    }
                    if (this.filter.charAt(ix) == '^') {
                        if (testName.indexOf(this.filter.substring(ix + 1, nix)) != -1) {
                            result = -1;
                            break;
                        }
                    } else {
                        noIncludes = false;
                        if (testName.indexOf(this.filter.substring(ix, nix)) != -1) {
                            result = 1;
                            if (noExcludes) break;
                        }
                    }
                    ix = nix + 1;
                }
                if (result == 0 && noIncludes) {
                    result = 1;
                }
            }
            return result;
        }

        public void write(String msg) {
            this.write(msg, false);
        }

        public void writeln(String msg) {
            this.write(msg, true);
        }

        private void write(String msg, boolean newln) {
            if (!this.suppressIndent) {
                if (this.needLineFeed) {
                    this.log.println();
                    this.needLineFeed = false;
                }
                this.log.print(TestFmwk.spaces.substring(0, this.indentLevel * 2));
            }
            this.log.print(msg);
            if (newln) {
                this.log.println();
            }
            this.log.flush();
            this.suppressIndent = !newln;
        }

        private void msg(String message, int level, boolean incCount, boolean newln) {
            int oldLevel = level;
            if (incCount) {
                if (level == 1) {
                    ++this.warnCount;
                } else if (level == 2) {
                    ++this.errorCount;
                }
            }
            if (this.verbose || level > (this.quiet ? 1 : 0)) {
                if (!this.suppressIndent) {
                    this.indent(this.indentLevel + 1);
                    String[] MSGNAMES = new String[]{"", "Warning: ", "Error: "};
                    this.log.print(MSGNAMES[oldLevel]);
                }
                String testLocation = TestFmwk.sourceLocation();
                message = testLocation + message;
                this.log.print(message);
                if (newln) {
                    this.log.println();
                }
                this.log.flush();
            }
            if (level == 2 && !this.suppressIndent && this.errorSummary != null && this.stack != null && this.errorCount == this.stack.ec + 1) {
                this.stack.appendPath(this.errorSummary);
                this.errorSummary.append("\n");
            }
            this.suppressIndent = !newln;
        }

        private void writeTestInvalid(String name, boolean nodataArg) {
            if (this.inDocMode()) {
                if (!this.warnings) {
                    if (this.stack != null) {
                        this.stack.flush();
                    }
                    this.log.println(" *** Target not found or not valid.");
                    this.log.flush();
                    this.needLineFeed = false;
                }
            } else if (!nodataArg) {
                this.msg("Test " + name + " not found or not valid.", 1, true, true);
            }
        }

        long getmem() {
            long newmem = 0L;
            if (this.memusage) {
                Runtime rt = Runtime.getRuntime();
                long lastmem = Long.MAX_VALUE;
                do {
                    rt.gc();
                    rt.gc();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        break;
                    }
                    lastmem = newmem;
                } while ((newmem = rt.totalMemory() - rt.freeMemory()) < lastmem);
            }
            return newmem;
        }

        private void writeTestResult() {
            if (this.inDocMode()) {
                if (this.needLineFeed) {
                    this.log.println();
                    this.log.flush();
                }
                this.needLineFeed = false;
                return;
            }
            long dmem = this.getmem() - this.stack.mem;
            long dtime = System.currentTimeMillis() - this.stack.millis;
            int testDelta = this.testCount - this.stack.tc;
            if (testDelta == 0) {
                if (this.stack.included) {
                    this.stack.flush();
                    this.indent(this.indentLevel);
                    this.log.println("} (0s) Empty");
                }
                return;
            }
            int errorDelta = this.errorCount - this.stack.ec;
            int warnDelta = this.warnCount - this.stack.wc;
            int invalidDelta = this.invalidCount - this.stack.ic;
            this.stack.flush();
            if (!this.needLineFeed) {
                this.indent(this.indentLevel);
                this.log.print("}");
            }
            this.needLineFeed = false;
            if (this.memusage || dtime >= this.timing) {
                this.log.print(" (");
                if (this.memusage) {
                    this.log.print("dmem: " + dmem);
                }
                if (dtime >= this.timing) {
                    if (this.memusage) {
                        this.log.print(", ");
                    }
                    this.log.print(this.tformat.format((float)dtime / 1000.0f));
                }
                this.log.print(")");
            }
            if (errorDelta != 0) {
                this.log.println(" FAILED (" + errorDelta + " failure(s)" + (warnDelta != 0 ? ", " + warnDelta + " warning(s)" : "") + (invalidDelta != 0 ? ", " + invalidDelta + " test(s) skipped)" : ")"));
            } else if (warnDelta != 0) {
                this.log.println(" ALERT (" + warnDelta + " warning(s)" + (invalidDelta != 0 ? ", " + invalidDelta + " test(s) skipped)" : ")"));
            } else if (invalidDelta != 0) {
                this.log.println(" Qualified (" + invalidDelta + " test(s) skipped)");
            } else {
                this.log.println(" Passed");
            }
        }

        private final void indent(int distance) {
            boolean idm = this.inDocMode();
            if (this.needLineFeed) {
                if (idm) {
                    this.log.println();
                } else {
                    this.log.println(" {");
                }
                this.needLineFeed = false;
            }
            this.log.print(TestFmwk.spaces.substring(0, distance * (idm ? 3 : 2)));
            if (idm) {
                this.log.print("-- ");
            }
        }

        public class State {
            State link;
            String name;
            StringBuffer buffer;
            int level;
            int ec;
            int wc;
            int ic;
            int tc;
            boolean flushed;
            public boolean included;
            long mem;
            long millis;

            public State(State link, String name, boolean included) {
                this.link = link;
                this.name = name;
                if (link == null) {
                    this.level = 0;
                    this.included = included;
                } else {
                    this.level = link.level + 1;
                    this.included = included || link.included;
                }
                this.ec = TestParams.this.errorCount;
                this.wc = TestParams.this.warnCount;
                this.ic = TestParams.this.invalidCount;
                this.tc = TestParams.this.testCount;
                if (link == null || this.included) {
                    this.flush();
                }
                this.mem = TestParams.this.getmem();
                this.millis = System.currentTimeMillis();
            }

            void flush() {
                if (!this.flushed) {
                    if (this.link != null) {
                        this.link.flush();
                    }
                    TestParams.this.indent(this.level);
                    TestParams.this.log.print(this.name);
                    TestParams.this.log.flush();
                    this.flushed = true;
                    TestParams.this.needLineFeed = true;
                }
            }

            void appendPath(StringBuffer buf) {
                if (this.link != null) {
                    this.link.appendPath(buf);
                    buf.append('/');
                }
                buf.append(this.name);
            }
        }
    }

    public static class ASCIIWriter
    extends PrintWriter {
        private StringBuffer buffer = new StringBuffer();
        private static final String PRINTABLES = "\t\n\r";

        public ASCIIWriter(Writer w, boolean autoFlush) {
            super(w, autoFlush);
        }

        public ASCIIWriter(OutputStream os, boolean autoFlush) {
            super(os, autoFlush);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int c) {
            Object object = this.lock;
            synchronized (object) {
                this.buffer.setLength(0);
                if (PRINTABLES.indexOf(c) < 0 && TestUtil.escapeUnprintable(this.buffer, c)) {
                    super.write(this.buffer.toString());
                } else {
                    super.write(c);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] buf, int off, int len) {
            Object object = this.lock;
            synchronized (object) {
                this.buffer.setLength(0);
                int limit = off + len;
                while (off < limit) {
                    int c = UTF16Util.charAt(buf, 0, buf.length, off);
                    off += UTF16Util.getCharCount(c);
                    if (PRINTABLES.indexOf(c) < 0 && TestUtil.escapeUnprintable(this.buffer, c)) {
                        super.write(this.buffer.toString());
                        this.buffer.setLength(0);
                        continue;
                    }
                    super.write(c);
                }
            }
        }

        @Override
        public void write(String s, int off, int len) {
            this.write(s.substring(off, off + len).toCharArray(), 0, len);
        }
    }

    public static class NullWriter
    extends PrintWriter {
        public NullWriter() {
            super(System.out, false);
        }

        @Override
        public void write(int c) {
        }

        @Override
        public void write(char[] buf, int off, int len) {
        }

        @Override
        public void write(String s, int off, int len) {
        }

        @Override
        public void println() {
        }
    }

    public class ClassTarget
    extends Target {
        String targetName;

        public ClassTarget() {
            this(null);
        }

        public ClassTarget(String targetName) {
            super(TestFmwk.getClassTargetName(TestFmwk.this.getClass()));
            this.targetName = targetName;
        }

        @Override
        protected boolean validate() {
            return TestFmwk.this.validate();
        }

        @Override
        protected String getDescription() {
            return TestFmwk.this.getDescription();
        }

        @Override
        protected void execute() throws Exception {
            ++TestFmwk.this.params.indentLevel;
            Target target = this.randomize(TestFmwk.this.getTargets(this.targetName));
            while (target != null) {
                target.run();
                target = target.next;
            }
            --TestFmwk.this.params.indentLevel;
        }

        private Target randomize(Target t) {
            if (t != null && t.getNext() != null) {
                ArrayList<Target> list = new ArrayList<Target>();
                while (t != null) {
                    list.add(t);
                    t = t.getNext();
                }
                Target[] arr = list.toArray(new Target[list.size()]);
                Arrays.sort(arr, new Comparator(){

                    public int compare(Object lhs, Object rhs) {
                        return ((Target)rhs).name.compareTo(((Target)lhs).name);
                    }
                });
                for (int i = 0; i < arr.length; ++i) {
                    t = arr[i].setNext(t);
                }
                if (TestFmwk.this.params.random != null) {
                    t = null;
                    Random r = TestFmwk.this.params.random;
                    int i = arr.length;
                    while (--i >= 1) {
                        int x = r.nextInt(i + 1);
                        t = arr[x].setNext(t);
                        arr[x] = arr[i];
                    }
                    t = arr[0].setNext(t);
                }
            }
            return t;
        }
    }

    public class MethodTarget
    extends Target {
        private Method testMethod;

        public MethodTarget(String name, Method method) {
            super(name);
            this.testMethod = method;
        }

        @Override
        protected boolean validate() {
            return this.testMethod != null && TestFmwk.this.validateMethod(this.name);
        }

        @Override
        protected String getDescription() {
            return TestFmwk.this.getMethodDescription(this.name);
        }

        @Override
        protected void execute() throws Exception {
            double deltaSec;
            if (!TestFmwk.this.params.inDocMode()) {
                if (!TestFmwk.this.params.stack.included) {
                    ++TestFmwk.this.params.invalidCount;
                } else {
                    Object[] NO_ARGS = new Object[]{};
                    try {
                        ++TestFmwk.this.params.testCount;
                        TestFmwk.this.init();
                        this.testMethod.invoke((Object)TestFmwk.this, NO_ARGS);
                    }
                    catch (IllegalAccessException e) {
                        TestFmwk.this.errln("Can't access test method " + this.testMethod.getName());
                    }
                    catch (Exception e) {
                        TestFmwk.this.handleException(e);
                    }
                }
            }
            if (TestFmwk.this.params.inclusion <= 5 && (deltaSec = (double)(System.currentTimeMillis() - TestFmwk.this.params.stack.millis) / 1000.0) > (double)TestFmwk.this.params.maxTargetSec) {
                if (TestFmwk.this.params.timeLog == null) {
                    TestFmwk.this.params.timeLog = new StringBuffer();
                }
                TestFmwk.this.params.stack.appendPath(TestFmwk.this.params.timeLog);
                TestFmwk.this.params.timeLog.append(" (" + deltaSec + "s" + ")\n");
            }
        }

        protected String getStackTrace(InvocationTargetException e) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            e.getTargetException().printStackTrace(ps);
            return bs.toString();
        }
    }

    public class EmptyTarget
    extends Target {
        public EmptyTarget(String name) {
            super(name);
        }

        @Override
        protected boolean validate() {
            return true;
        }
    }

    public class Target {
        private Target next;
        public final String name;

        public Target(String name) {
            this.name = name;
        }

        public Target setNext(Target next) {
            this.next = next;
            return this;
        }

        public Target getNext() {
            return this.next;
        }

        public Target append(Target targets) {
            Target t = this;
            while (t.next != null) {
                t = t.next;
            }
            t.next = targets;
            return this;
        }

        public void run() throws Exception {
            int f = this.filter();
            if (f == -1) {
                ++TestFmwk.this.params.invalidCount;
            } else {
                Locale.setDefault(defaultLocale);
                TimeZone.setDefault((TimeZone)defaultTimeZone);
                if (!this.validate()) {
                    TestFmwk.this.params.writeTestInvalid(this.name, TestFmwk.this.params.nodata);
                } else {
                    TestFmwk.this.params.push(this.name, this.getDescription(), f == 1);
                    this.execute();
                    TestFmwk.this.params.pop();
                }
            }
        }

        protected int filter() {
            return TestFmwk.this.params.filter(this.name);
        }

        protected boolean validate() {
            return false;
        }

        protected String getDescription() {
            return null;
        }

        protected void execute() throws Exception {
        }
    }

    public static abstract class TestGroup
    extends TestFmwk {
        private String defaultPackage;
        private String[] names;
        private String description;
        private Class[] tests;

        protected TestGroup(String defaultPackage, String[] classnames, String description) {
            if (classnames == null) {
                throw new IllegalStateException("classnames must not be null");
            }
            if (defaultPackage == null) {
                defaultPackage = this.getClass().getPackage().getName();
            }
            this.defaultPackage = defaultPackage = defaultPackage + ".";
            this.names = classnames;
            this.description = description;
        }

        protected TestGroup(String[] classnames, String description) {
            this(null, classnames, description);
        }

        protected TestGroup(String[] classnames) {
            this(null, classnames, null);
        }

        @Override
        protected String getDescription() {
            return this.description;
        }

        @Override
        protected Target getTargets(String targetName) {
            Target target;
            block9: {
                target = null;
                if (targetName != null) {
                    this.finishInit();
                    try {
                        TestFmwk test = this.getSubtest(targetName);
                        if (test != null) {
                            target = test.new ClassTarget();
                            break block9;
                        }
                        target = new Target(targetName);
                    }
                    catch (TestFmwkException e) {
                        target = new Target(targetName);
                    }
                } else if (this.params.doRecurse()) {
                    this.finishInit();
                    boolean groupOnly = this.params.doRecurseGroupsOnly();
                    int i = this.names.length;
                    while (--i >= 0) {
                        Target newTarget = null;
                        Class cls = this.tests[i];
                        if (cls == null) {
                            if (this.params.warnings) continue;
                            newTarget = new Target(this.names[i]);
                        } else {
                            TestFmwk test = this.getSubtest(i, groupOnly);
                            newTarget = test != null ? test.new ClassTarget() : (groupOnly ? new EmptyTarget(this.names[i]) : new Target(this.names[i]));
                        }
                        if (newTarget == null) continue;
                        newTarget.setNext(target);
                        target = newTarget;
                    }
                }
            }
            return target;
        }

        @Override
        protected TestFmwk getSubtest(String testName) throws TestFmwkException {
            this.finishInit();
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.names[i].equalsIgnoreCase(testName)) continue;
                return this.getSubtest(i, false);
            }
            throw new TestFmwkException(testName);
        }

        private TestFmwk getSubtest(int i, boolean groupOnly) {
            Class cls = this.tests[i];
            if (cls != null) {
                if (groupOnly && !TestGroup.class.isAssignableFrom(cls)) {
                    return null;
                }
                try {
                    TestFmwk subtest = (TestFmwk)cls.newInstance();
                    subtest.params = this.params;
                    return subtest;
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            return null;
        }

        private void finishInit() {
            if (this.tests == null) {
                this.tests = new Class[this.names.length];
                for (int i = 0; i < this.names.length; ++i) {
                    String name = this.names[i];
                    if (name.indexOf(46) == -1) {
                        name = this.defaultPackage + name;
                    }
                    try {
                        Class<?> cls = Class.forName(name);
                        if (!TestFmwk.class.isAssignableFrom(cls)) {
                            throw new IllegalStateException("class " + name + " does not extend TestFmwk");
                        }
                        this.tests[i] = cls;
                        this.names[i] = TestFmwk.getClassTargetName(cls);
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static final class ICUTestError
    extends RuntimeException {
        private static final long serialVersionUID = 6170003850185143046L;

        ICUTestError(String msg) {
            super(msg);
        }
    }

    public static final class TestFmwkException
    extends Exception {
        private static final long serialVersionUID = -3051148210247229194L;

        TestFmwkException(String msg) {
            super(msg);
        }
    }
}

