/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.util;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UTF16;

public abstract class Quoter {
    private static boolean DEBUG = false;
    protected boolean quoting = false;
    protected StringBuffer output = new StringBuffer();

    public void setQuoting(boolean value) {
        this.quoting = value;
    }

    public boolean isQuoting() {
        return this.quoting;
    }

    public void clear() {
        this.quoting = false;
        this.output.setLength(0);
    }

    public int length() {
        return this.output.length();
    }

    public Quoter append(String string) {
        this.output.append(string);
        return this;
    }

    public Quoter append(int codepoint) {
        return this.append(UTF16.valueOf((int)codepoint));
    }

    public String toString() {
        this.setQuoting(false);
        return this.output.toString();
    }

    public static class RuleQuoter
    extends Quoter {
        private StringBuffer quoteBuffer = new StringBuffer();

        @Override
        public void setQuoting(boolean value) {
            if (this.quoting == value) {
                return;
            }
            if (this.quoting) {
                Utility.appendToRule((StringBuffer)this.output, (int)-1, (boolean)true, (boolean)false, (StringBuffer)this.quoteBuffer);
            }
            this.quoting = value;
        }

        @Override
        public Quoter append(String s) {
            if (DEBUG) {
                System.out.println("\"" + s + "\"");
            }
            if (this.quoting) {
                Utility.appendToRule((StringBuffer)this.output, (String)s, (boolean)false, (boolean)false, (StringBuffer)this.quoteBuffer);
            } else {
                this.output.append(s);
            }
            return this;
        }
    }
}

