/*
 * Decompiled with CFR 0.152.
 */
package com.google.myanmartools;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

class BinaryMarkov {
    private static final long BINARY_TAG = 4777546601416578592L;
    private static final int BINARY_VERSION = 0;
    final float[][] logProbabilityDifferences;

    BinaryMarkov(float[][] logProbabilityDifferences) {
        this.logProbabilityDifferences = logProbabilityDifferences;
    }

    public BinaryMarkov(InputStream stream) throws IOException {
        DataInputStream dis = new DataInputStream(stream);
        long binaryTag = dis.readLong();
        if (binaryTag != 4777546601416578592L) {
            throw new IOException(String.format("Unexpected magic number; expected %016X but got %016X", 4777546601416578592L, binaryTag));
        }
        int binaryVersion = dis.readInt();
        if (binaryVersion != 0) {
            throw new IOException(String.format("Unexpected serial version number; expected %08X but got %08X", 0, binaryVersion));
        }
        short size = dis.readShort();
        float[][] logProbabilityDifferences = new float[size][size];
        for (short i1 = 0; i1 < size; i1 = (short)(i1 + 1)) {
            short entries = dis.readShort();
            float fallback = entries == 0 ? 0.0f : dis.readFloat();
            short next = -1;
            for (short i2 = 0; i2 < size; i2 = (short)(i2 + 1)) {
                if (entries > 0 && next < i2) {
                    next = dis.readShort();
                    entries = (short)(entries - 1);
                }
                logProbabilityDifferences[i1][i2] = next == i2 ? dis.readFloat() : fallback;
            }
        }
        this.logProbabilityDifferences = logProbabilityDifferences;
    }

    public float getLogProbabilityDifference(int i1, int i2) {
        return this.logProbabilityDifferences[i1][i2];
    }

    public boolean equals(Object other) {
        if (!(other instanceof BinaryMarkov)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.logProbabilityDifferences, (Object[])((BinaryMarkov)other).logProbabilityDifferences);
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.logProbabilityDifferences);
    }
}

